/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder.protoss;

import bwapi.Race;
import bwapi.UnitType;
import bwapi.UpgradeType;
import info.BaseData;
import info.GameState;
import info.TechProgression;
import info.tracking.StrategyTracker;
import java.util.ArrayList;
import java.util.List;
import macro.plan.Plan;
import strategy.buildorder.protoss.ProtossBase;
import util.Time;

public class ThreeHatchHydra
extends ProtossBase {
    private boolean plannedFirstMacroHatch = false;
    private boolean plannedSecondMacroHatch = false;
    private boolean plannedThirdMacroHatch = false;
    private boolean plannedHydraliskDen = false;
    private boolean plannedEvolutionChamber = false;

    public ThreeHatchHydra() {
        super("3HatchHydra");
    }

    @Override
    public List<Plan> plan(GameState gameState) {
        Plan evolutionChamberPlan;
        Plan hydraliskDenPlan;
        Plan macroHatchPlan;
        Plan hatcheryPlan;
        ArrayList<Plan> plans = new ArrayList<Plan>();
        Time time = gameState.getGameTime();
        TechProgression techProgression = gameState.getTechProgression();
        BaseData baseData = gameState.getBaseData();
        StrategyTracker strategyTracker = gameState.getStrategyTracker();
        boolean cannonRushed = strategyTracker.isDetectedStrategy("CannonRush");
        int baseCount = baseData.currentBaseCount();
        int extractorCount = baseData.numExtractor();
        int supply = gameState.getSupply();
        int plannedHatcheries = gameState.getPlannedHatcheries();
        int macroHatchCount = baseData.numMacroHatcheries();
        int hatchCount = gameState.ourUnitCount(UnitType.Zerg_Hatchery);
        int plannedAndCurrentHatcheries = plannedHatcheries + baseCount;
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        int droneCount = gameState.ourUnitCount(UnitType.Zerg_Drone);
        int zerglingCount = gameState.ourUnitCount(UnitType.Zerg_Zergling);
        boolean gasBlocked = cannonRushed && time.lessThanOrEqual(new Time(4, 0));
        boolean firstGas = !gasBlocked && gameState.canPlanExtractor() && (time.greaterThan(new Time(2, 32)) || supply > 40) && extractorCount < 1;
        boolean secondGas = gameState.canPlanExtractor() && (techProgression.isHydraliskDen() || droneCount >= 20);
        boolean wantNatural = plannedAndCurrentHatcheries < 2 && supply >= 24;
        boolean wantThird = plannedAndCurrentHatcheries < 3 && supply >= 40 && techProgression.isSpawningPool();
        boolean wantBaseAdvantage = this.behindOnBases(gameState);
        boolean floatingMinerals = gameState.getGameTime().greaterThan(new Time(5, 0)) && gameState.getResourceCount().availableMinerals() > (plannedHatcheries + 1) * 350;
        boolean wantFirstMacroHatch = this.wantFirstMacroHatchery(gameState);
        boolean wantSecondMacroHatch = this.wantSecondMacroHatchery(gameState);
        boolean wantThirdMacroHatch = this.wantThirdMacroHatchery(gameState);
        boolean wantHydraliskDen = this.wantHydraliskDen(gameState);
        boolean wantEvolutionChamber = this.wantEvolutionChamber(gameState);
        boolean wantMetabolicBoost = techProgression.canPlanMetabolicBoost() && zerglingCount > 12;
        boolean wantMuscularAugments = techProgression.canPlanMuscularAugments();
        boolean wantGroovedSpines = techProgression.canPlanGroovedSpines();
        boolean wantRangedUpgrades = this.wantRangedUpgrade(gameState);
        boolean wantCarapaceUpgrade = this.wantCarapaceUpgrade(gameState);
        boolean wantOverlordSpeed = this.needOverlordSpeed(gameState) && techProgression.canPlanOverlordSpeed();
        int desiredSunkenColonies = this.requiredSunkens(gameState);
        if (!gameState.basesNeedingSunken(desiredSunkenColonies).isEmpty()) {
            plans.addAll(this.planSunkenColony(gameState));
        }
        if ((wantNatural || wantThird || wantBaseAdvantage || floatingMinerals) && (hatcheryPlan = this.planNewBase(gameState)) != null) {
            plans.add(hatcheryPlan);
            return plans;
        }
        if (wantFirstMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedFirstMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (wantSecondMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedSecondMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (wantThirdMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedThirdMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (firstGas || secondGas) {
            Plan extractorPlan = this.planExtractor(gameState);
            plans.add(extractorPlan);
        }
        if (techProgression.canPlanPool() && droneCount > 10) {
            Plan poolPlan = this.planSpawningPool(gameState);
            plans.add(poolPlan);
            return plans;
        }
        if (wantHydraliskDen && (hydraliskDenPlan = this.planHydraliskDen(gameState)) != null) {
            this.plannedHydraliskDen = true;
            plans.add(hydraliskDenPlan);
            return plans;
        }
        if (wantEvolutionChamber && (evolutionChamberPlan = this.planEvolutionChamber(gameState)) != null) {
            this.plannedEvolutionChamber = true;
            plans.add(evolutionChamberPlan);
            return plans;
        }
        if (wantMetabolicBoost) {
            Plan metabolicBoostPlan = this.planUpgrade(gameState, UpgradeType.Metabolic_Boost);
            plans.add(metabolicBoostPlan);
        }
        boolean plannedMuscularAugmentsThisFrame = false;
        if (wantMuscularAugments) {
            Plan muscularAugmentsPlan = this.planUpgrade(gameState, UpgradeType.Muscular_Augments);
            plans.add(muscularAugmentsPlan);
            plannedMuscularAugmentsThisFrame = true;
        }
        if (wantGroovedSpines && !plannedMuscularAugmentsThisFrame) {
            Plan groovedSpinesPlan = this.planUpgrade(gameState, UpgradeType.Grooved_Spines);
            plans.add(groovedSpinesPlan);
        }
        boolean plannedRangedUpgradesThisFrame = false;
        if (wantRangedUpgrades) {
            Plan rangedPlan = this.planUpgrade(gameState, UpgradeType.Zerg_Missile_Attacks);
            plans.add(rangedPlan);
            plannedRangedUpgradesThisFrame = true;
        }
        if (wantCarapaceUpgrade && !plannedRangedUpgradesThisFrame) {
            Plan carapacePlan = this.planUpgrade(gameState, UpgradeType.Zerg_Carapace);
            plans.add(carapacePlan);
        }
        if (wantOverlordSpeed) {
            Plan overlordSpeedPlan = this.planUpgrade(gameState, UpgradeType.Pneumatized_Carapace);
            plans.add(overlordSpeedPlan);
        }
        if (droneCount < 13) {
            Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
            plans.add(dronePlan);
            return plans;
        }
        int desiredHydralisks = this.desiredHydralisks(gameState);
        if (techProgression.isHydraliskDen() && hydraCount < desiredHydralisks) {
            Plan hydraliskPlan = this.planUnit(gameState, UnitType.Zerg_Hydralisk);
            plans.add(hydraliskPlan);
            return plans;
        }
        int desiredZerglings = this.zerglingsNeeded(gameState);
        if (zerglingCount < desiredZerglings) {
            int i = 0;
            while (i < desiredZerglings - zerglingCount) {
                Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Zergling);
                plans.add(zerglingPlan);
                ++i;
            }
            return plans;
        }
        int droneTarget = hatchCount * 9;
        droneTarget = Math.min(droneTarget, 55);
        if (macroHatchCount > 0 && droneCount < droneTarget) {
            int i = 0;
            while (i < droneTarget - droneCount) {
                Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
                plans.add(dronePlan);
                ++i;
            }
            return plans;
        }
        if (plans.isEmpty() && gameState.canPlanDrone() && droneCount < droneTarget) {
            Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
            plans.add(dronePlan);
            return plans;
        }
        return plans;
    }

    private boolean wantFirstMacroHatchery(GameState gameState) {
        if (this.plannedFirstMacroHatch) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 1) {
            return false;
        }
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        Time gameTime = gameState.getGameTime();
        return hydraCount > 18 || gameTime.greaterThan(new Time(10, 0));
    }

    private boolean wantSecondMacroHatchery(GameState gameState) {
        if (this.plannedSecondMacroHatch) {
            return false;
        }
        if (this.plannedFirstMacroHatch && gameState.getGameTime().lessThanOrEqual(new Time(8, 0))) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 2) {
            return false;
        }
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        Time gameTime = gameState.getGameTime();
        return hydraCount >= 25 || gameTime.greaterThan(new Time(11, 0));
    }

    private boolean wantThirdMacroHatchery(GameState gameState) {
        if (this.plannedThirdMacroHatch) {
            return false;
        }
        if (this.plannedSecondMacroHatch && gameState.getGameTime().lessThanOrEqual(new Time(9, 0))) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 3) {
            return false;
        }
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        Time gameTime = gameState.getGameTime();
        return hydraCount >= 35 || gameTime.greaterThan(new Time(12, 0));
    }

    private boolean wantHydraliskDen(GameState gameState) {
        if (this.plannedHydraliskDen || gameState.ourUnitCount(UnitType.Zerg_Extractor) == 0) {
            return false;
        }
        BaseData baseData = gameState.getBaseData();
        int baseCount = baseData.currentBaseCount();
        int plannedHatcheries = gameState.getPlannedHatcheries();
        int plannedAndCurrentHatcheries = plannedHatcheries + baseCount;
        TechProgression techProgression = gameState.getTechProgression();
        return techProgression.canPlanHydraliskDen() && plannedAndCurrentHatcheries >= 3;
    }

    private boolean wantEvolutionChamber(GameState gameState) {
        if (this.plannedEvolutionChamber) {
            return false;
        }
        TechProgression techProgression = gameState.getTechProgression();
        boolean haveDen = techProgression.isHydraliskDen();
        if (!haveDen) {
            return false;
        }
        int hydras = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        return techProgression.canPlanEvolutionChamber() && hydras > 6;
    }

    private boolean wantRangedUpgrade(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (techProgression.getEvolutionChambers() < 1) {
            return false;
        }
        return techProgression.canPlanRangedUpgrades() && techProgression.getRangedUpgrades() < 1;
    }

    private boolean wantCarapaceUpgrade(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (techProgression.getEvolutionChambers() < 1) {
            return false;
        }
        return techProgression.canPlanCarapaceUpgrades() && techProgression.getCarapaceUpgrades() < 1;
    }

    private int desiredHydralisks(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (!techProgression.isHydraliskDen()) {
            return 0;
        }
        int baseTarget = 18;
        int availableMinerals = gameState.getResourceCount().availableMinerals();
        if (availableMinerals < 400) {
            return baseTarget;
        }
        int extraHydras = availableMinerals / 75;
        return baseTarget += Math.min(extraHydras, 50);
    }

    @Override
    public boolean playsRace(Race race) {
        switch (race) {
            case Terran: 
            case Protoss: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needLair() {
        return false;
    }

    @Override
    protected int zerglingsNeeded(GameState gameState) {
        boolean den = gameState.ourUnitCount(UnitType.Zerg_Hydralisk_Den) > 0;
        int hydras = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        if (den && hydras < 11) {
            return 0;
        }
        return super.zerglingsNeeded(gameState);
    }
}

