/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder.opener;

import bwapi.Race;
import bwapi.UnitType;
import info.GameState;
import info.TechProgression;
import java.util.ArrayList;
import java.util.List;
import macro.plan.Plan;
import strategy.buildorder.BuildOrder;

public class FourPool
extends BuildOrder {
    public FourPool() {
        super("4Pool");
    }

    @Override
    public List<Plan> plan(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        ArrayList<Plan> list = new ArrayList<Plan>();
        boolean needPool = techProgression.canPlanPool();
        if (needPool) {
            Plan poolPlan = this.planSpawningPool(gameState);
            list.add(poolPlan);
            return list;
        }
        int neededDrones = 4 - gameState.ourUnitCount(UnitType.Zerg_Drone);
        if (neededDrones > 0) {
            int i = 0;
            while (i < neededDrones) {
                Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
                list.add(dronePlan);
                ++i;
            }
        }
        int neededZerglings = 24 - gameState.ourUnitCount(UnitType.Zerg_Zergling);
        if (techProgression.isSpawningPool() && neededZerglings > 0) {
            int i = 0;
            while (i < neededZerglings) {
                Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Zergling);
                list.add(zerglingPlan);
                ++i;
            }
        }
        return list;
    }

    @Override
    public boolean playsRace(Race race) {
        return true;
    }

    @Override
    public boolean isOpener() {
        return true;
    }
}

