/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder;

import bwapi.Race;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwem.Base;
import info.BaseData;
import info.GameState;
import info.TechProgression;
import info.UnitTypeCount;
import info.map.BuildingPlanner;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import macro.plan.BuildingPlan;
import macro.plan.Plan;
import macro.plan.TechPlan;
import macro.plan.UnitPlan;
import macro.plan.UpgradePlan;
import util.Time;

public abstract class BuildOrder {
    private final String name;
    protected Time activatedAt;

    protected BuildOrder(String name) {
        this.name = name;
    }

    public boolean shouldTransition(GameState gameState) {
        return false;
    }

    public Set<BuildOrder> transition(GameState gameState) {
        return new HashSet<BuildOrder>();
    }

    public abstract List<Plan> plan(GameState var1);

    public abstract boolean playsRace(Race var1);

    public boolean isOpener() {
        return false;
    }

    public boolean needLair() {
        return false;
    }

    public boolean needOverlordSpeed(GameState gameState) {
        if (gameState.ourUnitCount(UnitType.Zerg_Lair) < 1) {
            return false;
        }
        if (gameState.getGameTime().greaterThan(new Time(12, 0))) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Zerg_Lurker) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Templar_Archives) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Fleet_Beacon) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Dark_Templar) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Observer) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Terran_Vulture_Spider_Mine) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Terran_Science_Vessel) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Stargate) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Terran_Starport) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Terran_Valkyrie) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Terran_Wraith) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Scout) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Protoss_Corsair) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Zerg_Devourer) > 0) {
            return true;
        }
        if (gameState.enemyUnitCount(UnitType.Zerg_Greater_Spire) > 0) {
            return true;
        }
        return gameState.enemyUnitCount(UnitType.Zerg_Hive) > 0;
    }

    protected int requiredSunkens(GameState gameState) {
        return 0;
    }

    protected int zerglingsNeeded(GameState gameState) {
        return 6;
    }

    protected Plan planNewBase(GameState gameState) {
        Base base = gameState.reserveBase();
        if (base == null) {
            return null;
        }
        gameState.addPlannedHatchery(1);
        return new BuildingPlan(UnitType.Zerg_Hatchery, gameState.getGameTime().getFrames(), true, base.getLocation());
    }

    protected Plan planLair(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        techProgression.setPlannedLair(true);
        return new BuildingPlan(UnitType.Zerg_Lair, 3, true);
    }

    protected Plan planSpawningPool(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        techProgression.setPlannedSpawningPool(true);
        BuildingPlan plan = new BuildingPlan(UnitType.Zerg_Spawning_Pool, gameState.getGameTime(), true);
        TilePosition buildPosition = gameState.getTechBuildingLocation(UnitType.Zerg_Spawning_Pool);
        ((Plan)plan).setBuildPosition(buildPosition);
        return plan;
    }

    protected Plan planSpire(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        techProgression.setSpire(true);
        BuildingPlan plan = new BuildingPlan(UnitType.Zerg_Spire, 4, true);
        TilePosition buildPosition = gameState.getTechBuildingLocation(UnitType.Zerg_Spire);
        ((Plan)plan).setBuildPosition(buildPosition);
        return plan;
    }

    protected Plan planExtractor(GameState gameState) {
        BaseData baseData = gameState.getBaseData();
        BuildingPlan plan = new BuildingPlan(UnitType.Zerg_Extractor, 50, true);
        Unit geyser = baseData.reserveExtractor();
        ((Plan)plan).setBuildPosition(geyser.getTilePosition());
        return plan;
    }

    protected Set<Plan> planSunkenColony(GameState gameState) {
        HashSet<Plan> plans = new HashSet<Plan>();
        BaseData baseData = gameState.getBaseData();
        BuildingPlanner buildingPlanner = gameState.getBuildingPlanner();
        Optional eligibleBase = gameState.basesNeedingSunken(this.requiredSunkens(gameState)).stream().findFirst();
        if (!eligibleBase.isPresent()) {
            return plans;
        }
        baseData.reserveSunkenColony((Base)eligibleBase.get());
        TilePosition location = buildingPlanner.getLocationForCreepColony((Base)eligibleBase.get(), gameState.getOpponentRace());
        buildingPlanner.reservePlannedBuildingTiles(location, UnitType.Zerg_Creep_Colony);
        BuildingPlan creepColonyPlan = new BuildingPlan(UnitType.Zerg_Creep_Colony, 5, true, location);
        BuildingPlan sunkenColonyPlan = new BuildingPlan(UnitType.Zerg_Sunken_Colony, 5, true, location);
        plans.add(creepColonyPlan);
        plans.add(sunkenColonyPlan);
        return plans;
    }

    protected Plan planUnit(GameState gameState, UnitType unitType) {
        UnitTypeCount count = gameState.getUnitTypeCount();
        count.planUnit(unitType);
        if (unitType == UnitType.Zerg_Drone) {
            gameState.addPlannedWorker(1);
        }
        if (unitType == UnitType.Zerg_Overlord) {
            int plannedSupply = gameState.getResourceCount().getPlannedSupply();
            gameState.getResourceCount().setPlannedSupply(plannedSupply + 16);
        }
        return new UnitPlan(unitType, gameState.getGameTime().getFrames(), true);
    }

    protected Plan planUpgrade(GameState gameState, UpgradeType upgradeType) {
        TechProgression techProgression = gameState.getTechProgression();
        int priority = gameState.getGameTime().getFrames();
        switch (upgradeType) {
            case Metabolic_Boost: {
                techProgression.setPlannedMetabolicBoost(true);
                break;
            }
            case Muscular_Augments: {
                techProgression.setPlannedMuscularAugments(true);
                break;
            }
            case Grooved_Spines: {
                techProgression.setPlannedGroovedSpines(true);
                break;
            }
            case Zerg_Melee_Attacks: {
                int meleeAttacks = techProgression.getMeleeUpgrades();
                techProgression.setMeleeUpgrades(meleeAttacks + 1);
                break;
            }
            case Zerg_Missile_Attacks: {
                int missileAttacks = techProgression.getRangedUpgrades();
                techProgression.setRangedUpgrades(missileAttacks + 1);
                break;
            }
            case Zerg_Flyer_Carapace: {
                int flyerCarapace = techProgression.getFlyerDefense();
                techProgression.setFlyerDefense(flyerCarapace + 1);
                break;
            }
            case Zerg_Carapace: {
                int carapace = techProgression.getCarapaceUpgrades();
                techProgression.setCarapaceUpgrades(carapace + 1);
                break;
            }
            case Pneumatized_Carapace: {
                techProgression.setPlannedOverlordSpeed(true);
                priority = 100;
            }
        }
        return new UpgradePlan(upgradeType, priority, false);
    }

    protected Plan planHydraliskDen(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        techProgression.setPlannedDen(true);
        BuildingPlan plan = new BuildingPlan(UnitType.Zerg_Hydralisk_Den, gameState.getGameTime().getFrames(), true);
        TilePosition buildPosition = gameState.getTechBuildingLocation(UnitType.Zerg_Hydralisk_Den);
        ((Plan)plan).setBuildPosition(buildPosition);
        return plan;
    }

    protected Plan planEvolutionChamber(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        techProgression.setPlannedEvolutionChambers(techProgression.getPlannedEvolutionChambers() + 1);
        BuildingPlan plan = new BuildingPlan(UnitType.Zerg_Evolution_Chamber, gameState.getGameTime().getFrames(), true);
        TilePosition buildPosition = gameState.getTechBuildingLocation(UnitType.Zerg_Evolution_Chamber);
        ((Plan)plan).setBuildPosition(buildPosition);
        return plan;
    }

    protected Plan planTech(GameState gameState, TechType techType) {
        TechProgression techProgression = gameState.getTechProgression();
        int priority = gameState.getGameTime().getFrames();
        if (techType == TechType.Lurker_Aspect) {
            techProgression.setPlannedLurker(true);
            priority = 100;
        }
        return new TechPlan(techType, priority, true);
    }

    protected Plan planMacroHatchery(GameState gameState) {
        BuildingPlanner buildingPlanner = gameState.getBuildingPlanner();
        BaseData baseData = gameState.getBaseData();
        TilePosition location = buildingPlanner.getLocationForMacroHatchery(gameState.getOpponentRace(), baseData);
        if (location == null) {
            return null;
        }
        buildingPlanner.reservePlannedBuildingTiles(location, UnitType.Zerg_Hatchery);
        gameState.addPlannedHatchery(1);
        return new BuildingPlan(UnitType.Zerg_Hatchery, gameState.getGameTime().getFrames(), true, location);
    }

    protected boolean behindOnHatchery(GameState gameState) {
        int enemyHives;
        int enemyLairs;
        if (gameState.getOpponentRace() != Race.Zerg) {
            return false;
        }
        int ourHatcheries = gameState.ourUnitCount(UnitType.Zerg_Hatchery);
        int ourLairs = gameState.ourUnitCount(UnitType.Zerg_Lair);
        int ourHives = gameState.ourUnitCount(UnitType.Zerg_Hive);
        int ourPlanned = gameState.getPlannedHatcheries();
        int morphingLairs = gameState.ourMorphingCount(UnitType.Zerg_Lair);
        int ourTotal = ourHatcheries + ourLairs + ourHives + ourPlanned + morphingLairs;
        int enemyHatcheries = gameState.enemyUnitCount(UnitType.Zerg_Hatchery);
        int enemyTotal = enemyHatcheries + (enemyLairs = gameState.enemyUnitCount(UnitType.Zerg_Lair)) + (enemyHives = gameState.enemyUnitCount(UnitType.Zerg_Hive));
        return enemyTotal > ourTotal;
    }

    protected boolean behindOnBases(GameState gameState) {
        int enemyTotal;
        BaseData baseData = gameState.getBaseData();
        if (!baseData.hasNaturalExpansion()) {
            return false;
        }
        int ourBaseCount = baseData.currentAndReservedCount();
        return ourBaseCount <= (enemyTotal = gameState.enemyResourceDepotCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildOrder that = (BuildOrder)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

