/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.bk.ass.PositionOutOfBoundsException;
import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.AttackerBehavior;
import org.bk.ass.sim.HealerBehavior;
import org.bk.ass.sim.RepairerBehavior;
import org.bk.ass.sim.SuiciderBehavior;

public class Simulator {
    public static final ToIntFunction<Agent> HEALTH_AND_SHIELD = agent -> agent.getHealth() + agent.getShields();
    public static final ToIntFunction<Agent> HEALTH_AND_HALFED_SHIELD = agent -> agent.getHealth() + agent.getShields() / 2;
    private static final int MAX_MAP_DIMENSION = 8192;
    private static final int TILE_SIZE = 16;
    public static final int MIN_SIMULATION_RANGE = 576;
    private static final int COLLISION_MAP_DIMENSION = 512;
    private final UnorderedCollection<Agent> playerA = new UnorderedCollection();
    private final UnorderedCollection<Agent> playerB = new UnorderedCollection();
    final byte[] collision = new byte[262144];
    private final Behavior playerABehavior;
    private final Behavior playerBBehavior;
    private final int frameSkip;

    private Simulator(int frameSkip, Behavior playerABehavior, Behavior playerBBehavior) {
        if (frameSkip < 1) {
            throw new IllegalArgumentException("frameSkip must be >= 1");
        }
        Objects.requireNonNull(playerABehavior, "Behavior of player A must be set");
        Objects.requireNonNull(playerBBehavior, "Behavior of player B must be set");
        this.playerABehavior = playerABehavior;
        this.playerBBehavior = playerBBehavior;
        this.frameSkip = frameSkip;
    }

    public Simulator addAgentA(Agent agent) {
        this.checkBounds(agent);
        this.playerA.add(agent);
        if (!agent.isFlyer) {
            int n = this.colindex(agent.x, agent.y);
            this.collision[n] = (byte)(this.collision[n] + 1);
        }
        return this;
    }

    public void removeAgentA(Agent agent) {
        this.playerA.remove(agent);
    }

    public void removeAgentB(Agent agent) {
        this.playerB.remove(agent);
    }

    public Simulator addAgentB(Agent agent) {
        this.checkBounds(agent);
        this.playerB.add(agent);
        if (!agent.isFlyer) {
            int n = this.colindex(agent.x, agent.y);
            this.collision[n] = (byte)(this.collision[n] + 1);
        }
        return this;
    }

    private void checkBounds(Agent agent) {
        if (agent.x < 0 || agent.x >= 8192 || agent.y < 0 || agent.y >= 8192) {
            throw new PositionOutOfBoundsException(agent + " should be inside the map! This could be caused by an agent being fogged.");
        }
    }

    public Collection<Agent> getAgentsA() {
        return Collections.unmodifiableCollection(this.playerA);
    }

    public Collection<Agent> getAgentsB() {
        return Collections.unmodifiableCollection(this.playerB);
    }

    public IntEvaluation evalToInt(ToIntFunction<Agent> agentEval) {
        int evalA = 0;
        for (Agent agent : this.playerA) {
            evalA += agentEval.applyAsInt(agent);
        }
        int evalB = 0;
        for (Agent agent : this.playerB) {
            evalB += agentEval.applyAsInt(agent);
        }
        return new IntEvaluation(evalA, evalB);
    }

    public int simulate() {
        return this.simulate(96);
    }

    public int simulate(int frames) {
        if (frames > 0) {
            frames += Math.floorMod(this.frameSkip - frames, this.frameSkip);
        }
        while (frames != 0 && !this.playerA.isEmpty() && !this.playerB.isEmpty()) {
            frames -= this.frameSkip;
            if (this.step()) continue;
        }
        this.playerA.clearReferences();
        this.playerB.clearReferences();
        return frames;
    }

    public void reset() {
        Agent agent;
        int i;
        for (i = this.playerA.size() - 1; i >= 0; --i) {
            agent = this.playerA.get(i);
            this.collision[this.colindex((int)agent.x, (int)agent.y)] = 0;
        }
        for (i = this.playerB.size() - 1; i >= 0; --i) {
            agent = this.playerB.get(i);
            this.collision[this.colindex((int)agent.x, (int)agent.y)] = 0;
        }
        this.resetUnits();
    }

    private void resetUnits() {
        this.playerA.clear();
        this.playerB.clear();
    }

    private boolean step() {
        Agent agent;
        int i;
        boolean simRunning = false;
        for (i = this.playerA.size() - 1; i >= 0; --i) {
            agent = this.playerA.get(i);
            simRunning |= agent.isLockeddown || agent.isStasised || this.playerABehavior.simUnit(this.frameSkip, agent, this.playerA, this.playerB);
        }
        for (i = this.playerB.size() - 1; i >= 0; --i) {
            agent = this.playerB.get(i);
            simRunning |= agent.isLockeddown || agent.isStasised || this.playerBBehavior.simUnit(this.frameSkip, agent, this.playerB, this.playerA);
        }
        this.removeDead(this.playerA);
        this.removeDead(this.playerB);
        this.updateStats(this.playerA);
        this.updateStats(this.playerB);
        return simRunning;
    }

    private void removeDead(UnorderedCollection<Agent> agents) {
        int i = 0;
        while (i < agents.size()) {
            if (agents.get((int)i).healthShifted < 1) {
                Agent agent = agents.removeAt(i);
                if (!agent.isFlyer) {
                    int n = this.colindex(agent.x, agent.y);
                    this.collision[n] = (byte)(this.collision[n] - 1);
                }
                agent.onDeathHandler.accept(agent, agents);
                continue;
            }
            ++i;
        }
    }

    private void updateStats(UnorderedCollection<Agent> agents) {
        for (int i = agents.size() - 1; i >= 0; --i) {
            Agent agent = agents.get(i);
            assert (agent.healthShifted >= 0);
            this.updatePosition(agent);
            agent.vx = 0;
            agent.vy = 0;
            agent.healedThisFrame = false;
            agent.cooldown -= this.frameSkip;
            agent.shieldsShifted += 7 * this.frameSkip;
            if (agent.plagueDamagePerFrameShifted * this.frameSkip < agent.healthShifted) {
                agent.healthShifted -= agent.plagueDamagePerFrameShifted * this.frameSkip;
            }
            agent.remainingStimFrames -= this.frameSkip;
            if (agent.regeneratesHealth) {
                agent.healthShifted += 4 * this.frameSkip;
            }
            agent.energyShifted += 8 * this.frameSkip;
        }
    }

    private void updatePosition(Agent agent) {
        int newCI;
        int oldCI;
        int tx = agent.x + agent.vx;
        int ty = agent.y + agent.vy;
        if (tx < 0 || ty < 0 || tx >= 8192 || ty >= 8192) {
            return;
        }
        if (!agent.isFlyer && (oldCI = this.colindex(agent.x, agent.y)) != (newCI = this.colindex(tx, ty))) {
            if (this.collision[newCI] > 1) {
                return;
            }
            int n = oldCI;
            this.collision[n] = (byte)(this.collision[n] - 1);
            int n2 = newCI;
            this.collision[n2] = (byte)(this.collision[n2] + 1);
        }
        agent.x = tx;
        agent.y = ty;
    }

    private int colindex(int tx, int ty) {
        return ty / 16 * 512 + tx / 16;
    }

    public static final class Builder {
        private Behavior playerABehavior = new RoleBasedBehavior();
        private Behavior playerBBehavior = new RoleBasedBehavior();
        private int frameSkip = 1;

        public Builder withPlayerABehavior(Behavior playerABehavior) {
            this.playerABehavior = playerABehavior;
            return this;
        }

        public Builder withPlayerBBehavior(Behavior playerBBehavior) {
            this.playerBBehavior = playerBBehavior;
            return this;
        }

        public Builder withFrameSkip(int frameSkip) {
            this.frameSkip = frameSkip;
            return this;
        }

        public Simulator build() {
            return new Simulator(this.frameSkip, this.playerABehavior, this.playerBBehavior);
        }
    }

    public static class IntEvaluation {
        public final int evalA;
        public final int evalB;

        IntEvaluation(int evalA, int evalB) {
            this.evalA = evalA;
            this.evalB = evalB;
        }

        public int delta() {
            return this.evalA - this.evalB;
        }

        public int dot(IntEvaluation other) {
            return this.evalA * other.evalA - this.evalB * other.evalB;
        }

        public int cross(IntEvaluation other) {
            return this.evalA * other.evalB - this.evalB * other.evalA;
        }

        public IntEvaluation subtract(IntEvaluation other) {
            return new IntEvaluation(this.evalA - other.evalA, this.evalB - other.evalB);
        }
    }

    public static interface Behavior {
        public boolean simUnit(int var1, Agent var2, UnorderedCollection<Agent> var3, UnorderedCollection<Agent> var4);
    }

    public static class RoleBasedBehavior
    implements Behavior {
        private final Behavior attackerSimulator;
        private final Behavior healerSimulator;
        private final Behavior repairerSimulator;
        private final Behavior suiciderSimulator;

        public RoleBasedBehavior(Behavior attackerSimulator, Behavior healerSimulator, Behavior repairerSimulator, Behavior suiciderSimulator) {
            this.attackerSimulator = attackerSimulator;
            this.healerSimulator = healerSimulator;
            this.repairerSimulator = repairerSimulator;
            this.suiciderSimulator = suiciderSimulator;
        }

        public RoleBasedBehavior() {
            this(new AttackerBehavior(), new HealerBehavior(), new RepairerBehavior(), new SuiciderBehavior());
        }

        @Override
        public boolean simUnit(int frameSkip, Agent agent, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
            if (agent.isSuicider) {
                return this.suiciderSimulator.simUnit(frameSkip, agent, allies, enemies);
            }
            if (agent.isHealer) {
                return this.healerSimulator.simUnit(frameSkip, agent, allies, enemies);
            }
            if (agent.isRepairer && this.repairerSimulator.simUnit(frameSkip, agent, allies, enemies)) {
                return true;
            }
            return this.attackerSimulator.simUnit(frameSkip, agent, allies, enemies);
        }
    }
}

