/*
 * Decompiled with CFR 0.152.
 */
package macro.plan;

import bwapi.TilePosition;
import bwapi.UnitType;
import lombok.Generated;
import macro.plan.Plan;
import macro.plan.PlanType;
import org.jetbrains.annotations.Nullable;
import util.Time;

public class BuildingPlan
extends Plan {
    @Nullable
    private TilePosition buildPosition;
    private UnitType plannedUnit;

    public BuildingPlan(UnitType unitType, int priority, boolean isBlocking) {
        super(priority, isBlocking);
        this.plannedUnit = unitType;
        this.blockOtherPlans = isBlocking;
    }

    public BuildingPlan(UnitType unitType, int priority, boolean isBlocking, TilePosition buildPosition) {
        super(priority, isBlocking);
        this.plannedUnit = unitType;
        this.buildPosition = buildPosition;
    }

    public BuildingPlan(UnitType unitType, Time time, boolean isBlocking) {
        super(time.getFrames(), isBlocking);
        this.plannedUnit = unitType;
        this.blockOtherPlans = isBlocking;
    }

    public BuildingPlan(UnitType unitType, Time time, boolean isBlocking, TilePosition buildPosition) {
        super(time.getFrames(), isBlocking);
        this.plannedUnit = unitType;
        this.buildPosition = buildPosition;
    }

    @Override
    public PlanType getType() {
        return PlanType.BUILDING;
    }

    @Override
    public String getName() {
        return this.plannedUnit.toString();
    }

    @Override
    public int mineralPrice() {
        return this.plannedUnit.mineralPrice();
    }

    @Override
    @Nullable
    @Generated
    public TilePosition getBuildPosition() {
        return this.buildPosition;
    }

    @Override
    @Generated
    public void setBuildPosition(@Nullable TilePosition buildPosition) {
        this.buildPosition = buildPosition;
    }

    @Override
    @Generated
    public UnitType getPlannedUnit() {
        return this.plannedUnit;
    }

    @Override
    @Generated
    public void setPlannedUnit(UnitType plannedUnit) {
        this.plannedUnit = plannedUnit;
    }
}

