/*
 * Decompiled with CFR 0.152.
 */
package learning;

import java.util.ArrayList;
import java.util.List;
import learning.UCBRecord;
import lombok.Generated;

public class MapAwareRecord
implements UCBRecord {
    private static final double GAMMA = 0.95;
    private String strategy;
    private String mapName;
    private String opponentName;
    private String opponentRace;
    private int wins;
    private int losses;
    private List<Long> winTimestamps;
    private List<Long> lossTimestamps;

    public int netWins() {
        return this.wins - this.losses;
    }

    @Override
    public int wins() {
        return this.wins;
    }

    @Override
    public int games() {
        return this.wins + this.losses;
    }

    @Override
    public int winsSquared() {
        return this.wins * this.wins;
    }

    public void addWinTimestamp(long timestamp) {
        this.winTimestamps.add(timestamp);
    }

    public void addLossTimestamp(long timestamp) {
        this.lossTimestamps.add(timestamp);
    }

    @Override
    public double index(int totalGames) {
        if (totalGames == 0 || this.games() == 0) {
            return 1.0;
        }
        double discountedWins = this.calculateDiscountedWins();
        double discountedGames = this.calculateDiscountedGames();
        if (discountedGames == 0.0) {
            return 1.0;
        }
        double sampleMean = discountedWins / discountedGames;
        double c = Math.sqrt(2.0 * Math.log(totalGames) / discountedGames);
        return sampleMean + c;
    }

    private double calculateDiscountedWins() {
        ArrayList<Long> allTimestamps = new ArrayList<Long>();
        allTimestamps.addAll(this.winTimestamps);
        allTimestamps.addAll(this.lossTimestamps);
        allTimestamps.sort((a, b) -> Long.compare(b, a));
        double discountedWins = 0.0;
        int i = 0;
        while (i < allTimestamps.size()) {
            Long t = (Long)allTimestamps.get(i);
            if (this.winTimestamps.contains(t)) {
                double weight = Math.pow(0.95, i);
                discountedWins += weight;
            }
            ++i;
        }
        return discountedWins;
    }

    private double calculateDiscountedGames() {
        ArrayList<Long> allTimestamps = new ArrayList<Long>();
        allTimestamps.addAll(this.winTimestamps);
        allTimestamps.addAll(this.lossTimestamps);
        double discountedGames = 0.0;
        int i = 0;
        while (i < allTimestamps.size()) {
            double weight = Math.pow(0.95, i);
            discountedGames += weight;
            ++i;
        }
        return discountedGames;
    }

    @Generated
    private static List<Long> $default$winTimestamps() {
        return new ArrayList<Long>();
    }

    @Generated
    private static List<Long> $default$lossTimestamps() {
        return new ArrayList<Long>();
    }

    @Generated
    MapAwareRecord(String strategy, String mapName, String opponentName, String opponentRace, int wins, int losses, List<Long> winTimestamps, List<Long> lossTimestamps) {
        this.strategy = strategy;
        this.mapName = mapName;
        this.opponentName = opponentName;
        this.opponentRace = opponentRace;
        this.wins = wins;
        this.losses = losses;
        this.winTimestamps = winTimestamps;
        this.lossTimestamps = lossTimestamps;
    }

    @Generated
    public static MapAwareRecordBuilder builder() {
        return new MapAwareRecordBuilder();
    }

    @Generated
    public String getStrategy() {
        return this.strategy;
    }

    @Generated
    public String getMapName() {
        return this.mapName;
    }

    @Generated
    public String getOpponentName() {
        return this.opponentName;
    }

    @Generated
    public String getOpponentRace() {
        return this.opponentRace;
    }

    @Generated
    public int getWins() {
        return this.wins;
    }

    @Generated
    public int getLosses() {
        return this.losses;
    }

    @Generated
    public List<Long> getWinTimestamps() {
        return this.winTimestamps;
    }

    @Generated
    public List<Long> getLossTimestamps() {
        return this.lossTimestamps;
    }

    @Generated
    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    @Generated
    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    @Generated
    public void setOpponentName(String opponentName) {
        this.opponentName = opponentName;
    }

    @Generated
    public void setOpponentRace(String opponentRace) {
        this.opponentRace = opponentRace;
    }

    @Generated
    public void setWins(int wins) {
        this.wins = wins;
    }

    @Generated
    public void setLosses(int losses) {
        this.losses = losses;
    }

    @Generated
    public void setWinTimestamps(List<Long> winTimestamps) {
        this.winTimestamps = winTimestamps;
    }

    @Generated
    public void setLossTimestamps(List<Long> lossTimestamps) {
        this.lossTimestamps = lossTimestamps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapAwareRecord)) {
            return false;
        }
        MapAwareRecord other = (MapAwareRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        if (this.getLosses() != other.getLosses()) {
            return false;
        }
        String this$strategy = this.getStrategy();
        String other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        String this$mapName = this.getMapName();
        String other$mapName = other.getMapName();
        if (this$mapName == null ? other$mapName != null : !this$mapName.equals(other$mapName)) {
            return false;
        }
        String this$opponentName = this.getOpponentName();
        String other$opponentName = other.getOpponentName();
        if (this$opponentName == null ? other$opponentName != null : !this$opponentName.equals(other$opponentName)) {
            return false;
        }
        String this$opponentRace = this.getOpponentRace();
        String other$opponentRace = other.getOpponentRace();
        if (this$opponentRace == null ? other$opponentRace != null : !this$opponentRace.equals(other$opponentRace)) {
            return false;
        }
        List<Long> this$winTimestamps = this.getWinTimestamps();
        List<Long> other$winTimestamps = other.getWinTimestamps();
        if (this$winTimestamps == null ? other$winTimestamps != null : !((Object)this$winTimestamps).equals(other$winTimestamps)) {
            return false;
        }
        List<Long> this$lossTimestamps = this.getLossTimestamps();
        List<Long> other$lossTimestamps = other.getLossTimestamps();
        return !(this$lossTimestamps == null ? other$lossTimestamps != null : !((Object)this$lossTimestamps).equals(other$lossTimestamps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MapAwareRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        String $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        String $mapName = this.getMapName();
        result = result * 59 + ($mapName == null ? 43 : $mapName.hashCode());
        String $opponentName = this.getOpponentName();
        result = result * 59 + ($opponentName == null ? 43 : $opponentName.hashCode());
        String $opponentRace = this.getOpponentRace();
        result = result * 59 + ($opponentRace == null ? 43 : $opponentRace.hashCode());
        List<Long> $winTimestamps = this.getWinTimestamps();
        result = result * 59 + ($winTimestamps == null ? 43 : ((Object)$winTimestamps).hashCode());
        List<Long> $lossTimestamps = this.getLossTimestamps();
        result = result * 59 + ($lossTimestamps == null ? 43 : ((Object)$lossTimestamps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MapAwareRecord(strategy=" + this.getStrategy() + ", mapName=" + this.getMapName() + ", opponentName=" + this.getOpponentName() + ", opponentRace=" + this.getOpponentRace() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ", winTimestamps=" + this.getWinTimestamps() + ", lossTimestamps=" + this.getLossTimestamps() + ")";
    }

    @Generated
    public static class MapAwareRecordBuilder {
        @Generated
        private String strategy;
        @Generated
        private String mapName;
        @Generated
        private String opponentName;
        @Generated
        private String opponentRace;
        @Generated
        private int wins;
        @Generated
        private int losses;
        @Generated
        private List<Long> winTimestamps$value;
        @Generated
        private boolean winTimestamps$set;
        @Generated
        private List<Long> lossTimestamps$value;
        @Generated
        private boolean lossTimestamps$set;

        @Generated
        MapAwareRecordBuilder() {
        }

        @Generated
        public MapAwareRecordBuilder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder opponentName(String opponentName) {
            this.opponentName = opponentName;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder opponentRace(String opponentRace) {
            this.opponentRace = opponentRace;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder winTimestamps(List<Long> winTimestamps) {
            this.winTimestamps$value = winTimestamps;
            this.winTimestamps$set = true;
            return this;
        }

        @Generated
        public MapAwareRecordBuilder lossTimestamps(List<Long> lossTimestamps) {
            this.lossTimestamps$value = lossTimestamps;
            this.lossTimestamps$set = true;
            return this;
        }

        @Generated
        public MapAwareRecord build() {
            List winTimestamps$value = this.winTimestamps$value;
            if (!this.winTimestamps$set) {
                winTimestamps$value = MapAwareRecord.$default$winTimestamps();
            }
            List lossTimestamps$value = this.lossTimestamps$value;
            if (!this.lossTimestamps$set) {
                lossTimestamps$value = MapAwareRecord.$default$lossTimestamps();
            }
            return new MapAwareRecord(this.strategy, this.mapName, this.opponentName, this.opponentRace, this.wins, this.losses, winTimestamps$value, lossTimestamps$value);
        }

        @Generated
        public String toString() {
            return "MapAwareRecord.MapAwareRecordBuilder(strategy=" + this.strategy + ", mapName=" + this.mapName + ", opponentName=" + this.opponentName + ", opponentRace=" + this.opponentRace + ", wins=" + this.wins + ", losses=" + this.losses + ", winTimestamps$value=" + this.winTimestamps$value + ", lossTimestamps$value=" + this.lossTimestamps$value + ")";
        }
    }
}

