/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.UnitType;
import java.util.HashMap;

public class UnitTypeCount {
    private HashMap<UnitType, Integer> unitTypeCount = new HashMap();
    private HashMap<UnitType, Integer> plannedUnitTypeCount = new HashMap();

    public int get(UnitType unitType) {
        this.ensureUnitType(unitType);
        return this.unitTypeCount.get((Object)unitType) + this.plannedUnitTypeCount.get((Object)unitType);
    }

    private int safeGet(UnitType unitType) {
        this.ensureUnitType(unitType);
        return this.unitTypeCount.get((Object)unitType);
    }

    private int safeLivingGet(UnitType unitType) {
        this.ensureUnitType(unitType);
        return this.unitTypeCount.get((Object)unitType);
    }

    public void addUnit(UnitType unitType) {
        if (!this.unitTypeCount.containsKey((Object)unitType)) {
            this.unitTypeCount.put(unitType, 0);
        }
        int newCount = this.unitTypeCount.get((Object)unitType) + 1;
        this.unitTypeCount.put(unitType, newCount);
    }

    public void removeUnit(UnitType unitType) {
        if (!this.unitTypeCount.containsKey((Object)unitType)) {
            return;
        }
        int newCount = this.unitTypeCount.get((Object)unitType) - 1;
        this.unitTypeCount.put(unitType, newCount);
    }

    public void planUnit(UnitType unitType) {
        if (!this.plannedUnitTypeCount.containsKey((Object)unitType)) {
            this.plannedUnitTypeCount.put(unitType, 0);
        }
        int newCount = this.plannedUnitTypeCount.get((Object)unitType) + 1;
        if (unitType == UnitType.Zerg_Zergling || unitType == UnitType.Zerg_Scourge) {
            ++newCount;
        }
        this.plannedUnitTypeCount.put(unitType, newCount);
    }

    public void unplanUnit(UnitType unitType) {
        if (!this.plannedUnitTypeCount.containsKey((Object)unitType)) {
            return;
        }
        int newCount = this.plannedUnitTypeCount.get((Object)unitType) - 1;
        if (newCount >= 0) {
            this.plannedUnitTypeCount.put(unitType, newCount);
        }
    }

    public HashMap<UnitType, Integer> getCountLookup() {
        return this.unitTypeCount;
    }

    private void ensureUnitType(UnitType unitType) {
        if (!this.unitTypeCount.containsKey((Object)unitType)) {
            this.unitTypeCount.put(unitType, 0);
        }
        if (!this.plannedUnitTypeCount.containsKey((Object)unitType)) {
            this.plannedUnitTypeCount.put(unitType, 0);
        }
    }

    public int meleeCount() {
        return this.safeGet(UnitType.Zerg_Zergling) + this.safeGet(UnitType.Zerg_Ultralisk);
    }

    public int rangedCount() {
        return this.safeGet(UnitType.Zerg_Hydralisk) + this.safeGet(UnitType.Zerg_Lurker);
    }

    public int groundCount() {
        return this.meleeCount() + this.rangedCount() + this.safeGet(UnitType.Zerg_Defiler);
    }

    public int airCount() {
        return this.safeGet(UnitType.Zerg_Mutalisk) + this.safeGet(UnitType.Zerg_Guardian) + this.safeGet(UnitType.Zerg_Devourer);
    }

    public int livingCount(UnitType unitType) {
        return this.safeLivingGet(unitType);
    }
}

