/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class ScoutData {
    private HashSet<TilePosition> scoutTargets = new HashSet();
    private HashSet<TilePosition> activeScoutTargets = new HashSet();
    private HashSet<TilePosition> enemyBuildingPositions = new HashSet();
    private HashMap<Base, Integer> baseScoutAssignments = new HashMap();

    public void addScoutTarget(TilePosition tp) {
        this.scoutTargets.add(tp);
    }

    public boolean hasScoutTarget(TilePosition tp) {
        return this.scoutTargets.contains(tp);
    }

    public boolean hasScoutTargets() {
        return this.scoutTargets.size() > 0;
    }

    public HashSet<TilePosition> getScoutTargets() {
        return this.scoutTargets;
    }

    public void removeActiveScoutTarget(TilePosition tp) {
        this.activeScoutTargets.remove(tp);
    }

    public void removeScoutTarget(TilePosition tp) {
        this.scoutTargets.remove(tp);
    }

    public void setActiveScoutTarget(TilePosition tp) {
        this.scoutTargets.remove(tp);
        this.activeScoutTargets.add(tp);
    }

    public boolean isEnemyBuildingLocationKnown() {
        return !this.enemyBuildingPositions.isEmpty();
    }

    public boolean shouldOverlordsContinueScouting(Race enemyRace, Set<Unit> enemies) {
        switch (enemyRace) {
            case Terran: {
                return !this.hasTerranScoutingConditions(enemies);
            }
            case Protoss: {
                return !this.hasProtossScoutingConditions(enemies);
            }
            case Zerg: {
                return !this.hasZergScoutingConditions(enemies);
            }
            case Unknown: {
                return true;
            }
        }
        return false;
    }

    private boolean hasTerranScoutingConditions(Set<Unit> enemies) {
        for (Unit unit : enemies) {
            if (unit.getType() == UnitType.Terran_Marine) {
                return true;
            }
            if (unit.getType() != UnitType.Terran_Barracks) continue;
            return true;
        }
        return false;
    }

    private boolean hasProtossScoutingConditions(Set<Unit> enemies) {
        for (Unit unit : enemies) {
            if (unit.getType() == UnitType.Protoss_Dragoon) {
                return true;
            }
            if (unit.getType() == UnitType.Protoss_Corsair) {
                return true;
            }
            if (unit.getType() == UnitType.Protoss_Cybernetics_Core) {
                return true;
            }
            if (unit.getType() != UnitType.Protoss_Stargate) continue;
            return true;
        }
        return false;
    }

    private boolean hasZergScoutingConditions(Set<Unit> enemies) {
        for (Unit unit : enemies) {
            if (unit.getType() == UnitType.Zerg_Spire) {
                return true;
            }
            if (unit.getType() == UnitType.Zerg_Mutalisk) {
                return true;
            }
            if (unit.getType() != UnitType.Zerg_Hydralisk) continue;
            return true;
        }
        return false;
    }

    public void addEnemyBuildingLocation(TilePosition tp) {
        this.enemyBuildingPositions.add(tp);
    }

    public void removeEnemyBuildingLocation(TilePosition tp) {
        this.enemyBuildingPositions.remove(tp);
    }

    public int getScoutsAssignedToBase(Base base) {
        return this.baseScoutAssignments.get(base);
    }

    public void removeBaseScoutAssignment(Base base) {
        this.baseScoutAssignments.remove(base);
    }

    public void addBaseScoutAssignment(Base base) {
        this.baseScoutAssignments.put(base, 0);
    }

    public void updateBaseScoutAssignment(Base base, int assignments) {
        this.baseScoutAssignments.put(base, assignments + 1);
    }

    public Set<Base> getScoutingBaseSet() {
        return this.baseScoutAssignments.keySet();
    }

    public TilePosition findNewActiveScoutTarget() {
        for (TilePosition target : this.scoutTargets) {
            if (this.activeScoutTargets.contains(target)) continue;
            return target;
        }
        return null;
    }

    public void clearScoutedBase(Base base) {
        if (base == null) {
            return;
        }
        TilePosition tp = base.getLocation();
        this.activeScoutTargets.remove(tp);
        this.scoutTargets.remove(tp);
        this.enemyBuildingPositions.remove(tp);
        this.removeBaseScoutAssignment(base);
    }

    @Generated
    public HashSet<TilePosition> getActiveScoutTargets() {
        return this.activeScoutTargets;
    }

    @Generated
    public HashSet<TilePosition> getEnemyBuildingPositions() {
        return this.enemyBuildingPositions;
    }
}

