/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Pair;
import bwem.Altitude;
import bwem.AreaId;
import bwem.Asserter;
import java.util.Comparator;

public final class MiniTile {
    private static final AreaId blockingCP = new AreaId(Integer.MIN_VALUE);
    public static final Comparator<Pair<?, MiniTile>> BY_ALTITUDE_ORDER = Comparator.comparing(p -> ((MiniTile)p.getRight()).getAltitude().intValue());
    private Altitude altitude = Altitude.UNINITIALIZED;
    private AreaId areaId = AreaId.UNINITIALIZED;
    private final Asserter asserter;

    MiniTile(Asserter asserter) {
        this.asserter = asserter;
    }

    public boolean isWalkable() {
        return this.areaId.intValue() != 0;
    }

    void setWalkable(boolean walkable) {
        this.areaId = new AreaId(walkable ? -1 : 0);
        this.altitude = new Altitude(walkable ? -1 : 1);
    }

    public Altitude getAltitude() {
        return this.altitude;
    }

    void setAltitude(Altitude altitude) {
        if (!this.isAltitudeMissing() || altitude.intValue() <= 0) {
            this.asserter.throwIllegalStateException("");
        }
        this.altitude = altitude;
    }

    public boolean isSea() {
        return this.altitude.intValue() == 0;
    }

    public boolean isLake() {
        return this.altitude.intValue() != 0 && !this.isWalkable();
    }

    public boolean isTerrain() {
        return this.isWalkable();
    }

    public AreaId getAreaId() {
        return this.areaId;
    }

    void setAreaId(AreaId areaId) {
        if (!this.isAreaIdMissing() || areaId.intValue() < 1) {
            this.asserter.throwIllegalStateException("");
        }
        this.areaId = areaId;
    }

    boolean isSeaOrLake() {
        return this.altitude.intValue() == 1;
    }

    void setSea() {
        if (this.isWalkable() || !this.isSeaOrLake()) {
            this.asserter.throwIllegalStateException("");
        }
        this.altitude = Altitude.ZERO;
    }

    void setLake() {
        if (this.isWalkable() || !this.isSea()) {
            this.asserter.throwIllegalStateException("");
        }
        this.altitude = Altitude.UNINITIALIZED;
    }

    boolean isAltitudeMissing() {
        return this.altitude.intValue() == -1;
    }

    boolean isAreaIdMissing() {
        return this.areaId.equals(AreaId.UNINITIALIZED);
    }

    void replaceAreaId(AreaId areaId) {
        if (this.areaId.intValue() <= 0) {
            this.asserter.throwIllegalStateException("Failed assert: this.areaId.intValue() > 0: " + this.areaId.intValue());
        } else if (areaId.intValue() < 1 && areaId.intValue() > -2) {
            this.asserter.throwIllegalStateException("Failed assert: (id.intValue() >= 1) || (id.intValue() <= -2): " + areaId.intValue());
        } else if (areaId.equals(this.areaId)) {
            this.asserter.throwIllegalStateException("Failed assert: !id.equals (areaId): not expected: " + this.areaId.intValue() + ", actual: " + areaId.intValue());
        } else {
            this.areaId = areaId;
        }
    }

    void setBlocked() {
        if (!this.isAreaIdMissing()) {
            this.asserter.throwIllegalStateException("");
        }
        this.areaId = blockingCP;
    }

    boolean isBlocked() {
        return this.areaId.equals(blockingCP);
    }

    void replaceBlockedAreaId(AreaId areaId) {
        if (!this.areaId.equals(blockingCP) || areaId.intValue() < 1) {
            this.asserter.throwIllegalStateException("");
        }
        this.areaId = areaId;
    }
}

