/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.CommandTemp;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Region;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.UnitCommand;
import bwapi.UnitCommandType;
import bwapi.UnitFilter;
import bwapi.UnitSelf;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WalkPosition;
import bwapi.WeaponType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Unit
implements Comparable<Unit> {
    private static final Set<Order> gatheringGasOrders = EnumSet.of(Order.Harvest1, new Order[]{Order.Harvest2, Order.MoveToGas, Order.WaitForGas, Order.HarvestGas, Order.ReturnGas, Order.ResetCollision});
    private static final Set<Order> gatheringMineralOrders = EnumSet.of(Order.Harvest1, new Order[]{Order.Harvest2, Order.MoveToMinerals, Order.WaitForMinerals, Order.MiningMinerals, Order.ReturnMinerals, Order.ResetCollision});
    private final ClientData.UnitData unitData;
    private final Game game;
    private final UnitType initialType;
    private final int initialResources;
    private final int initialHitPoints;
    private final Position initialPosition;
    private final TilePosition initialTilePosition;
    private final int id;
    private Position position;
    private int lastPositionUpdate = -1;
    private int lastCommandFrame;
    private UnitCommand lastCommand;
    private UnitSelf self = null;

    UnitSelf self() {
        if (this.self == null) {
            this.self = new UnitSelf();
        }
        return this.self;
    }

    Unit(ClientData.UnitData unitData, int id, Game game) {
        this.unitData = unitData;
        this.game = game;
        this.updatePosition(0);
        this.initialType = this.getType();
        this.initialResources = this.getResources();
        this.initialHitPoints = this.getHitPoints();
        this.initialPosition = this.getPosition();
        this.initialTilePosition = this.getTilePosition();
        this.id = id;
    }

    private static boolean reallyGatheringGas(Unit targ, Player player) {
        return targ != null && targ.exists() && targ.isCompleted() && targ.getPlayer() == player && targ.getType() != UnitType.Resource_Vespene_Geyser && (targ.getType().isRefinery() || targ.getType().isResourceDepot());
    }

    private static boolean reallyGatheringMinerals(Unit targ, Player player) {
        return targ != null && targ.exists() && (targ.getType().isMineralField() || targ.isCompleted() && targ.getPlayer() == player && targ.getType().isResourceDepot());
    }

    public int getID() {
        return this.id;
    }

    public boolean exists() {
        return this.unitData.getExists();
    }

    public int getReplayID() {
        return this.unitData.getReplayID();
    }

    public Player getPlayer() {
        return this.game.getPlayer(this.unitData.getPlayer());
    }

    public UnitType getType() {
        if (this.game.isLatComEnabled() && this.self().type.valid(this.game.getFrameCount())) {
            return (UnitType)((Object)this.self().type.get());
        }
        return UnitType.idToEnum[this.unitData.getType()];
    }

    public Position getPosition() {
        return this.position;
    }

    public int getX() {
        return this.getPosition().x;
    }

    public int getY() {
        return this.getPosition().y;
    }

    public TilePosition getTilePosition() {
        Position p = this.getPosition();
        UnitType ut = this.getType();
        return new Position(Math.abs(p.x - ut.tileWidth() * 32 / 2), Math.abs(p.y - ut.tileHeight() * 32 / 2)).toTilePosition();
    }

    public double getAngle() {
        return this.unitData.getAngle();
    }

    public double getVelocityX() {
        return this.unitData.getVelocityX();
    }

    public double getVelocityY() {
        return this.unitData.getVelocityY();
    }

    public Region getRegion() {
        return this.game.getRegionAt(this.getPosition());
    }

    public int getLeft() {
        return this.getX() - this.getType().dimensionLeft();
    }

    public int getTop() {
        return this.getY() - this.getType().dimensionUp();
    }

    public int getRight() {
        return this.getX() + this.getType().dimensionRight();
    }

    public int getBottom() {
        return this.getY() + this.getType().dimensionDown();
    }

    public int getHitPoints() {
        int hitpoints = this.unitData.getHitPoints();
        if (this.game.isLatComEnabled() && this.self().hitPoints.valid(this.game.getFrameCount())) {
            return hitpoints + (Integer)this.self().hitPoints.get();
        }
        return hitpoints;
    }

    public int getShields() {
        return this.unitData.getShields();
    }

    public int getEnergy() {
        int energy = this.unitData.getEnergy();
        if (this.game.isLatComEnabled() && this.self().energy.valid(this.game.getFrameCount())) {
            return energy + (Integer)this.self().energy.get();
        }
        return energy;
    }

    public int getResources() {
        return this.unitData.getResources();
    }

    public int getResourceGroup() {
        return this.unitData.getResourceGroup();
    }

    public int getDistance(Position target) {
        int yDist;
        if (!this.exists() || target == null) {
            return Integer.MAX_VALUE;
        }
        int xDist = this.getLeft() - target.x;
        if (xDist < 0 && (xDist = target.x - (this.getRight() + 1)) < 0) {
            xDist = 0;
        }
        if ((yDist = this.getTop() - target.y) < 0 && (yDist = target.y - (this.getBottom() + 1)) < 0) {
            yDist = 0;
        }
        return Position.Origin.getApproxDistance(new Position(xDist, yDist));
    }

    public int getDistance(Unit target) {
        int yDist;
        if (!this.exists() || target == null || !target.exists()) {
            return Integer.MAX_VALUE;
        }
        if (this == target) {
            return 0;
        }
        int left = target.getLeft() - 1;
        int top = target.getTop() - 1;
        int right = target.getRight() + 1;
        int bottom = target.getBottom() + 1;
        int xDist = this.getLeft() - right;
        if (xDist < 0 && (xDist = left - this.getRight()) < 0) {
            xDist = 0;
        }
        if ((yDist = this.getTop() - bottom) < 0 && (yDist = top - this.getBottom()) < 0) {
            yDist = 0;
        }
        return Position.Origin.getApproxDistance(new Position(xDist, yDist));
    }

    public boolean hasPath(Position target) {
        return this.isFlying() || this.game.hasPath(this.getPosition(), target) || this.game.hasPath(new Position(this.getLeft(), this.getTop()), target) || this.game.hasPath(new Position(this.getRight(), this.getTop()), target) || this.game.hasPath(new Position(this.getLeft(), this.getBottom()), target) || this.game.hasPath(new Position(this.getRight(), this.getBottom()), target);
    }

    public boolean hasPath(Unit target) {
        return this.hasPath(target.getPosition());
    }

    public int getLastCommandFrame() {
        return this.lastCommandFrame;
    }

    public UnitCommand getLastCommand() {
        return this.lastCommand;
    }

    public Player getLastAttackingPlayer() {
        return this.game.getPlayer(this.unitData.getLastAttackerPlayer());
    }

    public UnitType getInitialType() {
        return this.initialType;
    }

    public Position getInitialPosition() {
        return this.initialPosition;
    }

    public TilePosition getInitialTilePosition() {
        return this.initialTilePosition;
    }

    public int getInitialHitPoints() {
        return this.initialHitPoints;
    }

    public int getInitialResources() {
        return this.initialResources;
    }

    public int getKillCount() {
        return this.unitData.getKillCount();
    }

    public int getAcidSporeCount() {
        return this.unitData.getAcidSporeCount();
    }

    public int getInterceptorCount() {
        return this.unitData.getInterceptorCount();
    }

    public int getScarabCount() {
        return this.unitData.getScarabCount();
    }

    public int getSpiderMineCount() {
        return this.unitData.getSpiderMineCount();
    }

    public int getGroundWeaponCooldown() {
        return this.unitData.getGroundWeaponCooldown();
    }

    public int getAirWeaponCooldown() {
        return this.unitData.getAirWeaponCooldown();
    }

    public int getSpellCooldown() {
        return this.unitData.getSpellCooldown();
    }

    public int getDefenseMatrixPoints() {
        return this.unitData.getDefenseMatrixPoints();
    }

    public int getDefenseMatrixTimer() {
        return this.unitData.getDefenseMatrixTimer();
    }

    public int getEnsnareTimer() {
        return this.unitData.getEnsnareTimer();
    }

    public int getIrradiateTimer() {
        return this.unitData.getIrradiateTimer();
    }

    public int getLockdownTimer() {
        return this.unitData.getLockdownTimer();
    }

    public int getMaelstromTimer() {
        return this.unitData.getMaelstromTimer();
    }

    public int getOrderTimer() {
        return this.unitData.getOrderTimer();
    }

    public int getPlagueTimer() {
        return this.unitData.getPlagueTimer();
    }

    public int getRemoveTimer() {
        return this.unitData.getRemoveTimer();
    }

    public int getStasisTimer() {
        return this.unitData.getStasisTimer();
    }

    public int getStimTimer() {
        if (this.game.isLatComEnabled() && this.self().stimTimer.valid(this.game.getFrameCount())) {
            return (Integer)this.self().stimTimer.get();
        }
        return this.unitData.getStimTimer();
    }

    public UnitType getBuildType() {
        if (this.game.isLatComEnabled() && this.self().buildType.valid(this.game.getFrameCount())) {
            return (UnitType)((Object)this.self().buildType.get());
        }
        return UnitType.idToEnum[this.unitData.getBuildType()];
    }

    public List<UnitType> getTrainingQueue() {
        return IntStream.range(0, this.getTrainingQueueCount()).mapToObj(this::getTrainingQueueAt).collect(Collectors.toList());
    }

    public UnitType getTrainingQueueAt(int i) {
        if (this.game.isLatComEnabled() && this.self().trainingQueue[i].valid(this.game.getFrameCount())) {
            return (UnitType)((Object)this.self().trainingQueue[i].get());
        }
        return UnitType.idToEnum[this.unitData.getTrainingQueue(i)];
    }

    public int getTrainingQueueCount() {
        int count = this.unitData.getTrainingQueueCount();
        if (this.game.isLatComEnabled() && this.self().trainingQueueCount.valid(this.game.getFrameCount())) {
            return count + (Integer)this.self().trainingQueueCount.get();
        }
        return count;
    }

    public TechType getTech() {
        if (this.game.isLatComEnabled() && this.self().tech.valid(this.game.getFrameCount())) {
            return (TechType)((Object)this.self().tech.get());
        }
        return TechType.idToEnum[this.unitData.getTech()];
    }

    public UpgradeType getUpgrade() {
        if (this.game.isLatComEnabled() && this.self().upgrade.valid(this.game.getFrameCount())) {
            return (UpgradeType)((Object)this.self().upgrade.get());
        }
        return UpgradeType.idToEnum[this.unitData.getUpgrade()];
    }

    public int getRemainingBuildTime() {
        if (this.game.isLatComEnabled() && this.self().remainingBuildTime.valid(this.game.getFrameCount())) {
            return (Integer)this.self().remainingBuildTime.get();
        }
        return this.unitData.getRemainingBuildTime();
    }

    public int getRemainingTrainTime() {
        if (this.game.isLatComEnabled() && this.self().remainingTrainTime.valid(this.game.getFrameCount())) {
            return (Integer)this.self().remainingTrainTime.get();
        }
        return this.unitData.getRemainingTrainTime();
    }

    public int getRemainingResearchTime() {
        if (this.game.isLatComEnabled() && this.self().remainingResearchTime.valid(this.game.getFrameCount())) {
            return (Integer)this.self().remainingResearchTime.get();
        }
        return this.unitData.getRemainingResearchTime();
    }

    public int getRemainingUpgradeTime() {
        if (this.game.isLatComEnabled() && this.self().remainingUpgradeTime.valid(this.game.getFrameCount())) {
            return (Integer)this.self().remainingUpgradeTime.get();
        }
        return this.unitData.getRemainingUpgradeTime();
    }

    public Unit getBuildUnit() {
        if (this.game.isLatComEnabled() && this.self().buildUnit.valid(this.game.getFrameCount())) {
            return this.game.getUnit((Integer)this.self().buildUnit.get());
        }
        return this.game.getUnit(this.unitData.getBuildUnit());
    }

    public Unit getTarget() {
        if (this.game.isLatComEnabled() && this.self().target.valid(this.game.getFrameCount())) {
            return this.game.getUnit((Integer)this.self().target.get());
        }
        return this.game.getUnit(this.unitData.getTarget());
    }

    public Position getTargetPosition() {
        if (this.game.isLatComEnabled() && this.self().targetPositionX.valid(this.game.getFrameCount())) {
            return new Position((Integer)this.self().targetPositionX.get(), (Integer)this.self().targetPositionY.get());
        }
        return new Position(this.unitData.getTargetPositionX(), this.unitData.getTargetPositionY());
    }

    public Order getOrder() {
        if (this.game.isLatComEnabled() && this.self().order.valid(this.game.getFrameCount())) {
            return (Order)((Object)this.self().order.get());
        }
        return Order.idToEnum[this.unitData.getOrder()];
    }

    public Order getSecondaryOrder() {
        if (this.game.isLatComEnabled() && this.self().secondaryOrder.valid(this.game.getFrameCount())) {
            return (Order)((Object)this.self().secondaryOrder.get());
        }
        return Order.idToEnum[this.unitData.getSecondaryOrder()];
    }

    public Unit getOrderTarget() {
        if (this.game.isLatComEnabled() && this.self().orderTarget.valid(this.game.getFrameCount())) {
            return this.game.getUnit((Integer)this.self().orderTarget.get());
        }
        return this.game.getUnit(this.unitData.getOrderTarget());
    }

    public Position getOrderTargetPosition() {
        if (this.game.isLatComEnabled() && this.self().orderTargetPositionX.valid(this.game.getFrameCount())) {
            return new Position((Integer)this.self().orderTargetPositionX.get(), (Integer)this.self().orderTargetPositionY.get());
        }
        return new Position(this.unitData.getOrderTargetPositionX(), this.unitData.getOrderTargetPositionY());
    }

    public Position getRallyPosition() {
        if (this.game.isLatComEnabled() && this.self().rallyPositionX.valid(this.game.getFrameCount())) {
            return new Position((Integer)this.self().rallyPositionX.get(), (Integer)this.self().rallyPositionY.get());
        }
        return new Position(this.unitData.getRallyPositionX(), this.unitData.getRallyPositionY());
    }

    public Unit getRallyUnit() {
        if (this.game.isLatComEnabled() && this.self().rallyUnit.valid(this.game.getFrameCount())) {
            return this.game.getUnit((Integer)this.self().rallyUnit.get());
        }
        return this.game.getUnit(this.unitData.getRallyUnit());
    }

    public Unit getAddon() {
        return this.game.getUnit(this.unitData.getAddon());
    }

    public Unit getNydusExit() {
        return this.game.getUnit(this.unitData.getNydusExit());
    }

    public Unit getPowerUp() {
        return this.game.getUnit(this.unitData.getPowerUp());
    }

    public Unit getTransport() {
        return this.game.getUnit(this.unitData.getTransport());
    }

    public List<Unit> getLoadedUnits() {
        if (this.getType().spaceProvided() < 1) {
            return Collections.emptyList();
        }
        return this.game.loadedUnitsCache.getConnected(this);
    }

    public int getSpaceRemaining() {
        int space = this.getType().spaceProvided();
        for (Unit u : this.getLoadedUnits()) {
            space -= u.getType().spaceRequired();
        }
        return Math.max(space, 0);
    }

    public Unit getCarrier() {
        return this.game.getUnit(this.unitData.getCarrier());
    }

    public List<Unit> getInterceptors() {
        if (this.getType() != UnitType.Protoss_Carrier && this.getType() != UnitType.Hero_Gantrithor) {
            return Collections.emptyList();
        }
        return this.game.interceptorsCache.getConnected(this);
    }

    public Unit getHatchery() {
        return this.game.getUnit(this.unitData.getHatchery());
    }

    public List<Unit> getLarva() {
        if (!this.getType().producesLarva()) {
            return Collections.emptyList();
        }
        return this.game.larvaCache.getConnected(this);
    }

    public List<Unit> getUnitsInRadius(int radius) {
        return this.getUnitsInRadius(radius, u -> true);
    }

    public List<Unit> getUnitsInRadius(int radius, UnitFilter pred) {
        if (!this.exists()) {
            return Collections.emptyList();
        }
        return this.game.getUnitsInRectangle(this.getLeft() - radius, this.getTop() - radius, this.getRight() + radius, this.getBottom() + radius, u -> this.getDistance((Unit)u) <= radius && pred.test(u));
    }

    public List<Unit> getUnitsInWeaponRange(WeaponType weapon) {
        return this.getUnitsInWeaponRange(weapon, u -> true);
    }

    public List<Unit> getUnitsInWeaponRange(WeaponType weapon, UnitFilter pred) {
        if (!this.exists()) {
            return Collections.emptyList();
        }
        int max = this.getPlayer().weaponMaxRange(weapon);
        return this.game.getUnitsInRectangle(this.getLeft() - max, this.getTop() - max, this.getRight() + max, this.getBottom() + max, u -> {
            if (!pred.test(u)) {
                return false;
            }
            if (u == this || u.isInvincible()) {
                return false;
            }
            int dist = this.getDistance((Unit)u);
            if (weapon.minRange() != 0 && dist < weapon.minRange() || dist > max) {
                return false;
            }
            UnitType ut = u.getType();
            return !(weapon.targetsOwn() && !u.getPlayer().equals(this.getPlayer()) || !weapon.targetsAir() && !u.isFlying() || !weapon.targetsGround() && u.isFlying() || weapon.targetsMechanical() && ut.isMechanical() || weapon.targetsOrganic() && ut.isOrganic() || weapon.targetsNonBuilding() && !ut.isBuilding() || weapon.targetsNonRobotic() && !ut.isRobotic() || weapon.targetsOrgOrMech() && (ut.isOrganic() || ut.isMechanical()));
        });
    }

    public boolean hasNuke() {
        return this.unitData.getHasNuke();
    }

    public boolean isAccelerating() {
        return this.unitData.isAccelerating();
    }

    public boolean isAttacking() {
        return this.unitData.isAttacking();
    }

    public boolean isAttackFrame() {
        return this.unitData.isAttackFrame();
    }

    public boolean isBeingConstructed() {
        if (this.isMorphing()) {
            return true;
        }
        if (this.isCompleted()) {
            return false;
        }
        if (this.getType().getRace() != Race.Terran) {
            return true;
        }
        return this.getBuildUnit() != null;
    }

    public boolean isBeingGathered() {
        return this.unitData.isBeingGathered();
    }

    public boolean isBeingHealed() {
        return this.getType().getRace() == Race.Terran && this.isCompleted() && this.getHitPoints() > this.unitData.getLastHitPoints();
    }

    public boolean isBlind() {
        return this.unitData.isBlind();
    }

    public boolean isBraking() {
        return this.unitData.isBraking();
    }

    public boolean isBurrowed() {
        return this.unitData.isBurrowed();
    }

    public boolean isCarrying() {
        return this.isCarryingGas() || this.isCarryingMinerals();
    }

    public boolean isCarryingGas() {
        return this.unitData.getCarryResourceType() == 1;
    }

    public boolean isCarryingMinerals() {
        return this.unitData.getCarryResourceType() == 2;
    }

    public boolean isCloaked() {
        return this.unitData.isCloaked();
    }

    public boolean isCompleted() {
        if (this.game.isLatComEnabled() && this.self().isCompleted.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isCompleted.get();
        }
        return this.unitData.isCompleted();
    }

    public boolean isConstructing() {
        if (this.game.isLatComEnabled() && this.self().isConstructing.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isConstructing.get();
        }
        return this.unitData.isConstructing();
    }

    public boolean isDefenseMatrixed() {
        return this.getDefenseMatrixTimer() != 0;
    }

    public boolean isDetected() {
        return this.unitData.isDetected();
    }

    public boolean isEnsnared() {
        return this.getEnsnareTimer() != 0;
    }

    public boolean isFlying() {
        return this.getType().isFlyer() || this.isLifted();
    }

    public boolean isFollowing() {
        return this.getOrder() == Order.Follow;
    }

    boolean isGathering() {
        if (this.game.isLatComEnabled() && this.self().isGathering.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isGathering.get();
        }
        return this.unitData.isGathering();
    }

    public boolean isGatheringGas() {
        if (!this.isGathering()) {
            return false;
        }
        Order order = this.getOrder();
        if (!gatheringGasOrders.contains((Object)order)) {
            return false;
        }
        if (order == Order.ResetCollision) {
            return this.unitData.getCarryResourceType() == 1;
        }
        if (order == Order.WaitForGas || order == Order.HarvestGas || order == Order.ReturnGas) {
            return true;
        }
        return Unit.reallyGatheringGas(this.getTarget(), this.getPlayer()) || Unit.reallyGatheringGas(this.getOrderTarget(), this.getPlayer());
    }

    public boolean isGatheringMinerals() {
        if (!this.isGathering()) {
            return false;
        }
        Order order = this.getOrder();
        if (!gatheringMineralOrders.contains((Object)order)) {
            return false;
        }
        if (order == Order.ResetCollision) {
            return this.unitData.getCarryResourceType() == 2;
        }
        if (order == Order.WaitForMinerals || order == Order.MiningMinerals || order == Order.ReturnMinerals) {
            return true;
        }
        return Unit.reallyGatheringMinerals(this.getTarget(), this.getPlayer()) || Unit.reallyGatheringMinerals(this.getOrderTarget(), this.getPlayer());
    }

    public boolean isHallucination() {
        return this.unitData.isHallucination();
    }

    public boolean isHoldingPosition() {
        return this.getOrder() == Order.HoldPosition;
    }

    public boolean isIdle() {
        if (this.game.isLatComEnabled() && this.self().isIdle.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isIdle.get();
        }
        return this.unitData.isIdle();
    }

    public boolean isInterruptible() {
        return this.unitData.isInterruptible();
    }

    public boolean isInvincible() {
        return this.unitData.isInvincible();
    }

    public boolean isInWeaponRange(Unit target) {
        WeaponType wpn;
        if (!this.exists() || target == null || !target.exists() || this == target) {
            return false;
        }
        UnitType thisType = this.getType();
        WeaponType weaponType = wpn = target.isFlying() ? thisType.airWeapon() : thisType.groundWeapon();
        if (wpn == WeaponType.None || wpn == WeaponType.Unknown) {
            return false;
        }
        int minRange = wpn.minRange();
        int maxRange = this.getPlayer().weaponMaxRange(wpn);
        int distance = this.getDistance(target);
        return (minRange == 0 || minRange < distance) && distance <= maxRange;
    }

    public boolean isIrradiated() {
        return this.getIrradiateTimer() != 0;
    }

    public boolean isLifted() {
        return this.unitData.isLifted();
    }

    public boolean isLoaded() {
        return this.getTransport() != null;
    }

    public boolean isLockedDown() {
        return this.getLockdownTimer() != 0;
    }

    public boolean isMaelstrommed() {
        return this.getMaelstromTimer() != 0;
    }

    public boolean isMorphing() {
        if (this.game.isLatComEnabled() && this.self().isMorphing.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isMorphing.get();
        }
        return this.unitData.isMorphing();
    }

    public boolean isMoving() {
        if (this.game.isLatComEnabled() && this.self().isMoving.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isMoving.get();
        }
        return this.unitData.isMoving();
    }

    public boolean isParasited() {
        return this.unitData.isParasited();
    }

    public boolean isPatrolling() {
        return this.getOrder() == Order.Patrol;
    }

    public boolean isPlagued() {
        return this.getPlagueTimer() != 0;
    }

    public boolean isRepairing() {
        return this.getOrder() == Order.Repair;
    }

    public boolean isResearching() {
        return this.getOrder() == Order.ResearchTech;
    }

    public boolean isSelected() {
        return this.unitData.isSelected();
    }

    public boolean isSieged() {
        UnitType t = this.getType();
        return t == UnitType.Terran_Siege_Tank_Siege_Mode || t == UnitType.Hero_Edmund_Duke_Siege_Mode;
    }

    public boolean isStartingAttack() {
        return this.unitData.isStartingAttack();
    }

    public boolean isStasised() {
        return this.getStasisTimer() != 0;
    }

    public boolean isStimmed() {
        return this.getStimTimer() != 0;
    }

    public boolean isStuck() {
        return this.unitData.isStuck();
    }

    public boolean isTraining() {
        if (this.game.isLatComEnabled() && this.self().isTraining.valid(this.game.getFrameCount())) {
            return (Boolean)this.self().isTraining.get();
        }
        return this.unitData.isTraining();
    }

    public boolean isUnderAttack() {
        return this.unitData.getRecentlyAttacked();
    }

    public boolean isUnderDarkSwarm() {
        return this.unitData.isUnderDarkSwarm();
    }

    public boolean isUnderDisruptionWeb() {
        return this.unitData.isUnderDWeb();
    }

    public boolean isUnderStorm() {
        return this.unitData.isUnderStorm();
    }

    public boolean isPowered() {
        return this.unitData.isPowered();
    }

    public boolean isUpgrading() {
        return this.getOrder() == Order.Upgrade;
    }

    public boolean isVisible() {
        return this.isVisible(this.game.self());
    }

    public boolean isVisible(Player player) {
        return this.unitData.isVisible(player.getID());
    }

    public boolean isTargetable() {
        if (!this.exists()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!(this.isCompleted() || ut.isBuilding() || this.isMorphing() || ut == UnitType.Protoss_Archon || ut == UnitType.Protoss_Dark_Archon)) {
            return false;
        }
        return ut != UnitType.Spell_Scanner_Sweep && ut != UnitType.Spell_Dark_Swarm && ut != UnitType.Spell_Disruption_Web && ut != UnitType.Special_Map_Revealer;
    }

    public boolean issueCommand(UnitCommand command) {
        if (!this.canIssueCommand(command)) {
            return false;
        }
        command.unit = this;
        if ((command.type == UnitCommandType.Train || command.type == UnitCommandType.Morph) && this.getType().producesLarva() && command.getUnitType().whatBuilds().getKey() == UnitType.Zerg_Larva) {
            for (Unit larva : this.getLarva()) {
                if (larva.isConstructing() || !larva.isCompleted() || !larva.canCommand()) continue;
                command.unit = larva;
                break;
            }
            if (command.unit == this) {
                return false;
            }
        }
        if (this.game.isLatComEnabled()) {
            new CommandTemp(command, this.game).execute();
        }
        this.game.addUnitCommand(command.getType().id, command.getUnit().getID(), command.getTarget() != null ? command.getTarget().getID() : -1, command.x, command.y, command.extra);
        this.lastCommandFrame = this.game.getFrameCount();
        this.lastCommand = command;
        return true;
    }

    public boolean attack(Position target) {
        return this.issueCommand(UnitCommand.attack(this, target));
    }

    public boolean attack(Unit target) {
        return this.issueCommand(UnitCommand.attack(this, target));
    }

    public boolean attack(Position target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.attack(this, target, shiftQueueCommand));
    }

    public boolean attack(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.attack(this, target, shiftQueueCommand));
    }

    public boolean build(UnitType type) {
        return this.issueCommand(UnitCommand.train(this, type));
    }

    public boolean build(UnitType type, TilePosition target) {
        return this.issueCommand(UnitCommand.build(this, target, type));
    }

    public boolean buildAddon(UnitType type) {
        return this.issueCommand(UnitCommand.buildAddon(this, type));
    }

    public boolean train(UnitType type) {
        return this.issueCommand(UnitCommand.train(this, type));
    }

    public boolean morph(UnitType type) {
        return this.issueCommand(UnitCommand.morph(this, type));
    }

    public boolean research(TechType tech) {
        return this.issueCommand(UnitCommand.research(this, tech));
    }

    public boolean upgrade(UpgradeType upgrade) {
        return this.issueCommand(UnitCommand.upgrade(this, upgrade));
    }

    public boolean setRallyPoint(Position target) {
        return this.issueCommand(UnitCommand.setRallyPoint(this, target));
    }

    public boolean setRallyPoint(Unit target) {
        return this.issueCommand(UnitCommand.setRallyPoint(this, target));
    }

    public boolean move(Position target) {
        return this.issueCommand(UnitCommand.move(this, target));
    }

    public boolean move(Position target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.move(this, target, shiftQueueCommand));
    }

    public boolean patrol(Position target) {
        return this.issueCommand(UnitCommand.patrol(this, target));
    }

    public boolean patrol(Position target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.patrol(this, target, shiftQueueCommand));
    }

    public boolean holdPosition() {
        return this.issueCommand(UnitCommand.holdPosition(this));
    }

    public boolean holdPosition(boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.holdPosition(this, shiftQueueCommand));
    }

    public boolean stop() {
        return this.issueCommand(UnitCommand.stop(this));
    }

    public boolean stop(boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.stop(this, shiftQueueCommand));
    }

    public boolean follow(Unit target) {
        return this.issueCommand(UnitCommand.follow(this, target));
    }

    public boolean follow(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.follow(this, target, shiftQueueCommand));
    }

    public boolean gather(Unit target) {
        return this.issueCommand(UnitCommand.gather(this, target));
    }

    public boolean gather(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.gather(this, target, shiftQueueCommand));
    }

    public boolean returnCargo() {
        return this.issueCommand(UnitCommand.returnCargo(this));
    }

    public boolean returnCargo(boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.returnCargo(this, shiftQueueCommand));
    }

    public boolean repair(Unit target) {
        return this.issueCommand(UnitCommand.repair(this, target));
    }

    public boolean repair(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.repair(this, target, shiftQueueCommand));
    }

    public boolean burrow() {
        return this.issueCommand(UnitCommand.burrow(this));
    }

    public boolean unburrow() {
        return this.issueCommand(UnitCommand.unburrow(this));
    }

    public boolean cloak() {
        return this.issueCommand(UnitCommand.cloak(this));
    }

    public boolean decloak() {
        return this.issueCommand(UnitCommand.decloak(this));
    }

    public boolean siege() {
        return this.issueCommand(UnitCommand.siege(this));
    }

    public boolean unsiege() {
        return this.issueCommand(UnitCommand.unsiege(this));
    }

    public boolean lift() {
        return this.issueCommand(UnitCommand.lift(this));
    }

    public boolean land(TilePosition target) {
        return this.issueCommand(UnitCommand.land(this, target));
    }

    public boolean load(Unit target) {
        return this.issueCommand(UnitCommand.load(this, target));
    }

    public boolean load(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.load(this, target, shiftQueueCommand));
    }

    public boolean unload(Unit target) {
        return this.issueCommand(UnitCommand.unload(this, target));
    }

    public boolean unloadAll() {
        return this.issueCommand(UnitCommand.unloadAll(this));
    }

    public boolean unloadAll(boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.unloadAll(this, shiftQueueCommand));
    }

    public boolean unloadAll(Position target) {
        return this.issueCommand(UnitCommand.unloadAll(this, target));
    }

    public boolean unloadAll(Position target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.unloadAll(this, target, shiftQueueCommand));
    }

    public boolean rightClick(Position target) {
        return this.issueCommand(UnitCommand.rightClick(this, target));
    }

    public boolean rightClick(Unit target) {
        return this.issueCommand(UnitCommand.rightClick(this, target));
    }

    public boolean rightClick(Position target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.rightClick(this, target, shiftQueueCommand));
    }

    public boolean rightClick(Unit target, boolean shiftQueueCommand) {
        return this.issueCommand(UnitCommand.rightClick(this, target, shiftQueueCommand));
    }

    public boolean haltConstruction() {
        return this.issueCommand(UnitCommand.haltConstruction(this));
    }

    public boolean cancelConstruction() {
        return this.issueCommand(UnitCommand.cancelConstruction(this));
    }

    public boolean cancelAddon() {
        return this.issueCommand(UnitCommand.cancelAddon(this));
    }

    public boolean cancelTrain() {
        return this.issueCommand(UnitCommand.cancelTrain(this));
    }

    public boolean cancelTrain(int slot) {
        return this.issueCommand(UnitCommand.cancelTrain(this, slot));
    }

    public boolean cancelMorph() {
        return this.issueCommand(UnitCommand.cancelMorph(this));
    }

    public boolean cancelResearch() {
        return this.issueCommand(UnitCommand.cancelResearch(this));
    }

    public boolean cancelUpgrade() {
        return this.issueCommand(UnitCommand.cancelUpgrade(this));
    }

    public boolean useTech(TechType tech) {
        return this.issueCommand(UnitCommand.useTech(this, tech));
    }

    public boolean useTech(TechType tech, Position target) {
        return this.issueCommand(UnitCommand.useTech(this, tech, target));
    }

    public boolean useTech(TechType tech, Unit target) {
        return this.issueCommand(UnitCommand.useTech(this, tech, target));
    }

    public boolean placeCOP(TilePosition target) {
        return this.issueCommand(UnitCommand.placeCOP(this, target));
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanBuildUnitType, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canIssueCommand(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanBuildUnitType, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanBuildUnitType, boolean checkCanTargetUnit) {
        return this.canIssueCommand(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanBuildUnitType, checkCanTargetUnit, true);
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanBuildUnitType) {
        return this.canIssueCommand(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanBuildUnitType, true);
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits) {
        return this.canIssueCommand(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, true);
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions) {
        return this.canIssueCommand(command, checkCanUseTechPositionOnPositions, true);
    }

    public boolean canIssueCommand(UnitCommand command) {
        return this.canIssueCommand(command, true);
    }

    public boolean canIssueCommand(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanBuildUnitType, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitCommandType ct = command.type;
        if (checkCanIssueCommandType && !this.canIssueCommandType(ct, false)) {
            return false;
        }
        switch (ct) {
            case Attack_Move: {
                return true;
            }
            case Attack_Unit: {
                return this.canAttackUnit(command.target, checkCanTargetUnit, false, false);
            }
            case Build: {
                return this.canBuild(command.getUnitType(), new TilePosition(command.x, command.y), checkCanBuildUnitType, false, false);
            }
            case Build_Addon: {
                return this.canBuildAddon(command.getUnitType(), false, false);
            }
            case Train: {
                return this.canTrain(command.getUnitType(), false, false);
            }
            case Morph: {
                return this.canMorph(command.getUnitType(), false, false);
            }
            case Research: {
                return this.game.canResearch(command.getTechType(), this, false);
            }
            case Upgrade: {
                return this.game.canUpgrade(command.getUpgradeType(), this, false);
            }
            case Set_Rally_Position: {
                return true;
            }
            case Set_Rally_Unit: {
                return this.canSetRallyUnit(command.target, checkCanTargetUnit, false, false);
            }
            case Move: {
                return true;
            }
            case Patrol: {
                return true;
            }
            case Hold_Position: {
                return true;
            }
            case Stop: {
                return true;
            }
            case Follow: {
                return this.canFollow(command.target, checkCanTargetUnit, false, false);
            }
            case Gather: {
                return this.canGather(command.target, checkCanTargetUnit, false, false);
            }
            case Return_Cargo: {
                return true;
            }
            case Repair: {
                return this.canRepair(command.target, checkCanTargetUnit, false, false);
            }
            case Burrow: {
                return true;
            }
            case Unburrow: {
                return true;
            }
            case Cloak: {
                return true;
            }
            case Decloak: {
                return true;
            }
            case Siege: {
                return true;
            }
            case Unsiege: {
                return true;
            }
            case Lift: {
                return true;
            }
            case Land: {
                return this.canLand(new TilePosition(command.x, command.y), false, false);
            }
            case Load: {
                return this.canLoad(command.target, checkCanTargetUnit, false, false);
            }
            case Unload: {
                return this.canUnload(command.target, checkCanTargetUnit, false, false, false);
            }
            case Unload_All: {
                return true;
            }
            case Unload_All_Position: {
                return this.canUnloadAllPosition(command.getTargetPosition(), false, false);
            }
            case Right_Click_Position: {
                return true;
            }
            case Right_Click_Unit: {
                return this.canRightClickUnit(command.target, checkCanTargetUnit, false, false);
            }
            case Halt_Construction: {
                return true;
            }
            case Cancel_Construction: {
                return true;
            }
            case Cancel_Addon: {
                return true;
            }
            case Cancel_Train: {
                return true;
            }
            case Cancel_Train_Slot: {
                return this.canCancelTrainSlot(command.extra, false, false);
            }
            case Cancel_Morph: {
                return true;
            }
            case Cancel_Research: {
                return true;
            }
            case Cancel_Upgrade: {
                return true;
            }
            case Use_Tech: {
                return this.canUseTechWithoutTarget(TechType.idToEnum[command.extra], false, false);
            }
            case Use_Tech_Unit: {
                return this.canUseTechUnit(TechType.idToEnum[command.extra], command.target, checkCanTargetUnit, checkCanUseTechUnitOnUnits, false, false);
            }
            case Use_Tech_Position: {
                return this.canUseTechPosition(TechType.idToEnum[command.extra], command.getTargetPosition(), checkCanUseTechPositionOnPositions, false, false);
            }
            case Place_COP: {
                return this.canPlaceCOP(new TilePosition(command.x, command.y), false, false);
            }
        }
        return true;
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canIssueCommandGrouped(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canIssueCommandGrouped(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanTargetUnit) {
        return this.canIssueCommandGrouped(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, checkCanTargetUnit, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits) {
        return this.canIssueCommandGrouped(command, checkCanUseTechPositionOnPositions, checkCanUseTechUnitOnUnits, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions) {
        return this.canIssueCommandGrouped(command, checkCanUseTechPositionOnPositions, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command) {
        return this.canIssueCommandGrouped(command, true);
    }

    public boolean canIssueCommandGrouped(UnitCommand command, boolean checkCanUseTechPositionOnPositions, boolean checkCanUseTechUnitOnUnits, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        UnitCommandType ct = command.type;
        if (checkCanIssueCommandType && !this.canIssueCommandTypeGrouped(ct, false, false)) {
            return false;
        }
        switch (ct) {
            case Attack_Move: {
                return true;
            }
            case Attack_Unit: {
                return this.canAttackUnitGrouped(command.target, checkCanTargetUnit, false, false, false);
            }
            case Build: {
                return false;
            }
            case Build_Addon: {
                return false;
            }
            case Train: {
                return this.canTrain(command.getUnitType(), false, false);
            }
            case Morph: {
                return this.canMorph(command.getUnitType(), false, false);
            }
            case Research: {
                return false;
            }
            case Upgrade: {
                return false;
            }
            case Set_Rally_Position: {
                return false;
            }
            case Set_Rally_Unit: {
                return false;
            }
            case Move: {
                return true;
            }
            case Patrol: {
                return true;
            }
            case Hold_Position: {
                return true;
            }
            case Stop: {
                return true;
            }
            case Follow: {
                return this.canFollow(command.target, checkCanTargetUnit, false, false);
            }
            case Gather: {
                return this.canGather(command.target, checkCanTargetUnit, false, false);
            }
            case Return_Cargo: {
                return true;
            }
            case Repair: {
                return this.canRepair(command.target, checkCanTargetUnit, false, false);
            }
            case Burrow: {
                return true;
            }
            case Unburrow: {
                return true;
            }
            case Cloak: {
                return true;
            }
            case Decloak: {
                return true;
            }
            case Siege: {
                return true;
            }
            case Unsiege: {
                return true;
            }
            case Lift: {
                return false;
            }
            case Land: {
                return false;
            }
            case Load: {
                return this.canLoad(command.target, checkCanTargetUnit, false, false);
            }
            case Unload: {
                return false;
            }
            case Unload_All: {
                return false;
            }
            case Unload_All_Position: {
                return this.canUnloadAllPosition(command.getTargetPosition(), false, false);
            }
            case Right_Click_Position: {
                return true;
            }
            case Right_Click_Unit: {
                return this.canRightClickUnitGrouped(command.target, checkCanTargetUnit, false, false, false);
            }
            case Halt_Construction: {
                return true;
            }
            case Cancel_Construction: {
                return false;
            }
            case Cancel_Addon: {
                return false;
            }
            case Cancel_Train: {
                return false;
            }
            case Cancel_Train_Slot: {
                return false;
            }
            case Cancel_Morph: {
                return true;
            }
            case Cancel_Research: {
                return false;
            }
            case Cancel_Upgrade: {
                return false;
            }
            case Use_Tech: {
                return this.canUseTechWithoutTarget(TechType.idToEnum[command.extra], false, false);
            }
            case Use_Tech_Unit: {
                return this.canUseTechUnit(TechType.idToEnum[command.extra], command.target, checkCanTargetUnit, checkCanUseTechUnitOnUnits, false, false);
            }
            case Use_Tech_Position: {
                return this.canUseTechPosition(TechType.idToEnum[command.extra], command.getTargetPosition(), checkCanUseTechPositionOnPositions, false, false);
            }
            case Place_COP: {
                return false;
            }
        }
        return true;
    }

    public boolean canCommand() {
        if (!this.exists() || !this.getPlayer().equals(this.game.self())) {
            return false;
        }
        if (this.isLockedDown() || this.isMaelstrommed() || this.isStasised() || !this.isPowered() || this.getOrder() == Order.ZergBirth || this.isLoaded()) {
            if (!this.getType().producesLarva()) {
                return false;
            }
            for (Unit larva : this.getLarva()) {
                if (!larva.canCommand()) continue;
                return true;
            }
            return false;
        }
        UnitType uType = this.getType();
        if (uType == UnitType.Protoss_Interceptor || uType == UnitType.Terran_Vulture_Spider_Mine || uType == UnitType.Spell_Scanner_Sweep || uType == UnitType.Special_Map_Revealer) {
            return false;
        }
        if (this.isCompleted() && (uType == UnitType.Protoss_Pylon || uType == UnitType.Terran_Supply_Depot || uType.isResourceContainer() || uType == UnitType.Protoss_Shield_Battery || uType == UnitType.Terran_Nuclear_Missile || uType.isPowerup() || uType.isSpecialBuilding() && !uType.isFlagBeacon())) {
            return false;
        }
        return this.isCompleted() || uType.isBuilding() || this.isMorphing();
    }

    public boolean canCommandGrouped() {
        return this.canCommandGrouped(true);
    }

    public boolean canCommandGrouped(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return !this.getType().isBuilding() && !this.getType().isCritter();
    }

    public boolean canIssueCommandType(UnitCommandType ct) {
        return this.canIssueCommandType(ct, true);
    }

    public boolean canIssueCommandType(UnitCommandType ct, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        switch (ct) {
            case Attack_Move: {
                return this.canAttackMove(false);
            }
            case Attack_Unit: {
                return this.canAttackUnit(false);
            }
            case Build: {
                return this.canBuild(false);
            }
            case Build_Addon: {
                return this.canBuildAddon(false);
            }
            case Train: {
                return this.canTrain(false);
            }
            case Morph: {
                return this.canMorph(false);
            }
            case Research: {
                return this.canResearch(false);
            }
            case Upgrade: {
                return this.canUpgrade(false);
            }
            case Set_Rally_Position: {
                return this.canSetRallyPosition(false);
            }
            case Set_Rally_Unit: {
                return this.canSetRallyUnit(false);
            }
            case Move: {
                return this.canMove(false);
            }
            case Patrol: {
                return this.canPatrol(false);
            }
            case Hold_Position: {
                return this.canHoldPosition(false);
            }
            case Stop: {
                return this.canStop(false);
            }
            case Follow: {
                return this.canFollow(false);
            }
            case Gather: {
                return this.canGather(false);
            }
            case Return_Cargo: {
                return this.canReturnCargo(false);
            }
            case Repair: {
                return this.canRepair(false);
            }
            case Burrow: {
                return this.canBurrow(false);
            }
            case Unburrow: {
                return this.canUnburrow(false);
            }
            case Cloak: {
                return this.canCloak(false);
            }
            case Decloak: {
                return this.canDecloak(false);
            }
            case Siege: {
                return this.canSiege(false);
            }
            case Unsiege: {
                return this.canUnsiege(false);
            }
            case Lift: {
                return this.canLift(false);
            }
            case Land: {
                return this.canLand(false);
            }
            case Load: {
                return this.canLoad(false);
            }
            case Unload: {
                return this.canUnload(false);
            }
            case Unload_All: {
                return this.canUnloadAll(false);
            }
            case Unload_All_Position: {
                return this.canUnloadAllPosition(false);
            }
            case Right_Click_Position: {
                return this.canRightClickPosition(false);
            }
            case Right_Click_Unit: {
                return this.canRightClickUnit(false);
            }
            case Halt_Construction: {
                return this.canHaltConstruction(false);
            }
            case Cancel_Construction: {
                return this.canCancelConstruction(false);
            }
            case Cancel_Addon: {
                return this.canCancelAddon(false);
            }
            case Cancel_Train: {
                return this.canCancelTrain(false);
            }
            case Cancel_Train_Slot: {
                return this.canCancelTrainSlot(false);
            }
            case Cancel_Morph: {
                return this.canCancelMorph(false);
            }
            case Cancel_Research: {
                return this.canCancelResearch(false);
            }
            case Cancel_Upgrade: {
                return this.canCancelUpgrade(false);
            }
            case Use_Tech: 
            case Use_Tech_Unit: 
            case Use_Tech_Position: {
                return this.canUseTechWithOrWithoutTarget(false);
            }
            case Place_COP: {
                return this.canPlaceCOP(false);
            }
        }
        return true;
    }

    public boolean canIssueCommandTypeGrouped(UnitCommandType ct, boolean checkCommandibilityGrouped) {
        return this.canIssueCommandTypeGrouped(ct, checkCommandibilityGrouped, true);
    }

    public boolean canIssueCommandTypeGrouped(UnitCommandType ct) {
        return this.canIssueCommandTypeGrouped(ct, true);
    }

    public boolean canIssueCommandTypeGrouped(UnitCommandType ct, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        switch (ct) {
            case Attack_Move: {
                return this.canAttackMoveGrouped(false, false);
            }
            case Attack_Unit: {
                return this.canAttackUnitGrouped(false, false);
            }
            case Build: {
                return false;
            }
            case Build_Addon: {
                return false;
            }
            case Train: {
                return this.canTrain(false);
            }
            case Morph: {
                return this.canMorph(false);
            }
            case Research: {
                return false;
            }
            case Upgrade: {
                return false;
            }
            case Set_Rally_Position: {
                return false;
            }
            case Set_Rally_Unit: {
                return false;
            }
            case Move: {
                return this.canMoveGrouped(false, false);
            }
            case Patrol: {
                return this.canPatrolGrouped(false, false);
            }
            case Hold_Position: {
                return this.canHoldPosition(false);
            }
            case Stop: {
                return this.canStop(false);
            }
            case Follow: {
                return this.canFollow(false);
            }
            case Gather: {
                return this.canGather(false);
            }
            case Return_Cargo: {
                return this.canReturnCargo(false);
            }
            case Repair: {
                return this.canRepair(false);
            }
            case Burrow: {
                return this.canBurrow(false);
            }
            case Unburrow: {
                return this.canUnburrow(false);
            }
            case Cloak: {
                return this.canCloak(false);
            }
            case Decloak: {
                return this.canDecloak(false);
            }
            case Siege: {
                return this.canSiege(false);
            }
            case Unsiege: {
                return this.canUnsiege(false);
            }
            case Lift: {
                return false;
            }
            case Land: {
                return false;
            }
            case Load: {
                return this.canLoad(false);
            }
            case Unload: {
                return false;
            }
            case Unload_All: {
                return false;
            }
            case Unload_All_Position: {
                return this.canUnloadAllPosition(false);
            }
            case Right_Click_Position: {
                return this.canRightClickPositionGrouped(false, false);
            }
            case Right_Click_Unit: {
                return this.canRightClickUnitGrouped(false, false);
            }
            case Halt_Construction: {
                return this.canHaltConstruction(false);
            }
            case Cancel_Construction: {
                return false;
            }
            case Cancel_Addon: {
                return false;
            }
            case Cancel_Train: {
                return false;
            }
            case Cancel_Train_Slot: {
                return false;
            }
            case Cancel_Morph: {
                return this.canCancelMorph(false);
            }
            case Cancel_Research: {
                return false;
            }
            case Cancel_Upgrade: {
                return false;
            }
            case Use_Tech: 
            case Use_Tech_Unit: 
            case Use_Tech_Position: {
                return this.canUseTechWithOrWithoutTarget(false);
            }
            case Place_COP: {
                return false;
            }
        }
        return true;
    }

    public boolean canTargetUnit(Unit targetUnit) {
        if (targetUnit == null || !targetUnit.exists()) {
            return false;
        }
        UnitType targetType = targetUnit.getType();
        if (!(targetUnit.isCompleted() || targetType.isBuilding() || targetUnit.isMorphing() || targetType == UnitType.Protoss_Archon || targetType == UnitType.Protoss_Dark_Archon)) {
            return false;
        }
        return targetType != UnitType.Spell_Scanner_Sweep && targetType != UnitType.Spell_Dark_Swarm && targetType != UnitType.Spell_Disruption_Web && targetType != UnitType.Special_Map_Revealer;
    }

    public boolean canTargetUnit(Unit targetUnit, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canTargetUnit(targetUnit);
    }

    public boolean canAttack() {
        return this.canAttack(true);
    }

    public boolean canAttack(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canAttackMove(false) || this.canAttackUnit(false);
    }

    public boolean canAttack(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttack(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttack(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttack(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttack(Position target, boolean checkCanTargetUnit) {
        return this.canAttack(target, checkCanTargetUnit, true);
    }

    public boolean canAttack(Unit target, boolean checkCanTargetUnit) {
        return this.canAttack(target, checkCanTargetUnit, true);
    }

    public boolean canAttack(Position target) {
        return this.canAttack(target, true);
    }

    public boolean canAttack(Unit target) {
        return this.canAttack(target, true);
    }

    public boolean canAttack(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canAttackMove(false);
    }

    public boolean canAttack(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.canAttackUnit(target, checkCanTargetUnit, checkCanIssueCommandType, false);
    }

    public boolean canAttackGrouped(boolean checkCommandibilityGrouped) {
        return this.canAttackGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canAttackGrouped() {
        return this.canAttackGrouped(true);
    }

    public boolean canAttackGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        return this.canAttackMoveGrouped(false, false) || this.canAttackUnitGrouped(false, false);
    }

    public boolean canAttackGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canAttackGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canAttackGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canAttackGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canAttackGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttackGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttackGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttackGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttackGrouped(Position target, boolean checkCanTargetUnit) {
        return this.canAttackGrouped(target, checkCanTargetUnit, true);
    }

    public boolean canAttackGrouped(Unit target, boolean checkCanTargetUnit) {
        return this.canAttackGrouped(target, checkCanTargetUnit, true);
    }

    public boolean canAttackGrouped(Position target) {
        return this.canAttackGrouped(target, true);
    }

    public boolean canAttackGrouped(Unit target) {
        return this.canAttackGrouped(target, true);
    }

    public boolean canAttackGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        return this.canAttackMoveGrouped(false, false) || this.canAttackUnitGrouped(false, false);
    }

    public boolean canAttackGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.canAttackUnitGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, false, false);
    }

    public boolean canAttackMove() {
        return this.canAttackMove(true);
    }

    public boolean canAttackMove(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return (this.getType() == UnitType.Terran_Medic || this.canAttackUnit(false)) && this.canMove(false);
    }

    public boolean canAttackMoveGrouped(boolean checkCommandibilityGrouped) {
        return this.canAttackMoveGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canAttackMoveGrouped() {
        return this.canAttackMoveGrouped(true);
    }

    public boolean canAttackMoveGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        UnitType ut = this.getType();
        return ut.canMove() || ut == UnitType.Terran_Siege_Tank_Siege_Mode || ut == UnitType.Zerg_Cocoon || ut == UnitType.Zerg_Lurker_Egg;
    }

    public boolean canAttackUnit() {
        return this.canAttackUnit(true);
    }

    public boolean canAttackUnit(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (ut.groundWeapon() == WeaponType.None && ut.airWeapon() == WeaponType.None) {
            if (ut == UnitType.Protoss_Carrier || ut == UnitType.Hero_Gantrithor) {
                if (this.getInterceptorCount() <= 0) {
                    return false;
                }
            } else if (ut == UnitType.Protoss_Reaver || ut == UnitType.Hero_Warbringer) {
                if (this.getScarabCount() <= 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (ut == UnitType.Zerg_Lurker ? !this.isBurrowed() : this.isBurrowed()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        return this.getOrder() != Order.ConstructingBuilding;
    }

    public boolean canAttackUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttackUnit(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttackUnit(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canAttackUnit(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canAttackUnit(Unit targetUnit) {
        return this.canAttackUnit(targetUnit, true);
    }

    public boolean canAttackUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        WeaponType weapon;
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canAttackUnit(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        if (targetUnit.isInvincible()) {
            return false;
        }
        UnitType type = this.getType();
        boolean targetInAir = targetUnit.isFlying();
        WeaponType weaponType = weapon = targetInAir ? type.airWeapon() : type.groundWeapon();
        if (weapon == WeaponType.None) {
            switch (type) {
                case Protoss_Carrier: 
                case Hero_Gantrithor: {
                    break;
                }
                case Protoss_Reaver: 
                case Hero_Warbringer: {
                    if (!targetInAir) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        if (!type.canMove() && !this.isInWeaponRange(targetUnit)) {
            return false;
        }
        if (type == UnitType.Zerg_Lurker && !this.isInWeaponRange(targetUnit)) {
            return false;
        }
        return !this.equals(targetUnit);
    }

    public boolean canAttackUnitGrouped(boolean checkCommandibilityGrouped) {
        return this.canAttackUnitGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canAttackUnitGrouped() {
        return this.canAttackUnitGrouped(true);
    }

    public boolean canAttackUnitGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (!this.isInterruptible()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.canMove() && ut != UnitType.Terran_Siege_Tank_Siege_Mode) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        if (this.getType() == UnitType.Zerg_Lurker ? !this.isBurrowed() : this.isBurrowed()) {
            return false;
        }
        return this.getOrder() != Order.ConstructingBuilding;
    }

    public boolean canAttackUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canAttackUnitGrouped(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canAttackUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canAttackUnitGrouped(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canAttackUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canAttackUnitGrouped(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canAttackUnitGrouped(Unit targetUnit) {
        return this.canAttackUnitGrouped(targetUnit, true);
    }

    public boolean canAttackUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandTypeGrouped, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (checkCanIssueCommandTypeGrouped && !this.canAttackUnitGrouped(false, false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        if (this.isInvincible()) {
            return false;
        }
        UnitType ut = this.getType();
        if (ut == UnitType.Zerg_Lurker && !this.isInWeaponRange(targetUnit)) {
            return false;
        }
        if (ut == UnitType.Zerg_Queen && (targetUnit.getType() != UnitType.Terran_Command_Center || targetUnit.getHitPoints() >= 750 || targetUnit.getHitPoints() <= 0)) {
            return false;
        }
        return !this.equals(targetUnit);
    }

    public boolean canBuild() {
        return this.canBuild(true);
    }

    public boolean canBuild(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (this.isConstructing() || !this.isCompleted() || ut.isBuilding() && !this.isIdle()) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canBuild(UnitType uType, boolean checkCanIssueCommandType) {
        return this.canBuild(uType, checkCanIssueCommandType, true);
    }

    public boolean canBuild(UnitType uType) {
        return this.canBuild(uType, true);
    }

    public boolean canBuild(UnitType uType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canBuild(false)) {
            return false;
        }
        if (!this.game.canMake(uType, this)) {
            return false;
        }
        if (!uType.isBuilding()) {
            return false;
        }
        return this.getAddon() == null;
    }

    public boolean canBuild(UnitType uType, TilePosition tilePos, boolean checkTargetUnitType, boolean checkCanIssueCommandType) {
        return this.canBuild(uType, tilePos, checkTargetUnitType, checkCanIssueCommandType, true);
    }

    public boolean canBuild(UnitType uType, TilePosition tilePos, boolean checkTargetUnitType) {
        return this.canBuild(uType, tilePos, checkTargetUnitType, true);
    }

    public boolean canBuild(UnitType uType, TilePosition tilePos) {
        return this.canBuild(uType, tilePos, true);
    }

    public boolean canBuild(UnitType uType, TilePosition tilePos, boolean checkTargetUnitType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canBuild(false)) {
            return false;
        }
        if (checkTargetUnitType && !this.canBuild(uType, false, false)) {
            return false;
        }
        if (!tilePos.isValid(this.game)) {
            return false;
        }
        return this.game.canBuildHere(tilePos, uType, this, true);
    }

    public boolean canBuildAddon() {
        return this.canBuildAddon(true);
    }

    public boolean canBuildAddon(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (this.isConstructing() || !this.isCompleted() || this.isLifted() || this.getType().isBuilding() && !this.isIdle()) {
            return false;
        }
        if (this.getAddon() != null) {
            return false;
        }
        return this.getType().canBuildAddon();
    }

    public boolean canBuildAddon(UnitType uType, boolean checkCanIssueCommandType) {
        return this.canBuildAddon(uType, checkCanIssueCommandType, true);
    }

    public boolean canBuildAddon(UnitType uType) {
        return this.canBuildAddon(uType, true);
    }

    public boolean canBuildAddon(UnitType uType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canBuildAddon(uType, false)) {
            return false;
        }
        if (!this.game.canMake(uType, this)) {
            return false;
        }
        if (!uType.isAddon()) {
            return false;
        }
        return this.game.canBuildHere(this.getTilePosition(), uType, this);
    }

    public boolean canTrain() {
        return this.canTrain(true);
    }

    public boolean canTrain(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (ut.producesLarva()) {
            if (!this.isConstructing() && this.isCompleted()) {
                return true;
            }
            for (Unit larva : this.getLarva()) {
                if (larva.isConstructing() || !larva.isCompleted() || !larva.canCommand()) continue;
                return true;
            }
            return false;
        }
        if (this.isConstructing() || !this.isCompleted() || this.isLifted()) {
            return false;
        }
        if (!ut.canProduce() && ut != UnitType.Terran_Nuclear_Silo && ut != UnitType.Zerg_Hydralisk && ut != UnitType.Zerg_Mutalisk && ut != UnitType.Zerg_Creep_Colony && ut != UnitType.Zerg_Spire && ut != UnitType.Zerg_Larva) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canTrain(UnitType uType, boolean checkCanIssueCommandType) {
        return this.canTrain(uType, checkCanIssueCommandType, true);
    }

    public boolean canTrain(UnitType uType) {
        return this.canTrain(uType, true);
    }

    public boolean canTrain(UnitType uType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canTrain(false)) {
            return false;
        }
        Unit thisUnit = this;
        if (this.getType().producesLarva()) {
            if (uType.whatBuilds().getKey() == UnitType.Zerg_Larva) {
                boolean foundCommandableLarva = false;
                for (Unit larva : this.getLarva()) {
                    if (!larva.canTrain(true)) continue;
                    foundCommandableLarva = true;
                    thisUnit = larva;
                    break;
                }
                if (!foundCommandableLarva) {
                    return false;
                }
            } else if (this.isConstructing() || !this.isCompleted()) {
                return false;
            }
        }
        if (!this.game.canMake(uType, thisUnit)) {
            return false;
        }
        if (uType.isAddon() || uType.isBuilding() && !thisUnit.getType().isBuilding()) {
            return false;
        }
        return uType != UnitType.Zerg_Larva && uType != UnitType.Zerg_Egg && uType != UnitType.Zerg_Cocoon;
    }

    public boolean canMorph() {
        return this.canMorph(true);
    }

    public boolean canMorph(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (ut.producesLarva()) {
            if (!this.isConstructing() && this.isCompleted() && (!ut.isBuilding() || this.isIdle())) {
                return true;
            }
            for (Unit larva : this.getLarva()) {
                if (larva.isConstructing() || !larva.isCompleted() || !larva.canCommand()) continue;
                return true;
            }
            return false;
        }
        if (this.isConstructing() || !this.isCompleted() || ut.isBuilding() && !this.isIdle()) {
            return false;
        }
        if (ut != UnitType.Zerg_Hydralisk && ut != UnitType.Zerg_Mutalisk && ut != UnitType.Zerg_Creep_Colony && ut != UnitType.Zerg_Spire && ut != UnitType.Zerg_Hatchery && ut != UnitType.Zerg_Lair && ut != UnitType.Zerg_Hive && ut != UnitType.Zerg_Larva) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canMorph(UnitType uType, boolean checkCanIssueCommandType) {
        return this.canMorph(uType, checkCanIssueCommandType, true);
    }

    public boolean canMorph(UnitType uType) {
        return this.canMorph(uType, true);
    }

    public boolean canMorph(UnitType uType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canMorph(false)) {
            return false;
        }
        Unit thisUnit = this;
        if (this.getType().producesLarva()) {
            if (uType.whatBuilds().getKey() == UnitType.Zerg_Larva) {
                boolean foundCommandableLarva = false;
                for (Unit larva : this.getLarva()) {
                    if (!larva.canMorph(true)) continue;
                    foundCommandableLarva = true;
                    thisUnit = larva;
                    break;
                }
                if (!foundCommandableLarva) {
                    return false;
                }
            } else if (this.isConstructing() || !this.isCompleted() || this.getType().isBuilding() && !this.isIdle()) {
                return false;
            }
        }
        if (!this.game.canMake(uType, thisUnit)) {
            return false;
        }
        return uType != UnitType.Zerg_Larva && uType != UnitType.Zerg_Egg && uType != UnitType.Zerg_Cocoon;
    }

    public boolean canResearch() {
        return this.canResearch(true);
    }

    public boolean canResearch(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return !this.isLifted() && this.isIdle() && this.isCompleted();
    }

    public boolean canResearch(TechType type) {
        return this.canResearch(type, true);
    }

    public boolean canResearch(TechType type, boolean checkCanIssueCommandType) {
        Player self = this.game.self();
        if (!this.getPlayer().equals(self)) {
            return false;
        }
        if (!this.getType().isSuccessorOf(type.whatResearches())) {
            return false;
        }
        if (checkCanIssueCommandType && (this.isLifted() || !this.isIdle() || !this.isCompleted())) {
            return false;
        }
        if (self.isResearching(type)) {
            return false;
        }
        if (self.hasResearched(type)) {
            return false;
        }
        if (!self.isResearchAvailable(type)) {
            return false;
        }
        if (self.minerals() < type.mineralPrice()) {
            return false;
        }
        if (self.gas() < type.gasPrice()) {
            return false;
        }
        return self.hasUnitTypeRequirement(type.requiredUnit());
    }

    public boolean canUpgrade() {
        return this.canUpgrade(true);
    }

    public boolean canUpgrade(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return !this.isLifted() && this.isIdle() && this.isCompleted();
    }

    public boolean canUpgrade(UpgradeType type) {
        return this.canUpgrade(type, true);
    }

    public boolean canUpgrade(UpgradeType type, boolean checkCanIssueCommandType) {
        Player self = this.game.self();
        if (!this.getPlayer().equals(self)) {
            return false;
        }
        if (!this.getType().isSuccessorOf(type.whatUpgrades())) {
            return false;
        }
        if (checkCanIssueCommandType && (this.isLifted() || !this.isIdle() || !this.isCompleted())) {
            return false;
        }
        if (!self.hasUnitTypeRequirement(type.whatUpgrades())) {
            return false;
        }
        int nextLvl = self.getUpgradeLevel(type) + 1;
        if (!self.hasUnitTypeRequirement(type.whatsRequired(nextLvl))) {
            return false;
        }
        if (self.isUpgrading(type)) {
            return false;
        }
        if (self.getUpgradeLevel(type) >= self.getMaxUpgradeLevel(type)) {
            return false;
        }
        if (self.minerals() < type.mineralPrice(nextLvl)) {
            return false;
        }
        return self.gas() >= type.gasPrice(nextLvl);
    }

    public boolean canSetRallyPoint() {
        return this.canSetRallyPoint(true);
    }

    public boolean canSetRallyPoint(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canSetRallyPosition(false) || this.canSetRallyUnit(false);
    }

    public boolean canSetRallyPoint(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canSetRallyPoint(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canSetRallyPoint(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canSetRallyPoint(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canSetRallyPoint(Position target, boolean checkCanTargetUnit) {
        return this.canSetRallyPoint(target, checkCanTargetUnit, true);
    }

    public boolean canSetRallyPoint(Unit target, boolean checkCanTargetUnit) {
        return this.canSetRallyPoint(target, checkCanTargetUnit, true);
    }

    public boolean canSetRallyPoint(Position target) {
        return this.canSetRallyPoint(target, true);
    }

    public boolean canSetRallyPoint(Unit target) {
        return this.canSetRallyPoint(target, true);
    }

    public boolean canSetRallyPoint(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canSetRallyPosition(false);
    }

    public boolean canSetRallyPoint(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.canSetRallyUnit(target, checkCanTargetUnit, checkCanIssueCommandType, false);
    }

    public boolean canSetRallyPosition() {
        return this.canSetRallyPosition(true);
    }

    public boolean canSetRallyPosition(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().canProduce() || !this.getType().isBuilding()) {
            return false;
        }
        return !this.isLifted();
    }

    public boolean canSetRallyUnit() {
        return this.canSetRallyUnit(true);
    }

    public boolean canSetRallyUnit(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().canProduce() || !this.getType().isBuilding()) {
            return false;
        }
        return !this.isLifted();
    }

    public boolean canSetRallyUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canSetRallyUnit(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canSetRallyUnit(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canSetRallyUnit(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canSetRallyUnit(Unit targetUnit) {
        return this.canSetRallyUnit(targetUnit, true);
    }

    public boolean canSetRallyUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canSetRallyUnit(false)) {
            return false;
        }
        return !checkCanTargetUnit || this.canTargetUnit(targetUnit, false);
    }

    public boolean canMove() {
        return this.canMove(true);
    }

    public boolean canMove(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding()) {
            if (!this.isInterruptible()) {
                return false;
            }
            if (!this.getType().canMove()) {
                return false;
            }
            if (this.isBurrowed()) {
                return false;
            }
            if (this.getOrder() == Order.ConstructingBuilding) {
                return false;
            }
            if (ut == UnitType.Zerg_Larva) {
                return false;
            }
        } else {
            if (!ut.isFlyingBuilding()) {
                return false;
            }
            if (!this.isLifted()) {
                return false;
            }
        }
        return this.isCompleted();
    }

    public boolean canMoveGrouped(boolean checkCommandibilityGrouped) {
        return this.canMoveGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canMoveGrouped() {
        return this.canMoveGrouped(true);
    }

    public boolean canMoveGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (!this.getType().canMove()) {
            return false;
        }
        return this.isCompleted() || this.isMorphing();
    }

    public boolean canPatrol() {
        return this.canPatrol(true);
    }

    public boolean canPatrol(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canMove(false);
    }

    public boolean canPatrolGrouped(boolean checkCommandibilityGrouped) {
        return this.canPatrolGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canPatrolGrouped() {
        return this.canPatrolGrouped(true);
    }

    public boolean canPatrolGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        return this.canMoveGrouped(false, false);
    }

    public boolean canFollow() {
        return this.canFollow(true);
    }

    public boolean canFollow(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canMove(false);
    }

    public boolean canFollow(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canFollow(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canFollow(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canFollow(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canFollow(Unit targetUnit) {
        return this.canFollow(targetUnit, true);
    }

    public boolean canFollow(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canFollow(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        return targetUnit != this;
    }

    public boolean canGather() {
        return this.canGather(true);
    }

    public boolean canGather(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (!ut.isWorker()) {
            return false;
        }
        if (this.getPowerUp() != null) {
            return false;
        }
        if (this.isHallucination()) {
            return false;
        }
        if (this.isBurrowed()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        return this.getOrder() != Order.ConstructingBuilding;
    }

    public boolean canGather(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canGather(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canGather(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canGather(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canGather(Unit targetUnit) {
        return this.canGather(targetUnit, true);
    }

    public boolean canGather(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canGather(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        UnitType uType = targetUnit.getType();
        if (!uType.isResourceContainer() || uType == UnitType.Resource_Vespene_Geyser) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        if (!this.hasPath(this.getPosition())) {
            return false;
        }
        return !uType.isRefinery() || this.getPlayer().equals(this.game.self());
    }

    public boolean canReturnCargo() {
        return this.canReturnCargo(true);
    }

    public boolean canReturnCargo(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (!ut.isWorker()) {
            return false;
        }
        if (!this.isCarryingGas() && !this.isCarryingMinerals()) {
            return false;
        }
        if (this.isBurrowed()) {
            return false;
        }
        return this.getOrder() != Order.ConstructingBuilding;
    }

    public boolean canHoldPosition() {
        return this.canHoldPosition(true);
    }

    public boolean canHoldPosition(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding()) {
            if (!ut.canMove()) {
                return false;
            }
            if (this.isBurrowed() && ut != UnitType.Zerg_Lurker) {
                return false;
            }
            if (this.getOrder() == Order.ConstructingBuilding) {
                return false;
            }
            if (ut == UnitType.Zerg_Larva) {
                return false;
            }
        } else {
            if (!ut.isFlyingBuilding()) {
                return false;
            }
            if (!this.isLifted()) {
                return false;
            }
        }
        return this.isCompleted();
    }

    public boolean canStop() {
        return this.canStop(true);
    }

    public boolean canStop(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        UnitType ut = this.getType();
        if (this.isBurrowed() && ut != UnitType.Zerg_Lurker) {
            return false;
        }
        return !ut.isBuilding() || this.isLifted() || ut == UnitType.Protoss_Photon_Cannon || ut == UnitType.Zerg_Sunken_Colony || ut == UnitType.Zerg_Spore_Colony || ut == UnitType.Terran_Missile_Turret;
    }

    public boolean canRepair() {
        return this.canRepair(true);
    }

    public boolean canRepair(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.isInterruptible()) {
            return false;
        }
        if (this.getType() != UnitType.Terran_SCV) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        if (this.isHallucination()) {
            return false;
        }
        return this.getOrder() != Order.ConstructingBuilding;
    }

    public boolean canRepair(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRepair(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRepair(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canRepair(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canRepair(Unit targetUnit) {
        return this.canRepair(targetUnit, true);
    }

    public boolean canRepair(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canRepair(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        UnitType targType = targetUnit.getType();
        if (targType.getRace() != Race.Terran || !targType.isMechanical()) {
            return false;
        }
        if (targetUnit.getHitPoints() == targType.maxHitPoints()) {
            return false;
        }
        if (!targetUnit.isCompleted()) {
            return false;
        }
        return targetUnit != this;
    }

    public boolean canBurrow() {
        return this.canBurrow(true);
    }

    public boolean canBurrow(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canUseTechWithoutTarget(TechType.Burrowing, true, false);
    }

    public boolean canUnburrow() {
        return this.canUnburrow(true);
    }

    public boolean canUnburrow(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isBurrowable()) {
            return false;
        }
        return this.isBurrowed() && this.getOrder() != Order.Unburrowing;
    }

    public boolean canCloak() {
        return this.canCloak(true);
    }

    public boolean canCloak(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canUseTechWithoutTarget(this.getType().cloakingTech(), true, false);
    }

    public boolean canDecloak() {
        return this.canDecloak(true);
    }

    public boolean canDecloak(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (this.getType().cloakingTech() == TechType.None) {
            return false;
        }
        return this.getSecondaryOrder() == Order.Cloak;
    }

    public boolean canSiege() {
        return this.canSiege(true);
    }

    public boolean canSiege(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canUseTechWithoutTarget(TechType.Tank_Siege_Mode, true, false);
    }

    public boolean canUnsiege() {
        return this.canUnsiege(true);
    }

    public boolean canUnsiege(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.isSieged()) {
            return false;
        }
        Order order = this.getOrder();
        if (order == Order.Sieging || order == Order.Unsieging) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canLift() {
        return this.canLift(true);
    }

    public boolean canLift(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isFlyingBuilding()) {
            return false;
        }
        if (this.isLifted()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        return this.isIdle();
    }

    public boolean canLand() {
        return this.canLand(true);
    }

    public boolean canLand(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isFlyingBuilding()) {
            return false;
        }
        return this.isLifted();
    }

    public boolean canLand(TilePosition target, boolean checkCanIssueCommandType) {
        return this.canLand(target, checkCanIssueCommandType, true);
    }

    public boolean canLand(TilePosition target) {
        return this.canLand(target, true);
    }

    public boolean canLand(TilePosition target, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canLand(checkCommandibility)) {
            return false;
        }
        return this.game.canBuildHere(target, this.getType(), null, true);
    }

    public boolean canLoad() {
        return this.canLoad(true);
    }

    public boolean canLoad(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        if (ut == UnitType.Zerg_Overlord && this.game.self().getUpgradeLevel(UpgradeType.Ventral_Sacs) == 0) {
            return false;
        }
        if (this.isBurrowed()) {
            return false;
        }
        if (this.getOrder() == Order.ConstructingBuilding) {
            return false;
        }
        return ut != UnitType.Zerg_Larva;
    }

    public boolean canLoad(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canLoad(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canLoad(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canLoad(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canLoad(Unit targetUnit) {
        return this.canLoad(targetUnit, true);
    }

    public boolean canLoad(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        Unit unitThatLoads;
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canLoad(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        Player self = this.game.self();
        if (!targetUnit.getPlayer().equals(self)) {
            return false;
        }
        if (targetUnit.isLoaded() || !targetUnit.isCompleted()) {
            return false;
        }
        if (targetUnit.getType() == UnitType.Zerg_Overlord && self.getUpgradeLevel(UpgradeType.Ventral_Sacs) == 0) {
            return false;
        }
        int thisUnitSpaceProvided = this.getType().spaceProvided();
        int targetSpaceProvided = targetUnit.getType().spaceProvided();
        if (thisUnitSpaceProvided <= 0 && targetSpaceProvided <= 0) {
            return false;
        }
        Unit unitToBeLoaded = thisUnitSpaceProvided > 0 ? targetUnit : this;
        UnitType unitToBeLoadedType = unitToBeLoaded.getType();
        if (!unitToBeLoadedType.canMove() || unitToBeLoadedType.isFlyer() || unitToBeLoadedType.spaceRequired() > 8) {
            return false;
        }
        if (!unitToBeLoaded.isCompleted()) {
            return false;
        }
        if (unitToBeLoaded.isBurrowed()) {
            return false;
        }
        Unit unit = unitThatLoads = thisUnitSpaceProvided > 0 ? this : targetUnit;
        if (unitThatLoads.isHallucination()) {
            return false;
        }
        UnitType unitThatLoadsType = unitThatLoads.getType();
        if (unitThatLoadsType == UnitType.Terran_Bunker) {
            if (!unitToBeLoadedType.isOrganic() || unitToBeLoadedType.getRace() != Race.Terran) {
                return false;
            }
            if (!unitToBeLoaded.hasPath(unitThatLoads.getPosition())) {
                return false;
            }
        }
        int freeSpace = thisUnitSpaceProvided > 0 ? thisUnitSpaceProvided : targetSpaceProvided;
        for (Unit u : unitThatLoads.getLoadedUnits()) {
            int requiredSpace = u.getType().spaceRequired();
            if (requiredSpace <= 0 || requiredSpace >= 8) continue;
            freeSpace -= requiredSpace;
        }
        return unitToBeLoadedType.spaceRequired() <= freeSpace;
    }

    public boolean canUnloadWithOrWithoutTarget() {
        return this.canUnloadWithOrWithoutTarget(true);
    }

    public boolean canUnloadWithOrWithoutTarget(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (this.getLoadedUnits().isEmpty()) {
            return false;
        }
        if (ut == UnitType.Zerg_Overlord && this.game.self().getUpgradeLevel(UpgradeType.Ventral_Sacs) == 0) {
            return false;
        }
        return ut.spaceProvided() > 0;
    }

    public boolean canUnloadAtPosition(Position targDropPos, boolean checkCanIssueCommandType) {
        return this.canUnloadAtPosition(targDropPos, checkCanIssueCommandType, true);
    }

    public boolean canUnloadAtPosition(Position targDropPos) {
        return this.canUnloadAtPosition(targDropPos, true);
    }

    public boolean canUnloadAtPosition(Position targDropPos, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUnloadWithOrWithoutTarget(false)) {
            return false;
        }
        if (this.getType() != UnitType.Terran_Bunker) {
            if (!new WalkPosition(targDropPos.x / 8, targDropPos.y / 8).isValid(this.game)) {
                return false;
            }
            return this.game.isWalkable(targDropPos.x / 8, targDropPos.y / 8);
        }
        return true;
    }

    public boolean canUnload() {
        return this.canUnload(true);
    }

    public boolean canUnload(boolean checkCommandibility) {
        return this.canUnloadAtPosition(this.getPosition(), true, checkCommandibility);
    }

    public boolean canUnload(Unit targetUnit, boolean checkCanTargetUnit, boolean checkPosition, boolean checkCanIssueCommandType) {
        return this.canUnload(targetUnit, checkCanTargetUnit, checkPosition, checkCanIssueCommandType, true);
    }

    public boolean canUnload(Unit targetUnit, boolean checkCanTargetUnit, boolean checkPosition) {
        return this.canUnload(targetUnit, checkCanTargetUnit, checkPosition, true);
    }

    public boolean canUnload(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canUnload(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canUnload(Unit targetUnit) {
        return this.canUnload(targetUnit, true);
    }

    public boolean canUnload(Unit targetUnit, boolean checkCanTargetUnit, boolean checkPosition, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUnloadWithOrWithoutTarget(false)) {
            return false;
        }
        if (checkPosition && !this.canUnloadAtPosition(this.getPosition(), false, false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        if (!targetUnit.isLoaded()) {
            return false;
        }
        return this.equals(targetUnit.getTransport());
    }

    public boolean canUnloadAll() {
        return this.canUnloadAll(true);
    }

    public boolean canUnloadAll(boolean checkCommandibility) {
        return this.canUnloadAtPosition(this.getPosition(), true, checkCommandibility);
    }

    public boolean canUnloadAllPosition() {
        return this.canUnloadAllPosition(true);
    }

    public boolean canUnloadAllPosition(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.canUnloadWithOrWithoutTarget(false)) {
            return false;
        }
        return this.getType() != UnitType.Terran_Bunker;
    }

    public boolean canUnloadAllPosition(Position targDropPos, boolean checkCanIssueCommandType) {
        return this.canUnloadAllPosition(targDropPos, checkCanIssueCommandType, true);
    }

    public boolean canUnloadAllPosition(Position targDropPos) {
        return this.canUnloadAllPosition(targDropPos, true);
    }

    public boolean canUnloadAllPosition(Position targDropPos, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUnloadAllPosition(false)) {
            return false;
        }
        return this.canUnloadAtPosition(targDropPos, false, false);
    }

    public boolean canRightClick() {
        return this.canRightClick(true);
    }

    public boolean canRightClick(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canRightClickPosition(false) || this.canRightClickUnit(false);
    }

    public boolean canRightClick(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClick(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClick(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClick(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClick(Position target, boolean checkCanTargetUnit) {
        return this.canRightClick(target, checkCanTargetUnit, true);
    }

    public boolean canRightClick(Unit target, boolean checkCanTargetUnit) {
        return this.canRightClick(target, checkCanTargetUnit, true);
    }

    public boolean canRightClick(Position target) {
        return this.canRightClick(target, true);
    }

    public boolean canRightClick(Unit target) {
        return this.canRightClick(target, true);
    }

    public boolean canRightClick(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canRightClickPosition(false);
    }

    public boolean canRightClick(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.canRightClickUnit(target, checkCanTargetUnit, checkCanIssueCommandType, false);
    }

    public boolean canRightClickGrouped(boolean checkCommandibilityGrouped) {
        return this.canRightClickGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canRightClickGrouped() {
        return this.canRightClickGrouped(true);
    }

    public boolean canRightClickGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        return this.canRightClickPositionGrouped(false, false) || this.canRightClickUnitGrouped(false, false);
    }

    public boolean canRightClickGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canRightClickGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canRightClickGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClickGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClickGrouped(Position target, boolean checkCanTargetUnit) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, true);
    }

    public boolean canRightClickGrouped(Unit target, boolean checkCanTargetUnit) {
        return this.canRightClickGrouped(target, checkCanTargetUnit, true);
    }

    public boolean canRightClickGrouped(Position target) {
        return this.canRightClickGrouped(target, true);
    }

    public boolean canRightClickGrouped(Unit target) {
        return this.canRightClickGrouped(target, true);
    }

    public boolean canRightClickGrouped(Position target, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        return this.canRightClickPositionGrouped(false, false);
    }

    public boolean canRightClickGrouped(Unit target, boolean checkCanTargetUnit, boolean checkCanIssueCommandTypeGrouped, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.canRightClickUnitGrouped(target, checkCanTargetUnit, checkCanIssueCommandTypeGrouped, false, false);
    }

    public boolean canRightClickPosition() {
        return this.canRightClickPosition(true);
    }

    public boolean canRightClickPosition(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isBuilding() && !this.isInterruptible()) {
            return false;
        }
        return this.canMove(false) || this.canSetRallyPosition(false);
    }

    public boolean canRightClickPositionGrouped(boolean checkCommandibilityGrouped) {
        return this.canRightClickPositionGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canRightClickPositionGrouped() {
        return this.canRightClickPositionGrouped(true);
    }

    public boolean canRightClickPositionGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (!this.isInterruptible()) {
            return false;
        }
        return this.canMoveGrouped(false, false);
    }

    public boolean canRightClickUnit() {
        return this.canRightClickUnit(true);
    }

    public boolean canRightClickUnit(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isBuilding() && !this.isInterruptible()) {
            return false;
        }
        return this.canFollow(false) || this.canAttackUnit(false) || this.canLoad(false) || this.canSetRallyUnit(false);
    }

    public boolean canRightClickUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClickUnit(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClickUnit(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canRightClickUnit(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canRightClickUnit(Unit targetUnit) {
        return this.canRightClickUnit(targetUnit, true);
    }

    public boolean canRightClickUnit(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canRightClickUnit(false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        if (!targetUnit.getPlayer().isNeutral() && this.getPlayer().isEnemy(targetUnit.getPlayer()) && !this.canAttackUnit(targetUnit, false, true, false)) {
            return false;
        }
        return this.canFollow(targetUnit, false, true, false) || this.canLoad(targetUnit, false, true, false) || this.canSetRallyUnit(targetUnit, false, true, false);
    }

    public boolean canRightClickUnitGrouped(boolean checkCommandibilityGrouped) {
        return this.canRightClickUnitGrouped(checkCommandibilityGrouped, true);
    }

    public boolean canRightClickUnitGrouped() {
        return this.canRightClickUnitGrouped(true);
    }

    public boolean canRightClickUnitGrouped(boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (!this.isInterruptible()) {
            return false;
        }
        return this.canFollow(false) || this.canAttackUnitGrouped(false, false) || this.canLoad(false);
    }

    public boolean canRightClickUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped) {
        return this.canRightClickUnitGrouped(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, checkCommandibilityGrouped, true);
    }

    public boolean canRightClickUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType) {
        return this.canRightClickUnitGrouped(targetUnit, checkCanTargetUnit, checkCanIssueCommandType, true);
    }

    public boolean canRightClickUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canRightClickUnitGrouped(targetUnit, checkCanTargetUnit, true);
    }

    public boolean canRightClickUnitGrouped(Unit targetUnit) {
        return this.canRightClickUnitGrouped(targetUnit, true);
    }

    public boolean canRightClickUnitGrouped(Unit targetUnit, boolean checkCanTargetUnit, boolean checkCanIssueCommandType, boolean checkCommandibilityGrouped, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCommandibilityGrouped && !this.canCommandGrouped(false)) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canRightClickUnitGrouped(false, false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        if (!targetUnit.getPlayer().isNeutral() && this.getPlayer().isEnemy(targetUnit.getPlayer()) && !this.canAttackUnitGrouped(targetUnit, false, true, false, false)) {
            return false;
        }
        return this.canFollow(targetUnit, false, true, false) || this.canLoad(targetUnit, false, true, false);
    }

    public boolean canHaltConstruction() {
        return this.canHaltConstruction(true);
    }

    public boolean canHaltConstruction(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.getOrder() == Order.ConstructingBuilding;
    }

    public boolean canCancelConstruction() {
        return this.canCancelConstruction(true);
    }

    public boolean canCancelConstruction(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isBuilding()) {
            return false;
        }
        return !this.isCompleted() && (this.getType() != UnitType.Zerg_Nydus_Canal || this.getNydusExit() == null);
    }

    public boolean canCancelAddon() {
        return this.canCancelAddon(true);
    }

    public boolean canCancelAddon(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        Unit addon = this.getAddon();
        return addon != null && !addon.isCompleted();
    }

    public boolean canCancelTrain() {
        return this.canCancelTrain(true);
    }

    public boolean canCancelTrain(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.isTraining();
    }

    public boolean canCancelTrainSlot() {
        return this.canCancelTrainSlot(true);
    }

    public boolean canCancelTrainSlot(boolean checkCommandibility) {
        return this.canCancelTrain(checkCommandibility);
    }

    public boolean canCancelTrainSlot(int slot, boolean checkCanIssueCommandType) {
        return this.canCancelTrainSlot(slot, checkCanIssueCommandType, true);
    }

    public boolean canCancelTrainSlot(int slot) {
        return this.canCancelTrainSlot(slot, true);
    }

    public boolean canCancelTrainSlot(int slot, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canCancelTrainSlot(false)) {
            return false;
        }
        return this.isTraining() && slot >= 0 && this.getTrainingQueue().size() > slot;
    }

    public boolean canCancelMorph() {
        return this.canCancelMorph(true);
    }

    public boolean canCancelMorph(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.isMorphing() || !this.isCompleted() && this.getType() == UnitType.Zerg_Nydus_Canal && this.getNydusExit() != null) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canCancelResearch() {
        return this.canCancelResearch(true);
    }

    public boolean canCancelResearch(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.getOrder() == Order.ResearchTech;
    }

    public boolean canCancelUpgrade() {
        return this.canCancelUpgrade(true);
    }

    public boolean canCancelUpgrade(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.getOrder() == Order.Upgrade;
    }

    public boolean canUseTechWithOrWithoutTarget() {
        return this.canUseTechWithOrWithoutTarget(true);
    }

    public boolean canUseTechWithOrWithoutTarget(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isBuilding() && !this.isInterruptible()) {
            return false;
        }
        if (!this.isCompleted()) {
            return false;
        }
        return !this.isHallucination();
    }

    public boolean canUseTechWithOrWithoutTarget(TechType tech, boolean checkCanIssueCommandType) {
        return this.canUseTechWithOrWithoutTarget(tech, checkCanIssueCommandType, true);
    }

    public boolean canUseTechWithOrWithoutTarget(TechType tech) {
        return this.canUseTechWithOrWithoutTarget(tech, true);
    }

    public boolean canUseTechWithOrWithoutTarget(TechType tech, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        UnitType ut = this.getType();
        if (!ut.isHero() && !this.game.self().hasResearched(tech) && ut != UnitType.Zerg_Lurker) {
            return false;
        }
        if (this.getEnergy() < tech.energyCost()) {
            return false;
        }
        if (tech != TechType.Burrowing && !tech.whatUses().contains((Object)ut)) {
            return false;
        }
        Order order = this.getOrder();
        switch (tech) {
            case Spider_Mines: {
                return this.getSpiderMineCount() > 0;
            }
            case Tank_Siege_Mode: {
                return !this.isSieged() && order != Order.Sieging && order != Order.Unsieging;
            }
            case Cloaking_Field: 
            case Personnel_Cloaking: {
                return this.getSecondaryOrder() != Order.Cloak;
            }
            case Burrowing: {
                return ut.isBurrowable() && !this.isBurrowed() && order != Order.Burrowing && order != Order.Unburrowing;
            }
            case None: {
                return false;
            }
            case Nuclear_Strike: {
                return this.getPlayer().completedUnitCount(UnitType.Terran_Nuclear_Missile) != 0;
            }
            case Unknown: {
                return false;
            }
        }
        return true;
    }

    public boolean canUseTech(TechType tech, Position target, boolean checkCanTargetUnit, boolean checkTargetsType, boolean checkCanIssueCommandType) {
        return this.canUseTech(tech, target, checkCanTargetUnit, checkTargetsType, checkCanIssueCommandType, true);
    }

    public boolean canUseTech(TechType tech, Unit target, boolean checkCanTargetUnit, boolean checkTargetsType, boolean checkCanIssueCommandType) {
        return this.canUseTech(tech, target, checkCanTargetUnit, checkTargetsType, checkCanIssueCommandType, true);
    }

    public boolean canUseTech(TechType tech, Position target, boolean checkCanTargetUnit, boolean checkTargetsType) {
        return this.canUseTech(tech, target, checkCanTargetUnit, checkTargetsType, true);
    }

    public boolean canUseTech(TechType tech, Unit target, boolean checkCanTargetUnit, boolean checkTargetsType) {
        return this.canUseTech(tech, target, checkCanTargetUnit, checkTargetsType, true);
    }

    public boolean canUseTech(TechType tech, Position target, boolean checkCanTargetUnit) {
        return this.canUseTech(tech, target, checkCanTargetUnit, true);
    }

    public boolean canUseTech(TechType tech, Unit target, boolean checkCanTargetUnit) {
        return this.canUseTech(tech, target, checkCanTargetUnit, true);
    }

    public boolean canUseTech(TechType tech, Position target) {
        return this.canUseTech(tech, target, true);
    }

    public boolean canUseTech(TechType tech, Unit target) {
        return this.canUseTech(tech, target, true);
    }

    public boolean canUseTech(TechType tech) {
        return this.canUseTech(tech, (Unit)null);
    }

    public boolean canUseTech(TechType tech, Position target, boolean checkCanTargetUnit, boolean checkTargetsType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        return this.canUseTechPosition(tech, target, checkTargetsType, checkCanIssueCommandType, false);
    }

    public boolean canUseTech(TechType tech, Unit target, boolean checkCanTargetUnit, boolean checkTargetsType, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (target == null) {
            return this.canUseTechWithoutTarget(tech, checkCanIssueCommandType, false);
        }
        return this.canUseTechUnit(tech, target, checkCanTargetUnit, checkTargetsType, checkCanIssueCommandType, false);
    }

    public boolean canUseTechWithoutTarget(TechType tech, boolean checkCanIssueCommandType) {
        return this.canUseTechWithoutTarget(tech, checkCanIssueCommandType, true);
    }

    public boolean canUseTechWithoutTarget(TechType tech) {
        return this.canUseTechWithoutTarget(tech, true);
    }

    public boolean canUseTechWithoutTarget(TechType tech, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        if (!this.canUseTechWithOrWithoutTarget(tech, false, false)) {
            return false;
        }
        return !tech.targetsUnit() && !tech.targetsPosition() && tech != TechType.None && tech != TechType.Unknown && tech != TechType.Lurker_Aspect;
    }

    public boolean canUseTechUnit(TechType tech, boolean checkCanIssueCommandType) {
        return this.canUseTechUnit(tech, checkCanIssueCommandType, true);
    }

    public boolean canUseTechUnit(TechType tech) {
        return this.canUseTechUnit(tech, true);
    }

    public boolean canUseTechUnit(TechType tech, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        if (!this.canUseTechWithOrWithoutTarget(tech, false, false)) {
            return false;
        }
        return tech.targetsUnit();
    }

    public boolean canUseTechUnit(TechType tech, Unit targetUnit, boolean checkCanTargetUnit, boolean checkTargetsUnits, boolean checkCanIssueCommandType) {
        return this.canUseTech(tech, targetUnit, checkCanTargetUnit, checkTargetsUnits, checkCanIssueCommandType, true);
    }

    public boolean canUseTechUnit(TechType tech, Unit targetUnit, boolean checkCanTargetUnit, boolean checkTargetsUnits) {
        return this.canUseTech(tech, targetUnit, checkCanTargetUnit, checkTargetsUnits, true);
    }

    public boolean canUseTechUnit(TechType tech, Unit targetUnit, boolean checkCanTargetUnit) {
        return this.canUseTech(tech, targetUnit, checkCanTargetUnit, true);
    }

    public boolean canUseTechUnit(TechType tech, Unit targetUnit) {
        return this.canUseTech(tech, targetUnit, true);
    }

    public boolean canUseTechUnit(TechType tech, Unit targetUnit, boolean checkCanTargetUnit, boolean checkTargetsUnits, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        if (checkTargetsUnits && !this.canUseTechUnit(tech, false, false)) {
            return false;
        }
        if (checkCanTargetUnit && !this.canTargetUnit(targetUnit, false)) {
            return false;
        }
        UnitType targetType = targetUnit.getType();
        switch (tech) {
            case Archon_Warp: {
                if (targetType != UnitType.Protoss_High_Templar) {
                    return false;
                }
                if (this.getPlayer().equals(targetUnit.getPlayer())) break;
                return false;
            }
            case Dark_Archon_Meld: {
                if (targetType != UnitType.Protoss_Dark_Templar) {
                    return false;
                }
                if (this.getPlayer().equals(targetUnit.getPlayer())) break;
                return false;
            }
            case Consume: {
                if (!this.getPlayer().equals(targetUnit.getPlayer())) {
                    return false;
                }
                if (targetType.getRace() == Race.Zerg && targetType != UnitType.Zerg_Larva) break;
                return false;
            }
            case Spawn_Broodlings: {
                if ((targetType.isOrganic() || targetType.isMechanical()) && !targetType.isRobotic() && !targetType.isFlyer()) break;
                return false;
            }
            case Lockdown: {
                if (targetType.isMechanical()) break;
                return false;
            }
            case Healing: {
                if (targetUnit.getHitPoints() == targetType.maxHitPoints()) {
                    return false;
                }
                if (!targetType.isOrganic() || targetType.isFlyer()) {
                    return false;
                }
                if (targetUnit.getPlayer().isNeutral() || !this.getPlayer().isEnemy(this.getPlayer())) break;
                return false;
            }
            case Mind_Control: {
                if (this.getPlayer().equals(targetUnit.getPlayer())) {
                    return false;
                }
                if (targetType != UnitType.Protoss_Interceptor && targetType != UnitType.Terran_Vulture_Spider_Mine && targetType != UnitType.Zerg_Lurker_Egg && targetType != UnitType.Zerg_Cocoon && targetType != UnitType.Zerg_Larva && targetType != UnitType.Zerg_Egg) break;
                return false;
            }
            case Feedback: {
                if (targetType.isSpellcaster()) break;
                return false;
            }
            case Infestation: {
                if (targetType == UnitType.Terran_Command_Center && targetUnit.getHitPoints() < 750 && targetUnit.getHitPoints() > 0) break;
                return false;
            }
        }
        switch (tech) {
            case Archon_Warp: 
            case Dark_Archon_Meld: {
                if (!this.hasPath(targetUnit.getPosition())) {
                    return false;
                }
                if (targetUnit.isHallucination()) {
                    return false;
                }
                if (targetUnit.isMaelstrommed()) {
                    return false;
                }
            }
            case Consume: 
            case Spawn_Broodlings: 
            case Lockdown: 
            case Healing: 
            case Mind_Control: 
            case Feedback: 
            case Parasite: 
            case Irradiate: 
            case Optical_Flare: 
            case Defensive_Matrix: 
            case Hallucination: 
            case Restoration: 
            case Yamato_Gun: {
                if (!targetUnit.isStasised()) break;
                return false;
            }
        }
        switch (tech) {
            case Yamato_Gun: {
                if (!targetUnit.isInvincible()) break;
                return false;
            }
            case Spawn_Broodlings: 
            case Lockdown: 
            case Healing: 
            case Mind_Control: 
            case Parasite: 
            case Irradiate: 
            case Optical_Flare: 
            case Defensive_Matrix: 
            case Hallucination: 
            case Restoration: {
                if (targetUnit.isInvincible()) {
                    return false;
                }
            }
            case Consume: 
            case Feedback: {
                if (!targetType.isBuilding()) break;
                return false;
            }
        }
        return targetUnit != this;
    }

    public boolean canUseTechPosition(TechType tech, boolean checkCanIssueCommandType) {
        return this.canUseTechPosition(tech, checkCanIssueCommandType, true);
    }

    public boolean canUseTechPosition(TechType tech) {
        return this.canUseTechPosition(tech, true);
    }

    public boolean canUseTechPosition(TechType tech, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        if (!this.canUseTechWithOrWithoutTarget(tech, false, false)) {
            return false;
        }
        return tech.targetsPosition();
    }

    public boolean canUseTechPosition(TechType tech, Position target, boolean checkTargetsPositions, boolean checkCanIssueCommandType) {
        return this.canUseTechPosition(tech, target, checkTargetsPositions, checkCanIssueCommandType, true);
    }

    public boolean canUseTechPosition(TechType tech, Position target, boolean checkTargetsPositions) {
        return this.canUseTechPosition(tech, target, checkTargetsPositions, true);
    }

    public boolean canUseTechPosition(TechType tech, Position target) {
        return this.canUseTechPosition(tech, target, true);
    }

    public boolean canUseTechPosition(TechType tech, Position target, boolean checkTargetsPositions, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canUseTechWithOrWithoutTarget(false)) {
            return false;
        }
        if (checkTargetsPositions && !this.canUseTechPosition(tech, false, false)) {
            return false;
        }
        return tech != TechType.Spider_Mines || this.hasPath(target);
    }

    public boolean canPlaceCOP() {
        return this.canPlaceCOP(true);
    }

    public boolean canPlaceCOP(boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (!this.getType().isFlagBeacon()) {
            return false;
        }
        return this.unitData.getButtonset() != 228 && this.getOrder() == Order.CTFCOPInit;
    }

    public boolean canPlaceCOP(TilePosition target, boolean checkCanIssueCommandType) {
        return this.canPlaceCOP(target, checkCanIssueCommandType, true);
    }

    public boolean canPlaceCOP(TilePosition target) {
        return this.canPlaceCOP(target, true);
    }

    public boolean canPlaceCOP(TilePosition target, boolean checkCanIssueCommandType, boolean checkCommandibility) {
        if (checkCommandibility && !this.canCommand()) {
            return false;
        }
        if (checkCanIssueCommandType && !this.canPlaceCOP(checkCommandibility)) {
            return false;
        }
        return this.game.canBuildHere(target, this.getType(), this, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unit unit = (Unit)o;
        return this.id == unit.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Unit other) {
        return this.id - other.id;
    }

    void updatePosition(int frame) {
        if (frame > this.lastPositionUpdate) {
            this.lastPositionUpdate = frame;
            this.position = new Position(this.unitData.getPositionX(), this.unitData.getPositionY());
        }
    }
}

