/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Point;
import bwapi.Position;
import bwapi.WalkPosition;

public final class TilePosition
extends Point<TilePosition> {
    public static final int SIZE_IN_PIXELS = 32;
    public static final TilePosition Invalid = new TilePosition(1000, 1000);
    public static final TilePosition None = new TilePosition(1000, 1001);
    public static final TilePosition Unknown = new TilePosition(1000, 1002);
    public static final TilePosition Origin = new TilePosition(0, 0);

    public TilePosition(int x, int y) {
        super(x, y, 32);
    }

    public TilePosition(Position p) {
        this(p.x / 32, p.y / 32);
    }

    public TilePosition(WalkPosition wp) {
        this(wp.x / 4, wp.y / 4);
    }

    public TilePosition(TilePosition tp) {
        this(tp.x, tp.y);
    }

    TilePosition(ClientData.Position position) {
        this(position.getX(), position.getY());
    }

    public Position toPosition() {
        return new Position(this);
    }

    public WalkPosition toWalkPosition() {
        return new WalkPosition(this);
    }

    @Override
    public TilePosition subtract(TilePosition other) {
        return new TilePosition(this.x - other.x, this.y - other.y);
    }

    @Override
    public TilePosition add(TilePosition other) {
        return new TilePosition(this.x + other.x, this.y + other.y);
    }

    @Override
    public TilePosition divide(int divisor) {
        return new TilePosition(this.x / divisor, this.y / divisor);
    }

    @Override
    public TilePosition multiply(int multiplier) {
        return new TilePosition(this.x * multiplier, this.y * multiplier);
    }
}

