/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClientConfiguration;
import bwapi.BWEventListener;
import bwapi.ClientData;
import bwapi.EventHandler;
import bwapi.EventType;
import bwapi.FrameBuffer;
import bwapi.Game;
import bwapi.PerformanceMetrics;
import bwapi.WrappedBuffer;
import java.util.concurrent.locks.ReentrantLock;

class BotWrapper {
    private final ClientData liveClientData = new ClientData();
    private final BWClientConfiguration configuration;
    private final BWEventListener eventListener;
    private final FrameBuffer frameBuffer;
    private WrappedBuffer liveData;
    private Game botGame;
    private Thread botThread;
    private boolean gameOver;
    private PerformanceMetrics performanceMetrics;
    private Throwable lastBotThrow;
    private ReentrantLock lastBotThrowLock = new ReentrantLock();
    private ReentrantLock unsafeReadReadyLock = new ReentrantLock();
    private boolean unsafeReadReady = false;

    BotWrapper(BWClientConfiguration configuration, BWEventListener eventListener) {
        this.configuration = configuration;
        this.eventListener = eventListener;
        this.frameBuffer = configuration.getAsync() ? new FrameBuffer(configuration) : null;
    }

    void startNewGame(WrappedBuffer liveData, PerformanceMetrics performanceMetrics) {
        if (this.configuration.getAsync()) {
            this.frameBuffer.initialize(liveData, performanceMetrics);
        }
        this.performanceMetrics = performanceMetrics;
        this.botGame = new Game();
        this.botGame.setConfiguration(this.configuration);
        this.botGame.botClientData().setBuffer(liveData);
        this.liveClientData.setBuffer(liveData);
        this.liveData = liveData;
        this.botThread = null;
        this.gameOver = false;
    }

    Game getGame() {
        return this.botGame;
    }

    private boolean isUnsafeReadReady() {
        this.unsafeReadReadyLock.lock();
        try {
            boolean bl = this.unsafeReadReady;
            return bl;
        }
        finally {
            this.unsafeReadReadyLock.unlock();
        }
    }

    private void setUnsafeReadReady(boolean value) {
        this.unsafeReadReadyLock.lock();
        try {
            this.unsafeReadReady = value;
        }
        finally {
            this.unsafeReadReadyLock.unlock();
        }
        this.frameBuffer.lockSize.lock();
        try {
            this.frameBuffer.conditionSize.signalAll();
        }
        finally {
            this.frameBuffer.lockSize.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFrame() {
        if (this.configuration.getAsync()) {
            this.configuration.log("Main: onFrame asynchronous start");
            long startNanos = System.nanoTime();
            long endNanos = startNanos + (long)this.configuration.getMaxFrameDurationMs() * 1000000L;
            if (this.botThread == null) {
                this.configuration.log("Main: Starting bot thread");
                this.botThread = this.createBotThread();
                this.botThread.setName("JBWAPI Bot");
                this.botThread.setPriority(3);
                this.botThread.start();
            }
            if (this.configuration.getAsyncUnsafe()) {
                this.frameBuffer.lockSize.lock();
                try {
                    if (this.frameBuffer.empty()) {
                        this.configuration.log("Main: Putting bot on live data");
                        this.botGame.botClientData().setBuffer(this.liveData);
                        this.setUnsafeReadReady(true);
                    } else {
                        this.setUnsafeReadReady(false);
                    }
                }
                finally {
                    this.frameBuffer.lockSize.unlock();
                }
            }
            int frame = this.liveClientData.gameData().getFrameCount();
            this.configuration.log("Main: Enqueuing frame #" + frame);
            this.frameBuffer.enqueueFrame();
            this.configuration.log("Main: Enqueued frame #" + frame);
            if (frame > 0) {
                this.performanceMetrics.getClientIdle().startTiming();
            }
            this.frameBuffer.lockSize.lock();
            try {
                while (!this.frameBuffer.empty()) {
                    Throwable lastThrow;
                    if (this.configuration.getAsyncUnsafe() && this.frameBuffer.size() == 1) {
                        this.configuration.log("Main: Weaning bot off live data");
                        this.botGame.botClientData().setBuffer(this.frameBuffer.peek());
                    }
                    if ((lastThrow = this.getLastBotThrow()) != null) {
                        this.configuration.log("Main: Rethrowing bot throwable");
                        throw new RuntimeException(lastThrow);
                    }
                    if (this.configuration.getUnlimitedFrameZero() && frame == 0) {
                        this.configuration.log("Main: Waiting indefinitely on frame #" + frame);
                        this.frameBuffer.conditionSize.await();
                        continue;
                    }
                    long remainingNanos = endNanos - System.nanoTime();
                    if (remainingNanos <= 0L) {
                        this.configuration.log("Main: Out of time in frame #" + frame);
                    }
                    this.configuration.log("Main: Waiting " + remainingNanos / 1000000L + "ms for bot on frame #" + frame);
                    this.frameBuffer.conditionSize.awaitNanos(remainingNanos);
                    long excessNanos = Math.max(0L, (System.nanoTime() - endNanos) / 1000000L);
                    this.performanceMetrics.getExcessSleep().record(excessNanos);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.frameBuffer.lockSize.unlock();
                this.performanceMetrics.getClientIdle().stopTiming();
                this.configuration.log("Main: onFrame asynchronous end");
            }
        } else {
            this.configuration.log("Main: onFrame synchronous start");
            this.handleEvents();
            this.configuration.log("Main: onFrame synchronous end");
        }
    }

    void endGame() {
        if (this.botThread != null) {
            try {
                this.botThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    Throwable getLastBotThrow() {
        this.lastBotThrowLock.lock();
        Throwable output = this.lastBotThrow;
        this.lastBotThrowLock.unlock();
        return output;
    }

    private Thread createBotThread() {
        return new Thread(() -> {
            try {
                this.configuration.log("Bot: Thread started");
                while (!this.gameOver) {
                    boolean doUnsafeRead = false;
                    this.configuration.log("Bot: Ready for another frame");
                    this.performanceMetrics.getBotIdle().startTiming();
                    this.frameBuffer.lockSize.lock();
                    try {
                        doUnsafeRead = this.isUnsafeReadReady();
                        while (!doUnsafeRead && this.frameBuffer.empty()) {
                            this.configuration.log("Bot: Waiting for a frame");
                            this.frameBuffer.conditionSize.awaitUninterruptibly();
                            doUnsafeRead = this.isUnsafeReadReady();
                        }
                    }
                    finally {
                        this.frameBuffer.lockSize.unlock();
                    }
                    this.performanceMetrics.getBotIdle().stopTiming();
                    if (doUnsafeRead) {
                        this.configuration.log("Bot: Reading live frame");
                        this.setUnsafeReadReady(false);
                    } else {
                        this.configuration.log("Bot: Peeking next frame from buffer");
                        this.botGame.botClientData().setBuffer(this.frameBuffer.peek());
                    }
                    this.configuration.log("Bot: Handling events on frame #" + this.botGame.getFrameCount());
                    this.handleEvents();
                    this.configuration.log("Bot: Events handled. Dequeuing frame #" + this.botGame.getFrameCount());
                    this.frameBuffer.dequeue();
                }
            }
            catch (Throwable throwable) {
                this.lastBotThrowLock.lock();
                this.lastBotThrow = throwable;
                this.lastBotThrowLock.unlock();
                while (!this.frameBuffer.empty()) {
                    this.frameBuffer.dequeue();
                }
            }
        });
    }

    private void handleEvents() {
        ClientData.GameData botGameData = this.botGame.botClientData().gameData();
        for (int i = 0; i < botGameData.getEventCount(); ++i) {
            this.gameOver = this.gameOver || botGameData.getEvents(i).getType() == EventType.MatchEnd;
        }
        if (this.configuration.getAsync()) {
            this.performanceMetrics.getFramesBehind().record(Math.max(1, this.frameBuffer.framesBuffered()) - 1);
        }
        this.performanceMetrics.getBotResponse().timeIf(!this.gameOver && (botGameData.getFrameCount() > 0 || !this.configuration.getUnlimitedFrameZero()), () -> {
            for (int i = 0; i < botGameData.getEventCount(); ++i) {
                EventHandler.operation(this.eventListener, this.botGame, botGameData.getEvents(i));
            }
        });
    }
}

