/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import info.BaseData;
import info.GameState;
import info.UnitTypeCount;
import info.map.BuildingPlanner;
import info.map.GroundPath;
import info.map.MapTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import learning.OpponentRecord;
import learning.Record;
import strategy.buildorder.BuildOrder;

public class Debug {
    private static int BASE_MINERAL_DISTANCE = 300;
    private BWEM bwem;
    private Game game;
    private BuildOrder opener;
    private OpponentRecord opponentRecord;
    private GameState gameState;

    public Debug(BWEM bwem, Game game, BuildOrder opener, OpponentRecord opponentRecord, GameState gameState) {
        this.bwem = bwem;
        this.game = game;
        this.opener = opener;
        this.opponentRecord = opponentRecord;
        this.gameState = gameState;
    }

    public void onFrame() {
        this.drawBases();
        this.game.drawTextScreen(4, 8, "Opponent: " + this.opponentRecord.getName() + " " + this.getOpponentRecord(), new Text[0]);
        this.game.drawTextScreen(4, 16, "GameMap: " + this.game.mapFileName(), new Text[0]);
        this.game.drawTextScreen(4, 24, "Opener: " + this.opener.getName() + " " + this.getOpenerRecord(), Text.White);
        this.game.drawTextScreen(4, 32, "BuildOrder: " + this.gameState.getActiveBuildOrder().getName() + " " + this.getBuildOrderRecord(), Text.White);
        this.game.drawTextScreen(4, 40, "Frame: " + this.game.getFrameCount(), new Text[0]);
        this.drawUnitCount();
        this.debugBuildingPlanner();
        this.debugStaticDefenseCoverage();
    }

    private void drawBases() {
        BaseData baseData = this.gameState.getBaseData();
        for (Base b : baseData.getMyBases()) {
            this.game.drawBoxMap(b.getLocation().toPosition(), b.getLocation().toPosition().add(new Position(127, 95)), Color.Blue);
        }
        for (Base b : baseData.availableBases()) {
            this.game.drawBoxMap(b.getLocation().toPosition(), b.getLocation().toPosition().add(new Position(127, 95)), Color.White);
            this.game.drawTextMap(b.getLocation().toPosition(), String.format("(%d, %d)", b.getLocation().x, b.getLocation().y), Text.White);
        }
        for (Base b : baseData.getEnemyBases()) {
            this.game.drawBoxMap(b.getLocation().toPosition(), b.getLocation().toPosition().add(new Position(127, 95)), Color.Red);
        }
    }

    private void drawUnitCount() {
        int x = 4;
        int y = 128;
        this.game.drawTextScreen(x, y, "Unit Count", new Text[0]);
        UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
        for (Map.Entry<UnitType, Integer> entry : unitTypeCount.getCountLookup().entrySet()) {
            this.game.drawTextScreen(x, y += 8, String.valueOf(entry.getKey().toString()) + ": " + entry.getValue().toString(), new Text[0]);
        }
    }

    private String getOpenerRecord() {
        Record openerRecord = this.opponentRecord.getOpenerRecord().get(this.opener.getName());
        return String.format("%s_%s", openerRecord.getWins(), openerRecord.getLosses());
    }

    private String getOpponentRecord() {
        return String.format("%s_%s", this.opponentRecord.getWins(), this.opponentRecord.getLosses());
    }

    private String getBuildOrderRecord() {
        String openerName;
        String activeName = this.gameState.getActiveBuildOrder().getName();
        if (activeName.equals(openerName = this.opener.getName())) {
            Map<String, Record> openerMap = this.opponentRecord.getOpenerRecord();
            Record rec = openerMap != null ? openerMap.get(activeName) : null;
            return rec != null ? String.format("%s_%s", rec.getWins(), rec.getLosses()) : "0_0";
        }
        Map<String, Record> boMap = this.opponentRecord.getBuildOrderRecord();
        Record rec = boMap != null ? boMap.get(activeName) : null;
        return rec != null ? String.format("%s_%s", rec.getWins(), rec.getLosses()) : "0_0";
    }

    private void drawAllBasePaths() {
        HashMap<Base, GroundPath> pathMap = this.gameState.getBaseData().getBasePaths();
        for (GroundPath path : pathMap.values()) {
            this.drawPath(path.getPath());
        }
    }

    private void drawPath(List<MapTile> tiles) {
        for (MapTile tile : tiles) {
            TilePosition tp = tile.getTile();
            this.game.drawBoxMap(tp.toPosition(), tp.add(new TilePosition(1, 1)).toPosition(), Color.Yellow);
        }
    }

    private void debugGameMap() {
        for (MapTile mapTile : this.gameState.getGameMap().getHeatMap()) {
            if (!mapTile.isBuildable()) continue;
            this.game.drawBoxMap(mapTile.getTile().toPosition(), mapTile.getTile().add(new TilePosition(1, 1)).toPosition(), Color.White);
        }
    }

    private void debugStaticDefenseCoverage() {
        for (Position p : this.gameState.getStaticDefenseCoverage()) {
            this.game.drawCircleMap(p, 1, Color.Red);
        }
    }

    private void debugBuildingPlanner() {
        BuildingPlanner buildingPlanner = this.gameState.getBuildingPlanner();
        BaseData baseData = this.gameState.getBaseData();
        if (buildingPlanner == null) {
            return;
        }
        for (Base base : baseData.getMyBases()) {
        }
    }
}

