#include "Overgrid.h"

#include "UABAssert.h"

using namespace UAlbertaBot;

// -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
// Test objects.

// The test draws the grid with a checkerboard pattern of circles.
// Cells at the right and bottom edges may overlap and be cut off, but it's
// still possible to eyeball whether they are correct.
// To run a test, insert this code where it will be executed once per frame:

// static OvergridTest ot;
// ot.update();

OvergridTest::OvergridTest()
	: g(7)
{
	for (int x = 0; x < g.width(); ++x)
	{
		for (int y = 0; y < g.height(); ++y)
		{
			TestCell * c = new TestCell;
			c->color = ((x % 2) ^ (y % 2)) ? BWAPI::Colors::Orange : BWAPI::Colors::Green;
			g.set(x, y, c);
		}
	}
}

void OvergridTest::update()
{
	for (int x = 0; x < g.width(); ++x)
	{
		for (int y = 0; y < g.height(); ++y)
		{
			TestCell * c = g.get(x, y);
			BWAPI::Position pos = TileCenter(g.fromXY(x, y));
			BWAPI::Broodwar->drawCircleMap(BWAPI::Position(pos), (g.size() * 32)/2, c->color, false);
			BWAPI::Broodwar->drawTextMap(BWAPI::Position(pos) + BWAPI::Position(-10, 0), "%d %d", x, y);
		}
	}
}