/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClientConfiguration;
import bwapi.PerformanceMetrics;
import bwapi.UnsafeTools;
import bwapi.WrappedBuffer;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

class FrameBuffer {
    private static final int BUFFER_SIZE = 33017048;
    private static final Unsafe unsafe = UnsafeTools.getUnsafe();
    private WrappedBuffer liveData;
    private PerformanceMetrics performanceMetrics;
    private BWClientConfiguration configuration;
    private int capacity;
    private int stepGame = 0;
    private int stepBot = 0;
    private ArrayList<WrappedBuffer> dataBuffer = new ArrayList();
    private final Lock lockWrite = new ReentrantLock();
    final Lock lockSize = new ReentrantLock();
    final Condition conditionSize = this.lockSize.newCondition();

    FrameBuffer(BWClientConfiguration configuration) {
        this.capacity = configuration.getAsyncFrameBufferCapacity();
        this.configuration = configuration;
        while (this.dataBuffer.size() < this.capacity) {
            this.dataBuffer.add(new WrappedBuffer(33017048));
        }
    }

    void initialize(WrappedBuffer liveData, PerformanceMetrics performanceMetrics) {
        this.liveData = liveData;
        this.performanceMetrics = performanceMetrics;
        this.stepGame = 0;
        this.stepBot = 0;
    }

    synchronized int framesBuffered() {
        return this.stepGame - this.stepBot;
    }

    int size() {
        this.lockSize.lock();
        try {
            int n = this.framesBuffered();
            return n;
        }
        finally {
            this.lockSize.unlock();
        }
    }

    boolean empty() {
        return this.size() <= 0;
    }

    boolean full() {
        this.lockSize.lock();
        try {
            boolean bl = this.framesBuffered() >= this.capacity;
            return bl;
        }
        finally {
            this.lockSize.unlock();
        }
    }

    private int indexGame() {
        return this.stepGame % this.capacity;
    }

    private int indexBot() {
        return this.stepBot % this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueFrame() {
        this.lockWrite.lock();
        try {
            this.lockSize.lock();
            try {
                while (this.full()) {
                    this.configuration.log("Main: Waiting for frame buffer capacity");
                    this.performanceMetrics.getIntentionallyBlocking().startTiming();
                    this.conditionSize.awaitUninterruptibly();
                }
                this.performanceMetrics.getIntentionallyBlocking().stopTiming();
            }
            finally {
                this.lockSize.unlock();
            }
            if (this.stepGame == 0) {
                for (WrappedBuffer frameBuffer : this.dataBuffer) {
                    this.copyBuffer(this.liveData, frameBuffer, true);
                }
            } else {
                this.performanceMetrics.getCopyingToBuffer().time(() -> {
                    WrappedBuffer dataTarget = this.dataBuffer.get(this.indexGame());
                    this.copyBuffer(this.liveData, dataTarget, false);
                });
            }
            this.lockSize.lock();
            try {
                this.performanceMetrics.getFrameBufferSize().record(this.framesBuffered());
                ++this.stepGame;
                this.conditionSize.signalAll();
            }
            finally {
                this.lockSize.unlock();
            }
        }
        finally {
            this.lockWrite.unlock();
        }
    }

    WrappedBuffer peek() {
        this.lockSize.lock();
        try {
            while (this.empty()) {
                this.conditionSize.awaitUninterruptibly();
            }
            WrappedBuffer wrappedBuffer = this.dataBuffer.get(this.indexBot());
            return wrappedBuffer;
        }
        finally {
            this.lockSize.unlock();
        }
    }

    void dequeue() {
        this.lockSize.lock();
        try {
            while (this.empty()) {
                this.conditionSize.awaitUninterruptibly();
            }
            ++this.stepBot;
            this.conditionSize.signalAll();
        }
        finally {
            this.lockSize.unlock();
        }
    }

    private void copyBuffer(WrappedBuffer source, WrappedBuffer destination, long offset, int size) {
        long addressSource = source.getAddress() + offset;
        long addressDestination = destination.getAddress() + offset;
        unsafe.copyMemory(addressSource, addressDestination, size);
    }

    void copyBuffer(WrappedBuffer source, WrappedBuffer destination, boolean copyEverything) {
        if (copyEverything) {
            this.copyBuffer(source, destination, 0L, 33017048);
        } else {
            int STATICTILES_START = 3447004;
            int STATICTILES_END = 4823260;
            int REGION_START = 5085404;
            int REGION_END = 10586480;
            int STRINGSSHAPES_START = 10962632;
            int STRINGSHAPES_END = 32242636;
            int UNITFINDER_START = 32962644;
            this.copyBuffer(source, destination, 0L, 3447004);
            this.copyBuffer(source, destination, 4823260L, 262144);
            this.copyBuffer(source, destination, 10586480L, 376152);
            this.copyBuffer(source, destination, 32242636L, 720008);
        }
    }
}

