/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Game;
import bwapi.Region;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;

class BuildingPlacer {
    private static final int MAX_RANGE = 64;
    private static final TilePosition[] gDirections = new TilePosition[]{new TilePosition(1, 1), new TilePosition(0, 1), new TilePosition(-1, 1), new TilePosition(1, 0), new TilePosition(-1, 0), new TilePosition(1, -1), new TilePosition(0, -1), new TilePosition(-1, -1)};
    private static final BuildTemplate[] buildTemplates = new BuildTemplate[]{new BuildTemplate(32, 0, 0, 1), new BuildTemplate(0, 32, 1, 0), new BuildTemplate(31, 0, 0, 1), new BuildTemplate(0, 31, 1, 0), new BuildTemplate(33, 0, 0, 1), new BuildTemplate(0, 33, 1, 0), new BuildTemplate(30, 0, 0, 1), new BuildTemplate(29, 0, 0, 1), new BuildTemplate(0, 30, 1, 0), new BuildTemplate(28, 0, 0, 1), new BuildTemplate(0, 29, 1, 0), new BuildTemplate(27, 0, 0, 1), new BuildTemplate(0, 28, 1, 0), new BuildTemplate(-1, 0, 0, 0)};

    BuildingPlacer() {
    }

    static TilePosition getBuildLocation(UnitType type, TilePosition desiredPosition1, int maxRange, boolean creep, Game game) {
        if (!type.isBuilding()) {
            return TilePosition.Invalid;
        }
        TilePosition desiredPosition = desiredPosition1;
        boolean trimPlacement = true;
        Region pTargRegion = null;
        switch (type) {
            case Protoss_Pylon: {
                Unit pSpecialUnitTarget = game.getClosestUnit(desiredPosition.toPosition(), u -> u.getPlayer().equals(game.self()) && !u.isPowered());
                if (pSpecialUnitTarget == null) break;
                desiredPosition = pSpecialUnitTarget.getPosition().toTilePosition();
                trimPlacement = false;
                break;
            }
            case Terran_Command_Center: 
            case Protoss_Nexus: 
            case Zerg_Hatchery: 
            case Special_Start_Location: {
                trimPlacement = false;
                break;
            }
        }
        PlacementReserve reserve = new PlacementReserve(maxRange);
        BuildingPlacer.ReservePlacement(reserve, type, desiredPosition, game);
        if (trimPlacement) {
            BuildingPlacer.reserveTemplateSpacing(reserve);
        }
        TilePosition centerPosition = desiredPosition.subtract(new TilePosition(64, 64).divide(2));
        if (pTargRegion != null) {
            desiredPosition = pTargRegion.getCenter().toTilePosition();
        }
        int bestDistance = 999999;
        int fallbackDistance = 999999;
        TilePosition bestPosition = TilePosition.None;
        TilePosition fallbackPosition = TilePosition.None;
        for (int passCount = 0; passCount < (pTargRegion != null ? 2 : 1); ++passCount) {
            for (int y = 0; y < 64; ++y) {
                for (int x = 0; x < 64; ++x) {
                    TilePosition currentPosition;
                    int currentDistance;
                    if (reserve.getValue(x, y) == 0 || (currentDistance = desiredPosition.getApproxDistance(currentPosition = new TilePosition(x, y).add(centerPosition))) >= bestDistance) continue;
                    if (currentDistance <= maxRange) {
                        bestDistance = currentDistance;
                        bestPosition = currentPosition;
                        continue;
                    }
                    if (currentDistance >= fallbackDistance) continue;
                    fallbackDistance = currentDistance;
                    fallbackPosition = currentPosition;
                }
            }
            if (!bestPosition.equals(TilePosition.None)) break;
            if (!fallbackPosition.equals(TilePosition.None)) {
                bestPosition = fallbackPosition;
                break;
            }
            if (pTargRegion == null) continue;
            desiredPosition = centerPosition;
        }
        return bestPosition;
    }

    private static void ReservePlacement(PlacementReserve reserve, UnitType type, TilePosition desiredPosition, Game game) {
        reserve.reset();
        BuildingPlacer.AssignBuildableLocations(reserve, type, desiredPosition, game);
        BuildingPlacer.RemoveDisconnected(reserve, desiredPosition, game);
        TilePosition start = desiredPosition.subtract(new TilePosition(64, 64).divide(2));
        reserve.iterate((pr, x, y) -> {
            if (!start.add(new TilePosition(x, y)).isValid(game)) {
                pr.setValue(x, y, (byte)0);
            }
        });
        if (!reserve.hasValidSpace()) {
            return;
        }
        BuildingPlacer.ReserveGroundHeight(reserve, desiredPosition, game);
        if (!type.isResourceDepot()) {
            BuildingPlacer.ReserveAllStructures(reserve, type, desiredPosition, game);
            BuildingPlacer.ReserveExistingAddonPlacement(reserve, desiredPosition, game);
        }
        switch (type) {
            case Protoss_Pylon: {
                break;
            }
            case Terran_Bunker: {
                break;
            }
            case Terran_Missile_Turret: 
            case Protoss_Photon_Cannon: {
                break;
            }
            case Zerg_Creep_Colony: {
                break;
            }
            default: {
                if (type.isResourceDepot()) break;
                BuildingPlacer.ReserveDefault(reserve, type, desiredPosition, game);
            }
        }
    }

    private static void AssignBuildableLocations(PlacementReserve reserve, UnitType type, TilePosition desiredPosition, Game game) {
        TilePosition start = desiredPosition.subtract(new TilePosition(64, 64).divide(2));
        boolean hasAddon = type.canBuildAddon();
        reserve.iterate((pr, x, y) -> {
            if ((!hasAddon || game.canBuildHere(start.add(new TilePosition(x + 4, y + 1)), UnitType.Terran_Missile_Turret)) && game.canBuildHere(start.add(new TilePosition(x, y)), type)) {
                pr.setValue(x, y, (byte)1);
            }
        });
    }

    private static void RemoveDisconnected(PlacementReserve reserve, TilePosition desiredPosition, Game game) {
        TilePosition start = desiredPosition.subtract(new TilePosition(64, 64).divide(2));
        reserve.iterate((pr, x, y) -> {
            if (!game.hasPath(desiredPosition.toPosition(), start.add(new TilePosition(x, y)).toPosition())) {
                pr.setValue(x, y, (byte)0);
            }
        });
    }

    private static void ReserveGroundHeight(PlacementReserve reserve, TilePosition desiredPosition, Game game) {
        TilePosition start = desiredPosition.subtract(new TilePosition(64, 64).divide(2));
        reserve.backup();
        int targetHeight = game.getGroundHeight(desiredPosition);
        reserve.iterate((pr, x, y) -> {
            if (game.getGroundHeight(start.add(new TilePosition(x, y))) != targetHeight) {
                pr.setValue(x, y, (byte)0);
            }
        });
        reserve.restoreIfInvalid();
    }

    private static void ReserveAllStructures(PlacementReserve reserve, UnitType type, TilePosition desiredPosition, Game game) {
        if (type.isAddon()) {
            return;
        }
        reserve.backup();
        game.self().getUnits().stream().filter(u -> {
            UnitType ut = u.getType();
            return u.exists() && (u.isCompleted() || ut.producesLarva() && u.isMorphing()) && ut.isBuilding() && (ut.isResourceDepot() || ut.isRefinery());
        }).forEach(u -> BuildingPlacer.ReserveStructure(reserve, u, 2, type, desiredPosition));
        if (type != UnitType.Terran_Bunker) {
            game.getNeutralUnits().stream().filter(u -> u.exists() && u.getType().isResourceContainer()).forEach(u -> BuildingPlacer.ReserveStructure(reserve, u, 2, type, desiredPosition));
        }
        reserve.restoreIfInvalid();
    }

    private static void ReserveExistingAddonPlacement(PlacementReserve reserve, TilePosition desiredPosition, Game game) {
        TilePosition start = desiredPosition.subtract(new TilePosition(64, 64)).divide(2);
        reserve.backup();
        game.self().getUnits().stream().filter(u -> u.exists() && u.getType().canBuildAddon()).forEach(u -> {
            TilePosition addonPos = u.getTilePosition().add(new TilePosition(4, 1)).subtract(start);
            reserve.setRange(addonPos, addonPos.add(new TilePosition(2, 2)), (byte)0);
        });
        reserve.restoreIfInvalid();
    }

    private static void ReserveDefault(PlacementReserve reserve, UnitType type, TilePosition desiredPosition, Game game) {
        reserve.backup();
        PlacementReserve original = reserve;
        block6: for (Unit it : game.self().getUnits()) {
            if (!it.exists()) continue;
            switch (it.getType()) {
                case Zerg_Creep_Colony: 
                case Terran_Bunker: 
                case Terran_Missile_Turret: 
                case Protoss_Photon_Cannon: 
                case Terran_Factory: 
                case Protoss_Robotics_Facility: 
                case Protoss_Gateway: 
                case Terran_Barracks: {
                    BuildingPlacer.ReserveStructure(reserve, it, 1, type, desiredPosition);
                    continue block6;
                }
            }
            BuildingPlacer.ReserveStructure(reserve, it, 2, type, desiredPosition);
        }
        switch (type) {
            case Terran_Bunker: 
            case Terran_Missile_Turret: 
            case Protoss_Photon_Cannon: 
            case Terran_Factory: 
            case Protoss_Robotics_Facility: 
            case Protoss_Gateway: 
            case Terran_Barracks: {
                for (int y = 0; y < 64; ++y) {
                    for (int x = 0; x < 64; ++x) {
                        for (int dir = 0; dir < 8; ++dir) {
                            TilePosition p = new TilePosition(x, y).add(gDirections[dir]);
                            if (PlacementReserve.isValidPos(p) && original.getValue(p) != 0) continue;
                            reserve.setValue(p, (byte)0);
                        }
                    }
                }
                break;
            }
        }
        reserve.restoreIfInvalid();
    }

    private static void reserveTemplateSpacing(PlacementReserve reserve) {
        reserve.backup();
        int j = 0;
        while (BuildingPlacer.buildTemplates[j].startX != -1) {
            BuildTemplate t = buildTemplates[j];
            int x = t.startX;
            int y = t.startY;
            for (int i = 0; i < 64; ++i) {
                reserve.setValue(x, y, (byte)0);
                x += t.stepX;
                y += t.stepY;
            }
            ++j;
        }
        reserve.restoreIfInvalid();
    }

    private static void ReserveStructure(PlacementReserve reserve, Unit pUnit, int padding, UnitType type, TilePosition desiredPosition) {
        BuildingPlacer.ReserveStructureWithPadding(reserve, pUnit.getPosition().toTilePosition(), pUnit.getType().tileSize(), padding, type, desiredPosition);
    }

    private static void ReserveStructureWithPadding(PlacementReserve reserve, TilePosition currentPosition, TilePosition sizeExtra, int padding, UnitType type, TilePosition desiredPosition) {
        TilePosition paddingSize = sizeExtra.add(new TilePosition(padding, padding).multiply(2));
        TilePosition topLeft = currentPosition.subtract(type.tileSize()).subtract(paddingSize.divide(2)).subtract(new TilePosition(1, 1));
        TilePosition topLeftRelative = topLeft.subtract(desiredPosition).add(new TilePosition(64, 64).divide(2));
        TilePosition maxSize = topLeftRelative.add(type.tileSize()).add(paddingSize).add(new TilePosition(1, 1));
        reserve.setRange(topLeftRelative, maxSize, (byte)0);
    }

    static class PlacementReserve {
        final int maxSearch;
        byte[][] data;
        byte[][] save;

        PlacementReserve(int maxRange) {
            this.maxSearch = Math.min(Math.max(0, maxRange), 64);
            this.reset();
            this.backup();
        }

        static boolean isValidPos(int x, int y) {
            return x >= 0 && x < 64 && y >= 0 && y < 64;
        }

        static boolean isValidPos(TilePosition p) {
            return PlacementReserve.isValidPos(p.x, p.y);
        }

        void reset() {
            this.data = new byte[64][64];
            this.save = new byte[64][64];
        }

        void setValue(int x, int y, byte value) {
            if (PlacementReserve.isValidPos(x, y)) {
                this.data[y][x] = value;
            }
        }

        void setValue(TilePosition p, byte value) {
            this.setValue(p.x, p.y, value);
        }

        void setRange(int left, int top, int right, int bottom, byte value) {
            for (int y = top; y < bottom; ++y) {
                for (int x = left; x < right; ++x) {
                    this.setValue(x, y, value);
                }
            }
        }

        void setRange(TilePosition lt, TilePosition rb, byte value) {
            this.setRange(lt.x, lt.y, rb.x, rb.y, value);
        }

        byte getValue(int x, int y) {
            if (PlacementReserve.isValidPos(x, y)) {
                return this.data[y][x];
            }
            return 0;
        }

        byte getValue(TilePosition p) {
            return this.getValue(p.x, p.y);
        }

        void iterate(PlacementReserveExec proc) {
            int min = 32 - this.maxSearch / 2;
            int max = min + this.maxSearch;
            for (int y = min; y < max; ++y) {
                for (int x = min; x < max; ++x) {
                    proc.operation(this, x, y);
                }
            }
        }

        boolean hasValidSpace() {
            int min = 32 - this.maxSearch / 2;
            int max = min + this.maxSearch;
            for (int y = min; y < max; ++y) {
                for (int x = min; x < max; ++x) {
                    if (this.getValue(x, y) != 1) continue;
                    return true;
                }
            }
            return false;
        }

        void backup() {
            for (int i = 0; i < 64; ++i) {
                System.arraycopy(this.data[i], 0, this.save[i], 0, 64);
            }
        }

        void restore() {
            for (int i = 0; i < 64; ++i) {
                System.arraycopy(this.save[i], 0, this.data[i], 0, 64);
            }
        }

        void restoreIfInvalid() {
            if (!this.hasValidSpace()) {
                this.restore();
            }
        }
    }

    private static class BuildTemplate {
        final int startX;
        final int startY;
        final int stepX;
        final int stepY;

        BuildTemplate(int startX, int startY, int stepX, int stepY) {
            this.startX = startX;
            this.startY = startY;
            this.stepX = stepX;
            this.stepY = stepY;
        }
    }

    static interface PlacementReserveExec {
        public void operation(PlacementReserve var1, int var2, int var3);
    }
}

