/*
 * Decompiled with CFR 0.152.
 */
package Strategery.History;

import Lifecycle.With$;
import Strategery.History.HistoricalGame;
import bwapi.Race;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HistorySerializer$ {
    public static HistorySerializer$ MODULE$;
    private final int formatVersion;
    private final String separator;

    static {
        new HistorySerializer$();
    }

    public int formatVersion() {
        return this.formatVersion;
    }

    public String separator() {
        return this.separator;
    }

    public Vector<HistoricalGame> readGames(Iterable<String> serializedHistory) {
        return ((TraversableOnce)serializedHistory.flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)serializedGame -> Option$.MODULE$.option2Iterable(MODULE$.readGame((String)serializedGame)), Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    private Option<HistoricalGame> readGame(String serializedGame) {
        try {
            return new Some<HistoricalGame>(this.readGameFromColumns(serializedGame.replaceAll(",,,", ",").split(this.separator())));
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder(28).append("Failed to deserialize game: ").append(serializedGame).toString());
            With$.MODULE$.logger().onException(exception);
            return None$.MODULE$;
        }
    }

    private HistoricalGame readGameFromColumns(String[] columns) {
        long id = new StringOps(Predef$.MODULE$.augmentString(columns[0])).toLong();
        int startLocations = new StringOps(Predef$.MODULE$.augmentString(columns[1])).toInt();
        String mapName = columns[2];
        String opponentName = columns[3];
        String ourRace = columns[4];
        String enemyRace = columns[5];
        boolean won = new StringOps(Predef$.MODULE$.augmentString(columns[6])).toBoolean();
        String[] strategies = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])columns)).drop(7))).distinct();
        Race[] allRaces = (Race[])((Object[])new Race[]{Race.Terran, Race.Protoss, Race.Zerg, Race.Random, Race.None, Race.Unknown});
        return new HistoricalGame(id, startLocations, mapName, opponentName, (Race)((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allRaces)).find((Function1<Object, Object>)(Function1<Race, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(HistorySerializer$.$anonfun$readGameFromColumns$1(ourRace, x$1))).getOrElse((Function0<Race> & Serializable & scala.Serializable)() -> Race.Unknown)), (Race)((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allRaces)).find((Function1<Object, Object>)(Function1<Race, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(HistorySerializer$.$anonfun$readGameFromColumns$3(enemyRace, x$2))).getOrElse((Function0<Race> & Serializable & scala.Serializable)() -> Race.Unknown)), won, Predef$.MODULE$.wrapRefArray((Object[])strategies));
    }

    public Iterable<String> writeGames(Iterable<HistoricalGame> games) {
        return ((TraversableLike)games.toVector().sortBy((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(HistorySerializer$.$anonfun$writeGames$1(x$3)), (Ordering)Ordering$Long$.MODULE$)).map((Function1<HistoricalGame, String> & Serializable & scala.Serializable)game -> MODULE$.writeGame((HistoricalGame)game), Vector$.MODULE$.canBuildFrom());
    }

    private String writeGame(HistoricalGame game) {
        return new $colon$colon<Nothing$>((Nothing$)((Object)Long.toString(game.timestamp())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Integer.toString(game.startLocations())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)game.mapName().toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)game.enemyName().toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)game.ourRace().toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)game.enemyRace().toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Boolean.toString(game.won())), Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce<Nothing$>)game.tags(), List$.MODULE$.canBuildFrom()).mkString(this.separator());
    }

    public static final /* synthetic */ boolean $anonfun$readGameFromColumns$1(String ourRace$1, Race x$1) {
        String string = x$1.toString();
        return !(string != null ? !string.equals(ourRace$1) : ourRace$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$readGameFromColumns$3(String enemyRace$1, Race x$2) {
        String string = x$2.toString();
        return !(string != null ? !string.equals(enemyRace$1) : enemyRace$1 != null);
    }

    public static final /* synthetic */ long $anonfun$writeGames$1(HistoricalGame x$3) {
        return -x$3.timestamp();
    }

    private HistorySerializer$() {
        MODULE$ = this;
        this.formatVersion = 4;
        this.separator = ",";
    }
}

