/*
 * Decompiled with CFR 0.152.
 */
package Information.Battles.Types;

import Debugging.Visualizations.Colors$;
import Information.Battles.Types.Battle;
import Information.Battles.Types.JudgmentModifier;
import Information.Battles.Types.JudgmentModifier$;
import Information.Geography.Types.Base;
import Information.Geography.Types.Edge;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import Micro.Actions.Basic.Gather$;
import ProxyBwapi.Players.PlayerInfo;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitInfo.CombatUnit;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Tactic.Squads.Squad;
import Utilities.$qmark$;
import Utilities.Time.Minutes;
import Utilities.Time.Seconds;
import Utilities.UnitFilters.IsAny;
import Utilities.UnitFilters.IsTank$;
import Utilities.UnitFilters.IsWorker$;
import Utilities.UnitFilters.UnitFilter;
import bwapi.Color;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.collection.Iterable;
import scala.collection.IterableView$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric$DoubleIsFractional$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyDouble;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;

public final class JudgmentModifiers$ {
    public static JudgmentModifiers$ MODULE$;
    private final IsAny catcher;

    static {
        new JudgmentModifiers$();
    }

    public Seq<JudgmentModifier> apply(Battle battle) {
        ArrayBuffer<JudgmentModifier> output = new ArrayBuffer<JudgmentModifier>();
        JudgmentModifiers$.add$1("Proximity", Colors$.MODULE$.NeonRed(), this.proximity(battle), output);
        JudgmentModifiers$.add$1("Gatherers", Colors$.MODULE$.MediumBlue(), this.gatherers(battle), output);
        JudgmentModifiers$.add$1("HiddenTanks", Colors$.MODULE$.MediumIndigo(), this.hiddenTanks(battle), output);
        JudgmentModifiers$.add$1("Choke", Colors$.MODULE$.MediumOrange(), this.choke(battle), output);
        JudgmentModifiers$.add$1("Caught", Colors$.MODULE$.BrightGreen(), this.caught(battle), output);
        JudgmentModifiers$.add$1("Hysteresis", Colors$.MODULE$.MediumViolet(), this.hysteresis(battle), output);
        return output;
    }

    private Option<JudgmentModifier> modifyTarget(double value) {
        String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
        double x$4 = JudgmentModifier$.MODULE$.apply$default$3();
        return new Some<JudgmentModifier>(new JudgmentModifier(x$2, x$3, x$4, value));
    }

    private Option<JudgmentModifier> multiplySpeed(double value) {
        String x$2 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$3 = JudgmentModifier$.MODULE$.apply$default$2();
        double x$4 = JudgmentModifier$.MODULE$.apply$default$4();
        return new Some<JudgmentModifier>(new JudgmentModifier(x$2, x$3, value, x$4));
    }

    private double value(Iterable<UnitInfo> units) {
        return BoxesRunTime.unboxToDouble(((TraversableOnce)units.view().map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble(x$1.subjectiveValue()), IterableView$.MODULE$.canBuildFrom())).sum(Numeric$DoubleIsFractional$.MODULE$));
    }

    private double value(Iterable<UnitInfo> units, Function1<UnitInfo, Object> test) {
        return this.value((Iterable)units.view().filter(test));
    }

    private double valueRatio(Iterable<UnitInfo> units, Function1<UnitInfo, Object> test) {
        return this.value(units, test) / Math.max(1.0, this.value(units));
    }

    public Option<JudgmentModifier> proximity(Battle battle) {
        double enemyRange = battle.enemy().meanAttackerRange();
        double deltaMin = -0.4 * Maff$.MODULE$.clamp((double)With$.MODULE$.frame() / (double)new Minutes(10).apply(), 0.5, 1.0);
        double deltaMax = 0.05;
        double proximityMult = With$.MODULE$.scouting().proximity(battle.enemy().attackCentroidGround()) * (double)2 - 1.0;
        double rangeMult = Maff$.MODULE$.clamp(enemyRange / 192.0, 0.0, 2.0);
        double targetDeltaRaw = -0.3 * proximityMult * rangeMult;
        double targetDelta = Maff$.MODULE$.clamp(targetDeltaRaw, deltaMin, deltaMax);
        return this.modifyTarget(targetDelta);
    }

    public Option<JudgmentModifier> gatherers(Battle battle) {
        int workersImperiled = battle.us().units().count((Function1<UnitInfo, Object> & Serializable & scala.Serializable)ally -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$gatherers$1(ally)));
        int workersTotal = With$.MODULE$.units().countOurs(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsWorker$.MODULE$}));
        double workersRatio = Maff$.MODULE$.nanToZero((double)workersImperiled / (double)workersTotal);
        return this.modifyTarget(-workersRatio / 2.0);
    }

    public Option<JudgmentModifier> hiddenTanks(Battle battle) {
        if (With$.MODULE$.enemies().forall((Function1<PlayerInfo, Object> & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hiddenTanks$1(e)))) {
            return None$.MODULE$;
        }
        int tanks = battle.enemy().units().count((Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hiddenTanks$2(u)));
        if (tanks == 0) {
            return None$.MODULE$;
        }
        double valueUs = this.value(battle.us().attackers());
        double valueUsGround = this.value(battle.us().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hiddenTanks$4(x$5)));
        double ratioUsGround = Maff$.MODULE$.nanToZero(valueUsGround / valueUs);
        double score = Maff$.MODULE$.clamp(ratioUsGround * (double)tanks * 0.1, 0.0, 0.4);
        return this.multiplySpeed(1.0 - score);
    }

    public Option<JudgmentModifier> choke(Battle battle) {
        Pixel pixelUs = battle.us().attackCentroidGround();
        Pixel pixelFoe = battle.enemy().vanguardGround().apply();
        Option<Edge> edge = battle.choke();
        if (edge.isEmpty()) {
            return None$.MODULE$;
        }
        if (pixelFoe.zone().bases().exists((Function1<Base, Object>)((Function1<Object, Object> & Serializable & scala.Serializable)arg_0 -> JudgmentModifiers$.$anonfun$choke$1$adapted(With$.MODULE$.geography().ourBasesAndSettlements(), arg_0)))) {
            return None$.MODULE$;
        }
        if (pixelFoe.pixelDistance(edge.get().pixelCenter()) + edge.get().radiusPixels() < battle.us().maxRangeGround()) {
            return None$.MODULE$;
        }
        double badness = edge.get().badness(battle.us(), pixelUs.zone());
        if (badness <= 1.0) {
            return None$.MODULE$;
        }
        double speedMultiplier = battle.us().combatGroundFraction() * Maff$.MODULE$.nanToOne(1.0 / badness);
        double targetDelta = battle.us().combatGroundFraction() * Maff$.MODULE$.clamp((badness - 1.0) * 0.0175, 0.0, 0.3);
        String x$3 = JudgmentModifier$.MODULE$.apply$default$1();
        Color x$4 = JudgmentModifier$.MODULE$.apply$default$2();
        return new Some<JudgmentModifier>(new JudgmentModifier(x$3, x$4, speedMultiplier, targetDelta));
    }

    public Option<JudgmentModifier> tankLock(Battle battle) {
        if (!With$.MODULE$.enemies().exists((Function1<PlayerInfo, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.isTerran()))) {
            return None$.MODULE$;
        }
        if (!battle.enemy().units().exists(Terran$.MODULE$.SiegeTankSieged())) {
            return None$.MODULE$;
        }
        double inTankRangeRatio = this.valueRatio(battle.us().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$tankLock$2(x$7)));
        double tankInRangeRatio = this.valueRatio(battle.us().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$tankLock$3(x$8)));
        double inRankRangeScore = inTankRangeRatio * 1.0 / 3.0;
        double tankInRangeScore = tankInRangeRatio * (double)2 / 3.0;
        double score = -0.5 * (inRankRangeScore + tankInRangeScore);
        return this.modifyTarget(score);
    }

    private IsAny catcher() {
        return this.catcher;
    }

    public Option<JudgmentModifier> caught(Battle battle) {
        if (!battle.us().attackers().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$caught$1(x$9)))) {
            return None$.MODULE$;
        }
        double catcherRatio = this.valueRatio(battle.enemy().attackers(), this.catcher());
        double caughtRatio = this.valueRatio(battle.us().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$caught$2(u)));
        double score = -0.5 * Math.max(0.0, (1.0 - battle.us().vanguardGround().apply().proximity()) * Math.sqrt(Maff$.MODULE$.nanToZero(catcherRatio * caughtRatio)));
        return this.modifyTarget(score);
    }

    private double commitmentFloor(double value) {
        if (value > 0.0) {
            return Math.max(0.25, value);
        }
        return value;
    }

    public Option<JudgmentModifier> hysteresisOld(Battle battle) {
        LazyDouble groundRatio$lzy = new LazyDouble();
        LazyDouble invisibleRatio$lzy = new LazyDouble();
        LazyDouble siegeRatio$lzy = new LazyDouble();
        LazyDouble hesitanceVisibility$lzy = new LazyDouble();
        LazyDouble hesitanceTanks$lzy = new LazyDouble();
        double commitmentRaw = Maff$.MODULE$.weightedMean(battle.us().attackers().map((Function1<UnitInfo, Tuple2> & Serializable & scala.Serializable)u -> new Tuple2$mcDD$sp(Maff$.MODULE$.clamp01(MODULE$.commitmentFloor(((double)8 + u.matchups().pixelsEntangled()) / 96.0)), u.subjectiveValue()), Seq$.MODULE$.canBuildFrom()));
        double commitment = this.commitmentFloor(commitmentRaw);
        return this.modifyTarget(BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(commitment > 0.0, (JFunction0$mcD$sp & scala.Serializable)() -> -commitment * 0.2, (JFunction0$mcD$sp & scala.Serializable)() -> this.hesitanceVisibility$1(hesitanceVisibility$lzy, invisibleRatio$lzy, battle) + this.hesitanceTanks$1(hesitanceTanks$lzy, siegeRatio$lzy, battle, groundRatio$lzy))));
    }

    public Option<JudgmentModifier> hysteresis(Battle battle) {
        return this.modifyTarget(Maff$.MODULE$.weightedMean(battle.us().attackers().flatMap((Function1<UnitInfo, Iterable> & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(x$13.friendly().map((Function1<FriendlyUnitInfo, Tuple2> & Serializable & scala.Serializable)unit -> MODULE$.hysteresis((FriendlyUnitInfo)unit))), Seq$.MODULE$.canBuildFrom())));
    }

    public Tuple2<Object, Object> hysteresis(FriendlyUnitInfo unit) {
        double amount = 0.0;
        boolean fighting = unit.matchups().engagedUpon() || unit.matchups().engagingOn();
        double speed = Math.max(unit.topSpeed(), 0.1);
        double entanglement = Maff$.MODULE$.clamp01(unit.matchups().pixelsEntangled() / speed / Math.min(unit.matchups().framesToLive(), (double)new Seconds(5).apply()));
        int recentEngage = Math.max(0, 1 - unit.hysteresis().decisionFrames() / new Seconds(10).apply());
        int incomingShot = Maff$.MODULE$.fromBoolean(unit.damageQueue().view().exists((Function1<CombatUnit.DamageSource, Object> & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean(x$14.committed())));
        int paidPrice = Math.max(0, 1 - incomingShot * Math.max(0, With$.MODULE$.framesSince(unit.lastFrameTakingDamage()) / new Seconds(5).apply()));
        int stickiness = recentEngage * paidPrice;
        int staticThreat = Maff$.MODULE$.fromBoolean(unit.matchups().threatDeepest().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hysteresis$4(t))));
        double obscurity = BoxesRunTime.unboxToDouble(unit.presumptiveTarget().map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)target -> BoxesRunTime.boxToDouble(JudgmentModifiers$.$anonfun$hysteresis$5(target))).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> 0.0));
        Object pace = unit.squad().map((Function1<Squad, Object> & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble(x$15.pace01())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0);
        double patience = 1.0 - Maff$.MODULE$.clamp01((double)unit.hysteresis().bloodlustFrames() / (double)new Seconds(15).apply());
        double displacement = Math.max(0.0, Maff$.MODULE$.clamp01(Math.abs(BoxesRunTime.unboxToDouble(unit.matchups().pixelsToTargetRange().flatMap((Function1<Object, Option> & Serializable & scala.Serializable)distance -> JudgmentModifiers$.$anonfun$hysteresis$9(unit, BoxesRunTime.unboxToDouble(distance))).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> 0.0))) / speed / (double)new Seconds(15).apply()) - 0.333);
        double tankLock = Maff$.MODULE$.or0(Maff$.MODULE$.or0(0.333, unit.matchups().inTankRange()) + Maff$.MODULE$.or0(0.666, unit.matchups().inRangeOfTank()), With$.MODULE$.enemies().exists((Function1<PlayerInfo, Object> & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean(x$17.isTerran())));
        if (fighting) {
            amount -= 0.25 * entanglement;
            amount -= 0.15 * (double)stickiness;
            amount -= 0.25 * tankLock;
        } else {
            amount += 0.1 * (double)staticThreat;
            amount += 0.03 * obscurity;
            amount += 0.1 * patience;
            amount += 0.1 * displacement;
        }
        if (With$.MODULE$.frame() < 0) {
            Boolean arg$macro$1 = BoxesRunTime.boxToBoolean(fighting);
            Double arg$macro$2 = BoxesRunTime.boxToDouble(speed);
            Double arg$macro$3 = BoxesRunTime.boxToDouble(entanglement);
            Integer arg$macro$4 = BoxesRunTime.boxToInteger(stickiness);
            Integer arg$macro$5 = BoxesRunTime.boxToInteger(staticThreat);
            Double arg$macro$6 = BoxesRunTime.boxToDouble(obscurity);
            Double arg$macro$8 = BoxesRunTime.boxToDouble(patience);
            Double arg$macro$9 = BoxesRunTime.boxToDouble(displacement);
            Double arg$macro$10 = BoxesRunTime.boxToDouble(tankLock);
            With$.MODULE$.logger().debug(new StringOps("%s %s %s %s %s %s %s %s %s %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, arg$macro$5, arg$macro$6, pace, arg$macro$8, arg$macro$9, arg$macro$10})));
        }
        return new Tuple2$mcDD$sp(amount, unit.subjectiveValue() * (double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(fighting, (JFunction0$mcI$sp & scala.Serializable)() -> 2, (JFunction0$mcI$sp & scala.Serializable)() -> 1)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(JudgmentModifier m) {
        return !Double.isNaN(m.targetDelta()) && !Double.isNaN(m.speedMultiplier()) && (Math.abs(m.targetDelta()) > 1.0E-4 || Math.abs(m.speedMultiplier() - 1.0) > 1.0E-4);
    }

    private static final void add$1(String name, Color color, Option modifier, ArrayBuffer output$1) {
        modifier.filter((Function1<JudgmentModifier, Object> & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$apply$1(m))).foreach((Function1<JudgmentModifier, ArrayBuffer> & Serializable & scala.Serializable)m -> {
            m.name_$eq(name);
            m.color_$eq(color);
            return output$1.$plus$eq(m);
        });
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$4(Base x$3) {
        return x$3.owner().isUs();
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$5(UnitInfo g$1, UnitInfo ally$1, UnitInfo t) {
        return t.pixelDistanceEdge(g$1) - t.pixelRangeAgainst(ally$1) <= (double)Gather$.MODULE$.defenseRadiusPixels();
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$3(UnitInfo ally$1, UnitInfo g) {
        return g.base().exists((Function1<Base, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$gatherers$4(x$3))) && g.pixelDistanceEdge(ally$1) <= (double)Gather$.MODULE$.defenseRadiusPixels() && ally$1.matchups().threats().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$gatherers$5(g, ally$1, t)));
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$2(UnitInfo ally$1, FriendlyUnitInfo x$2) {
        return x$2.agent().toGather().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$gatherers$3(ally$1, g)));
    }

    public static final /* synthetic */ boolean $anonfun$gatherers$1(UnitInfo ally) {
        return ally.unitClass().isWorker() && ally.visibleToOpponents() && ally.friendly().exists((Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$gatherers$2(ally, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$1(PlayerInfo e) {
        return !e.isTerran() || !e.hasTech(Terran$.MODULE$.SiegeMode());
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$3(Base x$4) {
        return x$4.owner().isEnemy();
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$2(UnitInfo u) {
        return IsTank$.MODULE$.apply(u) && u.base().exists((Function1<Base, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hiddenTanks$3(x$4))) && !u.visible();
    }

    public static final /* synthetic */ boolean $anonfun$hiddenTanks$4(UnitInfo x$5) {
        return !x$5.flying();
    }

    public static final /* synthetic */ boolean $anonfun$tankLock$2(UnitInfo x$7) {
        return x$7.matchups().inTankRange();
    }

    public static final /* synthetic */ boolean $anonfun$tankLock$3(UnitInfo x$8) {
        return x$8.matchups().targetsInRange().exists(Terran$.MODULE$.SiegeTankSieged());
    }

    public static final /* synthetic */ boolean $anonfun$caught$1(UnitInfo x$9) {
        return x$9.matchups().engagedUpon();
    }

    public static final /* synthetic */ boolean $anonfun$caught$3(UnitInfo u$1, UnitInfo t) {
        return MODULE$.catcher().apply(t) && t.pixelsToGetInRange(u$1) < (double)160 && t.topSpeed() > 1.05 * u$1.topSpeed();
    }

    public static final /* synthetic */ boolean $anonfun$caught$2(UnitInfo u) {
        return !u.flying() && u.matchups().threatDeepest().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$caught$3(u, t)));
    }

    public static final /* synthetic */ boolean $anonfun$hysteresisOld$2(UnitInfo x$10) {
        return !x$10.flying();
    }

    private final /* synthetic */ double groundRatio$lzycompute$1(LazyDouble groundRatio$lzy$1, Battle battle$1) {
        synchronized (groundRatio$lzy$1) {
            double d = groundRatio$lzy$1.initialized() ? groundRatio$lzy$1.value() : groundRatio$lzy$1.initialize(this.valueRatio(battle$1.us().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hysteresisOld$2(x$10))));
            return d;
        }
    }

    private final double groundRatio$1(LazyDouble groundRatio$lzy$1, Battle battle$1) {
        if (groundRatio$lzy$1.initialized()) {
            return groundRatio$lzy$1.value();
        }
        return this.groundRatio$lzycompute$1(groundRatio$lzy$1, battle$1);
    }

    public static final /* synthetic */ boolean $anonfun$hysteresisOld$3(UnitInfo x$11) {
        return !x$11.visible();
    }

    private final /* synthetic */ double invisibleRatio$lzycompute$1(LazyDouble invisibleRatio$lzy$1, Battle battle$1) {
        synchronized (invisibleRatio$lzy$1) {
            double d = invisibleRatio$lzy$1.initialized() ? invisibleRatio$lzy$1.value() : invisibleRatio$lzy$1.initialize(this.valueRatio(battle$1.enemy().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hysteresisOld$3(x$11))));
            return d;
        }
    }

    private final double invisibleRatio$1(LazyDouble invisibleRatio$lzy$1, Battle battle$1) {
        if (invisibleRatio$lzy$1.initialized()) {
            return invisibleRatio$lzy$1.value();
        }
        return this.invisibleRatio$lzycompute$1(invisibleRatio$lzy$1, battle$1);
    }

    public static final /* synthetic */ boolean $anonfun$hysteresisOld$6(UnitInfo t) {
        return Terran$.MODULE$.SiegeTankSieged().apply(t) || t.canSiege() && With$.MODULE$.framesSince(t.lastSeen()) > 24;
    }

    private static final /* synthetic */ double siegeRatio$lzycompute$1(LazyDouble siegeRatio$lzy$1, Battle battle$1) {
        synchronized (siegeRatio$lzy$1) {
            double d = siegeRatio$lzy$1.initialized() ? siegeRatio$lzy$1.value() : siegeRatio$lzy$1.initialize(BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(With$.MODULE$.enemies().exists((Function1<PlayerInfo, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.isTerran())), (JFunction0$mcD$sp & scala.Serializable)() -> MODULE$.valueRatio(battle$1.enemy().attackers(), (Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(JudgmentModifiers$.$anonfun$hysteresisOld$6(t))), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0)));
            return d;
        }
    }

    private static final double siegeRatio$1(LazyDouble siegeRatio$lzy$1, Battle battle$1) {
        if (siegeRatio$lzy$1.initialized()) {
            return siegeRatio$lzy$1.value();
        }
        return JudgmentModifiers$.siegeRatio$lzycompute$1(siegeRatio$lzy$1, battle$1);
    }

    private final /* synthetic */ double hesitanceVisibility$lzycompute$1(LazyDouble hesitanceVisibility$lzy$1, LazyDouble invisibleRatio$lzy$1, Battle battle$1) {
        synchronized (hesitanceVisibility$lzy$1) {
            double d = hesitanceVisibility$lzy$1.initialized() ? hesitanceVisibility$lzy$1.value() : hesitanceVisibility$lzy$1.initialize(0.08 * this.invisibleRatio$1(invisibleRatio$lzy$1, battle$1));
            return d;
        }
    }

    private final double hesitanceVisibility$1(LazyDouble hesitanceVisibility$lzy$1, LazyDouble invisibleRatio$lzy$1, Battle battle$1) {
        if (hesitanceVisibility$lzy$1.initialized()) {
            return hesitanceVisibility$lzy$1.value();
        }
        return this.hesitanceVisibility$lzycompute$1(hesitanceVisibility$lzy$1, invisibleRatio$lzy$1, battle$1);
    }

    private final /* synthetic */ double hesitanceTanks$lzycompute$1(LazyDouble hesitanceTanks$lzy$1, LazyDouble siegeRatio$lzy$1, Battle battle$1, LazyDouble groundRatio$lzy$1) {
        synchronized (hesitanceTanks$lzy$1) {
            double d = hesitanceTanks$lzy$1.initialized() ? hesitanceTanks$lzy$1.value() : hesitanceTanks$lzy$1.initialize(0.12 * JudgmentModifiers$.siegeRatio$1(siegeRatio$lzy$1, battle$1) * this.groundRatio$1(groundRatio$lzy$1, battle$1));
            return d;
        }
    }

    private final double hesitanceTanks$1(LazyDouble hesitanceTanks$lzy$1, LazyDouble siegeRatio$lzy$1, Battle battle$1, LazyDouble groundRatio$lzy$1) {
        if (hesitanceTanks$lzy$1.initialized()) {
            return hesitanceTanks$lzy$1.value();
        }
        return this.hesitanceTanks$lzycompute$1(hesitanceTanks$lzy$1, siegeRatio$lzy$1, battle$1, groundRatio$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$hysteresis$4(UnitInfo t) {
        return t.unitClass().isBuilding() || Terran$.MODULE$.SiegeTankSieged().apply(t) || t.canSiege() && With$.MODULE$.framesSince(t.lastSeen()) > 24;
    }

    public static final /* synthetic */ double $anonfun$hysteresis$5(UnitInfo target) {
        return Math.min(1.0, (double)With$.MODULE$.framesSince(target.lastSeen()) / (double)new Seconds(60).apply());
    }

    public static final /* synthetic */ double $anonfun$hysteresis$10(double distance$1, Squad x$16) {
        return x$16.meanAttackerTargetDistance() - distance$1;
    }

    public static final /* synthetic */ Option $anonfun$hysteresis$9(FriendlyUnitInfo unit$1, double distance) {
        return unit$1.squad().map((Function1<Squad, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble(JudgmentModifiers$.$anonfun$hysteresis$10(distance, x$16)));
    }

    private JudgmentModifiers$() {
        MODULE$ = this;
        this.catcher = new IsAny(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Zerg$.MODULE$.Zergling(), Terran$.MODULE$.Vulture(), Zerg$.MODULE$.Mutalisk()}));
    }

    public static final /* synthetic */ Object $anonfun$choke$1$adapted(Vector eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.contains(elem));
    }
}

