/*
 * Decompiled with CFR 0.152.
 */
package Debugging.Visualizations.Rendering;

import Debugging.Asciify$;
import Debugging.Visualizations.Colors$;
import Debugging.Visualizations.Viewport;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Tile;
import Mathematics.Points.TileRectangle;
import bwapi.Color;
import bwapi.Text;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Vector;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class DrawMap$ {
    public static DrawMap$ MODULE$;

    static {
        new DrawMap$();
    }

    public void text(Pixel origin, Function0<String> text) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{origin}))) {
            return;
        }
        With$.MODULE$.game().drawTextMap(origin.bwapi(), Asciify$.MODULE$.apply(text.apply()), new Text[0]);
    }

    public void line(Pixel start, Pixel end, Color color) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end}))) {
            return;
        }
        With$.MODULE$.game().drawLineMap(start.bwapi(), end.bwapi(), color);
    }

    public void line(int startX, int startY, int endX, int endY, Color color) {
        this.line(new Pixel(startX, startY), new Pixel(endX, endY), color);
    }

    public Color line$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void arrow(Pixel start, Pixel end, Color color) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end}))) {
            return;
        }
        this.line(start, end, color);
        double angleBack = end.radiansTo(start);
        double angleDiff = 0.39269908169872414;
        this.triangle(end, end.radiateRadians(angleBack + angleDiff, 7.0), end.radiateRadians(angleBack - angleDiff, 7.0), color, true);
    }

    public Color arrow$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void cross(Pixel at, int radius, Color color) {
        this.line(at.add(-radius, -radius), at.add(radius, radius), color);
        this.line(at.add(radius, -radius), at.add(-radius, radius), color);
    }

    public Color cross$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void tile(Tile tile, int margin, Color color) {
        this.box(tile.topLeftPixel().add(margin, margin), tile.bottomRightPixel().subtract(margin, margin), color, this.box$default$4());
    }

    public int tile$default$2() {
        return 0;
    }

    public Color tile$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void box(Pixel start, Pixel end, Color color, boolean solid) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{start, end}))) {
            return;
        }
        With$.MODULE$.game().drawBoxMap(start.bwapi(), end.bwapi(), color, solid);
    }

    public Color box$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean box$default$4() {
        return false;
    }

    public void circle(Pixel center, int radius, Color color, boolean solid) {
        if (radius <= 0) {
            return;
        }
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{center.add(-radius, -radius), center.add(radius, radius)}))) {
            return;
        }
        With$.MODULE$.game().drawCircleMap(center.bwapi(), radius, color, solid);
    }

    public Color circle$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean circle$default$4() {
        return false;
    }

    public void triangle(Pixel position1, Pixel position2, Pixel position3, Color color, boolean solid) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{position1, position2, position3}))) {
            return;
        }
        With$.MODULE$.game().drawTriangleMap(position1.bwapi(), position2.bwapi(), position3.bwapi(), color, solid);
    }

    public Color triangle$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean triangle$default$5() {
        return false;
    }

    public void label(Function0<String> text, Pixel position, boolean drawBackground, Color backgroundColor, boolean drawBorder, Color borderColor) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{position}))) {
            return;
        }
        this.labelBox((Function0<TraversableOnce<String>>)(Function0<Vector> & Serializable & scala.Serializable)() -> (Vector)package$.MODULE$.Vector().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)text.apply()})), position, drawBackground, backgroundColor, drawBorder, borderColor);
    }

    public boolean label$default$3() {
        return false;
    }

    public Color label$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean label$default$5() {
        return false;
    }

    public Color label$default$6() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void labelDot(Function0<String> text, Pixel position, Color backgroundColor) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{position}))) {
            return;
        }
        int width = 9 * text.apply().length() / 2;
        int height = 11;
        int radius = 1 + Math.max(width, height) / 2;
        this.circle(position, radius, backgroundColor, true);
        With$.MODULE$.game().drawTextMap(position.x() - width / 2, position.y() - height / 2, Asciify$.MODULE$.apply(text.apply()), new Text[0]);
    }

    public Color labelDot$default$3() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void labelBox(Function0<TraversableOnce<String>> textLines, Pixel position, boolean drawBackground, Color backgroundColor, boolean drawBorder, Color borderColor) {
        int estimatedTextWidth;
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{position}))) {
            return;
        }
        int horizontalMargin = 2;
        int boxWidth = estimatedTextWidth + ((estimatedTextWidth = 9 * BoxesRunTime.unboxToInt(TraversableOnce$.MODULE$.MonadOps(textLines.apply()).map((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.length())).max(Ordering$Int$.MODULE$)) / 2) > 0 ? 2 * horizontalMargin : 0);
        int boxHeight = 11 * textLines.apply().size();
        int textX = position.x() - boxWidth / 2;
        int textY = position.y() - boxHeight / 2;
        int boxX = textX - horizontalMargin;
        if (drawBackground) {
            With$.MODULE$.game().drawBoxMap(boxX, textY, boxX + boxWidth, textY + boxHeight, backgroundColor, true);
        }
        if (drawBorder) {
            With$.MODULE$.game().drawBoxMap(boxX - 1, textY - 1, boxX + boxWidth + 1, textY + boxHeight + 1, borderColor, false);
        }
        With$.MODULE$.game().drawTextMap(textX, textY, TraversableOnce$.MODULE$.MonadOps(textLines.apply()).map((Function1<String, String> & Serializable & scala.Serializable)v -> Asciify$.MODULE$.apply((String)v)).mkString("\n"), new Text[0]);
    }

    public boolean labelBox$default$3() {
        return false;
    }

    public Color labelBox$default$4() {
        return Colors$.MODULE$.DefaultGray();
    }

    public boolean labelBox$default$5() {
        return false;
    }

    public Color labelBox$default$6() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void tileRectangle(TileRectangle rectangle, Color color, int margin) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{rectangle.startPixel(), rectangle.endPixelInclusive()}))) {
            return;
        }
        With$.MODULE$.game().drawBoxMap(rectangle.startPixel().subtract(margin, margin).bwapi(), rectangle.endPixelInclusive().add(margin, margin).bwapi(), color);
    }

    public int tileRectangle$default$3() {
        return 0;
    }

    public void polygon(Iterable<Pixel> pixels, Color color) {
        if (pixels.size() < 2) {
            return;
        }
        pixels.reduce((Function2<Pixel, Pixel, Pixel> & Serializable & scala.Serializable)(p1, p2) -> {
            MODULE$.line((Pixel)p1, (Pixel)p2, color);
            return p2;
        });
        this.line((Pixel)pixels.head(), (Pixel)pixels.last(), color);
    }

    public Color polygon$default$2() {
        return Colors$.MODULE$.DefaultGray();
    }

    public void drawSkull(Pixel pixel, Color colorDark, Color colorBright, int f) {
        this.circle(pixel, 5 * f, colorBright, true);
        this.circle(pixel, 5 * f, colorDark, false);
        this.box(pixel.add(-3 * f, 0), pixel.add(1 + 3 * f, 6 * f), colorBright, true);
        this.box(pixel.add(-3 * f, 0), pixel.add(1 + 3 * f, 6 * f), colorDark, false);
        this.box(pixel.add(-3 * f, 0), pixel.add(1 + 3 * f, 3 * f), colorBright, true);
        if (f == 1) {
            this.box(pixel.add(-2 * f, -2 * f), pixel.add(0, 0), Color.Black, true);
            this.box(pixel.add(1 * f, -2 * f), pixel.add(3 * f, 0), Color.Black, true);
        } else {
            this.circle(pixel.add(-2 * f, -1 * f), f, Color.Black, true);
            this.circle(pixel.add(2 * f, -1 * f), f, Color.Black, true);
        }
        this.triangle(pixel.add(0, 1 * f), pixel.add(-f, 2 * f), pixel.add(f, 2 * f), Color.Black, true);
        this.line(pixel.add(-1 * f, 4 * f), pixel.add(-1 * f, 6 * f - 1), colorDark);
        this.line(pixel.add(1 * f, 4 * f), pixel.add(1 * f, 6 * f - 1), colorDark);
    }

    public Color drawSkull$default$2() {
        return Colors$.MODULE$.DarkGray();
    }

    public Color drawSkull$default$3() {
        return Colors$.MODULE$.BrightGray();
    }

    public int drawSkull$default$4() {
        return 1;
    }

    public void star(Pixel pixel, int radius, Color color, boolean solid) {
        int a = Math.max(4, radius);
        int b = Math.max(2, a / 2);
        int c = Math.max(1, b / 2);
        this.triangle(pixel.add(-a, -c), pixel.add(a, -c), pixel.add(0, c), color, solid);
        this.triangle(pixel.add(0, -a), pixel.add(0, c), pixel.add(-b, b + 1), color, solid);
        this.triangle(pixel.add(0, -a), pixel.add(0, c), pixel.add(b, b + 1), color, solid);
    }

    public boolean star$default$4() {
        return true;
    }

    public void crosshair(Pixel pixel, int radius, Color color) {
        this.circle(pixel, radius, color, this.circle$default$4());
        int r3 = radius * 3 / 2;
        int r1 = radius / 2;
        this.box(pixel.add(-1, -r3), pixel.add(1, -r1), color, this.box$default$4());
        this.box(pixel.add(-1, r1), pixel.add(1, r3), color, this.box$default$4());
        this.box(pixel.add(-r3, -1), pixel.add(-r1, 1), color, this.box$default$4());
        this.box(pixel.add(r1, -1), pixel.add(r3, 1), color, this.box$default$4());
    }

    public void hatchTile(Tile tile, Color color) {
        if (this.irrelevant(Predef$.MODULE$.wrapRefArray((Object[])new Pixel[]{tile.center()}))) {
            return;
        }
        Pixel s = tile.topLeftPixel();
        Pixel e = tile.bottomRightPixel();
        int sx = s.x();
        int sy = s.y();
        int ex = e.x();
        int ey = e.y();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 32).by(8).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)d -> {
            MODULE$.line(sx + d, sy, ex, ey - d, color);
            MODULE$.line(ex - d, sy, sx, ey - d, color);
            MODULE$.line(sx + d, ey, ex, sy + d, color);
            MODULE$.line(ex - d, ey, sx, sy + d, color);
        });
    }

    public boolean irrelevant(Seq<Pixel> points) {
        int x$22;
        Pixel x$1;
        Viewport qual$1;
        return !points.exists((Function1<Pixel, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(DrawMap$.$anonfun$irrelevant$1(x$2))) && !(qual$1 = With$.MODULE$.viewport()).contains(x$1 = Maff$.MODULE$.centroid(points), x$22 = qual$1.contains$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$irrelevant$1(Pixel x$2) {
        return With$.MODULE$.viewport().contains(x$2, 0);
    }

    private DrawMap$() {
        MODULE$ = this;
    }
}

