/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.GameInstance;
import bwapi.GameTable;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

class Client {
    private static final int READ_WRITE = 7;
    private static final int SUPPORTED_BWAPI_VERSION = 10003;
    static final int MAX_COUNT = 19999;
    static final int MAX_STRING_SIZE = 1024;
    private ClientData clientData;
    private ClientData.GameData gameData;
    private boolean connected = false;
    private RandomAccessFile pipeObjectHandle = null;
    private ByteBuffer mapFileHandle = null;
    private ByteBuffer gameTableFileHandle = null;
    private boolean debugConnection = false;

    Client(boolean debugConnection) {
        this.debugConnection = debugConnection;
    }

    Client(ByteBuffer buffer) {
        ClientData clientData = this.clientData = new ClientData(buffer);
        clientData.getClass();
        this.gameData = new ClientData.GameData(clientData, 0);
    }

    ClientData clientData() {
        return this.clientData;
    }

    ClientData.GameData gameData() {
        return this.gameData;
    }

    boolean isConnected() {
        return this.connected;
    }

    void reconnect() {
        while (!this.connect()) {
            this.sleep(1000);
        }
    }

    void disconnect() {
        if (this.debugConnection) {
            System.err.print("Disconnect called by: ");
            System.err.println(Thread.currentThread().getStackTrace()[2]);
        }
        if (!this.connected) {
            return;
        }
        if (this.pipeObjectHandle != null) {
            try {
                this.pipeObjectHandle.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pipeObjectHandle = null;
        }
        this.mapFileHandle = null;
        this.gameTableFileHandle = null;
        this.gameData = null;
        this.connected = false;
    }

    boolean connect() {
        GameTable gameTable;
        if (this.connected) {
            System.err.println("Already connected");
            return true;
        }
        int serverProcID = -1;
        int gameTableIndex = -1;
        try {
            this.gameTableFileHandle = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, "Local\\bwapi_shared_memory_game_list"), 7, 0, 0, 96).getByteBuffer(0L, 96L);
            this.gameTableFileHandle.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (Exception e) {
            System.err.println("Game table mapping not found.");
            return false;
        }
        try {
            gameTable = new GameTable(this.gameTableFileHandle);
        }
        catch (Exception e) {
            System.err.println("Unable to map Game table.");
            if (this.debugConnection) {
                e.printStackTrace();
            }
            return false;
        }
        int latest = 0;
        for (int i = 0; i < 8; ++i) {
            GameInstance gameInstance = gameTable.gameInstances[i];
            System.out.println(i + " | " + gameInstance.serverProcessID + " | " + (gameInstance.isConnected ? 1 : 0) + " | " + gameInstance.lastKeepAliveTime);
            if (gameInstance.serverProcessID == 0 || gameInstance.isConnected || gameTableIndex != -1 && latest != 0 && gameInstance.lastKeepAliveTime >= latest) continue;
            latest = gameInstance.lastKeepAliveTime;
            gameTableIndex = i;
        }
        if (gameTableIndex != -1) {
            serverProcID = gameTable.gameInstances[gameTableIndex].serverProcessID;
        }
        if (serverProcID == -1) {
            System.err.println("No server proc ID");
            return false;
        }
        String sharedMemoryName = "Local\\bwapi_shared_memory_" + serverProcID;
        String communicationPipe = "\\\\.\\pipe\\bwapi_pipe_" + serverProcID;
        try {
            this.pipeObjectHandle = new RandomAccessFile(communicationPipe, "rw");
        }
        catch (Exception e) {
            System.err.println("Unable to open communications pipe: " + communicationPipe);
            if (this.debugConnection) {
                e.printStackTrace();
            }
            this.gameTableFileHandle = null;
            return false;
        }
        System.out.println("Connected");
        try {
            this.mapFileHandle = Kernel32.INSTANCE.MapViewOfFile(MappingKernel.INSTANCE.OpenFileMapping(7, false, sharedMemoryName), 7, 0, 0, 33017048).getByteBuffer(0L, 33017048L);
        }
        catch (Exception e) {
            System.err.println("Unable to open shared memory mapping: " + sharedMemoryName);
            if (this.debugConnection) {
                e.printStackTrace();
            }
            this.pipeObjectHandle = null;
            this.gameTableFileHandle = null;
            return false;
        }
        try {
            ClientData clientData = this.clientData = new ClientData(this.mapFileHandle);
            clientData.getClass();
            this.gameData = new ClientData.GameData(clientData, 0);
        }
        catch (Exception e) {
            System.err.println("Unable to map game data.");
            if (this.debugConnection) {
                e.printStackTrace();
            }
            return false;
        }
        if (10003 != this.gameData.getClient_version()) {
            System.err.println("Error: Client and Server are not compatible!");
            System.err.println("Client version: 10003");
            System.err.println("Server version: " + this.gameData.getClient_version());
            this.disconnect();
            this.sleep(2000);
            return false;
        }
        int code = 1;
        while (code != 2) {
            try {
                code = this.pipeObjectHandle.readByte();
            }
            catch (Exception e) {
                System.err.println("Unable to read pipe object.");
                if (this.debugConnection) {
                    e.printStackTrace();
                }
                this.disconnect();
                return false;
            }
        }
        System.out.println("Connection successful");
        this.connected = true;
        return true;
    }

    void update(EventHandler handler) {
        int code = 1;
        try {
            this.pipeObjectHandle.writeByte(code);
        }
        catch (Exception e) {
            System.err.println("failed, disconnecting");
            if (this.debugConnection) {
                e.printStackTrace();
            }
            this.disconnect();
            return;
        }
        while (code != 2) {
            try {
                code = this.pipeObjectHandle.readByte();
            }
            catch (Exception e) {
                System.err.println("failed, disconnecting");
                if (this.debugConnection) {
                    e.printStackTrace();
                }
                this.disconnect();
                return;
            }
        }
        for (int i = 0; i < this.gameData.getEventCount(); ++i) {
            handler.operation(this.gameData.getEvents(i));
        }
    }

    String eventString(int s) {
        return this.gameData.getEventStrings(s);
    }

    int addString(String string) {
        int stringCount = this.gameData.getStringCount();
        if (stringCount >= 19999) {
            throw new IllegalStateException("Too many strings!");
        }
        String stringTruncated = string.length() >= 1024 ? string.substring(0, 1023) : string;
        this.gameData.setStringCount(stringCount + 1);
        this.gameData.setStrings(stringCount, stringTruncated);
        return stringCount;
    }

    ClientData.Shape addShape() {
        int shapeCount = this.gameData.getShapeCount();
        if (shapeCount >= 19999) {
            throw new IllegalStateException("Too many shapes!");
        }
        this.gameData.setShapeCount(shapeCount + 1);
        return this.gameData.getShapes(shapeCount);
    }

    ClientData.Command addCommand() {
        int commandCount = this.gameData.getCommandCount();
        if (commandCount >= 19999) {
            throw new IllegalStateException("Too many commands!");
        }
        this.gameData.setCommandCount(commandCount + 1);
        return this.gameData.getCommands(commandCount);
    }

    ClientData.UnitCommand addUnitCommand() {
        int unitCommandCount = this.gameData.getUnitCommandCount();
        if (unitCommandCount >= 19999) {
            throw new IllegalStateException("Too many unit commands!");
        }
        this.gameData.setUnitCommandCount(unitCommandCount + 1);
        return this.gameData.getUnitCommands(unitCommandCount);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface EventHandler {
        public void operation(ClientData.Event var1);
    }

    static interface MappingKernel
    extends Kernel32 {
        public static final MappingKernel INSTANCE = (MappingKernel)Native.load(MappingKernel.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinNT.HANDLE OpenFileMapping(int var1, boolean var2, String var3);
    }
}

