/*
 * Decompiled with CFR 0.152.
 */
package unit.scout;

import bwapi.Game;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import info.BaseData;
import info.GameState;
import info.ScoutData;
import info.map.GameMap;
import info.map.MapTile;
import info.map.ScoutPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import strategy.openers.OpenerName;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class ScoutManager {
    final int FRAME_DRONE_SCOUT = 1440;
    private Game game;
    private GameState gameState;
    private HashSet<ManagedUnit> scouts = new HashSet();
    private HashSet<ManagedUnit> droneScouts = new HashSet();
    private ScoutPath enemyMainScoutPath;

    public ScoutManager(Game game, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
    }

    public void onFrame() {
        for (ManagedUnit managedUnit : this.scouts) {
            if (managedUnit.getMovementTargetPosition() != null) continue;
            this.assignScoutMovementTarget(managedUnit);
        }
    }

    public void addScout(ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.SCOUT);
        this.assignScoutMovementTarget(managedUnit);
        this.scouts.add(managedUnit);
        if (managedUnit.getUnitType() == UnitType.Zerg_Drone) {
            this.droneScouts.add(managedUnit);
        }
    }

    public void removeScout(ManagedUnit managedUnit) {
        if (managedUnit == null) {
            return;
        }
        ScoutData scoutData = this.gameState.getScoutData();
        TilePosition movementTarget = managedUnit.getMovementTargetPosition();
        HashSet<TilePosition> activeScoutTargets = scoutData.getActiveScoutTargets();
        if (movementTarget != null && activeScoutTargets.contains(managedUnit.getMovementTargetPosition())) {
            activeScoutTargets.remove(movementTarget);
        }
        this.scouts.remove(managedUnit);
        this.droneScouts.remove(managedUnit);
    }

    public boolean needDroneScout() {
        if (this.gameState.getActiveOpener().getName() == OpenerName.FOUR_POOL) {
            return false;
        }
        if (this.gameState.getBaseData().getMainEnemyBase() != null) {
            return false;
        }
        if (this.game.enemy().getRace() == Race.Zerg) {
            return false;
        }
        if (this.game.getFrameCount() < 1440) {
            return false;
        }
        return this.droneScouts.size() <= 0;
    }

    public boolean endDroneScout() {
        for (ManagedUnit managedUnit : this.droneScouts) {
            Unit unit = managedUnit.getUnit();
            if (!unit.isUnderAttack()) continue;
            return true;
        }
        return false;
    }

    public TilePosition pollScoutTarget(boolean allowDuplicateScoutTarget) {
        ArrayList<MapTile> heatMap;
        Object baseTarget;
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        if (baseData.getMainEnemyBase() == null && !scoutData.isEnemyBuildingLocationKnown() && (baseTarget = this.fetchBaseRoundRobin(scoutData.getScoutingBaseSet())) != null) {
            int assignments = scoutData.getScoutsAssignedToBase((Base)baseTarget);
            scoutData.updateBaseScoutAssignment((Base)baseTarget, assignments);
            return ((Base)baseTarget).getLocation();
        }
        if (scoutData.isEnemyBuildingLocationKnown()) {
            for (TilePosition target : scoutData.getEnemyBuildingPositions()) {
                if (scoutData.hasScoutTarget(target) && !allowDuplicateScoutTarget) continue;
                return target;
            }
        }
        if ((heatMap = this.gameState.getGameMap().getHeatMap()).size() > 0) {
            MapTile scoutTile = heatMap.get(0);
            scoutTile.setScoutImportance(0);
            return scoutTile.getTile();
        }
        return scoutData.findNewActiveScoutTarget();
    }

    private TilePosition pollDroneScoutTarget() {
        BaseData baseData = this.gameState.getBaseData();
        if (!baseData.knowEnemyMainBase()) {
            return this.findEnemyMain();
        }
        return this.scoutEnemyMain();
    }

    private TilePosition scoutEnemyMain() {
        BaseData baseData = this.gameState.getBaseData();
        Base enemyMain = baseData.getMainEnemyBase();
        TilePosition enemyMainTp = enemyMain.getLocation();
        if (this.enemyMainScoutPath == null) {
            this.ensureEnemyMainMovePoints(enemyMainTp);
        }
        return this.enemyMainScoutPath.next();
    }

    private void ensureEnemyMainMovePoints(TilePosition enemyMainTp) {
        GameMap gameMap = this.gameState.getGameMap();
        this.enemyMainScoutPath = gameMap.findScoutPath(enemyMainTp);
    }

    private TilePosition findEnemyMain() {
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        Set<Base> baseSet = scoutData.getScoutingBaseSet();
        int unscountedMainBases = baseSet.size();
        if (unscountedMainBases == 3) {
            Base farthestBase = baseData.findFarthestStartingBaseByGround();
            this.updateBaseScoutAssignments(farthestBase);
            return farthestBase.getLocation();
        }
        if (unscountedMainBases == 2) {
            Base farthestBase = this.fetchBaseFarthestFromScouts(baseSet);
            this.updateBaseScoutAssignments(farthestBase);
            return farthestBase.getLocation();
        }
        Base fathestBase = (Base)baseSet.stream().collect(Collectors.toList()).get(0);
        Base farthestBase = this.fetchBaseFarthestFromScouts(baseSet);
        this.updateBaseScoutAssignments(farthestBase);
        return fathestBase.getLocation();
    }

    private void updateBaseScoutAssignments(Base base) {
        ScoutData scoutData = this.gameState.getScoutData();
        int assignments = scoutData.getScoutsAssignedToBase(base);
        scoutData.updateBaseScoutAssignment(base, assignments);
    }

    private Base fetchBaseFarthestFromScouts(Set<Base> mainBases) {
        HashMap<Base, Double> baseDistance = new HashMap<Base, Double>();
        mainBases.stream().forEach(b -> baseDistance.put((Base)b, (Double)Double.MAX_VALUE));
        for (Base b2 : mainBases) {
            for (ManagedUnit scout : this.scouts) {
                double distance = b2.getLocation().getDistance(scout.getUnit().getTilePosition());
                if (!(distance < (Double)baseDistance.get(b2))) continue;
                baseDistance.put(b2, distance);
            }
        }
        Base farthest = null;
        for (Map.Entry entry : baseDistance.entrySet()) {
            if (farthest == null) {
                farthest = (Base)entry.getKey();
                continue;
            }
            if (!((Double)entry.getValue() > (Double)baseDistance.get(farthest))) continue;
            farthest = (Base)entry.getKey();
        }
        return farthest;
    }

    private Base fetchBaseRoundRobin(Set<Base> candidateBases) {
        Base leastScoutedBase = null;
        Integer fewestScouts = Integer.MAX_VALUE;
        ScoutData scoutData = this.gameState.getScoutData();
        for (Base base : candidateBases) {
            Integer assignedScoutsToBase = scoutData.getScoutsAssignedToBase(base);
            if (assignedScoutsToBase >= fewestScouts) continue;
            leastScoutedBase = base;
            fewestScouts = assignedScoutsToBase;
        }
        return leastScoutedBase;
    }

    private void assignScoutMovementTarget(ManagedUnit managedUnit) {
        if (managedUnit.getMovementTargetPosition() != null) {
            if (!this.game.isVisible(managedUnit.getMovementTargetPosition())) {
                return;
            }
            managedUnit.setMovementTargetPosition(null);
        }
        ScoutData scoutData = this.gameState.getScoutData();
        TilePosition target = null;
        target = managedUnit.getUnitType() == UnitType.Zerg_Drone ? this.pollDroneScoutTarget() : this.pollScoutTarget(false);
        scoutData.setActiveScoutTarget(target);
        managedUnit.setMovementTargetPosition(target);
    }
}

