/*
 * Decompiled with CFR 0.152.
 */
package strategy;

import bwapi.Race;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import strategy.openers.Opener;
import strategy.strategies.Default;
import strategy.strategies.Hydra;
import strategy.strategies.LingFlood;
import strategy.strategies.Mutalisk;
import strategy.strategies.Strategy;

public class StrategyFactory {
    private Race opponentRace;
    private List<Strategy> allStrategies = new ArrayList<Strategy>();
    private Map<String, Strategy> lookup = new HashMap<String, Strategy>();

    public StrategyFactory(Race opponentRace) {
        this.opponentRace = opponentRace;
        this.initStrategies();
    }

    public Strategy getByName(String name) {
        return this.lookup.get(name);
    }

    public List<String> listAllOpenerNames() {
        return this.allStrategies.stream().map(s -> s.getName()).collect(Collectors.toList());
    }

    public Set<String> getPlayableStrategies(Opener opener) {
        List playableStrategies = this.lookup.values().stream().filter(s -> s.playsOpener(opener)).filter(s -> this.playsRace((Strategy)s)).collect(Collectors.toList());
        return playableStrategies.stream().map(s -> s.getName()).collect(Collectors.toSet());
    }

    private void initStrategies() {
        this.allStrategies.add(new Default());
        this.allStrategies.add(new Hydra());
        this.allStrategies.add(new LingFlood());
        this.allStrategies.add(new Mutalisk());
        for (Strategy strategy : this.allStrategies) {
            this.lookup.put(strategy.getName(), strategy);
        }
    }

    private boolean playsRace(Strategy strategy) {
        switch (this.opponentRace) {
            case Zerg: {
                return this.playsZerg(strategy);
            }
            case Terran: {
                return this.playsTerran(strategy);
            }
            case Protoss: {
                return this.playsProtoss(strategy);
            }
        }
        return this.playsRandom(strategy);
    }

    private boolean playsZerg(Strategy strategy) {
        switch (strategy.getType()) {
            case LING_FLOOD: 
            case MUTALISK: {
                return true;
            }
        }
        return false;
    }

    private boolean playsTerran(Strategy _) {
        return true;
    }

    private boolean playsProtoss(Strategy _) {
        return true;
    }

    private boolean playsRandom(Strategy _) {
        return true;
    }
}

