/*
 * Decompiled with CFR 0.152.
 */
package learning;

import bwapi.Race;
import bwem.BWEM;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import learning.Decisions;
import learning.DefensiveSunkRecord;
import learning.OpenerRecord;
import learning.OpponentRecord;
import learning.StrategyRecord;
import learning.UCBRecordComparator;
import strategy.OpenerFactory;
import strategy.StrategyFactory;
import strategy.openers.Opener;
import strategy.strategies.Strategy;

public class LearningManager {
    private BWEM bwem;
    private static String READ_DIR = "bwapi-data/read/";
    private static String WRITE_DIR = "bwapi-data/write/";
    private Race opponentRace;
    private String opponentName;
    private String opponentFileName;
    private OpponentRecord opponentRecord;
    private Decisions decisions = new Decisions();
    private OpenerRecord currentOpener;
    private StrategyRecord currentStrategy;
    private ObjectMapper mapper = new ObjectMapper();
    private OpenerFactory openerFactory;
    private StrategyFactory strategyFactory;

    public LearningManager(Race opponentRace, String opponentName, BWEM bwem) {
        this.opponentRace = opponentRace;
        this.opponentName = opponentName;
        this.opponentFileName = opponentName + "_" + (Object)((Object)opponentRace) + ".json";
        this.opponentRecord = new OpponentRecord(opponentName, opponentRace.toString(), 0, 0, new HashMap<String, OpenerRecord>(), new HashMap<String, OpenerRecord>(), new HashMap<String, StrategyRecord>(), new DefensiveSunkRecord(0, 0));
        this.bwem = bwem;
        this.openerFactory = new OpenerFactory(bwem.getMap().getStartingLocations().size(), opponentRace);
        this.strategyFactory = new StrategyFactory(opponentRace);
        try {
            this.readOpponentRecord();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ensureOpenersInOpponentRecord();
        this.ensureStrategiesInOpponentRecord();
        this.ensureDefensiveSunk();
        this.decisions.setOpener(this.determineOpener());
        this.decisions.setStrategy(this.determineStrategy());
        this.decisions.setDefensiveSunk(this.determineDefensiveSunk());
    }

    public void onEnd(boolean isWinner) {
        DefensiveSunkRecord defensiveSunkRecord = this.opponentRecord.getDefensiveSunkRecord();
        if (isWinner) {
            this.currentOpener.setWins(this.currentOpener.getWins() + 1);
            this.opponentRecord.setWins(this.opponentRecord.getWins() + 1);
            this.currentStrategy.setWins(this.currentStrategy.getWins() + 1);
            if (this.decisions.isDefensiveSunk()) {
                defensiveSunkRecord.setWins(defensiveSunkRecord.getWins() + 1);
            }
        } else {
            this.currentOpener.setLosses(this.currentOpener.getLosses() + 1);
            this.opponentRecord.setLosses(this.opponentRecord.getLosses() + 1);
            this.currentStrategy.setLosses(this.currentStrategy.getLosses() + 1);
            if (this.decisions.isDefensiveSunk()) {
                defensiveSunkRecord.setLosses(defensiveSunkRecord.getLosses() + 1);
            }
        }
        Map<String, OpenerRecord> openerRecords = this.opponentRecord.getOpenerRecord();
        openerRecords.put(this.currentOpener.getOpener(), this.currentOpener);
        Map<String, StrategyRecord> strategyRecordMap = this.opponentRecord.getStrategyRecordMap();
        strategyRecordMap.put(this.currentStrategy.getStrategy(), this.currentStrategy);
        try {
            this.writeOpponentRecord();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Decisions getDecisions() {
        return this.decisions;
    }

    public OpponentRecord getOpponentRecord() {
        return this.opponentRecord;
    }

    private void readOpponentRecord() throws IOException {
        File file = new File(READ_DIR + this.opponentFileName);
        if (!file.exists()) {
            this.opponentRecord.setName(this.opponentName);
            this.opponentRecord.setRace(this.opponentRace.toString());
            return;
        }
        FileInputStream inJson = new FileInputStream(file);
        this.opponentRecord = this.mapper.readValue((InputStream)inJson, OpponentRecord.class);
        if (this.opponentRecord.getOpenerRecord() == null) {
            this.opponentRecord.setOpenerRecord(new HashMap<String, OpenerRecord>());
        }
    }

    private void writeOpponentRecord() throws IOException {
        File file = new File(WRITE_DIR + this.opponentFileName);
        file.createNewFile();
        if (!file.isFile()) {
            return;
        }
        this.mapper.writeValue(file, (Object)this.opponentRecord);
    }

    private void ensureOpenersInOpponentRecord() {
        Map<String, OpenerRecord> openerRecordMap = this.opponentRecord.getOpenerRecord();
        List knownOpeners = openerRecordMap.keySet().stream().collect(Collectors.toList());
        Set missingOpeners = this.openerFactory.listAllOpenerNames().stream().filter(s -> !knownOpeners.contains(s)).collect(Collectors.toSet());
        for (String opener : missingOpeners) {
            openerRecordMap.put(opener, new OpenerRecord(opener, 0, 0));
        }
    }

    private void ensureStrategiesInOpponentRecord() {
        Map<String, StrategyRecord> strategyRecordMap = this.opponentRecord.getStrategyRecordMap();
        List knownStrategies = strategyRecordMap.keySet().stream().collect(Collectors.toList());
        Set missingStrategies = this.strategyFactory.listAllOpenerNames().stream().filter(s -> !knownStrategies.contains(s)).collect(Collectors.toSet());
        for (String strategy : missingStrategies) {
            strategyRecordMap.put(strategy, new StrategyRecord(strategy, 0, 0));
        }
    }

    private void ensureDefensiveSunk() {
        DefensiveSunkRecord record = this.opponentRecord.getDefensiveSunkRecord();
        if (record == null) {
            this.opponentRecord.setDefensiveSunkRecord(new DefensiveSunkRecord(0, 0));
        }
    }

    private Opener determineOpener() {
        List openers = this.opponentRecord.getOpenerRecord().values().stream().filter(sr -> this.openerFactory.getPlayableOpeners().contains(sr.getOpener())).collect(Collectors.toList());
        Collections.sort(openers, new UCBRecordComparator(this.opponentRecord.totalGames()));
        this.currentOpener = (OpenerRecord)openers.get(0);
        return this.openerFactory.getByName(this.currentOpener.getOpener());
    }

    private Strategy determineStrategy() {
        List strategies = this.opponentRecord.getStrategyRecordMap().values().stream().filter(sr -> this.strategyFactory.getPlayableStrategies(this.decisions.getOpener()).contains(sr.getStrategy())).collect(Collectors.toList());
        Collections.sort(strategies, new UCBRecordComparator(this.opponentRecord.totalGames()));
        this.currentStrategy = (StrategyRecord)strategies.get(0);
        return this.strategyFactory.getByName(this.currentStrategy.getStrategy());
    }

    private boolean determineDefensiveSunk() {
        DefensiveSunkRecord record = this.opponentRecord.getDefensiveSunkRecord();
        return record.index(this.opponentRecord.totalGames()) > 0.5;
    }
}

