/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.TilePosition;
import bwapi.Unit;
import bwem.Base;
import info.exception.NoWalkablePathException;
import info.map.GameMap;
import info.map.GroundPath;
import info.map.GroundPathComparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import util.BaseUnitDistanceComparator;

public class BaseData {
    private Base mainBase;
    private Base naturalExpansion;
    private Base mainEnemyBase;
    private HashSet<Unit> macroHatcheries = new HashSet();
    private HashSet<Unit> baseHatcheries = new HashSet();
    private HashSet<Base> allBases = new HashSet();
    private HashSet<Base> myBases = new HashSet();
    private HashSet<Base> reservedBases = new HashSet();
    private HashSet<Base> enemyBases = new HashSet();
    private HashSet<Base> islands = new HashSet();
    private HashSet<Base> mineralOnlyBase = new HashSet();
    private HashSet<Base> mains = new HashSet();
    private HashMap<Unit, Base> baseLookup = new HashMap();
    private HashSet<TilePosition> baseTilePositionSet = new HashSet();
    private HashMap<TilePosition, Base> baseTilePositionLookup = new HashMap();
    private HashMap<Base, GroundPath> allBasePaths = new HashMap();
    private HashMap<Base, GroundPath> availableBases = new HashMap();
    private HashSet<Unit> extractors = new HashSet();
    private HashSet<Unit> availableGeysers = new HashSet();
    private HashMap<Base, Unit> sunkenColonyLookup = new HashMap();
    private int reservedSunkenColonies = 0;

    public BaseData(List<Base> allBases) {
        for (Base base : allBases) {
            this.allBases.add(base);
            this.baseTilePositionSet.add(base.getLocation());
            this.baseTilePositionLookup.put(base.getLocation(), base);
            if (base.getGeysers().size() == 0) {
                this.mineralOnlyBase.add(base);
            }
            if (!base.isStartingLocation()) continue;
            this.mains.add(base);
        }
    }

    public HashMap<Base, GroundPath> getBasePaths() {
        return this.allBasePaths;
    }

    public void initializeMainBase(Base base, GameMap map) {
        this.mainBase = base;
        HashSet potentialBases = this.allBases.stream().filter(b -> b != base).collect(Collectors.toCollection(HashSet::new));
        for (Base b2 : potentialBases) {
            try {
                GroundPath path = map.aStarSearch(this.mainBase.getLocation(), b2.getLocation());
                this.availableBases.put(b2, path);
                this.allBasePaths.put(b2, path);
            }
            catch (NoWalkablePathException e) {
                this.islands.add(b2);
            }
        }
    }

    public Base getMainBase() {
        return this.mainBase;
    }

    public void addBase(Unit hatchery, Base base) {
        this.baseHatcheries.add(hatchery);
        this.myBases.add(base);
        this.baseLookup.put(hatchery, base);
        this.availableBases.remove(base);
        this.reservedBases.remove(base);
        if (this.naturalExpansion == null && this.myBases.size() > 1) {
            this.naturalExpansion = base;
        }
        base.getGeysers().stream().forEach(g -> this.availableGeysers.add(g.getUnit()));
    }

    public boolean canReserveExtractor() {
        return this.availableGeysers.size() > 0;
    }

    public Unit reserveExtractor() {
        Unit candidate = this.availableGeysers.iterator().next();
        this.extractors.add(candidate);
        this.availableGeysers.remove(candidate);
        return candidate;
    }

    public void addExtractorCandidate(Unit geyser) {
    }

    public int numExtractor() {
        return this.extractors.size();
    }

    public Base reserveBase() {
        Base base = this.findNewBase();
        if (base == null) {
            return null;
        }
        this.reservedBases.add(base);
        return base;
    }

    public void cancelReserveBase(Base base) {
        GroundPath oldPath = this.allBasePaths.get(base);
        this.availableBases.put(base, oldPath);
        this.reservedBases.remove(base);
    }

    public Base claimBase(Unit hatchery) {
        TilePosition tp = hatchery.getTilePosition();
        Base base = null;
        for (Base reservedBase : this.reservedBases) {
            if (!tp.equals(reservedBase.getLocation())) continue;
            base = reservedBase;
            break;
        }
        if (base == null && (base = this.findNewBase()) == null) {
            return null;
        }
        return base;
    }

    public Base get(Unit hatchery) {
        return this.baseLookup.get(hatchery);
    }

    public boolean isBase(Unit hatchery) {
        return this.baseHatcheries.contains(hatchery);
    }

    public void addMacroHatchery(Unit hatchery) {
        this.macroHatcheries.add(hatchery);
    }

    public void removeHatchery(Unit hatchery) {
        if (this.baseHatcheries.contains(hatchery)) {
            this.removeBase(hatchery);
        } else {
            this.removeMacroHatchery(hatchery);
        }
    }

    private void removeBase(Unit hatchery) {
        Base base = this.baseLookup.get(hatchery);
        this.baseHatcheries.remove(hatchery);
        this.myBases.remove(base);
        GroundPath pathToRemovedBase = this.allBasePaths.get(base);
        this.availableBases.put(base, pathToRemovedBase);
    }

    private void removeMacroHatchery(Unit hatchery) {
        this.macroHatcheries.remove(hatchery);
    }

    public HashSet<Unit> baseHatcheries() {
        return this.baseHatcheries;
    }

    public int currentBaseCount() {
        return this.baseHatcheries.size();
    }

    public int numHatcheries() {
        return this.myBases.size() + this.macroHatcheries.size() + this.reservedBases.size();
    }

    public TilePosition mainBasePosition() {
        return this.mainBase.getLocation();
    }

    public TilePosition naturalExpansionPosition() {
        return this.naturalExpansion.getLocation();
    }

    public boolean hasNaturalExpansion() {
        return this.naturalExpansion != null;
    }

    public boolean isBaseTilePosition(TilePosition tilePosition) {
        return this.baseTilePositionSet.contains(tilePosition);
    }

    public Base baseAtTilePosition(TilePosition tilePosition) {
        return this.baseTilePositionLookup.get(tilePosition);
    }

    public Base findNewBase() {
        List potential = this.availableBases.entrySet().stream().filter(p -> !this.reservedBases.contains(p.getKey())).sorted(Map.Entry.comparingByValue(new GroundPathComparator())).collect(Collectors.toList());
        if (potential == null || potential.size() == 0) {
            return null;
        }
        for (int i = 0; i < potential.size(); ++i) {
            Base candidate = (Base)((Map.Entry)potential.get(i)).getKey();
            if (this.myBases.size() == 1 && candidate.getGeysers().size() == 0) continue;
            return candidate;
        }
        return null;
    }

    public void addSunkenColony(Unit sunken) {
        Base base = (Base)this.myBases.stream().sorted(new BaseUnitDistanceComparator(sunken)).collect(Collectors.toList()).get(0);
        this.sunkenColonyLookup.put(base, sunken);
        if (this.reservedSunkenColonies > 0) {
            --this.reservedSunkenColonies;
        }
    }

    public TilePosition reserveSunkenColony() {
        Base base = (Base)this.myBases.stream().filter(b -> !this.sunkenColonyLookup.containsKey(b)).collect(Collectors.toList()).iterator().next();
        ++this.reservedSunkenColonies;
        return base.getLocation();
    }

    public boolean canPlanSunkenColony() {
        return this.myBases.size() - this.reservedSunkenColonies - this.sunkenColonyLookup.size() > 0;
    }

    public Base getMainEnemyBase() {
        return this.mainEnemyBase;
    }

    public void setMainEnemyBase(Base base) {
        this.mainEnemyBase = base;
        this.enemyBases.add(base);
        this.availableBases.remove(base);
    }

    public boolean knowEnemyMainBase() {
        return this.mainEnemyBase != null;
    }

    public Base findFarthestStartingBaseByGround() {
        Base best = null;
        for (Base b : this.mains) {
            if (b == this.mainBase) continue;
            if (best == null) {
                best = b;
                continue;
            }
            GroundPath bestPath = this.allBasePaths.get(best);
            GroundPath candidatePath = this.allBasePaths.get(b);
            if (candidatePath.getGroundDistance() <= bestPath.getGroundDistance()) continue;
            best = b;
        }
        return best;
    }

    public int numMains() {
        return this.mains.size();
    }
}

