/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Collectors;

class Asserter {
    private boolean failOnError = true;
    private OutputStream outStream = System.err;

    Asserter() {
    }

    void throwIllegalStateException(String message) {
        IllegalStateException exception = new IllegalStateException(message);
        if (this.failOnError) {
            throw exception;
        }
        try {
            throw exception;
        }
        catch (IllegalStateException e) {
            if (this.outStream != null) {
                try {
                    this.outStream.write(Arrays.stream(e.getStackTrace()).map(s -> s.toString() + "\n").collect(Collectors.joining()).getBytes());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
    }

    void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    void setFailOutputStream(OutputStream outputStream) {
        this.outStream = outputStream;
    }
}

