/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.UnsafeTools;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

class WrappedBuffer {
    private final ByteBuffer buffer;
    private final long address;
    private static final Unsafe unsafe = UnsafeTools.getUnsafe();

    WrappedBuffer(int size) {
        this.buffer = ByteBuffer.allocateDirect(size);
        this.address = UnsafeTools.getAddress(this.buffer);
    }

    WrappedBuffer(Pointer pointer, int size) {
        this.buffer = pointer.getByteBuffer(0L, size);
        this.address = Pointer.nativeValue(pointer);
    }

    byte getByte(int offset) {
        return unsafe.getByte(this.address + (long)offset);
    }

    void putByte(int offset, byte value) {
        unsafe.putByte(this.address + (long)offset, value);
    }

    short getShort(int offset) {
        return unsafe.getShort(this.address + (long)offset);
    }

    void putShort(int offset, short value) {
        unsafe.putShort(this.address + (long)offset, value);
    }

    int getInt(int offset) {
        return unsafe.getInt(this.address + (long)offset);
    }

    void putInt(int offset, int value) {
        unsafe.putInt(this.address + (long)offset, value);
    }

    double getDouble(int offset) {
        return unsafe.getDouble(this.address + (long)offset);
    }

    void putDouble(int offset, double value) {
        unsafe.putDouble(this.address + (long)offset, value);
    }

    String getString(int offset, int maxLen) {
        byte b;
        char[] buf = new char[maxLen];
        long pos = (long)offset + this.address;
        for (int i = 0; i < maxLen && (b = unsafe.getByte(pos)) != 0; ++i) {
            buf[i] = (char)(b & 0xFF);
            ++pos;
        }
        return new String(buf, 0, (int)(pos - (long)offset - this.address));
    }

    void putString(int offset, int maxLen, String string) {
        long pos = (long)offset + this.address;
        for (int i = 0; i < Math.min(string.length(), maxLen - 1); ++i) {
            unsafe.putByte(pos, (byte)string.charAt(i));
            ++pos;
        }
        unsafe.putByte(pos, (byte)0);
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    long getAddress() {
        return this.address;
    }
}

