/*
 * Decompiled with CFR 0.152.
 */
package Information.Battles.Prediction.Skimulation;

import Information.Battles.Types.Battle;
import Information.Battles.Types.Team;
import Lifecycle.With$;
import Mathematics.Maff$;
import ProxyBwapi.Players.PlayerInfo;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.$qmark$;
import Utilities.LightYear$;
import Utilities.Time.Seconds;
import Utilities.UnitFilters.IsBioWarrior$;
import Utilities.UnitFilters.IsGroundWarrior$;
import Utilities.UnitFilters.IsMechWarrior$;
import Utilities.UnitFilters.IsTank$;
import Utilities.UnitFilters.IsWarrior$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.math.Ordering$Double$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LazyDouble;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;

public final class Skimulator$ {
    public static Skimulator$ MODULE$;

    static {
        new Skimulator$();
    }

    private double distanceToEngage(UnitInfo unit, Team team) {
        Iterable targets = (Iterable)$qmark$.MODULE$.apply(Terran$.MODULE$.Medic().apply(unit), (Function0<SeqView> & Serializable & scala.Serializable)() -> (SeqView)team.units().view().filter((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$distanceToEngage$2(x$1))), (Function0<Iterable> & Serializable & scala.Serializable)() -> Maff$.MODULE$.orElse(Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{Option$.MODULE$.option2Iterable(unit.presumptiveTarget()), team.opponent().units()})));
        unit.skimTarget_$eq(None$.MODULE$);
        DoubleRef output = DoubleRef.create(LightYear$.MODULE$.apply());
        targets.foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)target -> {
            Skimulator$.$anonfun$distanceToEngage$4(unit, output, target);
            return BoxedUnit.UNIT;
        });
        return output.elem;
    }

    public void predict(Battle battle) {
        if (battle.isGlobal()) {
            double maxEffectiveRange = BoxesRunTime.unboxToDouble(Maff$.MODULE$.max(battle.units().map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble(x$2.effectiveRangePixels()), Seq$.MODULE$.canBuildFrom()), Ordering$Double$.MODULE$).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> 0.0));
            battle.units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> {
                u.skimDistanceToEngage_$eq(maxEffectiveRange - u.effectiveRangePixels());
                return BoxedUnit.UNIT;
            });
        } else {
            IntRef enemyBonusTravelFrames = IntRef.create(new Seconds(3).apply());
            battle.us().units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
                Skimulator$.$anonfun$predict$4(battle, enemyBonusTravelFrames, unit);
                return BoxedUnit.UNIT;
            });
            DoubleRef visibleDistanceToTargetNumerator = DoubleRef.create(0.0);
            DoubleRef visibleDistanceToTargetDenominator = DoubleRef.create(0.0);
            battle.enemy().units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
                Skimulator$.$anonfun$predict$5(battle, visibleDistanceToTargetNumerator, visibleDistanceToTargetDenominator, enemyBonusTravelFrames, unit);
                return BoxedUnit.UNIT;
            });
            double visibleDistanceToTarget = visibleDistanceToTargetNumerator.elem / Math.max(1.0, visibleDistanceToTargetDenominator.elem);
            battle.enemy().units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
                Skimulator$.$anonfun$predict$6(battle, visibleDistanceToTarget, enemyBonusTravelFrames, unit);
                return BoxedUnit.UNIT;
            });
        }
        if (battle.enemy().units().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.visible()))) {
            double enemyMeanVisibleDistance = Maff$.MODULE$.mean(Maff$.MODULE$.orElse(Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{battle.enemy().attackers(), battle.enemy().units()})).view().filter((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.visible())).map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble(x$5.skimDistanceToEngage()), IterableView$.MODULE$.canBuildFrom()));
            ((IterableLike)battle.enemy().units().view().filterNot((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.visible()))).foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> {
                u.skimDistanceToEngage_$eq(Maff$.MODULE$.clamp(u.skimDistanceToEngage() - u.topSpeed() * (double)With$.MODULE$.framesSince(u.lastSeen()), u.skimDistanceToEngage(), enemyMeanVisibleDistance));
                return BoxedUnit.UNIT;
            });
        }
        battle.teams().foreach((Function1<Team, Object> & Serializable & scala.Serializable)team -> {
            team.skimMeanWarriorDistanceToEngage_$eq(Math.min(320.0, BoxesRunTime.unboxToDouble(Maff$.MODULE$.medianOpt(team.units().view().filter(IsWarrior$.MODULE$).map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToDouble(x$7.skimDistanceToEngage()), SeqView$.MODULE$.canBuildFrom()), Ordering$Double$.MODULE$).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> LightYear$.MODULE$.apply()))));
            return BoxedUnit.UNIT;
        });
        battle.teams().foreach((Function1<Team, Object> & Serializable & scala.Serializable)team -> {
            Skimulator$.$anonfun$predict$15(battle, team);
            return BoxedUnit.UNIT;
        });
        battle.teams().foreach((Function1<Team, Object> & Serializable & scala.Serializable)team -> {
            Skimulator$.$anonfun$predict$19(battle, team);
            return BoxedUnit.UNIT;
        });
        battle.teams().foreach((Function1<Team, Object> & Serializable & scala.Serializable)team -> {
            Skimulator$.$anonfun$predict$42(team);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$distanceToEngage$2(UnitInfo x$1) {
        return x$1.unitClass().isOrganic();
    }

    public static final /* synthetic */ void $anonfun$distanceToEngage$4(UnitInfo unit$1, DoubleRef output$1, UnitInfo target) {
        double distance = unit$1.pixelDistanceEdge(target);
        if (distance < output$1.elem) {
            output$1.elem = distance;
            unit$1.skimTarget_$eq(new Some<UnitInfo>(target));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$predict$4(Battle battle$1, IntRef enemyBonusTravelFrames$1, UnitInfo unit) {
        unit.skimDistanceToEngage_$eq(Math.max(0.0, MODULE$.distanceToEngage(unit, battle$1.us()) - unit.effectiveRangePixels()));
        enemyBonusTravelFrames$1.elem = Math.min(enemyBonusTravelFrames$1.elem, unit.framesToTravelPixels(unit.skimDistanceToEngage()));
    }

    public static final /* synthetic */ void $anonfun$predict$5(Battle battle$1, DoubleRef visibleDistanceToTargetNumerator$1, DoubleRef visibleDistanceToTargetDenominator$1, IntRef enemyBonusTravelFrames$1, UnitInfo unit) {
        if (unit.visible()) {
            double distanceToTarget = MODULE$.distanceToEngage(unit, battle$1.enemy());
            if (distanceToTarget < (double)LightYear$.MODULE$.apply()) {
                visibleDistanceToTargetNumerator$1.elem += distanceToTarget;
                visibleDistanceToTargetDenominator$1.elem += 1.0;
                unit.skimDistanceToEngage_$eq(Math.max(0.0, distanceToTarget - unit.effectiveRangePixels() - unit.topSpeed() * (double)enemyBonusTravelFrames$1.elem));
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$predict$6(Battle battle$1, double visibleDistanceToTarget$1, IntRef enemyBonusTravelFrames$1, UnitInfo unit) {
        if (!unit.visible()) {
            double distanceToTarget = MODULE$.distanceToEngage(unit, battle$1.enemy());
            double distanceFloor = distanceToTarget - unit.topSpeed() * (double)With$.MODULE$.framesSince(unit.lastSeen());
            unit.skimDistanceToEngage_$eq(BoxesRunTime.unboxToDouble(Maff$.MODULE$.vmax(Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, distanceFloor, Math.min(distanceToTarget, visibleDistanceToTarget$1 + (double)256) - unit.effectiveRangePixels() - unit.topSpeed() * (double)enemyBonusTravelFrames$1.elem}), Ordering$Double$.MODULE$)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$predict$16(Team team$2, Battle battle$1, UnitInfo unit) {
        double speed = Math.max(unit.topSpeed(), unit.isFriendly() ? 0.0 : (IsTank$.MODULE$.apply(unit) && !unit.visible() ? Terran$.MODULE$.SiegeTankUnsieged().topSpeed() : Protoss$.MODULE$.Reaver().topSpeed() * 0.25));
        double delayFrames = Math.max((double)unit.cooldownLeft(), Maff$.MODULE$.nanToOne((unit.skimDistanceToEngage() - team$2.skimMeanWarriorDistanceToEngage()) / speed / BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(unit.isFriendly(), (JFunction0$mcD$sp & scala.Serializable)() -> battle$1.speedMultiplier(), (JFunction0$mcD$sp & scala.Serializable)() -> 1.0))));
        double extensionFrames = Maff$.MODULE$.nanToOne((team$2.skimMeanWarriorDistanceToEngage() - unit.skimDistanceToEngage()) / team$2.meanAttackerSpeed());
        double teamDurabilityFrames = Maff$.MODULE$.clamp(Maff$.MODULE$.nanToOne(team$2.meanAttackerHealth() / team$2.opponent().meanDpf()), 12.0, 240.0);
        unit.skimDelay_$eq(Maff$.MODULE$.clamp(Maff$.MODULE$.nanToOne(delayFrames / teamDurabilityFrames), 0.0, 1.0));
        unit.skimExtension_$eq(Maff$.MODULE$.clamp(Maff$.MODULE$.nanToZero(extensionFrames / teamDurabilityFrames), 0.0, 0.75));
        unit.skimPresence_$eq(1.0 - Math.max(unit.skimDelay(), unit.skimExtension()));
    }

    public static final /* synthetic */ void $anonfun$predict$15(Battle battle$1, Team team) {
        team.units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            Skimulator$.$anonfun$predict$16(team, battle$1, unit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$predict$28(UnitInfo unit$2, UnitInfo x$8) {
        return x$8.altitude() > unit$2.altitude();
    }

    public static final /* synthetic */ boolean $anonfun$predict$29(UnitInfo unit$2, UnitInfo t) {
        return t.altitude() < unit$2.pixelToFireAtSimple(t).altitude();
    }

    private static final /* synthetic */ double maxEffectiveMedics$lzycompute$1(LazyDouble maxEffectiveMedics$lzy$1, Team team$3) {
        synchronized (maxEffectiveMedics$lzy$1) {
            double d = maxEffectiveMedics$lzy$1.initialized() ? maxEffectiveMedics$lzy$1.value() : maxEffectiveMedics$lzy$1.initialize((double)team$3.attackersBioCount() / 3.0);
            return d;
        }
    }

    private static final double maxEffectiveMedics$1(LazyDouble maxEffectiveMedics$lzy$1, Team team$3) {
        if (maxEffectiveMedics$lzy$1.initialized()) {
            return maxEffectiveMedics$lzy$1.value();
        }
        return Skimulator$.maxEffectiveMedics$lzycompute$1(maxEffectiveMedics$lzy$1, team$3);
    }

    public static final /* synthetic */ boolean $anonfun$predict$32(FriendlyUnitInfo x$9) {
        return x$9.agent().ride().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$predict$34(UnitInfo u) {
        return Protoss$.MODULE$.Shuttle().apply(u) && u.pixelDistanceEdge(u) < (double)160;
    }

    public static final /* synthetic */ boolean $anonfun$predict$39(UnitInfo unit$2, UnitInfo t) {
        return Zerg$.MODULE$.Zergling().apply(t) && unit$2.damageUpgradeLevel() > t.armorHealth();
    }

    public static final /* synthetic */ void $anonfun$predict$20(Team team$3, Battle battle$1, UnitInfo unit) {
        LazyDouble maxEffectiveMedics$lzy = new LazyDouble();
        Team opponent = team$3.opponent();
        $qmark$.MODULE$.apply(unit.isFriendly(), (JFunction0$mcI$sp & scala.Serializable)() -> unit.energy(), (JFunction0$mcI$sp & scala.Serializable)() -> 100);
        PlayerInfo player = unit.player();
        double casts75 = Math.floor(unit.energy() / 75);
        double casts100 = Math.floor(unit.energy() / 100);
        double casts125 = Math.floor(unit.energy() / 125);
        double casts150 = Math.floor(unit.energy() / 150);
        unit.skimStrength_$eq(Maff$.MODULE$.nanToZero(unit.unitClass().skimulationValue() * (double)unit.totalHealth() / (double)unit.unitClass().maxTotalHealth()));
        unit.skimStrength_$eq(unit.skimStrength() * Maff$.MODULE$.vmean(Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, Maff$.MODULE$.nanToOne((unit.unitClass().hitPointsHealthRatio() * (opponent.meanDamageOnHit() - (double)unit.armorHealth()) + unit.unitClass().shieldsHealthRatio() * (opponent.meanDamageOnHit() - (double)unit.armorShield())) / (unit.unitClass().hitPointsHealthRatio() * (opponent.meanDamageOnHit() - (double)unit.unitClass().armor()) + unit.unitClass().shieldsHealthRatio() * opponent.meanDamageOnHit()))})));
        unit.skimTarget().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> {
            unit.skimStrength_$eq(unit.skimStrength() * Maff$.MODULE$.vmean(Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, Maff$.MODULE$.nanToOne((double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(t.flying(), (JFunction0$mcI$sp & scala.Serializable)() -> unit$2.damageOnHitAir(), (JFunction0$mcI$sp & scala.Serializable)() -> unit$2.damageOnHitGround())) / (double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(t.flying(), (JFunction0$mcI$sp & scala.Serializable)() -> unit$2.unitClass().effectiveAirDamage(), (JFunction0$mcI$sp & scala.Serializable)() -> unit$2.unitClass().effectiveGroundDamage())))})));
            return BoxedUnit.UNIT;
        });
        if (!battle$1.isGlobal() && unit.isFriendly() && unit.canAttack() && unit.effectiveRangePixels() > (double)64 && !unit.flying()) {
            if (unit.presumptiveTarget().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$predict$28(unit, x$8)))) {
                unit.skimStrength_$eq(unit.skimStrength() * 0.75);
            } else if (unit.presumptiveTarget().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$predict$29(unit, t)))) {
                unit.skimStrength_$eq(unit.skimStrength() * 1.25);
            }
        }
        if (unit.isEnemy() && !team$3.opponent().hasDetection()) {
            if (Terran$.MODULE$.Wraith().apply(unit) && Terran$.MODULE$.WraithCloak().apply(player)) {
                unit.skimStrength_$eq(unit.skimStrength() * (double)5);
            }
            if (Protoss$.MODULE$.DarkTemplar().apply(unit)) {
                unit.skimStrength_$eq(unit.skimStrength() * (double)15);
            }
            if (Zerg$.MODULE$.Lurker().apply(unit)) {
                unit.skimStrength_$eq(unit.skimStrength() * (double)5);
            }
        }
        if (unit.canStim()) {
            unit.skimStrength_$eq(unit.skimStrength() * BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(unit.stimmed(), (JFunction0$mcD$sp & scala.Serializable)() -> 1.2, (JFunction0$mcD$sp & scala.Serializable)() -> 1.1)));
        }
        if (unit.ensnared()) {
            unit.skimStrength_$eq(unit.skimStrength() * 0.5);
        }
        if (Terran$.MODULE$.Marine().apply(unit) && Terran$.MODULE$.MarineRange().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.3);
        }
        if (Terran$.MODULE$.Marine().apply(unit) && Terran$.MODULE$.Stim().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.3);
        }
        if (Terran$.MODULE$.Firebat().apply(unit) && Terran$.MODULE$.Stim().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.3);
        }
        if (Terran$.MODULE$.Medic().apply(unit)) {
            unit.skimStrength_$eq(unit.skimStrength() * Maff$.MODULE$.clamp(Skimulator$.maxEffectiveMedics$1(maxEffectiveMedics$lzy, team$3) / (double)Math.max(1, team$3.count(Terran$.MODULE$.Medic())), 0.0, 1.0));
        }
        if (Terran$.MODULE$.Vulture().apply(unit) && Terran$.MODULE$.VultureSpeed().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Protoss$.MODULE$.Archon().apply(unit) && unit.matchups().targetsInRange().nonEmpty()) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.5);
        }
        if (Protoss$.MODULE$.Carrier().apply(unit) && unit.isFriendly()) {
            unit.skimStrength_$eq(unit.skimStrength() * ((double)unit.interceptors().size() * Maff$.MODULE$.inv8()));
        }
        if (Protoss$.MODULE$.Reaver().apply(unit)) {
            unit.skimStrength_$eq(unit.skimStrength() * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsGroundWarrior$.MODULE$) / 12), 1.0, 2.5));
        }
        if (Protoss$.MODULE$.Reaver().apply(unit)) {
            unit.skimStrength_$eq(unit.skimStrength() * BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(BoxesRunTime.unboxToBoolean(unit.friendly().map((Function1<FriendlyUnitInfo, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$predict$32(x$9))).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> team$3.units().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$predict$34(u))))), (JFunction0$mcD$sp & scala.Serializable)() -> BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(Protoss$.MODULE$.ShuttleSpeed().apply(unit.player()), (JFunction0$mcD$sp & scala.Serializable)() -> 2.0, (JFunction0$mcD$sp & scala.Serializable)() -> 1.5)), (JFunction0$mcD$sp & scala.Serializable)() -> 1.0)));
        }
        if (Protoss$.MODULE$.Zealot().apply(unit) && Protoss$.MODULE$.ZealotSpeed().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Protoss$.MODULE$.Dragoon().apply(unit) && Protoss$.MODULE$.DragoonRange().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.5);
        }
        if (Zerg$.MODULE$.Zergling().apply(unit) && Zerg$.MODULE$.ZerglingSpeed().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Zerg$.MODULE$.Zergling().apply(unit) && Zerg$.MODULE$.ZerglingAttackSpeed().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Zerg$.MODULE$.Hydralisk().apply(unit) && Zerg$.MODULE$.HydraliskSpeed().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Zerg$.MODULE$.Hydralisk().apply(unit) && Zerg$.MODULE$.HydraliskRange().apply(player)) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.2);
        }
        if (Zerg$.MODULE$.Lurker().apply(unit) && !unit.burrowed()) {
            unit.skimStrength_$eq(unit.skimStrength() * 0.8);
        }
        if (Protoss$.MODULE$.Zealot().apply(unit) && unit.presumptiveTarget().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(Skimulator$.$anonfun$predict$39(unit, t)))) {
            unit.skimStrength_$eq(unit.skimStrength() * 1.3);
        }
        unit.skimMagic_$eq(0.0);
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Terran$.MODULE$.ScienceVessel().apply(unit)) * casts100 * 1.5));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Terran$.MODULE$.Battlecruiser().apply(unit)) * casts150 * 2.5));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Terran$.MODULE$.Ghost().apply(unit) && Terran$.MODULE$.Lockdown().apply(player)) * casts100 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsMechWarrior$.MODULE$) / 1), 1.0, 1.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Protoss$.MODULE$.HighTemplar().apply(unit) && Protoss$.MODULE$.PsionicStorm().apply(player)) * casts75 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsWarrior$.MODULE$) / 8), 1.0, 2.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Protoss$.MODULE$.DarkArchon().apply(unit) && Protoss$.MODULE$.Maelstrom().apply(player)) * casts100 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsBioWarrior$.MODULE$) / 4), 1.0, 4.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Protoss$.MODULE$.Arbiter().apply(unit) && Protoss$.MODULE$.Stasis().apply(player)) * casts100 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsWarrior$.MODULE$) / 4), 1.0, 8.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Protoss$.MODULE$.Corsair().apply(unit) && Protoss$.MODULE$.DisruptionWeb().apply(player)) * casts125 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsGroundWarrior$.MODULE$) / 4), 1.0, 3.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Zerg$.MODULE$.Queen().apply(unit) && Zerg$.MODULE$.Ensnare().apply(player)) * casts100 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsWarrior$.MODULE$) / 12), 1.0, 2.0)));
        unit.skimMagic_$eq(Math.max(unit.skimMagic(), (double)Maff$.MODULE$.fromBoolean(Zerg$.MODULE$.Defiler().apply(unit)) * casts100 * Maff$.MODULE$.clamp((double)(team$3.opponent().count(IsWarrior$.MODULE$) / 4), 1.0, 4.0)));
        unit.skimStrength_$eq(unit.skimStrength() + unit.skimMagic());
        unit.skimStrength_$eq(unit.skimStrength() * unit.skimPresence());
        if (!unit.complete() || unit.stasised() || unit.maelstrommed() || unit.unitClass().canAttack() && unit.underDisruptionWeb() || unit.unitClass().canBeStormed() && unit.underStorm() || unit.lockedDown() || unit.underDarkSwarm() && unit.unitClass().affectedByDarkSwarm()) {
            unit.skimStrength_$eq(unit.skimStrength() * BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(unit.isFriendly(), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0, (JFunction0$mcD$sp & scala.Serializable)() -> -0.25)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$predict$19(Battle battle$1, Team team) {
        team.units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            Skimulator$.$anonfun$predict$20(team, battle$1, unit);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$predict$43(Team team$4, UnitInfo unit) {
        team$4.skimStrengthTotal_$eq(team$4.skimStrengthTotal() + unit.skimStrength());
        team$4.skimStrengthAir_$eq(team$4.skimStrengthAir() + unit.skimStrength() * (double)Maff$.MODULE$.fromBoolean(unit.flying()));
        team$4.skimStrengthGround_$eq(team$4.skimStrengthGround() + unit.skimStrength() * (double)Maff$.MODULE$.fromBoolean(!unit.flying()));
        team$4.skimStrengthVsAir_$eq(team$4.skimStrengthVsAir() + unit.skimStrength() * (double)Maff$.MODULE$.fromBoolean(unit.canAttackAir() || !unit.canAttack()));
        team$4.skimStrengthVsGround_$eq(team$4.skimStrengthVsGround() + unit.skimStrength() * (double)Maff$.MODULE$.fromBoolean(unit.canAttackGround() || !unit.canAttack() || Protoss$.MODULE$.Corsair().apply(unit) && unit.skimMagic() > 0.0));
    }

    public static final /* synthetic */ void $anonfun$predict$42(Team team) {
        team.units().foreach((Function1<UnitInfo, Object> & Serializable & scala.Serializable)unit -> {
            Skimulator$.$anonfun$predict$43(team, unit);
            return BoxedUnit.UNIT;
        });
    }

    private Skimulator$() {
        MODULE$ = this;
    }
}

