/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Color;
import bwapi.Game;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import info.GameState;
import info.InformationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bk.ass.sim.BWMirrorAgentFactory;
import org.bk.ass.sim.Simulator;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import unit.squad.Squad;
import unit.squad.SquadStatus;
import util.Filter;
import util.UnitDistanceComparator;

public class SquadManager {
    private Game game;
    private GameState gameState;
    private BWMirrorAgentFactory agentFactory;
    private InformationManager informationManager;
    private Squad overlords = new Squad();
    private HashSet<Squad> fightSquads = new HashSet();
    private HashMap<Base, Squad> defenseSquads = new HashMap();

    public SquadManager(Game game, GameState gameState, InformationManager informationManager) {
        this.game = game;
        this.gameState = gameState;
        this.informationManager = informationManager;
        this.agentFactory = new BWMirrorAgentFactory();
    }

    public void updateOverlordSquad() {
        TilePosition mainBaseLocation = this.gameState.getBaseData().mainBasePosition();
        if (this.overlords.getRallyPoint() == null) {
            this.overlords.setRallyPoint(mainBaseLocation);
        }
        for (ManagedUnit managedUnit : this.overlords.getMembers()) {
            if (managedUnit.getUnit().getDistance(mainBaseLocation.toPosition()) < 16) {
                managedUnit.setRole(UnitRole.IDLE);
                continue;
            }
            managedUnit.setRole(UnitRole.RETREAT);
            managedUnit.setRetreatTarget(mainBaseLocation);
        }
    }

    public void updateFightSquads() {
        this.debugPainters();
        this.removeEmptySquads();
        this.mergeSquads();
        for (Squad fightSquad : this.fightSquads) {
            fightSquad.onFrame();
            this.rallyOrFight(fightSquad);
        }
    }

    public void updateDefenseSquads() {
        this.ensureDefenderSquadsHaveTargets();
    }

    public List<ManagedUnit> assignGathererDefenders(Base base, HashSet<ManagedUnit> baseUnits, List<Unit> hostileUnits) {
        this.ensureDefenseSquad(base);
        Squad defenseSquad = this.defenseSquads.get(base);
        ArrayList<ManagedUnit> reassignedGatherers = new ArrayList<ManagedUnit>();
        if (baseUnits.size() < 3 || baseUnits.size() - reassignedGatherers.size() < 3) {
            return reassignedGatherers;
        }
        for (ManagedUnit gatherer : baseUnits) {
            Boolean canClear = this.canDefenseSquadClearThreat(defenseSquad, hostileUnits);
            if (canClear.booleanValue()) break;
            defenseSquad.addUnit(gatherer);
            reassignedGatherers.add(gatherer);
        }
        for (ManagedUnit managedUnit : reassignedGatherers) {
            managedUnit.setRole(UnitRole.DEFEND);
            this.assignDefenderTarget(managedUnit, hostileUnits);
        }
        return reassignedGatherers;
    }

    public List<ManagedUnit> disbandDefendSquad(Base base) {
        this.ensureDefenseSquad(base);
        Squad defenseSquad = this.defenseSquads.get(base);
        ArrayList<ManagedUnit> reassignedDefenders = new ArrayList<ManagedUnit>();
        for (ManagedUnit defender : defenseSquad.getMembers()) {
            reassignedDefenders.add(defender);
        }
        for (ManagedUnit defender : reassignedDefenders) {
            defenseSquad.removeUnit(defender);
        }
        return reassignedDefenders;
    }

    private void ensureDefenseSquad(Base base) {
        if (!this.defenseSquads.containsKey(base)) {
            Squad squad = new Squad();
            squad.setCenter(base.getCenter());
            squad.setRallyPoint(base.getLocation());
            this.defenseSquads.put(base, squad);
        }
    }

    private void assignDefenderTarget(ManagedUnit defender, List<Unit> threats) {
        if (defender.getDefendTarget() != null) {
            return;
        }
        threats.sort(new UnitDistanceComparator(defender.getUnit()));
        defender.setDefendTarget(threats.get(0));
    }

    private void ensureDefenderSquadsHaveTargets() {
        for (Base base : this.defenseSquads.keySet()) {
            HashSet<Unit> baseThreats;
            this.ensureDefenseSquad(base);
            Squad squad = this.defenseSquads.get(base);
            if (this.defenseSquads.size() == 0 || (baseThreats = this.gameState.getBaseToThreatLookup().get(base)) == null || baseThreats.size() == 0) continue;
            for (ManagedUnit defender : squad.getMembers()) {
                this.ensureDefenderHasTarget(defender, baseThreats);
            }
        }
    }

    private void ensureDefenderHasTarget(ManagedUnit defender, HashSet<Unit> baseThreats) {
        if (!defender.isReady()) {
            return;
        }
        if (defender.getDefendTarget() != null) {
            return;
        }
        this.assignDefenderTarget(defender, baseThreats.stream().collect(Collectors.toList()));
    }

    private void removeEmptySquads() {
        ArrayList<Squad> emptySquads = new ArrayList<Squad>();
        for (Squad squad : this.fightSquads) {
            if (squad.size() != 0) continue;
            emptySquads.add(squad);
        }
        for (Squad squad : emptySquads) {
            this.fightSquads.remove(squad);
        }
    }

    private void mergeSquads() {
        if (this.game.getFrameCount() % 50 != 0) {
            return;
        }
        ArrayList toMerge = new ArrayList();
        HashSet<Squad> considered = new HashSet<Squad>();
        for (Squad squad : this.fightSquads) {
            for (Squad squad2 : this.fightSquads) {
                if (squad == squad2 || considered.contains(squad) || considered.contains(squad2) || squad.distance(squad2) >= 256) continue;
                HashSet<Squad> mergeSet = new HashSet<Squad>();
                mergeSet.add(squad);
                mergeSet.add(squad2);
                considered.add(squad);
                considered.add(squad2);
                toMerge.add(mergeSet);
            }
        }
        for (Set set : toMerge) {
            Squad newSquad = new Squad();
            newSquad.setStatus(SquadStatus.FIGHT);
            newSquad.setRallyPoint(this.getRallyPoint(newSquad));
            for (Squad mergingSquad : set) {
                newSquad.merge(mergingSquad);
                this.fightSquads.remove(mergingSquad);
            }
            this.fightSquads.add(newSquad);
        }
    }

    private List<Unit> enemyUnitsNearSquad(Squad squad) {
        double d;
        HashSet<Unit> enemyUnits = this.informationManager.getVisibleEnemyUnits();
        HashSet<Unit> enemyBuildings = this.informationManager.getEnemyBuildings();
        ArrayList<Unit> enemies = new ArrayList<Unit>();
        for (Unit u : enemyUnits) {
            d = u.getPosition().getDistance(squad.getCenter());
            if (d > 256.0) continue;
            enemies.add(u);
        }
        for (Unit u : enemyBuildings) {
            d = u.getPosition().getDistance(squad.getCenter());
            if (d > 256.0) continue;
            enemies.add(u);
        }
        return enemies;
    }

    private void rallySquad(Squad squad) {
        TilePosition rallyPoint = this.getRallyPoint(squad);
        for (ManagedUnit managedUnit : squad.getMembers()) {
            managedUnit.setRallyPoint(rallyPoint);
            managedUnit.setRole(UnitRole.RALLY);
        }
    }

    private TilePosition getRallyPoint(Squad squad) {
        List eligibleSquads = this.fightSquads.stream().filter(s -> s != squad).filter(s -> s.getStatus() == SquadStatus.FIGHT).collect(Collectors.toList());
        Base enemyMainBase = this.gameState.getBaseData().getMainEnemyBase();
        if (eligibleSquads.size() > 1 && enemyMainBase != null) {
            Squad best = null;
            for (Squad s2 : eligibleSquads) {
                if (best == null) {
                    best = s2;
                    continue;
                }
                double bestDistance = best.getCenter().getDistance(enemyMainBase.getCenter());
                double candidateDistance = s2.getCenter().getDistance(enemyMainBase.getCenter());
                if (!(candidateDistance < bestDistance)) continue;
                best = s2;
            }
            return best.getCenter().toTilePosition();
        }
        return this.informationManager.getRallyPoint();
    }

    private void rallyOrFight(Squad squad) {
        SquadStatus squadStatus = squad.getStatus();
        if (squadStatus == SquadStatus.RETREAT) {
            return;
        }
        int staticDefensePenalty = Math.min(this.informationManager.getEnemyHostileToGroundBuildingsCount(), 5);
        int moveOutThreshold = 5 * (1 + staticDefensePenalty);
        if (squadStatus == SquadStatus.FIGHT) {
            moveOutThreshold /= 2;
        }
        if (this.enemyUnitsNearSquad(squad).size() > 0 || squad.size() > moveOutThreshold) {
            this.simulateFightSquad(squad);
        } else {
            this.rallySquad(squad);
        }
    }

    private void simulateFightSquad(Squad squad) {
        float percentRemaining;
        HashSet<ManagedUnit> managedFighters = squad.getMembers();
        HashSet<Unit> enemyBuildings = this.informationManager.getEnemyBuildings();
        Unit closest = Filter.closestHostileUnit(squad.getCenter(), enemyBuildings.stream().collect(Collectors.toList()));
        if (!this.informationManager.isEnemyUnitVisible() && enemyBuildings.size() > 0) {
            squad.setStatus(SquadStatus.FIGHT);
            for (ManagedUnit managedUnit : squad.getMembers()) {
                managedUnit.setRole(UnitRole.FIGHT);
                managedUnit.setMovementTargetPosition(closest.getTilePosition());
            }
        }
        HashSet<Unit> enemyUnits = this.informationManager.getVisibleEnemyUnits();
        Simulator simulator = new Simulator.Builder().build();
        for (ManagedUnit managedUnit : managedFighters) {
            simulator.addAgentA(this.agentFactory.of(managedUnit.getUnit()));
        }
        for (Unit unit : enemyUnits) {
            if (unit.getType() == UnitType.Unknown || (int)unit.getPosition().getDistance(squad.getCenter()) > 256 || unit.isBeingConstructed() || unit.isMorphing() || unit.getType().isWorker()) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(unit));
            }
            catch (ArithmeticException e) {
                return;
            }
        }
        for (Unit unit : enemyBuildings) {
            if (!Filter.isHostileBuilding(unit.getType()) || (int)unit.getPosition().getDistance(squad.getCenter()) > 512) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(unit));
            }
            catch (ArithmeticException e) {
                return;
            }
        }
        simulator.simulate(150);
        if (simulator.getAgentsA().isEmpty()) {
            squad.setStatus(SquadStatus.RETREAT);
            for (ManagedUnit managedUnit : managedFighters) {
                managedUnit.setRole(UnitRole.RETREAT);
                managedUnit.setRetreatTarget(this.getRallyPoint(squad));
            }
            return;
        }
        if (!simulator.getAgentsB().isEmpty() && (double)(percentRemaining = (float)simulator.getAgentsA().size() / (float)managedFighters.size()) < 0.2) {
            squad.setStatus(SquadStatus.RETREAT);
            for (ManagedUnit managedUnit : managedFighters) {
                managedUnit.setRole(UnitRole.RETREAT);
                managedUnit.setRetreatTarget(this.getRallyPoint(squad));
            }
            return;
        }
        squad.setStatus(SquadStatus.FIGHT);
        for (ManagedUnit managedUnit : managedFighters) {
            managedUnit.setRole(UnitRole.FIGHT);
        }
    }

    private boolean canDefenseSquadClearThreat(Squad squad, List<Unit> enemyUnits) {
        HashSet<ManagedUnit> managedDefenders = squad.getMembers();
        Simulator simulator = new Simulator.Builder().build();
        for (ManagedUnit managedUnit : managedDefenders) {
            if (managedUnit.getUnit().getType() == UnitType.Unknown) continue;
            simulator.addAgentA(this.agentFactory.of(managedUnit.getUnit()));
        }
        for (Unit enemyUnit : enemyUnits) {
            if (enemyUnit.getType() == UnitType.Unknown || (int)enemyUnit.getPosition().getDistance(squad.getCenter()) > 256) continue;
            try {
                simulator.addAgentB(this.agentFactory.of(enemyUnit));
            }
            catch (ArithmeticException e) {
                return false;
            }
        }
        simulator.simulate(150);
        if (simulator.getAgentsB().isEmpty()) {
            return true;
        }
        if (simulator.getAgentsA().isEmpty()) {
            return false;
        }
        float percentRemaining = (float)simulator.getAgentsA().size() / (float)managedDefenders.size();
        return (double)percentRemaining >= 0.5;
    }

    public void addManagedUnit(ManagedUnit managedUnit) {
        if (managedUnit.getUnitType() == UnitType.Zerg_Overlord) {
            this.addManagedOverlord(managedUnit);
            return;
        }
        this.addManagedFighter(managedUnit);
    }

    private void addManagedFighter(ManagedUnit managedUnit) {
        Squad squad = this.findCloseSquad(managedUnit);
        if (squad == null) {
            squad = this.newFightSquad();
        }
        squad.addUnit(managedUnit);
        this.simulateFightSquad(squad);
    }

    private Squad findCloseSquad(ManagedUnit managedUnit) {
        for (Squad squad : this.fightSquads) {
            if (squad.distance(managedUnit) >= 256) continue;
            return squad;
        }
        return null;
    }

    private Squad newFightSquad() {
        Squad newSquad = new Squad();
        newSquad.setStatus(SquadStatus.FIGHT);
        newSquad.setRallyPoint(this.getRallyPoint(newSquad));
        this.fightSquads.add(newSquad);
        return newSquad;
    }

    private void addManagedOverlord(ManagedUnit overlord) {
        this.overlords.addUnit(overlord);
    }

    public void removeManagedUnit(ManagedUnit managedUnit) {
        UnitType unitType = managedUnit.getUnitType();
        if (unitType != null && unitType == UnitType.Zerg_Overlord) {
            this.removeManagedOverlord(managedUnit);
            return;
        }
        this.removeManagedFigher(managedUnit);
    }

    private void removeManagedFigher(ManagedUnit managedUnit) {
        for (Squad squad : this.fightSquads) {
            if (!squad.containsManagedUnit(managedUnit)) continue;
            squad.removeUnit(managedUnit);
            return;
        }
        for (Base base : this.defenseSquads.keySet()) {
            Squad squad = this.defenseSquads.get(base);
            squad.removeUnit(managedUnit);
        }
    }

    private void removeManagedOverlord(ManagedUnit overlord) {
        this.overlords.removeUnit(overlord);
    }

    private void debugPainters() {
        for (Squad squad : this.fightSquads) {
            this.game.drawCircleMap(squad.getCenter(), 256, Color.White);
        }
        for (Squad squad : this.defenseSquads.values()) {
            this.game.drawCircleMap(squad.getCenter(), 256, Color.White);
            this.game.drawTextMap(squad.getCenter(), String.format("Defenders: %s", squad.size()), Text.White);
        }
    }
}

