/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Position;
import bwapi.TilePosition;
import java.util.HashSet;
import java.util.UUID;
import unit.managed.ManagedUnit;
import unit.squad.SquadStatus;

public class Squad {
    private final String id = UUID.randomUUID().toString();
    private HashSet<ManagedUnit> members = new HashSet();
    private TilePosition rallyPoint;
    private Position center;
    private int radius;
    private SquadStatus status;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Squad)) {
            return false;
        }
        Squad s = (Squad)other;
        return this.id.equals(s.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int distance(Squad other) {
        return (int)this.center.getDistance(other.getCenter());
    }

    public int distance(ManagedUnit managedUnit) {
        return (int)this.center.getDistance(managedUnit.getUnit().getPosition());
    }

    public void onFrame() {
        this.calculateCenter();
    }

    public void addUnit(ManagedUnit managedUnit) {
        this.members.add(managedUnit);
    }

    public void removeUnit(ManagedUnit managedUnit) {
        this.members.remove(managedUnit);
    }

    public int size() {
        return this.members.size();
    }

    public boolean containsManagedUnit(ManagedUnit managedUnit) {
        return this.members.contains(managedUnit);
    }

    public void merge(Squad other) {
        for (ManagedUnit managedUnit : other.getMembers()) {
            this.members.add(managedUnit);
        }
    }

    public Position getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    private void calculateCenter() {
        int y = 0;
        int x = 0;
        for (ManagedUnit managedUnit : this.members) {
            Position position = managedUnit.getUnit().getPosition();
            x += position.getX();
            y += position.getY();
        }
        this.center = new Position(x / this.members.size(), y / this.members.size());
    }

    public String getId() {
        return this.id;
    }

    public HashSet<ManagedUnit> getMembers() {
        return this.members;
    }

    public TilePosition getRallyPoint() {
        return this.rallyPoint;
    }

    public int getRadius() {
        return this.radius;
    }

    public SquadStatus getStatus() {
        return this.status;
    }

    public void setMembers(HashSet<ManagedUnit> members) {
        this.members = members;
    }

    public void setRallyPoint(TilePosition rallyPoint) {
        this.rallyPoint = rallyPoint;
    }

    public void setCenter(Position center) {
        this.center = center;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setStatus(SquadStatus status) {
        this.status = status;
    }

    public String toString() {
        return "Squad(id=" + this.getId() + ", members=" + this.getMembers() + ", rallyPoint=" + this.getRallyPoint() + ", center=" + this.getCenter() + ", radius=" + this.getRadius() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }
}

