/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bk.ass.cluster.Cluster;
import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.query.PositionQueries;

public class StableDBScanner<U> {
    private final Collection<U> db;
    private final int minPoints;
    private Function<U, Collection<U>> inRadiusFinder;
    private final UnorderedCollection<WrappedElement<U>> remainingDbEntries = new UnorderedCollection();
    private final UnorderedCollection<WrappedElement<U>> horizon = new UnorderedCollection();
    private Map<U, WrappedElement<U>> elementToWrapper = Collections.emptyMap();
    private Map<U, Cluster<U>> elementToCluster = Collections.emptyMap();
    private ClusterSurrogate<U> currentCluster;

    public StableDBScanner(PositionQueries<U> positionQueries, int minPoints, int radius) {
        this(positionQueries, minPoints, u -> positionQueries.inRadius(u, radius));
    }

    public StableDBScanner(int minPoints) {
        this(new ArrayList(), minPoints, unused -> Collections.emptyList());
    }

    public StableDBScanner(Collection<U> db, int minPoints, Function<U, Collection<U>> inRadiusFinder) {
        this.db = db;
        this.minPoints = minPoints;
        this.inRadiusFinder = inRadiusFinder;
    }

    public Cluster<U> getClusterOf(U element) {
        return this.elementToCluster.get(element);
    }

    public Collection<Cluster<U>> getClusters() {
        return new HashSet<Cluster<U>>(this.elementToCluster.values());
    }

    public StableDBScanner<U> updateDB(Collection<U> db, Function<U, Collection<U>> inRadiusFinder) {
        this.inRadiusFinder = inRadiusFinder;
        this.db.clear();
        this.db.addAll(db);
        return this;
    }

    public StableDBScanner<U> updateDB(PositionQueries<U> positionQueries, int radius) {
        return this.updateDB(positionQueries, u -> positionQueries.inRadius(u, radius));
    }

    public final boolean isComplete() {
        return this.remainingDbEntries.isEmpty();
    }

    public StableDBScanner<U> scan(int maxMarkedElements) {
        if (this.isComplete()) {
            this.reset();
        }
        while (!(this.remainingDbEntries.isEmpty() && this.horizon.isEmpty() || maxMarkedElements == 0)) {
            List<WrappedElement<U>> n;
            while (!this.horizon.isEmpty() && maxMarkedElements-- != 0) {
                WrappedElement<U> q = this.horizon.removeAt(0);
                if (q.cluster == null) {
                    this.setCluster(q, this.currentCluster);
                }
                if (q.marked) continue;
                q.cluster.elements.remove(q);
                this.setCluster(q, this.currentCluster);
                List<WrappedElement<U>> qn = this.elementsWithinRadius(q);
                if (qn.size() < this.minPoints) continue;
                this.horizon.addAll((Collection<WrappedElement<U>>)qn);
            }
            if (!this.horizon.isEmpty() || this.remainingDbEntries.isEmpty()) continue;
            WrappedElement<U> p = this.remainingDbEntries.removeAt(0);
            if (p.marked || (n = this.elementsWithinRadius(p)).size() < this.minPoints) continue;
            this.currentCluster = p.cluster == null ? new ClusterSurrogate() : p.cluster;
            this.currentCluster.elements.forEach(w -> {
                w.cluster = null;
            });
            this.currentCluster.elements.clear();
            this.horizon.addAll((Collection<WrappedElement<U>>)n);
        }
        if (this.remainingDbEntries.isEmpty()) {
            this.noiseToNewClusters();
            this.updateElementClusters();
            this.remainingDbEntries.clearReferences();
        }
        return this;
    }

    private void updateElementClusters() {
        this.elementToCluster = this.elementToWrapper.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            ClusterSurrogate clusterSurrogate = ((WrappedElement)e.getValue()).cluster;
            if (clusterSurrogate == null) {
                Cluster cluster = new Cluster();
                cluster.elements.add(e.getKey());
                return cluster;
            }
            Cluster cluster = clusterSurrogate.cluster;
            cluster.elements.clear();
            clusterSurrogate.elements.forEach(w -> cluster.elements.add(w.element));
            return cluster;
        }));
    }

    private void noiseToNewClusters() {
        for (WrappedElement<U> it : this.elementToWrapper.values()) {
            if (it.marked) continue;
            if (it.cluster == null) {
                ClusterSurrogate clusterSurrogate = new ClusterSurrogate();
                clusterSurrogate.elements.add(it);
                it.cluster = clusterSurrogate;
                continue;
            }
            for (WrappedElement other : it.cluster.elements) {
                if (other == it) continue;
                other.cluster = null;
            }
            it.cluster.elements.clear();
            it.cluster.elements.add(it);
        }
    }

    private void reset() {
        IdentityHashMap<U, WrappedElement<U>> newElementToWrapper = new IdentityHashMap<U, WrappedElement<U>>();
        for (U element : this.db) {
            WrappedElement<U> wrappedElement = this.elementToWrapper.get(element);
            if (wrappedElement == null) {
                wrappedElement = new WrappedElement<U>(element);
            } else {
                wrappedElement.marked = false;
            }
            this.remainingDbEntries.add(wrappedElement);
            newElementToWrapper.put(element, wrappedElement);
        }
        this.elementToWrapper = newElementToWrapper;
    }

    private List<WrappedElement<U>> elementsWithinRadius(WrappedElement<U> q) {
        return this.inRadiusFinder.apply(q.element).stream().map(u -> this.elementToWrapper.get(u)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void setCluster(WrappedElement<U> element, ClusterSurrogate<U> newCluster) {
        element.marked = true;
        element.cluster = newCluster;
        newCluster.elements.add(element);
    }

    private static class WrappedElement<U> {
        final U element;
        ClusterSurrogate<U> cluster;
        boolean marked;

        WrappedElement(U element) {
            this.element = element;
        }
    }

    private static class ClusterSurrogate<U> {
        final Collection<WrappedElement<U>> elements = new ArrayList<WrappedElement<U>>();
        final Cluster<U> cluster = new Cluster();

        private ClusterSurrogate() {
        }
    }
}

