/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwem.Base;
import info.BaseData;
import info.GameState;
import info.ResourceCount;
import info.TechProgression;
import info.UnitTypeCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import planner.Plan;
import planner.PlanComparator;
import planner.PlanState;
import planner.PlanType;
import strategy.openers.Opener;
import strategy.openers.OpenerName;
import strategy.strategies.UnitWeights;

public class ProductionManager {
    final int FRAME_ZVZ_HATCH_RESTRICT = 7200;
    private Game game;
    private GameState gameState;
    private boolean isPlanning = false;
    private int scheduledBuildings = 0;
    private int currentFrame = 5;
    private int plannedHatcheries = 1;
    private int plannedWorkers = 0;
    private int macroHatchMod = 0;
    private PriorityQueue<Plan> productionQueue = new PriorityQueue<Plan>(new PlanComparator());

    public ProductionManager(Game game, GameState gameState, List<Plan> initialBuildOrder) {
        this.game = game;
        this.gameState = gameState;
        this.init(initialBuildOrder);
    }

    private boolean firstHatchInBase(Opener opener) {
        if (opener.getName() == OpenerName.NINE_HATCH_IN_BASE) {
            this.macroHatchMod = 1;
            return true;
        }
        return false;
    }

    private void init(List<Plan> initialBuildOrder) {
        TechProgression techProgression = this.gameState.getTechProgression();
        BaseData baseData = this.gameState.getBaseData();
        Opener opener = this.gameState.getActiveOpener();
        for (Plan plan : initialBuildOrder) {
            if (plan.getPlannedUnit() != null && plan.getPlannedUnit() == UnitType.Zerg_Extractor) {
                Unit geyser = baseData.reserveExtractor();
                plan.setBuildPosition(geyser.getTilePosition());
            }
            if (plan.getPlannedUnit() != null && plan.getPlannedUnit() == UnitType.Zerg_Hatchery && !this.firstHatchInBase(opener)) {
                Base base = this.gameState.reserveBase();
                plan.setBuildPosition(base.getLocation());
            }
            if (plan.getPlannedUnit() != null && plan.getPlannedUnit() == UnitType.Zerg_Drone) {
                ++this.plannedWorkers;
            }
            if (plan.getPlannedUnit() != null && plan.getPlannedUnit() == UnitType.Zerg_Spawning_Pool) {
                techProgression.setPlannedSpawningPool(true);
            }
            if (plan.getType() == PlanType.UPGRADE && plan.getPlannedUpgrade() == UpgradeType.Metabolic_Boost) {
                techProgression.setPlannedMetabolicBoost(true);
            }
            this.productionQueue.add(plan);
        }
    }

    private void debugProductionQueue() {
        int numDisplayed = 0;
        int x = 4;
        int y = 64;
        for (Plan plan : this.productionQueue) {
            this.game.drawTextScreen(x, y, plan.getName() + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed != 10) continue;
            break;
        }
        if (numDisplayed < this.productionQueue.size()) {
            this.game.drawTextScreen(x, y, String.format("... %s more planned items", this.productionQueue.size() - numDisplayed), Text.GreyGreen);
        }
    }

    private void debugInProgressQueue() {
        int numDisplayed = 0;
        int x = 100;
        int y = 64;
        for (Plan plan : this.gameState.getAssignedPlannedItems().values()) {
            this.game.drawTextScreen(x, y, plan.getName() + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed != 10) continue;
            break;
        }
    }

    private void debugScheduledPlannedItems() {
        int numDisplayed = 0;
        int x = 196;
        int y = 64;
        for (Plan plan : this.gameState.getPlansScheduled()) {
            this.game.drawTextScreen(x, y, plan.getName() + " " + plan.getPriority(), Text.Green);
            y += 8;
            if (++numDisplayed != 10) continue;
            break;
        }
    }

    private void planBase() {
        Base base = this.gameState.reserveBase();
        if (base == null) {
            return;
        }
        this.productionQueue.add(new Plan(UnitType.Zerg_Hatchery, 2, true, true, base.getLocation()));
    }

    private void debug() {
        this.debugProductionQueue();
        this.debugInProgressQueue();
        this.debugScheduledPlannedItems();
    }

    public void onFrame() {
        this.debug();
        this.currentFrame = this.game.getFrameCount();
        this.plan();
        this.schedulePlannedItems();
        this.buildUpgrades();
        for (Unit u : this.game.getAllUnits()) {
            if (!u.getType().isWorker() || !u.isIdle()) continue;
            this.assignUnit(u);
        }
    }

    private boolean canPlanDrone() {
        int expectedWorkers = this.expectedWorkers();
        return this.plannedWorkers < 3 && this.numWorkers() < 80 && this.numWorkers() < expectedWorkers;
    }

    private int expectedWorkers() {
        int base = 5;
        int expectedMineralWorkers = this.gameState.getBaseData().currentBaseCount() * 7;
        int expectedGasWorkers = this.gameState.getGeyserAssignments().size() * 3;
        Race race = this.gameState.getOpponentRace();
        switch (race) {
            case Zerg: {
                return Math.min(expectedMineralWorkers, 7) + expectedGasWorkers;
            }
        }
        return 5 + expectedMineralWorkers + expectedGasWorkers;
    }

    private int numWorkers() {
        return this.gameState.getMineralWorkers() + this.gameState.getGeyserWorkers();
    }

    private boolean canPlanHatchery(boolean isAllIn) {
        if (isAllIn) {
            return false;
        }
        if (this.plannedHatcheries >= 3) {
            return false;
        }
        if (this.gameState.getOpponentRace() == Race.Zerg && this.currentFrame <= 7200) {
            return false;
        }
        if (this.canAffordHatch()) {
            return true;
        }
        return this.isNearMaxExpectedWorkers() && this.canAffordHatchSaturation();
    }

    private void planBuildings(Player self, Boolean isAllIn) {
        TechProgression techProgression = this.gameState.getTechProgression();
        BaseData baseData = this.gameState.getBaseData();
        if (this.canPlanHatchery(isAllIn)) {
            ++this.plannedHatcheries;
            int numHatcheries = this.gameState.getBaseData().numHatcheries();
            if (numHatcheries % 2 != this.macroHatchMod) {
                this.planBase();
            } else {
                this.productionQueue.add(new Plan(UnitType.Zerg_Hatchery, 2, true, true));
            }
        }
        if (this.canPlanExtractor(isAllIn)) {
            Plan plan = new Plan(UnitType.Zerg_Extractor, this.currentFrame, true, true);
            Unit geyser = baseData.reserveExtractor();
            plan.setBuildPosition(geyser.getTilePosition());
            this.productionQueue.add(plan);
        }
        if (techProgression.canPlanPool()) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Spawning_Pool, this.currentFrame, true, true));
            techProgression.setPlannedSpawningPool(true);
        }
        if (isAllIn.booleanValue()) {
            return;
        }
        if (this.canPlanSunkenColony(techProgression, baseData)) {
            TilePosition tp = baseData.reserveSunkenColony();
            tp = this.game.getBuildLocation(UnitType.Zerg_Creep_Colony, tp, 128, true);
            Plan creepColonyPlan = new Plan(UnitType.Zerg_Creep_Colony, this.currentFrame - 2, true, true);
            Plan sunkenColonyPlan = new Plan(UnitType.Zerg_Sunken_Colony, this.currentFrame - 1, true, true);
            creepColonyPlan.setBuildPosition(tp);
            sunkenColonyPlan.setBuildPosition(tp);
            this.productionQueue.add(creepColonyPlan);
            this.productionQueue.add(sunkenColonyPlan);
        }
        UnitWeights unitWeights = this.gameState.getUnitWeights();
        if (techProgression.canPlanHydraliskDen() && unitWeights.hasUnit(UnitType.Zerg_Hydralisk)) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Hydralisk_Den, this.currentFrame, true, true));
            techProgression.setPlannedDen(true);
        }
        if (this.canPlanEvolutionChamber(techProgression)) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Evolution_Chamber, this.currentFrame, true, true));
            int currentEvolutionChambers = techProgression.evolutionChambers();
            techProgression.setPlannedEvolutionChambers(currentEvolutionChambers + 1);
        }
        if (this.gameState.canPlanLair()) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Lair, this.currentFrame, true, false));
            techProgression.setPlannedLair(true);
        }
        if (techProgression.canPlanSpire() && unitWeights.hasUnit(UnitType.Zerg_Mutalisk)) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Spire, this.currentFrame, true, true));
            techProgression.setPlannedSpire(true);
        }
        if (this.gameState.canPlanQueensNest()) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Queens_Nest, this.currentFrame, true, true));
            techProgression.setPlannedQueensNest(true);
        }
        if (this.gameState.canPlanHive()) {
            this.productionQueue.add(new Plan(UnitType.Zerg_Hive, this.currentFrame, true, true));
            techProgression.setPlannedHive(true);
        }
    }

    private boolean canPlanEvolutionChamber(TechProgression techProgression) {
        UnitTypeCount count = this.gameState.getUnitTypeCount();
        if (!techProgression.canPlanEvolutionChamber()) {
            return false;
        }
        int numEvolutionChambers = techProgression.evolutionChambers();
        int groundCount = count.groundCount();
        if (numEvolutionChambers == 0) {
            return groundCount > 24;
        }
        return groundCount > 48;
    }

    private boolean canPlanSunkenColony(TechProgression techProgression, BaseData baseData) {
        boolean defensiveSunk = this.gameState.isDefensiveSunk();
        return defensiveSunk && techProgression.canPlanSunkenColony() && baseData.canPlanSunkenColony();
    }

    private boolean canPlanExtractor(Boolean isAllIn) {
        BaseData baseData = this.gameState.getBaseData();
        TechProgression techProgression = this.gameState.getTechProgression();
        return isAllIn == false && techProgression.canPlanExtractor() && baseData.canReserveExtractor() && (baseData.numExtractor() < 1 || this.needExtractor());
    }

    private boolean needExtractor() {
        BaseData baseData = this.gameState.getBaseData();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        return baseData.numExtractor() < 1 || resourceCount.needExtractor();
    }

    private void planUpgrades(Boolean isAllIn) {
        BaseData baseData = this.gameState.getBaseData();
        if (baseData.numExtractor() == 0 || isAllIn.booleanValue()) {
            return;
        }
        TechProgression techProgression = this.gameState.getTechProgression();
        UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
        int numZerglings = unitTypeCount.get(UnitType.Zerg_Zergling);
        if (techProgression.canPlanMetabolicBoost() && numZerglings > 8) {
            this.productionQueue.add(new Plan(UpgradeType.Metabolic_Boost, this.currentFrame, false));
            techProgression.setPlannedMetabolicBoost(true);
        }
        int numHydralisks = unitTypeCount.get(UnitType.Zerg_Hydralisk);
        if (techProgression.canPlanMuscularAugments() && numHydralisks > 4) {
            this.productionQueue.add(new Plan(UpgradeType.Muscular_Augments, this.currentFrame, false));
            techProgression.setPlannedMuscularAugments(true);
        }
        if (techProgression.canPlanGroovedSpines() && numHydralisks > 10) {
            this.productionQueue.add(new Plan(UpgradeType.Grooved_Spines, this.currentFrame, false));
            techProgression.setPlannedGroovedSpines(true);
        }
        int evoBuffer = techProgression.evolutionChamberBuffer();
        if (techProgression.canPlanCarapaceUpgrades() && unitTypeCount.groundCount() > 8) {
            this.productionQueue.add(new Plan(UpgradeType.Zerg_Carapace, this.currentFrame + evoBuffer, false));
            techProgression.setPlannedCarapaceUpgrades(true);
        }
        if (techProgression.canPlanRangedUpgrades() && unitTypeCount.rangedCount() > 12) {
            this.productionQueue.add(new Plan(UpgradeType.Zerg_Missile_Attacks, this.currentFrame + evoBuffer, false));
            techProgression.setPlannedRangedUpgrades(true);
        }
        if (techProgression.canPlanMeleeUpgrades() && unitTypeCount.meleeCount() > 18) {
            this.productionQueue.add(new Plan(UpgradeType.Zerg_Melee_Attacks, this.currentFrame + evoBuffer, false));
            techProgression.setPlannedMeleeUpgrades(true);
        }
        if (techProgression.canPlanFlyerAttack() && unitTypeCount.airCount() > 8) {
            this.productionQueue.add(new Plan(UpgradeType.Zerg_Flyer_Attacks, this.currentFrame, false));
            techProgression.setPlannedFlyerAttack(true);
        }
        if (techProgression.canPlanFlyerDefense() && unitTypeCount.airCount() > 8) {
            int flyerAttackTime = UpgradeType.Zerg_Flyer_Attacks.upgradeTime();
            this.productionQueue.add(new Plan(UpgradeType.Zerg_Flyer_Carapace, this.currentFrame + 1 + flyerAttackTime, false));
            techProgression.setPlannedFlyerDefense(true);
        }
    }

    private void planSupply(Player self) {
        int plannedSupply;
        if (self.supplyUsed() >= 400) {
            return;
        }
        int supplyRemaining = self.supplyTotal() - self.supplyUsed();
        if (supplyRemaining + (plannedSupply = this.gameState.getPlannedSupply()) < 5) {
            if (this.gameState.getBaseData().numHatcheries() > 3) {
                this.gameState.setPlannedSupply(plannedSupply + 32);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
            } else {
                this.gameState.setPlannedSupply(plannedSupply + 16);
                this.addUnitToQueue(UnitType.Zerg_Overlord, 1, true);
            }
        }
    }

    private void planUnits(Player self, Boolean isAllIn) {
        UnitWeights unitWeights;
        UnitType unitToBuild;
        if (self.supplyUsed() >= 400) {
            return;
        }
        if (!isAllIn.booleanValue() && this.canPlanDrone()) {
            ++this.plannedWorkers;
            this.addUnitToQueue(UnitType.Zerg_Drone, this.currentFrame, false);
        }
        if ((unitToBuild = (unitWeights = this.gameState.getUnitWeights()).getRandom()) == UnitType.Unknown) {
            return;
        }
        this.addUnitToQueue(unitToBuild, this.currentFrame, false);
    }

    private void addUnitToQueue(UnitType unitType, int priority, boolean isBlocking) {
        UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
        this.productionQueue.add(new Plan(unitType, priority, false, isBlocking));
        unitTypeCount.planUnit(unitType);
    }

    private void plan() {
        Player self = this.game.self();
        Boolean isAllIn = this.gameState.isAllIn();
        if (!this.isPlanning && this.productionQueue.size() > 0) {
            return;
        }
        this.isPlanning = true;
        this.planBuildings(self, isAllIn);
        this.planUpgrades(isAllIn);
        this.planSupply(self);
        if (this.productionQueue.size() >= this.unitQueueSize()) {
            return;
        }
        this.planUnits(self, isAllIn);
    }

    private int unitQueueSize() {
        if (this.gameState.getBaseData().numHatcheries() > 3) {
            return 6;
        }
        return 3;
    }

    private boolean canAffordHatchSaturation() {
        int numHatcheries = this.gameState.getBaseData().numHatcheries();
        return (numHatcheries + this.plannedHatcheries) * 7 <= this.gameState.getMineralWorkers();
    }

    private boolean canAffordHatch() {
        ResourceCount resourceCount = this.gameState.getResourceCount();
        return resourceCount.canAffordHatch(this.plannedHatcheries);
    }

    private boolean isNearMaxExpectedWorkers() {
        return this.expectedWorkers() * (1 + this.plannedHatcheries) - this.numWorkers() < 0;
    }

    private boolean canSchedulePlan(Plan plan) {
        switch (plan.getType()) {
            case UNIT: {
                return this.canScheduleUnit(plan.getPlannedUnit());
            }
            case BUILDING: {
                return this.canScheduleBuilding(plan.getPlannedUnit());
            }
            case UPGRADE: {
                return this.canScheduleUpgrade(plan.getPlannedUpgrade());
            }
        }
        return false;
    }

    private boolean canScheduleUnit(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        boolean hasFourOrMoreDrones = this.gameState.numGatherers() > 3;
        int numHatcheries = this.gameState.getBaseData().numHatcheries();
        switch (unitType) {
            case Zerg_Overlord: 
            case Zerg_Drone: {
                return numHatcheries > 0;
            }
            case Zerg_Zergling: {
                return techProgression.isPlannedSpawningPool() || techProgression.isSpawningPool();
            }
            case Zerg_Hydralisk: {
                return hasFourOrMoreDrones && (techProgression.isPlannedDen() || techProgression.isHydraliskDen());
            }
            case Zerg_Mutalisk: 
            case Zerg_Scourge: {
                return hasFourOrMoreDrones && (techProgression.isPlannedSpire() || techProgression.isSpire());
            }
        }
        return false;
    }

    private boolean canScheduleBuilding(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        int numHatcheries = this.gameState.getBaseData().numHatcheries();
        switch (unitType) {
            case Zerg_Hatchery: 
            case Zerg_Extractor: 
            case Zerg_Creep_Colony: {
                return true;
            }
            case Zerg_Spawning_Pool: {
                return numHatcheries > 0;
            }
            case Zerg_Hydralisk_Den: 
            case Zerg_Sunken_Colony: 
            case Zerg_Evolution_Chamber: {
                return techProgression.isSpawningPool();
            }
            case Zerg_Lair: {
                return numHatcheries > 0 && techProgression.isSpawningPool();
            }
            case Zerg_Spire: 
            case Zerg_Queens_Nest: {
                return techProgression.isLair();
            }
            case Zerg_Hive: {
                return techProgression.isLair() && techProgression.isQueensNest();
            }
        }
        return false;
    }

    private boolean canScheduleUpgrade(UpgradeType upgradeType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (upgradeType) {
            case Metabolic_Boost: {
                return techProgression.isSpawningPool();
            }
            case Muscular_Augments: 
            case Grooved_Spines: {
                return techProgression.isHydraliskDen();
            }
            case Zerg_Carapace: 
            case Zerg_Missile_Attacks: 
            case Zerg_Melee_Attacks: {
                return techProgression.getEvolutionChambers() > 0;
            }
            case Zerg_Flyer_Attacks: 
            case Zerg_Flyer_Carapace: {
                return techProgression.isSpire();
            }
        }
        return false;
    }

    private void schedulePlannedItems() {
        if (this.productionQueue.size() == 0) {
            return;
        }
        Player self = this.game.self();
        HashSet<Plan> scheduledPlans = this.gameState.getPlansScheduled();
        ArrayList<Plan> requeuePlans = new ArrayList<Plan>();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        int mineralBuffer = resourceCount.availableMinerals();
        for (int i = 0; i < this.productionQueue.size(); ++i) {
            boolean canSchedule = false;
            Plan plan = this.productionQueue.poll();
            if (plan == null) continue;
            if (!this.canSchedulePlan(plan)) {
                this.gameState.setImpossiblePlan(plan);
                continue;
            }
            PlanType planType = plan.getType();
            switch (planType) {
                case BUILDING: {
                    canSchedule = this.scheduleBuildingItem(plan);
                    break;
                }
                case UNIT: {
                    canSchedule = this.scheduleUnitItem(plan);
                    break;
                }
                case UPGRADE: {
                    canSchedule = this.scheduleUpgradeItem(self, plan);
                }
            }
            if (canSchedule) {
                scheduledPlans.add(plan);
                continue;
            }
            requeuePlans.add(plan);
            if (plan.isBlockOtherPlans() || (mineralBuffer -= plan.mineralPrice()) <= 0) break;
        }
        for (Plan plan : requeuePlans) {
            this.productionQueue.add(plan);
        }
    }

    private void buildUpgrades() {
        HashSet<Plan> scheduledPlans = this.gameState.getPlansScheduled();
        if (scheduledPlans.size() == 0) {
            return;
        }
        HashSet<Unit> unitsExecutingPlan = new HashSet<Unit>();
        List scheduledUpgradeAssignments = this.gameState.getAssignedPlannedItems().entrySet().stream().filter(assignment -> ((Plan)assignment.getValue()).getType() == PlanType.UPGRADE).collect(Collectors.toList());
        for (Map.Entry entry : scheduledUpgradeAssignments) {
            Plan plan;
            Unit unit = (Unit)entry.getKey();
            if (!this.buildUpgrade(unit, plan = (Plan)entry.getValue())) continue;
            unitsExecutingPlan.add(unit);
            scheduledPlans.remove(plan);
            plan.setState(PlanState.BUILDING);
            this.gameState.getPlansBuilding().add(plan);
        }
        for (Unit u : unitsExecutingPlan) {
            this.gameState.getAssignedPlannedItems().remove(u);
        }
    }

    private void plannedItemToMorphing(Plan plan) {
        UnitType unitType = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        resourceCount.unreserveUnit(unitType);
        if (unitType == UnitType.Zerg_Drone) {
            --this.plannedWorkers;
        }
        if (unitType.isBuilding()) {
            --this.scheduledBuildings;
        }
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (unitType) {
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(true);
                techProgression.setPlannedDen(false);
                break;
            }
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(true);
                techProgression.setPlannedSpawningPool(false);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(true);
                techProgression.setPlannedLair(false);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(true);
                techProgression.setPlannedSpire(false);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(true);
                techProgression.setPlannedQueensNest(false);
            }
            case Zerg_Hive: {
                techProgression.setHive(true);
                techProgression.setPlannedHive(false);
            }
        }
        this.gameState.getPlansBuilding().remove(plan);
        plan.setState(PlanState.MORPHING);
        this.gameState.getPlansMorphing().add(plan);
    }

    private boolean buildUpgrade(Unit unit, Plan plan) {
        UpgradeType upgradeType = plan.getPlannedUpgrade();
        if (this.game.canUpgrade(upgradeType, unit)) {
            unit.upgrade(upgradeType);
        }
        ResourceCount resourceCount = this.gameState.getResourceCount();
        TechProgression techProgression = this.gameState.getTechProgression();
        if (unit.isUpgrading()) {
            resourceCount.unreserveUpgrade(upgradeType);
            techProgression.upgradeTech(upgradeType);
            return true;
        }
        return false;
    }

    private boolean scheduleBuildingItem(Plan plan) {
        UnitType building = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        int predictedReadyFrame = this.gameState.frameCanAffordUnit(building, this.currentFrame);
        if (this.scheduledBuildings > 0 && resourceCount.canAffordUnit(building)) {
            return false;
        }
        if (plan.getBuildPosition() == null) {
            plan.setBuildPosition(this.game.getBuildLocation(building, this.gameState.getBaseData().mainBasePosition(), 128, true));
        }
        ++this.scheduledBuildings;
        resourceCount.reserveUnit(building);
        plan.setPredictedReadyFrame(predictedReadyFrame);
        plan.setState(PlanState.SCHEDULE);
        return true;
    }

    private boolean scheduleUnitItem(Plan plan) {
        UnitType unit = plan.getPlannedUnit();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.canAffordUnit(unit)) {
            return false;
        }
        if (!resourceCount.canScheduleLarva(this.gameState.numLarva())) {
            return false;
        }
        resourceCount.reserveUnit(unit);
        plan.setState(PlanState.SCHEDULE);
        return true;
    }

    private boolean scheduleUpgradeItem(Player self, Plan plan) {
        UpgradeType upgrade = plan.getPlannedUpgrade();
        ResourceCount resourceCount = this.gameState.getResourceCount();
        if (resourceCount.canAffordUpgrade(upgrade)) {
            return false;
        }
        Unit nextAvailable = null;
        for (Unit unit : self.getUnits()) {
            UnitType unitType = unit.getType();
            if (unitType != upgrade.whatUpgrades()) continue;
            if (nextAvailable == null) {
                nextAvailable = unit;
            }
            if (!unit.isUpgrading() && !this.gameState.getAssignedPlannedItems().containsKey(unit)) {
                this.gameState.getAssignedPlannedItems().put(unit, plan);
                plan.setState(PlanState.SCHEDULE);
                resourceCount.reserveUpgrade(upgrade);
                return true;
            }
            if (unit.getRemainingUpgradeTime() <= nextAvailable.getRemainingUpgradeTime()) continue;
            nextAvailable = unit;
        }
        if (nextAvailable != null) {
            int priority = plan.getPriority();
            plan.setPriority(priority + nextAvailable.getRemainingUpgradeTime());
        }
        return false;
    }

    public void onUnitComplete(Unit unit) {
        this.assignUnit(unit);
    }

    private void assignUnit(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Zerg_Extractor) {
            this.gameState.getGeyserAssignments().put(unit, new HashSet());
        }
        if (unitType == UnitType.Zerg_Overlord) {
            this.gameState.setPlannedSupply(Math.max(0, this.gameState.getPlannedSupply() - unitType.supplyProvided()));
        }
        if (unitType == UnitType.Zerg_Hatchery) {
            BaseData baseData = this.gameState.getBaseData();
            if (baseData.isBaseTilePosition(unit.getTilePosition())) {
                this.gameState.claimBase(unit);
            } else {
                this.gameState.addMacroHatchery(unit);
            }
            --this.plannedHatcheries;
            if (this.plannedHatcheries < 0) {
                this.plannedHatcheries = 0;
            }
        }
    }

    public void onUnitMorph(Unit unit) {
        UnitType unitType = unit.getType();
        HashMap<Unit, Plan> assignedPlannedItems = this.gameState.getAssignedPlannedItems();
        if (assignedPlannedItems.containsKey(unit)) {
            Plan plan = this.gameState.getAssignedPlannedItems().get(unit);
            this.plannedItemToMorphing(plan);
        }
        this.clearAssignments(unit, false);
        if (unitType == UnitType.Zerg_Sunken_Colony) {
            BaseData baseData = this.gameState.getBaseData();
            baseData.addSunkenColony(unit);
        }
    }

    public void onUnitRenegade(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Zerg_Extractor) {
            ResourceCount resourceCount = this.gameState.getResourceCount();
            resourceCount.unreserveUnit(unitType);
            this.clearAssignments(unit, false);
        }
    }

    public void onUnitDestroy(Unit unit) {
        Player self = this.game.self();
        if (unit.getPlayer() != self) {
            return;
        }
        this.updateTechOnDestroy(unit);
        this.clearAssignments(unit, true);
    }

    private void updateTechOnDestroy(Unit unit) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (unit.getType()) {
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(false);
            }
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(false);
            }
            case Zerg_Spire: {
                techProgression.setSpire(false);
            }
        }
    }

    private void clearAssignments(Unit unit, boolean isDestroyed) {
        if (this.gameState.getAssignedPlannedItems().containsKey(unit)) {
            Plan plan = this.gameState.getAssignedPlannedItems().get(unit);
            switch (plan.getState()) {
                case BUILDING: {
                    if (isDestroyed) {
                        this.gameState.cancelPlan(unit, plan);
                    } else {
                        this.gameState.completePlan(unit, plan);
                    }
                }
                case SCHEDULE: {
                    this.gameState.cancelPlan(unit, plan);
                    break;
                }
                default: {
                    this.gameState.completePlan(unit, plan);
                }
            }
        }
    }
}

