/*
 * Decompiled with CFR 0.152.
 */
package learning;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import learning.UCBRecord;

@JsonDeserialize(builder=StrategyRecordBuilder.class)
public class StrategyRecord
implements UCBRecord {
    private String strategy;
    private int wins;
    private int losses;

    public int netWins() {
        return this.wins - this.losses;
    }

    @Override
    public int wins() {
        return this.wins;
    }

    @Override
    public int games() {
        return this.wins + this.losses;
    }

    @Override
    public int winsSquared() {
        return this.wins * this.wins;
    }

    @Override
    public double index(int totalGames) {
        if (totalGames == 0 || this.games() == 0) {
            return 1.0;
        }
        double sampleMean = (double)this.wins() / (double)this.games();
        double c = Math.sqrt(2.0 * Math.log(totalGames) / (double)(2 * this.games()));
        return sampleMean + c;
    }

    StrategyRecord(String strategy, int wins, int losses) {
        this.strategy = strategy;
        this.wins = wins;
        this.losses = losses;
    }

    public static StrategyRecordBuilder builder() {
        return new StrategyRecordBuilder();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrategyRecord)) {
            return false;
        }
        StrategyRecord other = (StrategyRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        if (this.getLosses() != other.getLosses()) {
            return false;
        }
        String this$strategy = this.getStrategy();
        String other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StrategyRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        String $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        return result;
    }

    public String toString() {
        return "StrategyRecord(strategy=" + this.getStrategy() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StrategyRecordBuilder {
        private String strategy;
        private int wins;
        private int losses;

        StrategyRecordBuilder() {
        }

        public StrategyRecordBuilder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        public StrategyRecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        public StrategyRecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        public StrategyRecord build() {
            return new StrategyRecord(this.strategy, this.wins, this.losses);
        }

        public String toString() {
            return "StrategyRecord.StrategyRecordBuilder(strategy=" + this.strategy + ", wins=" + this.wins + ", losses=" + this.losses + ")";
        }
    }
}

