/*
 * Decompiled with CFR 0.152.
 */
package learning;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import learning.UCBRecord;

@JsonDeserialize(builder=OpenerRecordBuilder.class)
public class OpenerRecord
implements UCBRecord {
    private String opener;
    private int wins;
    private int losses;

    public int netWins() {
        return this.wins - this.losses;
    }

    @Override
    public int wins() {
        return this.wins;
    }

    @Override
    public int games() {
        return this.wins + this.losses;
    }

    @Override
    public int winsSquared() {
        return this.wins * this.wins;
    }

    @Override
    public double index(int totalGames) {
        if (totalGames == 0 || this.games() == 0) {
            return 1.0;
        }
        double sampleMean = (double)this.wins() / (double)this.games();
        double c = Math.sqrt(2.0 * Math.log(totalGames) / (double)(2 * this.games()));
        return sampleMean + c;
    }

    OpenerRecord(String opener, int wins, int losses) {
        this.opener = opener;
        this.wins = wins;
        this.losses = losses;
    }

    public static OpenerRecordBuilder builder() {
        return new OpenerRecordBuilder();
    }

    public String getOpener() {
        return this.opener;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setOpener(String opener) {
        this.opener = opener;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenerRecord)) {
            return false;
        }
        OpenerRecord other = (OpenerRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        if (this.getLosses() != other.getLosses()) {
            return false;
        }
        String this$opener = this.getOpener();
        String other$opener = other.getOpener();
        return !(this$opener == null ? other$opener != null : !this$opener.equals(other$opener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenerRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        String $opener = this.getOpener();
        result = result * 59 + ($opener == null ? 43 : $opener.hashCode());
        return result;
    }

    public String toString() {
        return "OpenerRecord(opener=" + this.getOpener() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class OpenerRecordBuilder {
        private String opener;
        private int wins;
        private int losses;

        OpenerRecordBuilder() {
        }

        public OpenerRecordBuilder opener(String opener) {
            this.opener = opener;
            return this;
        }

        public OpenerRecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        public OpenerRecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        public OpenerRecord build() {
            return new OpenerRecord(this.opener, this.wins, this.losses);
        }

        public String toString() {
            return "OpenerRecord.OpenerRecordBuilder(opener=" + this.opener + ", wins=" + this.wins + ", losses=" + this.losses + ")";
        }
    }
}

