/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.TilePosition;
import bwem.Base;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ScoutData {
    private HashSet<TilePosition> scoutTargets = new HashSet();
    private HashSet<TilePosition> activeScoutTargets = new HashSet();
    private HashSet<TilePosition> enemyBuildingPositions = new HashSet();
    private HashMap<Base, Integer> baseScoutAssignments = new HashMap();

    public void addScoutTarget(TilePosition tp) {
        this.scoutTargets.add(tp);
    }

    public boolean hasScoutTarget(TilePosition tp) {
        return this.scoutTargets.contains(tp);
    }

    public boolean hasScoutTargets() {
        return this.scoutTargets.size() > 0;
    }

    public void removeActiveScoutTarget(TilePosition tp) {
        this.activeScoutTargets.remove(tp);
    }

    public void removeScoutTarget(TilePosition tp) {
        this.scoutTargets.remove(tp);
    }

    public HashSet<TilePosition> getActiveScoutTargets() {
        return this.activeScoutTargets;
    }

    public void setActiveScoutTarget(TilePosition tp) {
        this.scoutTargets.remove(tp);
        this.activeScoutTargets.add(tp);
    }

    public boolean isEnemyBuildingLocationKnown() {
        return this.enemyBuildingPositions.size() > 0;
    }

    public void addEnemyBuildingLocation(TilePosition tp) {
        this.enemyBuildingPositions.add(tp);
    }

    public void removeEnemyBuildingLocation(TilePosition tp) {
        this.enemyBuildingPositions.remove(tp);
    }

    public HashSet<TilePosition> getEnemyBuildingPositions() {
        return this.enemyBuildingPositions;
    }

    public int getScoutsAssignedToBase(Base base) {
        return this.baseScoutAssignments.get(base);
    }

    public void removeBaseScoutAssignment(Base base) {
        this.baseScoutAssignments.remove(base);
    }

    public void addBaseScoutAssignment(Base base) {
        this.baseScoutAssignments.put(base, 0);
    }

    public void updateBaseScoutAssignment(Base base, int assignments) {
        this.baseScoutAssignments.put(base, assignments + 1);
    }

    public Set<Base> getScoutingBaseSet() {
        return this.baseScoutAssignments.keySet();
    }

    public TilePosition findNewActiveScoutTarget() {
        for (TilePosition target : this.scoutTargets) {
            if (this.activeScoutTargets.contains(target)) continue;
            return target;
        }
        return null;
    }
}

