/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Color;
import bwapi.Game;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.BWEM;
import bwem.Base;
import bwem.Geyser;
import info.BaseData;
import info.BaseManager;
import info.GameState;
import info.ScoutData;
import info.TechProgression;
import info.UnitTypeCount;
import info.map.GameMap;
import info.map.MapTile;
import info.map.MapTileScoutImportanceComparator;
import info.map.MapTileType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import planner.Plan;
import planner.PlanType;
import strategy.strategies.UnitWeights;
import util.Filter;

public class InformationManager {
    private BWEM bwem;
    private Game game;
    private GameState gameState;
    private BaseManager baseManager;
    private HashSet<Base> startingBasesSet = new HashSet();
    private HashSet<Base> expansionBasesSet = new HashSet();
    private HashSet<TilePosition> startingBasesTilePositions = new HashSet();
    private HashSet<Unit> enemyBuildings = new HashSet();
    private HashSet<Unit> enemyHostileToGroundBuildings = new HashSet();
    private HashSet<Unit> visibleEnemyUnits = new HashSet();
    private HashMap<Unit, TilePosition> enemyLastKnownLocations = new HashMap();
    private Base myBase;
    private HashMap<TilePosition, Base> tilePositionToBaseLookup = new HashMap();

    public InformationManager(BWEM bwem, Game game, GameState gameState) {
        this.bwem = bwem;
        this.game = game;
        this.gameState = gameState;
        this.initBases();
        this.initializeGameMap();
        this.baseManager = new BaseManager(bwem, game, gameState);
    }

    public void onFrame() {
        this.ageHeatMap();
        this.trackEnemyUnits();
        this.trackEnemyBuildings();
        this.checkEnemyBuildingPositions();
        this.debugEnemyTargets();
        this.checkScoutTargets();
        this.checkIfEnemyUnitsStillThreatenBase();
        this.checkBaseThreats();
        this.debugInitialHatch();
    }

    public void onUnitHide(Unit unit) {
        UnitType unitType = unit.getInitialType();
        if (unit.getPlayer() == this.game.self() || unitType == UnitType.Resource_Mineral_Field || unitType == UnitType.Resource_Vespene_Geyser || unitType == UnitType.Powerup_Mineral_Cluster_Type_1 || unitType == UnitType.Powerup_Mineral_Cluster_Type_2 || unitType == UnitType.Resource_Mineral_Field_Type_2 || unitType == UnitType.Resource_Mineral_Field_Type_3) {
            return;
        }
        if (unitType == UnitType.Unknown || unitType == UnitType.Special_Power_Generator || unitType == UnitType.Special_Protoss_Temple || unitType == UnitType.Special_XelNaga_Temple || unitType == UnitType.Special_Psi_Disrupter) {
            return;
        }
        if (unitType == UnitType.Zerg_Larva) {
            return;
        }
        this.enemyLastKnownLocations.put(unit, unit.getTilePosition());
    }

    public void updateTechProgression(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        UnitWeights unitWeights = this.gameState.getUnitWeights();
        switch (unitType) {
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(true);
                unitWeights.enableUnit(UnitType.Zerg_Zergling);
                break;
            }
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(true);
                unitWeights.enableUnit(UnitType.Zerg_Hydralisk);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(true);
                unitWeights.enableUnit(UnitType.Zerg_Mutalisk);
                unitWeights.enableUnit(UnitType.Zerg_Scourge);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(true);
                break;
            }
            case Zerg_Evolution_Chamber: {
                techProgression.setPlannedEvolutionChambers(techProgression.getPlannedEvolutionChambers() - 1);
                techProgression.setEvolutionChambers(techProgression.evolutionChambers() + 1);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(true);
                unitWeights.enableUnit(UnitType.Zerg_Queen);
                break;
            }
            case Zerg_Hive: {
                techProgression.setHive(true);
            }
        }
    }

    public void onUnitShow(Unit unit) {
        UnitType unitType = unit.getInitialType();
        if (unit.getPlayer() == this.game.self()) {
            this.updateTechProgression(unitType);
            return;
        }
        if (unitType == UnitType.Resource_Mineral_Field || unitType == UnitType.Resource_Vespene_Geyser || unitType == UnitType.Powerup_Mineral_Cluster_Type_1 || unitType == UnitType.Powerup_Mineral_Cluster_Type_2 || unitType == UnitType.Resource_Mineral_Field_Type_2 || unitType == UnitType.Resource_Mineral_Field_Type_3) {
            return;
        }
        if (unitType == UnitType.Unknown || unitType == UnitType.Special_Power_Generator || unitType == UnitType.Special_Protoss_Temple || unitType == UnitType.Special_XelNaga_Temple || unitType == UnitType.Special_Psi_Disrupter) {
            return;
        }
        if (unitType == UnitType.Zerg_Larva) {
            return;
        }
        if (this.enemyLastKnownLocations.containsKey(unit)) {
            this.enemyLastKnownLocations.remove(unit);
        }
    }

    public void onUnitMorph(Unit unit) {
        UnitType unitType = unit.getInitialType();
        HashMap<Unit, Plan> assignedPlannedItems = this.gameState.getAssignedPlannedItems();
        Plan assignedPlan = assignedPlannedItems.get(unit);
        if (assignedPlan == null) {
            return;
        }
        UnitType plannedUnit = assignedPlan.getPlannedUnit();
        if (assignedPlan.getType() == PlanType.BUILDING) {
            UnitTypeCount count = this.gameState.getUnitTypeCount();
            count.removeUnit(UnitType.Zerg_Drone);
            this.updateTechProgression(plannedUnit);
        }
    }

    public void onUnitComplete(Unit unit) {
        UnitType unitType = unit.getType();
        UnitTypeCount unitCount = this.gameState.getUnitTypeCount();
        unitCount.addUnit(unitType);
        unitCount.unplanUnit(unitType);
    }

    public void onUnitRenegade(Unit unit) {
        if (unit.getType() == UnitType.Resource_Vespene_Geyser) {
            this.onUnitDestroy(unit);
        }
    }

    public void updateTechOnDestroy(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        UnitWeights unitWeights = this.gameState.getUnitWeights();
        switch (unitType) {
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(false);
                unitWeights.disableUnit(UnitType.Zerg_Zergling);
                break;
            }
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(false);
                unitWeights.disableUnit(UnitType.Zerg_Hydralisk);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(false);
                unitWeights.disableUnit(UnitType.Zerg_Mutalisk);
                unitWeights.disableUnit(UnitType.Zerg_Scourge);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(false);
                break;
            }
            case Zerg_Evolution_Chamber: {
                int evolutionChambers = techProgression.getEvolutionChambers();
                techProgression.setEvolutionChambers(evolutionChambers - 1);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(false);
                unitWeights.disableUnit(UnitType.Zerg_Queen);
                break;
            }
            case Zerg_Hive: {
                techProgression.setHive(false);
            }
        }
    }

    public void onUnitDestroy(Unit unit) {
        UnitType unitType = unit.getType();
        if (this.enemyBuildings.contains(unit)) {
            this.enemyBuildings.remove(unit);
        }
        if (this.enemyHostileToGroundBuildings.contains(unit)) {
            this.enemyHostileToGroundBuildings.remove(unit);
        }
        if (this.visibleEnemyUnits.contains(unit)) {
            this.visibleEnemyUnits.remove(unit);
        }
        if (this.enemyLastKnownLocations.containsKey(unit)) {
            this.enemyLastKnownLocations.remove(unit);
        }
        this.ensureEnemyUnitRemovedFromBaseThreats(unit);
        if (unit.getPlayer() == this.game.self()) {
            this.baseManager.onUnitDestroy(unit);
            this.updateTechOnDestroy(unitType);
            UnitTypeCount unitCount = this.gameState.getUnitTypeCount();
            unitCount.removeUnit(unitType);
        }
    }

    public boolean isEnemyLocationKnown() {
        return this.visibleEnemyUnits.size() + this.enemyBuildings.size() > 0;
    }

    public boolean isEnemyUnitVisible() {
        for (Unit enemy : this.visibleEnemyUnits) {
            if (!enemy.isDetected()) continue;
            return true;
        }
        for (Unit enemy : this.enemyBuildings) {
            if (!enemy.isVisible()) continue;
            return true;
        }
        return false;
    }

    public HashSet<Unit> getEnemyBuildings() {
        return this.enemyBuildings;
    }

    public int getEnemyHostileToGroundBuildingsCount() {
        return this.enemyHostileToGroundBuildings.size();
    }

    public HashSet<Unit> getVisibleEnemyUnits() {
        return this.visibleEnemyUnits;
    }

    public TilePosition getRallyPoint() {
        BaseData baseData = this.gameState.getBaseData();
        if (baseData.hasNaturalExpansion()) {
            return baseData.naturalExpansionPosition();
        }
        return baseData.mainBasePosition();
    }

    private void trackEnemyUnits() {
        for (Unit unit : this.game.getAllUnits()) {
            UnitType unitType = unit.getType();
            if (unitType == UnitType.Special_Power_Generator || unitType == UnitType.Zerg_Larva || unitType == UnitType.Special_Pit_Door || unitType.isBuilding() || unit.getPlayer() == this.game.self() || unitType.isResourceContainer() || unitType.isNeutral() || unit.isMorphing()) continue;
            this.visibleEnemyUnits.add(unit);
        }
        ArrayList<Unit> unknownUnits = new ArrayList<Unit>();
        for (Unit unit : this.visibleEnemyUnits) {
            if (unit.isVisible()) continue;
            unknownUnits.add(unit);
        }
        if (unknownUnits.size() > 1) {
            unknownUnits.stream().forEach(this.visibleEnemyUnits::remove);
        }
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Unit unit : this.enemyLastKnownLocations.keySet()) {
            TilePosition tp = this.enemyLastKnownLocations.get(unit);
            if (!this.game.isVisible(tp)) continue;
            arrayList.add(unit);
        }
        for (Unit unit : arrayList) {
            this.enemyLastKnownLocations.remove(unit);
        }
    }

    private Base closestBaseToUnit(Unit unit, List<Base> baseList) {
        if (baseList.size() == 1) {
            return baseList.get(0);
        }
        Base closestBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base b : baseList) {
            int distance = unit.getDistance(b.getCenter());
            if (distance >= closestDistance) continue;
            closestBase = b;
            closestDistance = distance;
        }
        return closestBase;
    }

    private void trackEnemyBuildings() {
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        for (Unit unit : this.game.getAllUnits()) {
            Base enemyMainCandidate;
            if (unit.getPlayer() != this.game.enemy()) continue;
            UnitType unitType = unit.getType();
            if (!unit.isVisible() || !unitType.isBuilding()) continue;
            this.enemyBuildings.add(unit);
            scoutData.addEnemyBuildingLocation(unit.getTilePosition());
            if (Filter.isHostileBuildingToGround(unitType)) {
                this.enemyHostileToGroundBuildings.add(unit);
            }
            if (baseData.getMainEnemyBase() != null || (enemyMainCandidate = this.closestBaseToUnit(unit, this.startingBasesSet.stream().collect(Collectors.toList()))) == baseData.getMainBase()) continue;
            baseData.setMainEnemyBase(enemyMainCandidate);
        }
    }

    private boolean canSeeEnemyBuilding() {
        for (Unit building : this.enemyBuildings) {
            if (building.getType() == UnitType.Unknown) continue;
            return true;
        }
        return false;
    }

    private void checkEnemyBuildingPositions() {
        if (this.canSeeEnemyBuilding()) {
            return;
        }
        ScoutData scoutData = this.gameState.getScoutData();
        ArrayList<TilePosition> foundBuildings = new ArrayList<TilePosition>();
        for (TilePosition tilePosition : scoutData.getEnemyBuildingPositions()) {
            if (!this.game.isVisible(tilePosition)) continue;
            foundBuildings.add(tilePosition);
        }
        foundBuildings.stream().forEach(buildingPosition -> scoutData.removeEnemyBuildingLocation((TilePosition)buildingPosition));
    }

    private void ensureScoutTargets() {
        ScoutData scoutData = this.gameState.getScoutData();
        if (scoutData.hasScoutTargets()) {
            return;
        }
        int curImportance = 0;
        for (MapTile mapTile : this.gameState.getGameMap().getHeatMap()) {
            TilePosition tile = mapTile.getTile();
            int importance = mapTile.getScoutImportance();
            if (curImportance == 0) {
                curImportance = importance;
            }
            if (importance < curImportance) break;
            if (scoutData.hasScoutTarget(tile) || !mapTile.isBuildable()) continue;
            scoutData.addScoutTarget(tile);
        }
    }

    private void checkScoutTargets() {
        this.ensureScoutTargets();
        ScoutData scoutData = this.gameState.getScoutData();
        ArrayList<TilePosition> foundTargets = new ArrayList<TilePosition>();
        for (TilePosition target : scoutData.getActiveScoutTargets()) {
            if (target == null) {
                scoutData.removeActiveScoutTarget(target);
                return;
            }
            if (!this.game.isVisible(target)) continue;
            foundTargets.add(target);
        }
        for (TilePosition target : this.startingBasesTilePositions) {
            if (!this.game.isVisible(target)) continue;
            foundTargets.add(target);
        }
        for (TilePosition target : foundTargets) {
            scoutData.removeActiveScoutTarget(target);
            scoutData.removeEnemyBuildingLocation(target);
            this.startingBasesTilePositions.remove(target);
            if (!this.tilePositionToBaseLookup.containsKey(target)) continue;
            Base b = this.tilePositionToBaseLookup.get(target);
            scoutData.removeBaseScoutAssignment(b);
            this.tilePositionToBaseLookup.remove(target);
        }
    }

    private void initBases() {
        TilePosition initialHatchery = null;
        ScoutData scoutData = this.gameState.getScoutData();
        for (Unit unit : this.game.getAllUnits()) {
            if (unit.getPlayer() != this.game.self() || unit.getType() != UnitType.Zerg_Hatchery) continue;
            initialHatchery = unit.getTilePosition();
            break;
        }
        for (Base b : this.bwem.getMap().getBases()) {
            TilePosition tilePosition = b.getLocation();
            if (b.isStartingLocation()) {
                if (tilePosition.getX() == initialHatchery.getX() && tilePosition.getY() == initialHatchery.getY()) {
                    this.myBase = b;
                }
                this.startingBasesTilePositions.add(tilePosition);
                this.tilePositionToBaseLookup.put(tilePosition, b);
                scoutData.addBaseScoutAssignment(b);
                this.startingBasesSet.add(b);
                scoutData.addScoutTarget(tilePosition);
                continue;
            }
            this.expansionBasesSet.add(b);
        }
    }

    private void initializeGameMap() {
        HashSet startingPositions = new HashSet();
        HashSet expansionPositions = new HashSet();
        HashSet<TilePosition> resourcePositions = new HashSet<TilePosition>();
        this.startingBasesSet.stream().map(base -> base.getLocation()).forEach(startingPositions::add);
        this.expansionBasesSet.stream().map(base -> base.getLocation()).forEach(expansionPositions::add);
        for (Base base2 : this.startingBasesSet) {
            for (Geyser geyser : base2.getGeysers()) {
                TilePosition topLeft = geyser.getTopLeft();
                TilePosition bottomRight = geyser.getBottomRight();
                for (int x = topLeft.getX(); x < bottomRight.getX(); ++x) {
                    for (int y = topLeft.getY(); y < bottomRight.getY(); ++y) {
                        resourcePositions.add(topLeft.add(new TilePosition(x, y)));
                    }
                }
            }
        }
        GameMap gameMap = new GameMap(this.game.mapWidth(), this.game.mapHeight());
        for (int x = 0; x < this.game.mapWidth(); ++x) {
            for (int y = 0; y < this.game.mapHeight(); ++y) {
                TilePosition tp = new TilePosition(x, y);
                MapTile mapTile = startingPositions.contains(tp) ? new MapTile(tp, 2, true, MapTileType.BASE_START) : (expansionPositions.contains(tp) ? new MapTile(tp, 1, true, MapTileType.BASE_EXPANSION) : (resourcePositions.contains(tp) ? new MapTile(tp, 0, false, MapTileType.NORMAL) : new MapTile(tp, 0, this.isBuildable(tp), MapTileType.NORMAL)));
                gameMap.addTile(mapTile, x, y);
            }
        }
        this.gameState.setGameMap(gameMap);
    }

    private boolean isBuildable(TilePosition tp) {
        WalkPosition wp = tp.toWalkPosition();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.game.isWalkable(wp.add(new WalkPosition(x, y)))) continue;
                return false;
            }
        }
        return true;
    }

    private void ageHeatMap() {
        ScoutData scoutData = this.gameState.getScoutData();
        int weight = 1;
        GameMap gameMap = this.gameState.getGameMap();
        for (MapTile mapTile : gameMap.getHeatMap()) {
            TilePosition mapTp = mapTile.getTile();
            if (this.game.isVisible(mapTp)) {
                mapTile.setScoutImportance(0);
                scoutData.removeScoutTarget(mapTp);
                continue;
            }
            if (mapTile.getType() == MapTileType.BASE_START) {
                weight = 3;
            } else if (mapTile.getType() == MapTileType.BASE_EXPANSION) {
                weight = 2;
            } else if (mapTile.getType() == MapTileType.NORMAL) {
                weight = 1;
            }
            mapTile.setScoutImportance(mapTile.getScoutImportance() + weight);
        }
        Collections.sort(gameMap.getHeatMap(), new MapTileScoutImportanceComparator());
    }

    private void debugInitialHatch() {
        if (this.game.getFrameCount() < 10) {
            return;
        }
        this.game.drawBoxMap(this.myBase.getLocation().toPosition(), this.myBase.getLocation().add(new TilePosition(1, 1)).toPosition(), Color.Blue);
    }

    private void debugEnemyTargets() {
        ScoutData scoutData = this.gameState.getScoutData();
        for (Unit target : this.enemyBuildings) {
            this.game.drawCircleMap(target.getPosition(), 3, Color.Yellow);
        }
        for (Unit target : this.visibleEnemyUnits) {
            this.game.drawCircleMap(target.getPosition(), 3, Color.Red);
        }
        for (TilePosition tilePosition : scoutData.getEnemyBuildingPositions()) {
            this.game.drawCircleMap(tilePosition.toPosition(), 2, Color.Orange);
        }
        for (Unit unit : this.enemyLastKnownLocations.keySet()) {
            TilePosition tp = this.enemyLastKnownLocations.get(unit);
            this.game.drawTextMap(tp.toPosition(), String.format("%s", new Object[]{unit.getInitialType()}), Text.White);
        }
    }

    private void ensureEnemyUnitRemovedFromBaseThreats(Unit unit) {
        for (HashSet<Unit> baseThreat : this.gameState.getBaseToThreatLookup().values()) {
            if (!baseThreat.contains(unit)) continue;
            baseThreat.remove(unit);
        }
    }

    private void checkIfEnemyUnitsStillThreatenBase() {
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : baseThreats.keySet()) {
            HashSet<Unit> unitThreats = baseThreats.get(base);
            ArrayList<Unit> noLongerThreats = new ArrayList<Unit>();
            for (Unit unit : unitThreats) {
                if (unit.getType() == UnitType.Unknown) {
                    noLongerThreats.add(unit);
                    continue;
                }
                int distance = (int)base.getLocation().toPosition().getDistance(unit.getTilePosition().toPosition());
                if (distance > 256) {
                    noLongerThreats.add(unit);
                    continue;
                }
                if (unit.getPlayer() != this.game.self()) continue;
                noLongerThreats.add(unit);
            }
            for (Unit unit : noLongerThreats) {
                unitThreats.remove(unit);
            }
        }
    }

    private void checkBaseThreats() {
        if (this.visibleEnemyUnits.size() < 1) {
            return;
        }
        Set<Base> bases = this.gameState.getGatherersAssignedToBase().keySet();
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : bases) {
            if (!baseThreats.containsKey(base)) {
                baseThreats.put(base, new HashSet());
            }
            for (Unit unit : this.visibleEnemyUnits) {
                if (!(base.getLocation().toPosition().getDistance(unit.getTilePosition().toPosition()) < 256.0)) continue;
                baseThreats.get(base).add(unit);
            }
        }
    }
}

