#pragma once

#include <vector>
#include "BWAPI.h"
#include "Grid.h"

// Safe paths, with no known danger of attack.

namespace UAlbertaBot
{
class GridAttacks;		// forward declaration

class GridSafePath : public Grid
{
protected:
	bool _isInitialized;
    BWAPI::TilePosition _start;
    int _updateFrame;

public:
    GridSafePath(const BWAPI::TilePosition & start);

	bool isInitialized() const { return _isInitialized; };
    int getUpdateFrame() const { return _updateFrame; };
    virtual void update(GridAttacks * influence) = 0;
};

class GridSafePathGround : public GridSafePath
{
public:
    GridSafePathGround(const BWAPI::TilePosition & start);

    void update(GridAttacks * influence);
};

class GridSafePathAir : public GridSafePath
{
public:
    GridSafePathAir(const BWAPI::TilePosition & start);

    void update(GridAttacks * influence);
};

}
