package Information.Grids.Floody

import Lifecycle.With
import Mathematics.Maff
import ProxyBwapi.UnitInfo.UnitInfo


final class GridEnemyVulnerabilityGround extends AbstractGridFloody {

  override protected def include(unit: UnitInfo): Boolean = unit.isEnemy && ! unit.flying

  override protected def range(unit: UnitInfo): Int = maxVulnerability

  override val margin: Int = 1

  private var _maxVulnerability: Int = _
  @inline def maxVulnerability: Int = _maxVulnerability

  override def update(): Unit = {
    _maxVulnerability = Maff.max(With.units.ours.map(u => Maff.div32(u.pixelRangeGround.toInt + 31))).getOrElse(1)
    super.update()
  }
}
