/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Point;
import bwapi.Position;
import bwapi.TilePosition;

public class WalkPosition
extends Point<WalkPosition> {
    public static final int SIZE_IN_PIXELS = 8;
    public static final WalkPosition Invalid = new WalkPosition(4000, 4000);
    public static final WalkPosition None = new WalkPosition(4000, 4004);
    public static final WalkPosition Unknown = new WalkPosition(4000, 4008);
    public static final WalkPosition Origin = new WalkPosition(0, 0);

    public WalkPosition(int x, int y) {
        super(x, y, 8);
    }

    public Position toPosition() {
        return new Position(this.x * 8, this.y * 8);
    }

    public TilePosition toTilePosition() {
        return new TilePosition(this.x / 4, this.y / 4);
    }

    @Override
    public WalkPosition subtract(WalkPosition other) {
        return new WalkPosition(this.x - other.x, this.y - other.y);
    }

    @Override
    public WalkPosition add(WalkPosition other) {
        return new WalkPosition(this.x + other.x, this.y + other.y);
    }

    @Override
    public WalkPosition divide(int divisor) {
        return new WalkPosition(this.x / divisor, this.y / divisor);
    }

    @Override
    public WalkPosition multiply(int multiplier) {
        return new WalkPosition(this.x * multiplier, this.y * multiplier);
    }
}

