/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BuildingPlacer;
import bwapi.Bullet;
import bwapi.Client;
import bwapi.ClientData;
import bwapi.Color;
import bwapi.CommandType;
import bwapi.CoordinateType;
import bwapi.DamageType;
import bwapi.Flag;
import bwapi.Force;
import bwapi.GameType;
import bwapi.Key;
import bwapi.Latency;
import bwapi.MouseButton;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Region;
import bwapi.ShapeType;
import bwapi.TechType;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitCommand;
import bwapi.UnitFilter;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WalkPosition;
import bwapi.WeaponType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Game {
    private static final int[][] damageRatio = new int[][]{{0, 0, 0, 0, 0, 0}, {0, 128, 192, 256, 0, 0}, {0, 256, 128, 64, 0, 0}, {0, 256, 256, 256, 0, 0}, {0, 256, 256, 256, 0, 0}, {0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0}};
    private static final boolean[][] bPsiFieldMask = new boolean[][]{{false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}, {false, false, true, true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false}, {false, false, true, true, true, true, true, true, true, true, true, true, true, true, false, false}, {false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false}};
    private static final int REGION_DATA_SIZE = 5000;
    private final Set<Integer> visibleUnits = new HashSet<Integer>();
    private List<Unit> allUnits;
    private final Client client;
    private final ClientData.GameData gameData;
    private List<Unit> staticMinerals;
    private List<Unit> staticGeysers;
    private List<Unit> staticNeutralUnits;
    private Player[] players;
    private Region[] regions;
    private Force[] forces;
    private Bullet[] bullets;
    private List<Force> forceSet;
    private List<Player> playerSet;
    private List<Region> regionSet;
    private List<Player> allies;
    private List<Player> enemies;
    private List<Player> observers;
    private Unit[] units;
    private int randomSeed;
    private int revision;
    private boolean debug;
    private Player self;
    private Player enemy;
    private Player neutral;
    private boolean replay;
    private boolean multiplayer;
    private boolean battleNet;
    private List<TilePosition> startLocations;
    private int mapWidth;
    private int mapHeight;
    private int mapPixelWidth;
    private int mapPixelHeight;
    private String mapFileName;
    private String mapPathName;
    private String mapName;
    private String mapHash;
    private boolean[][] buildable;
    private boolean[][] walkable;
    private int[][] groundHeight;
    private short[][] mapTileRegionID;
    private short[] mapSplitTilesMiniTileMask;
    private short[] mapSplitTilesRegion1;
    private short[] mapSplitTilesRegion2;
    private Text.Size textSize = Text.Size.Default;
    private boolean latcom = true;

    Game(Client client) {
        this.client = client;
        this.gameData = client.gameData();
    }

    Client getClient() {
        return this.client;
    }

    private static boolean hasPower(int x, int y, UnitType unitType, List<Unit> pylons) {
        if (!(unitType.id < 0 || unitType.id >= UnitType.None.id || unitType.requiresPsi() && unitType.isBuilding())) {
            return true;
        }
        for (Unit i : pylons) {
            if (!i.exists() || !i.isCompleted()) continue;
            Position p = i.getPosition();
            if (Math.abs(p.x - x) >= 256 || Math.abs(p.y - y) >= 160 || !bPsiFieldMask[(y - p.y + 160) / 32][(x - p.x + 256) / 32]) continue;
            return true;
        }
        return false;
    }

    void init() {
        int i2;
        this.visibleUnits.clear();
        int forceCount = this.gameData.getForceCount();
        this.forces = new Force[forceCount];
        for (int id = 0; id < forceCount; ++id) {
            this.forces[id] = new Force(this.gameData.getForces(id), id, this);
        }
        this.forceSet = Collections.unmodifiableList(Arrays.asList(this.forces));
        int playerCount = this.gameData.getPlayerCount();
        this.players = new Player[playerCount];
        for (int id = 0; id < playerCount; ++id) {
            this.players[id] = new Player(this.gameData.getPlayers(id), id, this);
        }
        this.playerSet = Collections.unmodifiableList(Arrays.asList(this.players));
        int bulletCount = 100;
        this.bullets = new Bullet[100];
        for (int id = 0; id < 100; ++id) {
            this.bullets[id] = new Bullet(this.gameData.getBullets(id), id, this);
        }
        int regionCount = this.gameData.getRegionCount();
        this.regions = new Region[regionCount];
        for (int id = 0; id < regionCount; ++id) {
            this.regions[id] = new Region(this.gameData.getRegions(id), this);
        }
        for (Region region : this.regions) {
            region.updateNeighbours();
        }
        this.regionSet = Collections.unmodifiableList(Arrays.asList(this.regions));
        this.units = new Unit[10000];
        this.randomSeed = this.gameData.getRandomSeed();
        this.revision = this.gameData.getRevision();
        this.debug = this.gameData.isDebug();
        this.replay = this.gameData.isReplay();
        this.neutral = this.players[this.gameData.getNeutral()];
        this.self = this.isReplay() ? null : this.players[this.gameData.getSelf()];
        this.enemy = this.isReplay() ? null : this.players[this.gameData.getEnemy()];
        this.multiplayer = this.gameData.isMultiplayer();
        this.battleNet = this.gameData.isBattleNet();
        this.startLocations = IntStream.range(0, this.gameData.getStartLocationCount()).mapToObj(i -> new TilePosition(this.gameData.getStartLocations(i))).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.mapWidth = this.gameData.getMapWidth();
        this.mapHeight = this.gameData.getMapHeight();
        this.mapFileName = this.gameData.getMapFileName();
        this.mapPathName = this.gameData.getMapPathName();
        this.mapName = this.gameData.getMapName();
        this.mapHash = this.gameData.getMapHash();
        ArrayList<Unit> staticMinerals = new ArrayList<Unit>();
        ArrayList<Unit> staticGeysers = new ArrayList<Unit>();
        ArrayList<Unit> staticNeutralUnits = new ArrayList<Unit>();
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        for (int id = 0; id < this.gameData.getInitialUnitCount(); ++id) {
            Unit unit = new Unit(this.gameData.getUnits(id), id, this);
            if (unit.getInitialType() == UnitType.Terran_Marine && unit.getInitialHitPoints() == 0) continue;
            this.units[id] = unit;
            allUnits.add(unit);
            if (unit.getType().isMineralField()) {
                staticMinerals.add(unit);
            }
            if (unit.getType() == UnitType.Resource_Vespene_Geyser) {
                staticGeysers.add(unit);
            }
            if (!unit.getPlayer().equals(this.neutral())) continue;
            staticNeutralUnits.add(unit);
        }
        this.staticMinerals = Collections.unmodifiableList(staticMinerals);
        this.staticGeysers = Collections.unmodifiableList(staticGeysers);
        this.staticNeutralUnits = Collections.unmodifiableList(staticNeutralUnits);
        this.allUnits = Collections.unmodifiableList(allUnits);
        this.buildable = new boolean[this.mapWidth][this.mapHeight];
        this.groundHeight = new int[this.mapWidth][this.mapHeight];
        this.mapTileRegionID = new short[this.mapWidth][this.mapHeight];
        for (int x = 0; x < this.mapWidth; ++x) {
            for (int y = 0; y < this.mapHeight; ++y) {
                this.buildable[x][y] = this.gameData.isBuildable(x, y);
                this.groundHeight[x][y] = this.gameData.getGroundHeight(x, y);
                this.mapTileRegionID[x][y] = this.gameData.getMapTileRegionId(x, y);
            }
        }
        this.walkable = new boolean[this.mapWidth * 4][this.mapHeight * 4];
        for (i2 = 0; i2 < this.mapWidth * 4; ++i2) {
            for (int j = 0; j < this.mapHeight * 4; ++j) {
                this.walkable[i2][j] = this.gameData.isWalkable(i2, j);
            }
        }
        this.mapSplitTilesMiniTileMask = new short[5000];
        this.mapSplitTilesRegion1 = new short[5000];
        this.mapSplitTilesRegion2 = new short[5000];
        for (i2 = 0; i2 < 5000; ++i2) {
            this.mapSplitTilesMiniTileMask[i2] = this.gameData.getMapSplitTilesMiniTileMask(i2);
            this.mapSplitTilesRegion1[i2] = this.gameData.getMapSplitTilesRegion1(i2);
            this.mapSplitTilesRegion2[i2] = this.gameData.getMapSplitTilesRegion2(i2);
        }
        this.mapPixelWidth = this.mapWidth * 32;
        this.mapPixelHeight = this.mapHeight * 32;
        if (this.isReplay()) {
            this.enemies = Collections.emptyList();
            this.allies = Collections.emptyList();
            this.observers = Collections.emptyList();
        } else {
            this.enemies = this.playerSet.stream().filter(p -> !p.equals(this.self()) && this.self().isEnemy((Player)p)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            this.allies = this.playerSet.stream().filter(p -> !p.equals(this.self()) && this.self().isAlly((Player)p)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            this.observers = this.playerSet.stream().filter(p -> !p.equals(this.self()) && p.isObserver()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        this.setLatCom(true);
    }

    void unitCreate(int id) {
        if (id > this.units.length) {
            Unit[] largerUnitsArray = new Unit[2 * this.units.length];
            System.arraycopy(this.units, 0, largerUnitsArray, 0, this.units.length);
            this.units = largerUnitsArray;
        }
        if (this.units[id] == null) {
            Unit u;
            this.units[id] = u = new Unit(this.gameData.getUnits(id), id, this);
        }
    }

    void unitShow(int id) {
        this.unitCreate(id);
        this.visibleUnits.add(id);
    }

    void unitHide(int id) {
        this.visibleUnits.remove(id);
    }

    void onFrame(int frame) {
        if (frame > 0) {
            this.allUnits = this.visibleUnits.stream().map(i -> this.units[i]).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        this.getAllUnits().forEach(u -> u.updatePosition(frame));
    }

    void addUnitCommand(int type, int unit, int target, int x, int y, int extra) {
        ClientData.UnitCommand unitCommand = this.client.addUnitCommand();
        unitCommand.setTid(type);
        unitCommand.setUnitIndex(unit);
        unitCommand.setTargetIndex(target);
        unitCommand.setX(x);
        unitCommand.setY(y);
        unitCommand.setExtra(extra);
    }

    void addCommand(CommandType type, int value1, int value2) {
        ClientData.Command command = this.client.addCommand();
        command.setType(type);
        command.setValue1(value1);
        command.setValue2(value2);
    }

    void addShape(ShapeType type, CoordinateType coordType, int x1, int y1, int x2, int y2, int extra1, int extra2, int color, boolean isSolid) {
        ClientData.Shape shape = this.client.addShape();
        shape.setType(type);
        shape.setCtype(coordType);
        shape.setX1(x1);
        shape.setY1(y1);
        shape.setX2(x2);
        shape.setY2(y2);
        shape.setExtra1(extra1);
        shape.setExtra2(extra2);
        shape.setColor(color);
        shape.setIsSolid(isSolid);
    }

    public List<Force> getForces() {
        return this.forceSet;
    }

    public List<Player> getPlayers() {
        return this.playerSet;
    }

    public List<Unit> getAllUnits() {
        return this.allUnits;
    }

    public List<Unit> getMinerals() {
        return this.getAllUnits().stream().filter(u -> u.getType().isMineralField()).collect(Collectors.toList());
    }

    public List<Unit> getGeysers() {
        return this.getAllUnits().stream().filter(u -> u.getType() == UnitType.Resource_Vespene_Geyser).collect(Collectors.toList());
    }

    public List<Unit> getNeutralUnits() {
        return this.getAllUnits().stream().filter(u -> u.getPlayer().equals(this.neutral())).collect(Collectors.toList());
    }

    public List<Unit> getStaticMinerals() {
        return this.staticMinerals;
    }

    public List<Unit> getStaticGeysers() {
        return this.staticGeysers;
    }

    public List<Unit> getStaticNeutralUnits() {
        return this.staticNeutralUnits;
    }

    public List<Bullet> getBullets() {
        return Arrays.stream(this.bullets).filter(Bullet::exists).collect(Collectors.toList());
    }

    public List<Position> getNukeDots() {
        return IntStream.range(0, this.gameData.getNukeDotCount()).mapToObj(id -> new Position(this.gameData.getNukeDots(id))).collect(Collectors.toList());
    }

    public Force getForce(int forceID) {
        if (forceID < 0 || forceID >= this.forces.length) {
            return null;
        }
        return this.forces[forceID];
    }

    public Player getPlayer(int playerID) {
        if (playerID < 0 || playerID >= this.players.length) {
            return null;
        }
        return this.players[playerID];
    }

    public Unit getUnit(int unitID) {
        if (unitID < 0 || unitID >= this.units.length) {
            return null;
        }
        return this.units[unitID];
    }

    public Region getRegion(int regionID) {
        if (regionID < 0 || regionID >= this.regions.length) {
            return null;
        }
        return this.regions[regionID];
    }

    public GameType getGameType() {
        return GameType.idToEnum[this.gameData.getGameType()];
    }

    public Latency getLatency() {
        return Latency.idToEnum[this.gameData.getLatency()];
    }

    public int getFrameCount() {
        return this.gameData.getFrameCount();
    }

    public int getReplayFrameCount() {
        return this.gameData.getReplayFrameCount();
    }

    public int getFPS() {
        return this.gameData.getFps();
    }

    public double getAverageFPS() {
        return this.gameData.getAverageFPS();
    }

    public Position getMousePosition() {
        return new Position(this.gameData.getMouseX(), this.gameData.getMouseY());
    }

    public boolean getMouseState(MouseButton button) {
        return this.gameData.getMouseState(button.id);
    }

    public boolean getKeyState(Key key) {
        return this.gameData.getKeyState(key.id);
    }

    public Position getScreenPosition() {
        return new Position(this.gameData.getScreenX(), this.gameData.getScreenY());
    }

    public void setScreenPosition(Position p) {
        this.setScreenPosition(p.x, p.y);
    }

    public void setScreenPosition(int x, int y) {
        this.addCommand(CommandType.SetScreenPosition, x, y);
    }

    public void pingMinimap(int x, int y) {
        this.addCommand(CommandType.PingMinimap, x, y);
    }

    public void pingMinimap(Position p) {
        this.pingMinimap(p.x, p.y);
    }

    public boolean isFlagEnabled(Flag flag) {
        return this.gameData.getFlags(flag.id);
    }

    public void enableFlag(Flag flag) {
        this.addCommand(CommandType.EnableFlag, flag.id, 1);
    }

    public List<Unit> getUnitsOnTile(TilePosition tile) {
        return this.getUnitsOnTile(tile.x, tile.y);
    }

    public List<Unit> getUnitsOnTile(int tileX, int tileY) {
        return this.getUnitsOnTile(tileX, tileY, u -> true);
    }

    public List<Unit> getUnitsOnTile(int tileX, int tileY, UnitFilter pred) {
        return this.getAllUnits().stream().filter(u -> {
            TilePosition tp = u.getTilePosition();
            return tp.x == tileX && tp.y == tileY && pred.test(u);
        }).collect(Collectors.toList());
    }

    public List<Unit> getUnitsInRectangle(int left, int top, int right, int bottom) {
        return this.getUnitsInRectangle(left, top, right, bottom, u -> true);
    }

    public List<Unit> getUnitsInRectangle(int left, int top, int right, int bottom, UnitFilter pred) {
        return this.getAllUnits().stream().filter(u -> left <= u.getRight() && top <= u.getBottom() && right >= u.getLeft() && bottom >= u.getTop() && pred.test(u)).collect(Collectors.toList());
    }

    public List<Unit> getUnitsInRectangle(Position leftTop, Position rightBottom) {
        return this.getUnitsInRectangle(leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, u -> true);
    }

    public List<Unit> getUnitsInRectangle(Position leftTop, Position rightBottom, UnitFilter pred) {
        return this.getUnitsInRectangle(leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, pred);
    }

    public List<Unit> getUnitsInRadius(int x, int y, int radius) {
        return this.getUnitsInRadius(x, y, radius, u -> true);
    }

    public List<Unit> getUnitsInRadius(int x, int y, int radius, UnitFilter pred) {
        return this.getUnitsInRadius(new Position(x, y), radius, pred);
    }

    public List<Unit> getUnitsInRadius(Position center, int radius) {
        return this.getUnitsInRadius(center, radius, u -> true);
    }

    public List<Unit> getUnitsInRadius(Position center, int radius, UnitFilter pred) {
        return this.getAllUnits().stream().filter(u -> center.getApproxDistance(u.getPosition()) <= radius && pred.test(u)).collect(Collectors.toList());
    }

    public Unit getClosestUnitInRectangle(Position center, int left, int top, int right, int bottom) {
        return this.getClosestUnitInRectangle(center, left, top, right, bottom, u -> true);
    }

    public Unit getClosestUnitInRectangle(Position center, int left, int top, int right, int bottom, UnitFilter pred) {
        return this.getUnitsInRectangle(left, top, right, bottom, pred).stream().min(Comparator.comparingInt(u -> u.getDistance(center))).orElse(null);
    }

    public Unit getClosestUnit(Position center) {
        return this.getClosestUnit(center, 999999);
    }

    public Unit getClosestUnit(Position center, UnitFilter pred) {
        return this.getClosestUnit(center, 999999, pred);
    }

    public Unit getClosestUnit(Position center, int radius) {
        return this.getClosestUnit(center, radius, u -> true);
    }

    public Unit getClosestUnit(Position center, int radius, UnitFilter pred) {
        return this.getUnitsInRadius(center, radius, pred).stream().min(Comparator.comparingInt(u -> u.getDistance(center))).orElse(null);
    }

    public int mapWidth() {
        return this.mapWidth;
    }

    public int mapHeight() {
        return this.mapHeight;
    }

    int mapPixelWidth() {
        return this.mapPixelWidth;
    }

    int mapPixelHeight() {
        return this.mapPixelHeight;
    }

    public String mapFileName() {
        return this.mapFileName;
    }

    public String mapPathName() {
        return this.mapPathName;
    }

    public String mapName() {
        return this.mapName;
    }

    public String mapHash() {
        return this.mapHash;
    }

    public boolean isWalkable(int walkX, int walkY) {
        return this.isWalkable(new WalkPosition(walkX, walkY));
    }

    public boolean isWalkable(WalkPosition position) {
        if (!position.isValid(this)) {
            return false;
        }
        return this.walkable[position.x][position.y];
    }

    public int getGroundHeight(int tileX, int tileY) {
        return this.getGroundHeight(new TilePosition(tileX, tileY));
    }

    public int getGroundHeight(TilePosition position) {
        if (!position.isValid(this)) {
            return 0;
        }
        return this.groundHeight[position.x][position.y];
    }

    public boolean isBuildable(int tileX, int tileY) {
        return this.isBuildable(tileX, tileY, false);
    }

    public boolean isBuildable(int tileX, int tileY, boolean includeBuildings) {
        return this.isBuildable(new TilePosition(tileX, tileY), includeBuildings);
    }

    public boolean isBuildable(TilePosition position) {
        return this.isBuildable(position, false);
    }

    public boolean isBuildable(TilePosition position, boolean includeBuildings) {
        if (!position.isValid(this)) {
            return false;
        }
        return this.buildable[position.x][position.y] && (!includeBuildings || !this.gameData.isOccupied(position.x, position.y));
    }

    public boolean isVisible(int tileX, int tileY) {
        return this.isVisible(new TilePosition(tileX, tileY));
    }

    public boolean isVisible(TilePosition position) {
        if (!position.isValid(this)) {
            return false;
        }
        return this.gameData.isVisible(position.x, position.y);
    }

    public boolean isExplored(int tileX, int tileY) {
        return this.isExplored(new TilePosition(tileX, tileY));
    }

    public boolean isExplored(TilePosition position) {
        if (!position.isValid(this)) {
            return false;
        }
        return this.gameData.isExplored(position.x, position.y);
    }

    public boolean hasCreep(int tileX, int tileY) {
        return this.hasCreep(new TilePosition(tileX, tileY));
    }

    public boolean hasCreep(TilePosition position) {
        if (!position.isValid(this)) {
            return false;
        }
        return this.gameData.getHasCreep(position.x, position.y);
    }

    public boolean hasPowerPrecise(int x, int y) {
        return this.hasPowerPrecise(new Position(x, y));
    }

    public boolean hasPowerPrecise(int x, int y, UnitType unitType) {
        return this.hasPowerPrecise(new Position(x, y), unitType);
    }

    public boolean hasPowerPrecise(Position position) {
        return this.hasPowerPrecise(position, UnitType.None);
    }

    public boolean hasPowerPrecise(Position position, UnitType unitType) {
        if (!position.isValid(this)) {
            return false;
        }
        return Game.hasPower(position.x, position.y, unitType, this.self().getUnits().stream().filter(u -> u.getType() == UnitType.Protoss_Pylon).collect(Collectors.toList()));
    }

    public boolean hasPower(int tileX, int tileY) {
        return this.hasPower(new TilePosition(tileX, tileY));
    }

    public boolean hasPower(int tileX, int tileY, UnitType unitType) {
        return this.hasPower(new TilePosition(tileX, tileY), unitType);
    }

    public boolean hasPower(TilePosition position) {
        return this.hasPower(position.x, position.y, UnitType.None);
    }

    public boolean hasPower(TilePosition position, UnitType unitType) {
        if (unitType.id >= 0 && unitType.id < UnitType.None.id) {
            return this.hasPowerPrecise(position.x * 32 + unitType.tileWidth() * 16, position.y * 32 + unitType.tileHeight() * 16, unitType);
        }
        return this.hasPowerPrecise(position.x * 32, position.y * 32, UnitType.None);
    }

    public boolean hasPower(int tileX, int tileY, int tileWidth, int tileHeight) {
        return this.hasPower(tileX, tileY, tileWidth, tileHeight, UnitType.Unknown);
    }

    public boolean hasPower(int tileX, int tileY, int tileWidth, int tileHeight, UnitType unitType) {
        return this.hasPowerPrecise(tileX * 32 + tileWidth * 16, tileY * 32 + tileHeight * 16, unitType);
    }

    public boolean hasPower(TilePosition position, int tileWidth, int tileHeight) {
        return this.hasPower(position.x, position.y, tileWidth, tileHeight);
    }

    public boolean hasPower(TilePosition position, int tileWidth, int tileHeight, UnitType unitType) {
        return this.hasPower(position.x, position.y, tileWidth, tileHeight, unitType);
    }

    public boolean canBuildHere(TilePosition position, UnitType type, Unit builder) {
        return this.canBuildHere(position, type, builder, false);
    }

    public boolean canBuildHere(TilePosition position, UnitType type) {
        return this.canBuildHere(position, type, null);
    }

    public boolean canBuildHere(TilePosition position, UnitType type, Unit builder, boolean checkExplored) {
        TilePosition lt = builder != null && type.isAddon() ? position.add(new TilePosition(4, 1)) : position;
        TilePosition rb = lt.add(type.tileSize());
        if (!lt.isValid(this) || !rb.toPosition().subtract(new Position(1, 1)).isValid(this)) {
            return false;
        }
        if (type.isRefinery()) {
            for (Unit g : this.getGeysers()) {
                if (!g.getTilePosition().equals(lt)) continue;
                return !g.isVisible() || g.getType() == UnitType.Resource_Vespene_Geyser;
            }
            return false;
        }
        for (int x = lt.x; x < rb.x; ++x) {
            for (int y = lt.y; y < rb.y; ++y) {
                if (this.isBuildable(x, y) && (!checkExplored || this.isExplored(x, y))) continue;
                return false;
            }
        }
        if (builder != null && (!builder.getType().isBuilding() ? !builder.hasPath(lt.toPosition().add(type.tileSize().toPosition().divide(2))) : !builder.getType().isFlyingBuilding() && type != UnitType.Zerg_Nydus_Canal && !type.isFlagBeacon())) {
            return false;
        }
        if (type != UnitType.Special_Start_Location) {
            Position targPos = lt.toPosition().add(type.tileSize().toPosition().divide(2));
            List<Unit> unitsInRect = this.getUnitsInRectangle(targPos.subtract(new Position(type.dimensionLeft(), type.dimensionUp())), targPos.add(new Position(type.dimensionRight(), type.dimensionDown())), u -> !u.isFlying() && !u.isLoaded() && (builder != u || type == UnitType.Zerg_Nydus_Canal));
            for (Unit u2 : unitsInRect) {
                if (type.isAddon() && u2.getType().canMove()) continue;
                return false;
            }
            boolean needsCreep = type.requiresCreep();
            if (type.getRace() != Race.Zerg || needsCreep) {
                for (int x = lt.x; x < rb.x; ++x) {
                    for (int y = lt.y; y < rb.y; ++y) {
                        if (needsCreep == this.hasCreep(x, y)) continue;
                        return false;
                    }
                }
            }
            if (type.requiresPsi() && !this.hasPower(lt, type)) {
                return false;
            }
        }
        if (type.isResourceDepot()) {
            for (Unit m : this.getStaticMinerals()) {
                TilePosition tp = m.getInitialTilePosition();
                if ((this.isVisible(tp) || this.isVisible(tp.x + 1, tp.y)) && !m.exists() || tp.x <= lt.x - 5 || tp.y <= lt.y - 4 || tp.x >= lt.x + 7 || tp.y >= lt.y + 6) continue;
                return false;
            }
            for (Unit g : this.getStaticGeysers()) {
                TilePosition tp = g.getInitialTilePosition();
                if (tp.x <= lt.x - 7 || tp.y <= lt.y - 5 || tp.x >= lt.x + 7 || tp.y >= lt.y + 6) continue;
                return false;
            }
        }
        if (builder != null && !builder.getType().isAddon() && type.isAddon()) {
            return this.canBuildHere(lt.subtract(new TilePosition(4, 1)), builder.getType(), builder, checkExplored);
        }
        return true;
    }

    public boolean canMake(UnitType type) {
        return this.canMake(type, null);
    }

    public boolean canMake(UnitType type, Unit builder) {
        Player pSelf = this.self();
        if (pSelf == null) {
            return false;
        }
        if (!pSelf.isUnitAvailable(type)) {
            return false;
        }
        UnitType requiredType = type.whatBuilds().getKey();
        if (builder != null) {
            if (!pSelf.equals(builder.getPlayer())) {
                return false;
            }
            UnitType builderType = builder.getType();
            if (type == UnitType.Zerg_Nydus_Canal && builderType == UnitType.Zerg_Nydus_Canal) {
                if (!builder.isCompleted()) {
                    return false;
                }
                return builder.getNydusExit() == null;
            }
            if (requiredType == UnitType.Zerg_Larva && builderType.producesLarva() ? builder.getLarva().size() == 0 : !builderType.equals((Object)requiredType)) {
                return false;
            }
            switch (builderType) {
                case Protoss_Carrier: 
                case Hero_Gantrithor: {
                    int max_amt = 4;
                    if (pSelf.getUpgradeLevel(UpgradeType.Carrier_Capacity) > 0 || builderType == UnitType.Hero_Gantrithor) {
                        max_amt += 4;
                    }
                    if (builder.getInterceptorCount() + builder.getTrainingQueue().size() < max_amt) break;
                    return false;
                }
                case Protoss_Reaver: 
                case Hero_Warbringer: {
                    int max_amt = 5;
                    if (pSelf.getUpgradeLevel(UpgradeType.Reaver_Capacity) > 0 || builderType == UnitType.Hero_Warbringer) {
                        max_amt += 5;
                    }
                    if (builder.getScarabCount() + builder.getTrainingQueue().size() < max_amt) break;
                    return false;
                }
            }
        }
        if (pSelf.minerals() < type.mineralPrice()) {
            return false;
        }
        if (pSelf.gas() < type.gasPrice()) {
            return false;
        }
        Race typeRace = type.getRace();
        int supplyRequired = type.supplyRequired() * (type.isTwoUnitsInOneEgg() ? 2 : 1);
        if (supplyRequired > 0 && pSelf.supplyTotal(typeRace) < pSelf.supplyUsed(typeRace) + supplyRequired - (requiredType.getRace() == typeRace ? requiredType.supplyRequired() : 0)) {
            return false;
        }
        UnitType addon = UnitType.None;
        Map<UnitType, Integer> reqUnits = type.requiredUnits();
        for (UnitType ut : type.requiredUnits().keySet()) {
            if (ut.isAddon()) {
                addon = ut;
            }
            if (pSelf.hasUnitTypeRequirement(ut, reqUnits.get((Object)ut))) continue;
            return false;
        }
        if (type.requiredTech() != TechType.None && !pSelf.hasResearched(type.requiredTech())) {
            return false;
        }
        return builder == null || addon == UnitType.None || addon.whatBuilds().getKey() != type.whatBuilds().getKey() || builder.getAddon() != null && builder.getAddon().getType() == addon;
    }

    public boolean canResearch(TechType type, Unit unit) {
        return this.canResearch(type, unit, true);
    }

    public boolean canResearch(TechType type) {
        return this.canResearch(type, null);
    }

    public boolean canResearch(TechType type, Unit unit, boolean checkCanIssueCommandType) {
        Player self = this.self();
        if (self == null) {
            return false;
        }
        if (unit != null) {
            if (!unit.getPlayer().equals(self)) {
                return false;
            }
            if (!unit.getType().isSuccessorOf(type.whatResearches())) {
                return false;
            }
            if (checkCanIssueCommandType && (unit.isLifted() || !unit.isIdle() || !unit.isCompleted())) {
                return false;
            }
        }
        if (self.isResearching(type)) {
            return false;
        }
        if (self.hasResearched(type)) {
            return false;
        }
        if (!self.isResearchAvailable(type)) {
            return false;
        }
        if (self.minerals() < type.mineralPrice()) {
            return false;
        }
        if (self.gas() < type.gasPrice()) {
            return false;
        }
        return self.hasUnitTypeRequirement(type.requiredUnit());
    }

    public boolean canUpgrade(UpgradeType type, Unit unit) {
        return this.canUpgrade(type, unit, true);
    }

    public boolean canUpgrade(UpgradeType type) {
        return this.canUpgrade(type, null);
    }

    public boolean canUpgrade(UpgradeType type, Unit unit, boolean checkCanIssueCommandType) {
        Player self = this.self();
        if (self == null) {
            return false;
        }
        if (unit != null) {
            if (!unit.getPlayer().equals(self)) {
                return false;
            }
            if (!unit.getType().isSuccessorOf(type.whatUpgrades())) {
                return false;
            }
            if (checkCanIssueCommandType && (unit.isLifted() || !unit.isIdle() || !unit.isCompleted())) {
                return false;
            }
        }
        if (!self.hasUnitTypeRequirement(type.whatUpgrades())) {
            return false;
        }
        int nextLvl = self.getUpgradeLevel(type) + 1;
        if (!self.hasUnitTypeRequirement(type.whatsRequired(nextLvl))) {
            return false;
        }
        if (self.isUpgrading(type)) {
            return false;
        }
        if (self.getUpgradeLevel(type) >= self.getMaxUpgradeLevel(type)) {
            return false;
        }
        if (self.minerals() < type.mineralPrice(nextLvl)) {
            return false;
        }
        return self.gas() >= type.gasPrice(nextLvl);
    }

    public List<TilePosition> getStartLocations() {
        return this.startLocations;
    }

    public void printf(String string) {
        this.addCommand(CommandType.Printf, this.client.addString(string), 0);
    }

    public void sendText(String string) {
        this.addCommand(CommandType.SendText, this.client.addString(string), 0);
    }

    public void sendTextEx(boolean toAllies, String string) {
        this.addCommand(CommandType.SendText, this.client.addString(string), toAllies ? 1 : 0);
    }

    public boolean isInGame() {
        return this.gameData.isInGame();
    }

    public boolean isMultiplayer() {
        return this.multiplayer;
    }

    public boolean isBattleNet() {
        return this.battleNet;
    }

    public boolean isPaused() {
        return this.gameData.isPaused();
    }

    public boolean isReplay() {
        return this.replay;
    }

    public void pauseGame() {
        this.addCommand(CommandType.PauseGame, 0, 0);
    }

    public void resumeGame() {
        this.addCommand(CommandType.ResumeGame, 0, 0);
    }

    public void leaveGame() {
        this.addCommand(CommandType.LeaveGame, 0, 0);
    }

    public void restartGame() {
        this.addCommand(CommandType.RestartGame, 0, 0);
    }

    public void setLocalSpeed(int speed) {
        this.addCommand(CommandType.SetLocalSpeed, speed, 0);
    }

    public boolean issueCommand(Collection<Unit> units, UnitCommand command) {
        return units.stream().map(u -> u.issueCommand(command)).reduce(false, (a, b) -> a | b);
    }

    public List<Unit> getSelectedUnits() {
        if (!this.isFlagEnabled(Flag.UserInput)) {
            return Collections.emptyList();
        }
        return IntStream.range(0, this.gameData.getSelectedUnitCount()).mapToObj(i -> this.units[this.gameData.getSelectedUnits(i)]).collect(Collectors.toList());
    }

    public Player self() {
        return this.self;
    }

    public Player enemy() {
        return this.enemy;
    }

    public Player neutral() {
        return this.neutral;
    }

    public List<Player> allies() {
        return this.allies;
    }

    public List<Player> enemies() {
        return this.enemies;
    }

    public List<Player> observers() {
        return this.observers;
    }

    public void drawText(CoordinateType ctype, int x, int y, String string) {
        int stringId = this.client.addString(string);
        this.addShape(ShapeType.Text, ctype, x, y, 0, 0, stringId, this.textSize.id, 0, false);
    }

    public void drawTextMap(int x, int y, String string) {
        this.drawText(CoordinateType.Map, x, y, string);
    }

    public void drawTextMap(Position p, String string) {
        this.drawTextMap(p.x, p.y, string);
    }

    public void drawTextMouse(int x, int y, String string) {
        this.drawText(CoordinateType.Mouse, x, y, string);
    }

    public void drawTextMouse(Position p, String string) {
        this.drawTextMouse(p.x, p.y, string);
    }

    public void drawTextScreen(int x, int y, String string) {
        this.drawText(CoordinateType.Screen, x, y, string);
    }

    public void drawTextScreen(Position p, String string) {
        this.drawTextScreen(p.x, p.y, string);
    }

    public void drawBox(CoordinateType ctype, int left, int top, int right, int bottom, Color color) {
        this.drawBox(ctype, left, top, right, bottom, color, false);
    }

    public void drawBox(CoordinateType ctype, int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.addShape(ShapeType.Box, ctype, left, top, right, bottom, 0, 0, color.id, isSolid);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color) {
        this.drawBox(CoordinateType.Map, left, top, right, bottom, color);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Map, left, top, right, bottom, color, isSolid);
    }

    public void drawBoxMap(Position leftTop, Position rightBottom, Color color) {
        this.drawBox(CoordinateType.Map, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color);
    }

    public void drawBoxMap(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Map, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color, isSolid);
    }

    public void drawBoxMouse(int left, int top, int right, int bottom, Color color) {
        this.drawBox(CoordinateType.Mouse, left, top, right, bottom, color);
    }

    public void drawBoxMouse(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Mouse, left, top, right, bottom, color, isSolid);
    }

    public void drawBoxMouse(Position leftTop, Position rightBottom, Color color) {
        this.drawBox(CoordinateType.Mouse, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color);
    }

    public void drawBoxMouse(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Mouse, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color, isSolid);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color) {
        this.drawBox(CoordinateType.Screen, left, top, right, bottom, color);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Screen, left, top, right, bottom, color, isSolid);
    }

    public void drawBoxScreen(Position leftTop, Position rightBottom, Color color) {
        this.drawBox(CoordinateType.Screen, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color);
    }

    public void drawBoxScreen(Position leftTop, Position rightBottom, Color color, boolean isSolid) {
        this.drawBox(CoordinateType.Screen, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, color, isSolid);
    }

    public void drawTriangle(CoordinateType ctype, int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle(ctype, ax, ay, bx, by, cx, cy, color, false);
    }

    public void drawTriangle(CoordinateType ctype, int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.addShape(ShapeType.Triangle, ctype, ax, ay, bx, by, cx, cy, color.id, isSolid);
    }

    public void drawTriangleMap(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle(CoordinateType.Map, ax, ay, bx, by, cx, cy, color);
    }

    public void drawTriangleMap(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Map, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawTriangleMap(Position a, Position b, Position c, Color color) {
        this.drawTriangle(CoordinateType.Map, a.x, a.y, b.x, b.y, c.x, c.y, color);
    }

    public void drawTriangleMap(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Map, a.x, a.y, b.x, b.y, c.x, c.y, color, isSolid);
    }

    public void drawTriangleMouse(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle(CoordinateType.Mouse, ax, ay, bx, by, cx, cy, color);
    }

    public void drawTriangleMouse(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Mouse, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawTriangleMouse(Position a, Position b, Position c, Color color) {
        this.drawTriangle(CoordinateType.Mouse, a.x, a.y, b.x, b.y, c.x, c.y, color);
    }

    public void drawTriangleMouse(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Mouse, a.x, a.y, b.x, b.y, c.x, c.y, color, isSolid);
    }

    public void drawTriangleScreen(int ax, int ay, int bx, int by, int cx, int cy, Color color) {
        this.drawTriangle(CoordinateType.Screen, ax, ay, bx, by, cx, cy, color);
    }

    public void drawTriangleScreen(int ax, int ay, int bx, int by, int cx, int cy, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Screen, ax, ay, bx, by, cx, cy, color, isSolid);
    }

    public void drawTriangleScreen(Position a, Position b, Position c, Color color) {
        this.drawTriangle(CoordinateType.Screen, a.x, a.y, b.x, b.y, c.x, c.y, color);
    }

    public void drawTriangleScreen(Position a, Position b, Position c, Color color, boolean isSolid) {
        this.drawTriangle(CoordinateType.Screen, a.x, a.y, b.x, b.y, c.x, c.y, color, isSolid);
    }

    public void drawCircle(CoordinateType ctype, int x, int y, int radius, Color color) {
        this.drawCircle(ctype, x, y, radius, color, false);
    }

    public void drawCircle(CoordinateType ctype, int x, int y, int radius, Color color, boolean isSolid) {
        this.addShape(ShapeType.Circle, ctype, x, y, 0, 0, radius, 0, color.id, isSolid);
    }

    public void drawCircleMap(int x, int y, int radius, Color color) {
        this.drawCircle(CoordinateType.Map, x, y, radius, color);
    }

    public void drawCircleMap(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Map, x, y, radius, color, isSolid);
    }

    public void drawCircleMap(Position p, int radius, Color color) {
        this.drawCircle(CoordinateType.Map, p.x, p.y, radius, color);
    }

    public void drawCircleMap(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Map, p.x, p.y, radius, color, isSolid);
    }

    public void drawCircleMouse(int x, int y, int radius, Color color) {
        this.drawCircle(CoordinateType.Mouse, x, y, radius, color);
    }

    public void drawCircleMouse(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Mouse, x, y, radius, color, isSolid);
    }

    public void drawCircleMouse(Position p, int radius, Color color) {
        this.drawCircle(CoordinateType.Mouse, p.x, p.y, radius, color);
    }

    public void drawCircleMouse(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Mouse, p.x, p.y, radius, color, isSolid);
    }

    public void drawCircleScreen(int x, int y, int radius, Color color) {
        this.drawCircle(CoordinateType.Screen, x, y, radius, color);
    }

    public void drawCircleScreen(int x, int y, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Screen, x, y, radius, color, isSolid);
    }

    public void drawCircleScreen(Position p, int radius, Color color) {
        this.drawCircle(CoordinateType.Screen, p.x, p.y, radius, color);
    }

    public void drawCircleScreen(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircle(CoordinateType.Screen, p.x, p.y, radius, color, isSolid);
    }

    public void drawEllipse(CoordinateType ctype, int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse(ctype, x, y, xrad, yrad, color, false);
    }

    public void drawEllipse(CoordinateType ctype, int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.addShape(ShapeType.Ellipse, ctype, x, y, 0, 0, xrad, yrad, color.id, isSolid);
    }

    public void drawEllipseMap(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Map, x, y, xrad, yrad, color);
    }

    public void drawEllipseMap(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Map, x, y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseMap(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Map, p.x, p.y, xrad, yrad, color);
    }

    public void drawEllipseMap(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Map, p.x, p.y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseMouse(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Mouse, x, y, xrad, yrad, color);
    }

    public void drawEllipseMouse(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Mouse, x, y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseMouse(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Mouse, p.x, p.y, xrad, yrad, color);
    }

    public void drawEllipseMouse(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Mouse, p.x, p.y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseScreen(int x, int y, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Screen, x, y, xrad, yrad, color);
    }

    public void drawEllipseScreen(int x, int y, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Mouse, x, y, xrad, yrad, color, isSolid);
    }

    public void drawEllipseScreen(Position p, int xrad, int yrad, Color color) {
        this.drawEllipse(CoordinateType.Mouse, p.x, p.y, xrad, yrad, color);
    }

    public void drawEllipseScreen(Position p, int xrad, int yrad, Color color, boolean isSolid) {
        this.drawEllipse(CoordinateType.Mouse, p.x, p.y, xrad, yrad, color, isSolid);
    }

    public void drawDot(CoordinateType ctype, int x, int y, Color color) {
        this.addShape(ShapeType.Dot, ctype, x, y, 0, 0, 0, 0, color.id, false);
    }

    public void drawDotMap(int x, int y, Color color) {
        this.drawDot(CoordinateType.Map, x, y, color);
    }

    public void drawDotMap(Position p, Color color) {
        this.drawDot(CoordinateType.Map, p.x, p.y, color);
    }

    public void drawDotMouse(int x, int y, Color color) {
        this.drawDot(CoordinateType.Mouse, x, y, color);
    }

    public void drawDotMouse(Position p, Color color) {
        this.drawDot(CoordinateType.Mouse, p.x, p.y, color);
    }

    public void drawDotScreen(int x, int y, Color color) {
        this.drawDot(CoordinateType.Screen, x, y, color);
    }

    public void drawDotScreen(Position p, Color color) {
        this.drawDot(CoordinateType.Screen, p.x, p.y, color);
    }

    public void drawLine(CoordinateType ctype, int x1, int y1, int x2, int y2, Color color) {
        this.addShape(ShapeType.Line, ctype, x1, y1, x2, y2, 0, 0, color.id, false);
    }

    public void drawLineMap(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.Map, x1, y1, x2, y2, color);
    }

    public void drawLineMap(Position a, Position b, Color color) {
        this.drawLine(CoordinateType.Map, a.x, a.y, b.x, b.y, color);
    }

    public void drawLineMouse(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.Mouse, x1, y1, x2, y2, color);
    }

    public void drawLineMouse(Position a, Position b, Color color) {
        this.drawLine(CoordinateType.Mouse, a.x, a.y, b.x, b.y, color);
    }

    public void drawLineScreen(int x1, int y1, int x2, int y2, Color color) {
        this.drawLine(CoordinateType.Screen, x1, y1, x2, y2, color);
    }

    public void drawLineScreen(Position a, Position b, Color color) {
        this.drawLine(CoordinateType.Screen, a.x, a.y, b.x, b.y, color);
    }

    public int getLatencyFrames() {
        return this.gameData.getLatencyFrames();
    }

    public int getLatencyTime() {
        return this.gameData.getLatencyTime();
    }

    public int getRemainingLatencyFrames() {
        return this.gameData.getRemainingLatencyFrames();
    }

    public int getRemainingLatencyTime() {
        return this.gameData.getRemainingLatencyTime();
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isLatComEnabled() {
        return this.latcom;
    }

    public void setLatCom(boolean isEnabled) {
        this.gameData.setHasLatCom(isEnabled);
        this.latcom = isEnabled;
        this.addCommand(CommandType.SetLatCom, isEnabled ? 1 : 0, 0);
    }

    public int getInstanceNumber() {
        return this.gameData.getInstanceID();
    }

    public int getAPM() {
        return this.getAPM(false);
    }

    public int getAPM(boolean includeSelects) {
        return includeSelects ? this.gameData.getBotAPM_selects() : this.gameData.getBotAPM_noselects();
    }

    public void setFrameSkip(int frameSkip) {
        this.addCommand(CommandType.SetFrameSkip, Math.max(frameSkip, 1), 0);
    }

    public boolean setAlliance(Player player, boolean allied, boolean alliedVictory) {
        if (this.self() == null || this.isReplay() || player == null || player.equals(this.self())) {
            return false;
        }
        this.addCommand(CommandType.SetAllies, player.getID(), allied ? (alliedVictory ? 2 : 1) : 0);
        return true;
    }

    public boolean setAlliance(Player player, boolean allied) {
        return this.setAlliance(player, allied, true);
    }

    public boolean setAlliance(Player player) {
        return this.setAlliance(player, true);
    }

    public boolean setVision(Player player, boolean enabled) {
        if (player == null) {
            return false;
        }
        if (!this.isReplay() && (this.self() == null || player.equals(this.self()))) {
            return false;
        }
        this.addCommand(CommandType.SetVision, player.getID(), enabled ? 1 : 0);
        return true;
    }

    boolean isGUIEnabled() {
        return this.gameData.getHasGUI();
    }

    public void setGUI(boolean enabled) {
        this.gameData.setHasGUI(enabled);
        this.addCommand(CommandType.SetGui, enabled ? 1 : 0, 0);
    }

    public int getLastEventTime() {
        return 0;
    }

    public boolean setMap(String mapFileName) {
        if (mapFileName == null || mapFileName.length() >= 260 || mapFileName.charAt(0) == '\u0000') {
            return false;
        }
        this.addCommand(CommandType.SetMap, this.client.addString(mapFileName), 0);
        return true;
    }

    public boolean setRevealAll(boolean reveal) {
        if (!this.isReplay()) {
            return false;
        }
        this.addCommand(CommandType.SetRevealAll, reveal ? 1 : 0, 0);
        return true;
    }

    public boolean setRevealAll() {
        return this.setRevealAll(true);
    }

    public boolean hasPath(Position source, Position destination) {
        if (source == null || destination == null) {
            return false;
        }
        if (source.isValid(this) && destination.isValid(this)) {
            Region rgnA = this.getRegionAt(source);
            Region rgnB = this.getRegionAt(destination);
            return rgnA != null && rgnB != null && rgnA.getRegionGroupID() == rgnB.getRegionGroupID();
        }
        return false;
    }

    public void setTextSize() {
        this.setTextSize(Text.Size.Default);
    }

    public void setTextSize(Text.Size size) {
        this.textSize = size;
    }

    public int elapsedTime() {
        return this.gameData.getElapsedTime();
    }

    public void setCommandOptimizationLevel(int level) {
        this.addCommand(CommandType.SetCommandOptimizerLevel, level, 0);
    }

    public int countdownTimer() {
        return this.gameData.getCountdownTimer();
    }

    public List<Region> getAllRegions() {
        return this.regionSet;
    }

    public Region getRegionAt(int x, int y) {
        return this.getRegionAt(new Position(x, y));
    }

    public Region getRegionAt(Position position) {
        if (!position.isValid(this)) {
            return null;
        }
        short idx = this.mapTileRegionID[position.x / 32][position.y / 32];
        if ((idx & 0x2000) != 0) {
            int index = idx & 0x1FFF;
            if (index >= 5000) {
                return null;
            }
            int minitileShift = (position.x & 0x1F) / 8 + (position.y & 0x1F) / 8 * 4;
            if ((this.mapSplitTilesMiniTileMask[index] >> minitileShift & 1) != 0) {
                return this.getRegion(this.mapSplitTilesRegion2[index]);
            }
            return this.getRegion(this.mapSplitTilesRegion1[index]);
        }
        return this.getRegion(idx);
    }

    public TilePosition getBuildLocation(UnitType type, TilePosition desiredPosition, int maxRange) {
        return this.getBuildLocation(type, desiredPosition, maxRange, false);
    }

    public TilePosition getBuildLocation(UnitType type, TilePosition desiredPosition) {
        return this.getBuildLocation(type, desiredPosition, 64);
    }

    public TilePosition getBuildLocation(UnitType type, TilePosition desiredPosition, int maxRange, boolean creep) {
        return BuildingPlacer.getBuildLocation(type, desiredPosition, maxRange, creep, this);
    }

    private int getDamageFromImpl(UnitType fromType, UnitType toType, Player fromPlayer, Player toPlayer) {
        int dmg;
        WeaponType wpn;
        WeaponType weaponType = wpn = toType.isFlyer() ? fromType.airWeapon() : fromType.groundWeapon();
        if (wpn == WeaponType.None || wpn == WeaponType.Unknown) {
            return 0;
        }
        int n = dmg = fromPlayer != null ? fromPlayer.damage(wpn) : wpn.damageAmount() * wpn.damageFactor();
        if (wpn.damageType() != DamageType.Ignore_Armor && toPlayer != null) {
            dmg -= Math.min(dmg, toPlayer.armor(toType));
        }
        return dmg * damageRatio[wpn.damageType().id][toType.size().id] / 256;
    }

    public int getDamageFrom(UnitType fromType, UnitType toType, Player fromPlayer) {
        return this.getDamageFrom(fromType, toType, fromPlayer, null);
    }

    public int getDamageFrom(UnitType fromType, UnitType toType) {
        return this.getDamageFrom(fromType, toType, null);
    }

    public int getDamageFrom(UnitType fromType, UnitType toType, Player fromPlayer, Player toPlayer) {
        return this.getDamageFromImpl(fromType, toType, fromPlayer, toPlayer == null ? this.self() : toPlayer);
    }

    public int getDamageTo(UnitType toType, UnitType fromType, Player toPlayer) {
        return this.getDamageTo(toType, fromType, toPlayer, null);
    }

    public int getDamageTo(UnitType toType, UnitType fromType) {
        return this.getDamageTo(toType, fromType, null);
    }

    public int getDamageTo(UnitType toType, UnitType fromType, Player toPlayer, Player fromPlayer) {
        return this.getDamageFromImpl(fromType, toType, fromPlayer == null ? this.self() : fromPlayer, toPlayer);
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }
}

