/*
 * Decompiled with CFR 0.152.
 */
package unit.scout;

import bwapi.Game;
import bwapi.TilePosition;
import info.InformationManager;
import java.util.HashSet;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class ScoutManager {
    private Game game;
    private InformationManager informationManager;
    private HashSet<ManagedUnit> scouts = new HashSet();

    public ScoutManager(Game game, InformationManager informationManager) {
        this.game = game;
        this.informationManager = informationManager;
    }

    public void onFrame() {
        for (ManagedUnit managedUnit : this.scouts) {
            if (managedUnit.getMovementTargetPosition() != null) continue;
            this.assignScoutMovementTarget(managedUnit);
        }
    }

    public void addScout(ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.SCOUT);
        this.assignScoutMovementTarget(managedUnit);
        this.scouts.add(managedUnit);
    }

    public void removeScout(ManagedUnit managedUnit) {
        if (managedUnit == null) {
            return;
        }
        TilePosition movementTarget = managedUnit.getMovementTargetPosition();
        HashSet<TilePosition> activeScoutTargets = this.informationManager.getActiveScoutTargets();
        if (movementTarget != null && activeScoutTargets.contains(managedUnit.getMovementTargetPosition())) {
            activeScoutTargets.remove(movementTarget);
        }
    }

    private void assignScoutMovementTarget(ManagedUnit managedUnit) {
        if (managedUnit.getMovementTargetPosition() != null) {
            if (!this.game.isVisible(managedUnit.getMovementTargetPosition())) {
                return;
            }
            managedUnit.setMovementTargetPosition(null);
        }
        TilePosition target = this.informationManager.pollScoutTarget(false);
        this.informationManager.setActiveScoutTarget(target);
        managedUnit.setMovementTargetPosition(target);
    }
}

