/*
 * Decompiled with CFR 0.152.
 */
package unit.managed;

import bwapi.Color;
import bwapi.Game;
import bwapi.Position;
import bwapi.Text;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.ArrayList;
import java.util.List;
import planner.Plan;
import planner.PlanState;
import unit.managed.UnitRole;
import util.Filter;

public class ManagedUnit {
    private static int LOCK_ENEMY_WITHIN_DISTANCE = 25;
    private Game game;
    private final int unitID;
    private Unit unit;
    private UnitRole role;
    private UnitType unitType;
    private TilePosition rallyPoint;
    private TilePosition movementTargetPosition;
    private List<TilePosition> pathToTarget;
    private TilePosition retreatTarget;
    private Unit defendTarget;
    private Unit fightTarget;
    private Unit gatherTarget;
    private boolean hasNewGatherTarget;
    private Plan plan;
    private int buildAttemptFrame;
    private boolean canFight;
    private int unreadyUntilFrame = 0;
    private boolean isReady = true;

    public ManagedUnit(Game game, Unit unit, UnitRole role) {
        this.game = game;
        this.unit = unit;
        this.role = role;
        this.canFight = unit.getType() != UnitType.Zerg_Overlord;
        this.unitType = unit.getType();
        this.unitID = unit.getID();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedUnit)) {
            return false;
        }
        ManagedUnit u = (ManagedUnit)o;
        return this.unitID == u.getUnitID();
    }

    public int hashCode() {
        return this.unitID;
    }

    public int getUnitID() {
        return this.unitID;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public void setRallyPoint(TilePosition tilePosition) {
        this.rallyPoint = tilePosition;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public UnitRole getRole() {
        return this.role;
    }

    public void setRole(UnitRole role) {
        this.role = role;
    }

    public void setRetreatTarget(TilePosition tp) {
        this.retreatTarget = tp;
    }

    public Unit getDefendTarget() {
        return this.defendTarget;
    }

    public void setDefendTarget(Unit unit) {
        this.defendTarget = unit;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReady(boolean isReady) {
        this.isReady = isReady;
    }

    public int getUnreadyUntilFrame() {
        return this.unreadyUntilFrame;
    }

    public boolean canFight() {
        return this.canFight;
    }

    public void setCanFight(boolean canFight) {
        this.canFight = canFight;
    }

    public void setGatherTarget(Unit unit) {
        this.gatherTarget = unit;
    }

    public void hasNewGatherTarget(boolean hasNewGatherTarget) {
        this.hasNewGatherTarget = hasNewGatherTarget;
    }

    public TilePosition getMovementTargetPosition() {
        return this.movementTargetPosition;
    }

    public void setMovementTargetPosition(TilePosition tp) {
        this.movementTargetPosition = tp;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public void setUnitType(UnitType unitType) {
        this.unitType = unitType;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void execute() {
        this.debugRole();
        switch (this.role) {
            case SCOUT: {
                this.scout();
                break;
            }
            case FIGHT: {
                this.fight();
                break;
            }
            case GATHER: {
                this.gather();
                break;
            }
            case BUILD: {
                this.build();
                break;
            }
            case MORPH: {
                this.morph();
                break;
            }
            case RETREAT: {
                this.retreat();
                break;
            }
            case DEFEND: {
                this.defend();
                break;
            }
            case RALLY: {
                this.rally();
                break;
            }
        }
    }

    private void debugScout() {
        Position unitPosition = this.unit.getPosition();
        this.game.drawLineMap(unitPosition, this.movementTargetPosition.toPosition(), Color.White);
    }

    private void debugFight() {
        Position unitPosition = this.unit.getPosition();
        if (this.fightTarget != null) {
            this.game.drawLineMap(unitPosition, this.fightTarget.getPosition(), Color.Red);
        }
        if (this.movementTargetPosition != null) {
            this.game.drawLineMap(unitPosition, this.movementTargetPosition.toPosition(), Color.White);
        }
    }

    private void debugBuild() {
        Position unitPosition = this.unit.getPosition();
        Position buildPosition = this.plan.getBuildPosition().toPosition();
        this.game.drawLineMap(unitPosition, buildPosition, Color.Cyan);
        this.game.drawTextMap(unitPosition.add(new Position(8, 8)), String.format("Distance: %d", this.unit.getDistance(buildPosition)), Text.Cyan);
    }

    private void debugRole() {
        if (this.role == UnitRole.BUILDING) {
            return;
        }
        Position unitPosition = this.unit.getPosition();
        this.game.drawTextMap(unitPosition, String.format("%s", new Object[]{this.role}), Text.Default);
    }

    private void rally() {
        if (!this.isReady) {
            return;
        }
        if (this.rallyPoint == null) {
            return;
        }
        if (this.unit.getDistance(this.rallyPoint.toPosition()) < 64) {
            return;
        }
        this.setUnready();
        this.unit.move(this.rallyPoint.toPosition());
    }

    private void gather() {
        if (!this.hasNewGatherTarget & (this.unit.isGatheringMinerals() || this.unit.isGatheringGas())) {
            return;
        }
        if (!this.isReady) {
            return;
        }
        if ((this.unit.isCarryingGas() || this.unit.isCarryingMinerals()) && this.unit.isIdle()) {
            this.setUnready();
            this.unit.returnCargo();
            return;
        }
        if (this.gatherTarget == null) {
            this.role = UnitRole.IDLE;
            return;
        }
        this.setUnready();
        this.unit.gather(this.gatherTarget);
        this.hasNewGatherTarget = false;
    }

    private void build() {
        Position buildTarget;
        if (this.unit.isBeingConstructed() || this.unit.isMorphing()) {
            return;
        }
        if (this.plan.getBuildPosition() != null) {
            this.debugBuild();
        }
        if (!this.isReady) {
            return;
        }
        UnitType plannedUnitType = this.plan.getPlannedUnit();
        if (this.plan.getBuildPosition() == null) {
            TilePosition buildLocation = this.game.getBuildLocation(plannedUnitType, this.unit.getTilePosition());
            this.plan.setBuildPosition(buildLocation);
        }
        if (this.unit.getDistance(buildTarget = this.plan.getBuildPosition().toPosition().add(new Position(4, 4))) > 150 || !this.unit.isMoving() || this.unit.isGatheringMinerals()) {
            this.setUnready();
            this.unit.move(buildTarget);
            return;
        }
        if (this.game.canMake(plannedUnitType, this.unit)) {
            this.setUnready();
            boolean didBuild = this.unit.build(plannedUnitType, buildTarget.toTilePosition());
            if (!didBuild) {
                didBuild = this.unit.morph(plannedUnitType);
            }
            int frameCount = this.game.getFrameCount();
            if (!didBuild && this.buildAttemptFrame == 0) {
                this.buildAttemptFrame = frameCount;
            }
            if (!didBuild && this.buildAttemptFrame + 150 < frameCount) {
                this.plan.setBuildPosition(this.game.getBuildLocation(plannedUnitType, this.unit.getTilePosition()));
            }
            if (didBuild) {
                this.plan.setState(PlanState.MORPHING);
            }
        }
    }

    private void morph() {
        if (!this.isReady) {
            return;
        }
        if (this.unit.isMorphing()) {
            return;
        }
        UnitType unitType = this.plan.getPlannedUnit();
        if (this.game.canMake(unitType, this.unit)) {
            this.setUnready();
            boolean didMorph = this.unit.morph(unitType);
            if (didMorph) {
                this.plan.setState(PlanState.MORPHING);
            }
        }
    }

    private void setUnready() {
        this.isReady = false;
        this.unreadyUntilFrame = this.game.getFrameCount() + this.game.getLatencyFrames() + 11;
    }

    private void scout() {
        if (this.movementTargetPosition == null) {
            return;
        }
        this.debugScout();
        if (!this.isReady) {
            return;
        }
        if (this.game.isVisible(this.movementTargetPosition)) {
            this.movementTargetPosition = null;
            return;
        }
        this.setUnready();
        this.unit.move(this.movementTargetPosition.toPosition());
    }

    private void fight() {
        this.debugFight();
        if (!this.isReady) {
            return;
        }
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.setUnready();
        if (!(this.fightTarget == null || this.fightTarget.getType() != UnitType.Unknown && this.fightTarget.isTargetable())) {
            this.fightTarget = null;
        }
        if (this.fightTarget != null) {
            this.unit.attack(this.fightTarget);
            return;
        }
        if (this.movementTargetPosition != null && this.game.isVisible(this.movementTargetPosition)) {
            this.movementTargetPosition = null;
        }
        if (this.movementTargetPosition != null) {
            this.unit.move(this.movementTargetPosition.toPosition());
            return;
        }
        this.role = UnitRole.IDLE;
    }

    private void retreat() {
        if (!this.isReady) {
            return;
        }
        if (this.retreatTarget == null) {
            this.role = UnitRole.IDLE;
            return;
        }
        this.setUnready();
        if (this.unit.getDistance(this.retreatTarget.toPosition()) < 250 || this.unit.isIdle()) {
            this.role = UnitRole.IDLE;
            return;
        }
        this.unit.move(this.retreatTarget.toPosition());
    }

    private void defend() {
        if (!this.isReady) {
            return;
        }
        if (this.unit.isAttackFrame()) {
            return;
        }
        this.setUnready();
        if (this.defendTarget != null && this.defendTarget.getType() == UnitType.Unknown) {
            this.defendTarget = null;
        }
        if (this.defendTarget != null) {
            this.unit.attack(this.defendTarget);
            return;
        }
    }

    public void assignClosestEnemyAsFightTarget(List<Unit> enemies, TilePosition backupScoutPosition) {
        if (this.fightTarget != null && !this.fightTarget.getType().isBuilding() && this.fightTarget.getDistance(this.unit) < LOCK_ENEMY_WITHIN_DISTANCE) {
            return;
        }
        ArrayList<Unit> filtered = new ArrayList<Unit>();
        for (Unit enemyUnit : enemies) {
            if (!this.unit.canAttack(enemyUnit) || !enemyUnit.isDetected()) continue;
            filtered.add(enemyUnit);
        }
        if (filtered.size() > 0) {
            Unit closestEnemy;
            this.fightTarget = closestEnemy = Filter.closestHostileUnit(this.unit, filtered);
            this.movementTargetPosition = closestEnemy.getTilePosition();
            return;
        }
        this.movementTargetPosition = backupScoutPosition;
    }
}

