/*
 * Decompiled with CFR 0.152.
 */
package unit;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import info.GameState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import planner.Plan;
import planner.PlanComparator;
import planner.PlanState;
import planner.PlanType;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;
import util.BaseUnitDistanceComparator;
import util.UnitDistanceComparator;

public class WorkerManager {
    private Game game;
    private GameState gameState;
    private HashSet<ManagedUnit> assignedManagedWorkers = new HashSet();
    private HashSet<ManagedUnit> gatherers;
    private HashSet<ManagedUnit> mineralGatherers;
    private HashSet<ManagedUnit> gasGatherers;
    private HashSet<ManagedUnit> larva;
    private HashSet<ManagedUnit> eggs = new HashSet();
    private HashSet<ManagedUnit> scheduledDrones = new HashSet();
    final int OVERLORD_HATCH_ANIMATION_FRAMES = 26;

    public WorkerManager(Game game, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
        this.gatherers = gameState.getGatherers();
        this.larva = gameState.getLarva();
        this.mineralGatherers = gameState.getMineralGatherers();
        this.gasGatherers = gameState.getGasGatherers();
    }

    public void onFrame() {
        this.checksLarvaDeadlock();
        this.handleLarvaDeadlock();
        this.assignScheduledPlannedItems();
        this.executeScheduledDrones();
        this.releaseImpossiblePlans();
    }

    public void onUnitComplete(ManagedUnit managedUnit) {
        UnitType unitType = managedUnit.getUnitType();
        if (unitType == UnitType.Zerg_Drone) {
            this.assignWorker(managedUnit);
            return;
        }
        if (unitType == UnitType.Zerg_Larva) {
            this.larva.add(managedUnit);
            return;
        }
    }

    public void onUnitMorph(ManagedUnit managedUnit) {
        this.clearAssignments(managedUnit);
        if (managedUnit.getUnitType() == UnitType.Zerg_Drone) {
            this.assignWorker(managedUnit);
        }
        if (managedUnit.getUnitType() == UnitType.Zerg_Egg) {
            this.eggs.add(managedUnit);
        }
    }

    public void addManagedWorker(ManagedUnit managedUnit) {
        this.assignWorker(managedUnit);
    }

    public void removeManagedWorker(ManagedUnit managedUnit) {
        this.clearAssignments(managedUnit);
    }

    public void removeMineral(Unit unit) {
        HashMap<Unit, HashSet<ManagedUnit>> mineralAssignments = this.gameState.getMineralAssignments();
        HashSet mineralWorkers = (HashSet)mineralAssignments.get(unit);
        mineralAssignments.remove(unit);
        if (mineralWorkers == null) {
            return;
        }
        for (ManagedUnit managedUnit : mineralWorkers) {
            this.clearAssignments(managedUnit);
            this.assignWorker(managedUnit);
        }
    }

    public void removeGeyser(Unit unit) {
        HashMap<Unit, HashSet<ManagedUnit>> geyserAssignments = this.gameState.getGeyserAssignments();
        HashSet geyserWorkers = (HashSet)geyserAssignments.get(unit);
        geyserAssignments.remove(unit);
        if (geyserWorkers == null) {
            return;
        }
        for (ManagedUnit managedUnit : geyserWorkers) {
            this.clearAssignments(managedUnit);
            this.assignWorker(managedUnit);
        }
    }

    public void onExtractorComplete() {
        ArrayList<ManagedUnit> newGeyserWorkers = new ArrayList<ManagedUnit>();
        if (this.mineralGatherers.size() < 4) {
            return;
        }
        for (ManagedUnit managedUnit : this.mineralGatherers) {
            if (newGeyserWorkers.size() >= 3) break;
            newGeyserWorkers.add(managedUnit);
        }
        for (ManagedUnit managedUnit : newGeyserWorkers) {
            this.clearAssignments(managedUnit);
            this.assignToGeyser(managedUnit);
        }
    }

    private void assignScheduledPlannedItems() {
        List scheduledPlans = this.gameState.getPlansScheduled().stream().collect(Collectors.toList());
        if (scheduledPlans.size() < 1) {
            return;
        }
        Collections.sort(scheduledPlans, new PlanComparator());
        ArrayList<Plan> assignedPlans = new ArrayList<Plan>();
        for (Plan plan : scheduledPlans) {
            UnitType planType = plan.getPlannedUnit();
            boolean didAssign = false;
            if (plan.getType() == PlanType.BUILDING) {
                if (this.isBuildingMorph(planType)) continue;
                didAssign = this.assignMorphDrone(plan);
            } else if (plan.getType() == PlanType.UNIT) {
                didAssign = this.assignMorphLarva(plan);
            }
            if (!didAssign) continue;
            assignedPlans.add(plan);
        }
        HashSet<Plan> buildingPlans = this.gameState.getPlansBuilding();
        for (Plan plan : assignedPlans) {
            scheduledPlans.remove(plan);
            buildingPlans.add(plan);
        }
        this.gameState.setPlansScheduled(scheduledPlans.stream().collect(Collectors.toCollection(HashSet::new)));
    }

    private void releaseImpossiblePlans() {
        Plan currentPlan;
        HashSet<Plan> impossiblePlans = this.gameState.getPlansImpossible();
        ArrayList cancelledPlans = new ArrayList();
        for (ManagedUnit larva : this.larva) {
            currentPlan = larva.getPlan();
            if (currentPlan == null || !impossiblePlans.contains(currentPlan)) continue;
            this.gameState.cancelPlan(larva.getUnit(), currentPlan);
        }
        for (ManagedUnit drone : this.scheduledDrones) {
            currentPlan = drone.getPlan();
            if (currentPlan == null || !impossiblePlans.contains(currentPlan)) continue;
            this.gameState.cancelPlan(drone.getUnit(), currentPlan);
        }
    }

    private boolean isBuildingMorph(UnitType unitType) {
        switch (unitType) {
            case Zerg_Lair: 
            case Zerg_Sunken_Colony: {
                return true;
            }
        }
        return false;
    }

    private int getTravelFrames(Unit unit, Position buildingPosition) {
        Position unitPosition = unit.getPosition();
        double distance = buildingPosition.getDistance(unitPosition);
        double unitSpeed = unit.getType().topSpeed();
        return (int)(distance / unitSpeed);
    }

    private void executeScheduledDrones() {
        int currentFrame = this.game.getFrameCount();
        ArrayList<ManagedUnit> executed = new ArrayList<ManagedUnit>();
        for (ManagedUnit managedUnit : this.scheduledDrones) {
            Plan plan = managedUnit.getPlan();
            int travelFrames = this.getTravelFrames(managedUnit.getUnit(), plan.getBuildPosition().toPosition());
            if (currentFrame <= plan.getPredictedReadyFrame() - travelFrames) continue;
            plan.setState(PlanState.BUILDING);
            managedUnit.setRole(UnitRole.BUILD);
            executed.add(managedUnit);
        }
        for (ManagedUnit managedUnit : executed) {
            this.scheduledDrones.remove(managedUnit);
        }
    }

    private void clearAssignments(ManagedUnit managedUnit) {
        if (this.assignedManagedWorkers.contains(managedUnit)) {
            for (HashSet<ManagedUnit> mineralWorkers : this.gameState.getMineralAssignments().values()) {
                if (!mineralWorkers.contains(managedUnit)) continue;
                this.gameState.setMineralWorkers(this.gameState.getMineralWorkers() - 1);
                mineralWorkers.remove(managedUnit);
            }
            for (HashSet<ManagedUnit> geyserWorkers : this.gameState.getGeyserAssignments().values()) {
                if (!geyserWorkers.contains(managedUnit)) continue;
                this.gameState.setGeyserWorkers(this.gameState.getGeyserWorkers() - 1);
                geyserWorkers.remove(managedUnit);
            }
        }
        this.eggs.remove(managedUnit);
        this.larva.remove(managedUnit);
        this.gatherers.remove(managedUnit);
        this.mineralGatherers.remove(managedUnit);
        this.gasGatherers.remove(managedUnit);
        this.assignedManagedWorkers.remove(managedUnit);
        for (HashSet<ManagedUnit> managedUnitAssignments : this.gameState.getGatherersAssignedToBase().values()) {
            if (!managedUnitAssignments.contains(managedUnit)) continue;
            managedUnitAssignments.remove(managedUnit);
        }
    }

    private void assignWorker(ManagedUnit managedUnit) {
        if (this.gameState.getGeyserWorkers() < 3 * this.gameState.getGeyserAssignments().size()) {
            this.assignToGeyser(managedUnit);
            return;
        }
        this.assignToMineral(managedUnit);
    }

    private void assignToClosestBase(Unit gatherTarget, ManagedUnit gatherer) {
        HashMap<Base, HashSet<ManagedUnit>> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase();
        List bases = gatherersAssignedToBase.keySet().stream().collect(Collectors.toList());
        if (bases.size() == 0) {
            return;
        }
        bases.sort(new BaseUnitDistanceComparator(gatherTarget));
        HashSet<ManagedUnit> assignedManagedUnits = gatherersAssignedToBase.get(bases.get(0));
        assignedManagedUnits.add(gatherer);
    }

    private void assignToMineral(ManagedUnit managedUnit) {
        Unit unit = managedUnit.getUnit();
        int fewestMineralAssignments = this.gameState.getMineralWorkers() == 0 ? 0 : (this.gameState.getMineralAssignments().size() / this.gameState.getMineralWorkers() <= 1 ? 1 : 0);
        List claimedMinerals = this.gameState.getMineralAssignments().keySet().stream().collect(Collectors.toList());
        claimedMinerals.sort(new UnitDistanceComparator(unit));
        for (Unit mineral : claimedMinerals) {
            HashSet<ManagedUnit> mineralUnits = this.gameState.getMineralAssignments().get(mineral);
            if (mineralUnits.size() > fewestMineralAssignments) continue;
            managedUnit.setRole(UnitRole.GATHER);
            managedUnit.setGatherTarget(mineral);
            managedUnit.hasNewGatherTarget(true);
            this.assignedManagedWorkers.add(managedUnit);
            this.gameState.setMineralWorkers(this.gameState.getMineralWorkers() + 1);
            mineralUnits.add(managedUnit);
            this.gatherers.add(managedUnit);
            this.mineralGatherers.add(managedUnit);
            this.assignToClosestBase(mineral, managedUnit);
            return;
        }
    }

    private void assignToGeyser(ManagedUnit managedUnit) {
        for (Unit geyser : this.gameState.getGeyserAssignments().keySet()) {
            HashSet<ManagedUnit> geyserUnits = this.gameState.getGeyserAssignments().get(geyser);
            if (geyserUnits.size() >= 3) continue;
            managedUnit.setRole(UnitRole.GATHER);
            managedUnit.setGatherTarget(geyser);
            managedUnit.hasNewGatherTarget(true);
            this.assignedManagedWorkers.add(managedUnit);
            this.gameState.setGeyserWorkers(this.gameState.getGeyserWorkers() + 1);
            geyserUnits.add(managedUnit);
            this.gatherers.add(managedUnit);
            this.gasGatherers.add(managedUnit);
            this.assignToClosestBase(geyser, managedUnit);
            break;
        }
    }

    private boolean assignMorphDrone(Plan plan) {
        for (ManagedUnit managedUnit : this.assignedManagedWorkers) {
            Unit unit = managedUnit.getUnit();
            if (unit.isCarrying() || this.gasGatherers.contains(managedUnit) || this.gameState.getAssignedPlannedItems().containsKey(unit)) continue;
            this.clearAssignments(managedUnit);
            this.scheduledDrones.add(managedUnit);
            managedUnit.setPlan(plan);
            this.gameState.getAssignedPlannedItems().put(unit, plan);
            return true;
        }
        return false;
    }

    private boolean assignMorphLarva(Plan plan) {
        for (ManagedUnit managedUnit : this.larva) {
            Unit unit = managedUnit.getUnit();
            if (this.gameState.getAssignedPlannedItems().containsKey(unit)) continue;
            this.clearAssignments(managedUnit);
            plan.setState(PlanState.BUILDING);
            managedUnit.setRole(UnitRole.MORPH);
            managedUnit.setPlan(plan);
            this.gameState.getAssignedPlannedItems().put(unit, plan);
            return true;
        }
        return false;
    }

    private void checksLarvaDeadlock() {
        Plan plan2;
        Player self = this.game.self();
        int supplyTotal = self.supplyTotal();
        int supplyUsed = self.supplyUsed();
        int curFrame = this.game.getFrameCount();
        if (supplyTotal - supplyUsed + this.gameState.getPlannedSupply() > 0) {
            this.gameState.setLarvaDeadlocked(false);
            return;
        }
        if (this.gameState.isLarvaDeadlocked() && curFrame < this.gameState.getLarvaDeadlockDetectedFrame() + 26) {
            return;
        }
        if (this.gameState.getPlansScheduled().size() == 0) {
            return;
        }
        for (ManagedUnit managedUnit : this.larva) {
            if (managedUnit.getRole() == UnitRole.LARVA) {
                return;
            }
            if (managedUnit.getRole() != UnitRole.MORPH || !((plan2 = managedUnit.getPlan()) != null & plan2.getPlannedUnit() == UnitType.Zerg_Overlord)) continue;
            return;
        }
        for (ManagedUnit managedUnit : this.eggs) {
            if (managedUnit.getRole() != UnitRole.MORPH || !((plan2 = managedUnit.getPlan()) != null & plan2.getPlannedUnit() == UnitType.Zerg_Overlord)) continue;
            return;
        }
        Boolean isOverlordAssignedOrMorphing = false;
        for (Plan plan2 : this.gameState.getAssignedPlannedItems().values()) {
            if (plan2.getType() != PlanType.UNIT || plan2.getPlannedUnit() != UnitType.Zerg_Overlord) continue;
            isOverlordAssignedOrMorphing = true;
            break;
        }
        for (Plan plan2 : this.gameState.getPlansMorphing()) {
            if (plan2.getType() != PlanType.UNIT || plan2.getPlannedUnit() != UnitType.Zerg_Overlord) continue;
            isOverlordAssignedOrMorphing = true;
            break;
        }
        if (isOverlordAssignedOrMorphing.booleanValue()) {
            return;
        }
        this.gameState.setLarvaDeadlocked(true);
        this.gameState.setLarvaDeadlockDetectedFrame(curFrame);
    }

    private void handleLarvaDeadlock() {
        int frameDeadlockDetected;
        if (!this.gameState.isLarvaDeadlocked()) {
            return;
        }
        int frameCount = this.game.getFrameCount();
        if (frameCount < (frameDeadlockDetected = this.gameState.getLarvaDeadlockDetectedFrame()) + 26) {
            return;
        }
        List larvaCopy = this.larva.stream().collect(Collectors.toList());
        for (ManagedUnit managedUnit : larvaCopy) {
            Unit unit = managedUnit.getUnit();
            this.clearAssignments(managedUnit);
            managedUnit.setRole(UnitRole.LARVA);
            this.larva.add(managedUnit);
            Plan plan = managedUnit.getPlan();
            if (plan != null) {
                plan.setState(PlanState.CANCELLED);
                managedUnit.setPlan(null);
            }
            this.gameState.getAssignedPlannedItems().remove(unit);
        }
        this.gameState.setLarvaDeadlocked(false);
    }
}

