/*
 * Decompiled with CFR 0.152.
 */
package unit;

import bwapi.Game;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import info.GameState;
import info.InformationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import unit.BuildingManager;
import unit.WorkerManager;
import unit.managed.ManagedUnit;
import unit.managed.ManagedUnitFactory;
import unit.managed.UnitRole;
import unit.scout.ScoutManager;
import unit.squad.SquadManager;

public class UnitManager {
    private Game game;
    private GameState gameState;
    private ManagedUnitFactory factory;
    private BuildingManager buildingManager;
    private InformationManager informationManager;
    private ScoutManager scoutManager;
    private SquadManager squadManager;
    private WorkerManager workerManager;
    private HashMap<Unit, ManagedUnit> managedUnitLookup = new HashMap();
    private HashSet<ManagedUnit> managedUnits = new HashSet();

    public UnitManager(Game game, InformationManager informationManager, BWEM bwem, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
        this.factory = new ManagedUnitFactory(game);
        this.informationManager = informationManager;
        this.workerManager = new WorkerManager(game, gameState);
        this.squadManager = new SquadManager(game, gameState, informationManager);
        this.scoutManager = new ScoutManager(game, informationManager);
        this.buildingManager = new BuildingManager(game, gameState);
        this.initManagedUnits();
    }

    private void initManagedUnits() {
        for (Unit unit : this.game.getAllUnits()) {
            if (unit.getPlayer() != this.game.self()) continue;
            UnitType unitType = unit.getType();
            ManagedUnit managedUnit = this.createManagedUnit(unit, UnitRole.IDLE);
            if (unitType == UnitType.Zerg_Overlord) {
                this.createScout(unit, managedUnit);
            }
            if (unitType == UnitType.Zerg_Drone) {
                this.createDrone(unit, managedUnit);
            }
            if (unitType == UnitType.Zerg_Larva) {
                this.createLarva(unit, managedUnit);
            }
            if (unitType != UnitType.Zerg_Hatchery) continue;
            this.createBuilding(unit, managedUnit);
        }
    }

    public void onFrame() {
        int frameCount = this.game.getFrameCount();
        if (frameCount < 1) {
            return;
        }
        this.checkBaseThreats();
        this.buildingManager.onFrame();
        this.workerManager.onFrame();
        this.squadManager.updateOverlordSquad();
        this.squadManager.updateFightSquads();
        this.squadManager.updateDefenseSquads();
        this.scoutManager.onFrame();
        block3: for (ManagedUnit managedUnit : this.managedUnits) {
            if (!managedUnit.isReady() && this.game.getFrameCount() >= managedUnit.getUnreadyUntilFrame()) {
                managedUnit.setReady(true);
            }
            UnitRole role = managedUnit.getRole();
            switch (role) {
                case GATHER: 
                case BUILD: 
                case MORPH: 
                case LARVA: 
                case RETREAT: 
                case DEFEND: 
                case BUILDING: 
                case RALLY: {
                    managedUnit.execute();
                    continue block3;
                }
            }
            if (managedUnit.getUnitType() == UnitType.Zerg_Overlord && role == UnitRole.SCOUT && this.informationManager.isEnemyBuildingLocationKnown()) {
                this.squadManager.addManagedUnit(managedUnit);
                this.scoutManager.removeScout(managedUnit);
            }
            if (managedUnit.canFight() && role != UnitRole.FIGHT && this.informationManager.isEnemyLocationKnown()) {
                managedUnit.setRole(UnitRole.FIGHT);
                this.squadManager.addManagedUnit(managedUnit);
                this.scoutManager.removeScout(managedUnit);
            } else if (role != UnitRole.SCOUT && !this.informationManager.isEnemyUnitVisible() && this.informationManager.getEnemyBuildings().size() == 0) {
                this.scoutManager.addScout(managedUnit);
                this.squadManager.removeManagedUnit(managedUnit);
            }
            if (role == UnitRole.FIGHT) {
                this.assignClosestEnemyToManagedUnit(managedUnit);
            }
            managedUnit.execute();
        }
    }

    public void onUnitShow(Unit unit) {
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        if (unit.getType() == UnitType.Zerg_Larva && !this.managedUnitLookup.containsKey(unit)) {
            ManagedUnit managedUnit = this.createManagedUnit(unit, UnitRole.LARVA);
            this.workerManager.onUnitComplete(managedUnit);
            return;
        }
        if (this.managedUnitLookup.containsKey(unit)) {
            return;
        }
        ManagedUnit managedUnit = this.createManagedUnit(unit, UnitRole.IDLE);
        UnitType unitType = unit.getType();
        if (unitType.isBuilding()) {
            this.createBuilding(unit, managedUnit);
            return;
        }
        if (unitType == UnitType.Zerg_Drone || unitType == UnitType.Zerg_Larva) {
            this.workerManager.onUnitComplete(managedUnit);
        } else if (unitType == UnitType.Zerg_Overlord || this.informationManager.getEnemyBuildings().size() + this.informationManager.getVisibleEnemyUnits().size() == 0) {
            if (unitType == UnitType.Zerg_Overlord && this.informationManager.isEnemyBuildingLocationKnown()) {
                this.squadManager.addManagedUnit(managedUnit);
                this.scoutManager.removeScout(managedUnit);
                return;
            }
            this.createScout(unit, managedUnit);
        } else {
            managedUnit.setRole(UnitRole.FIGHT);
            this.squadManager.addManagedUnit(managedUnit);
            this.assignClosestEnemyToManagedUnit(managedUnit);
        }
    }

    public void onUnitComplete(Unit unit) {
        UnitType unitType = unit.getType();
        if (unitType.isBuilding()) {
            if (unitType == UnitType.Zerg_Extractor) {
                this.workerManager.onExtractorComplete();
            }
            return;
        }
        if (!this.managedUnitLookup.containsKey(unit)) {
            return;
        }
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        if (managedUnit.getRole() == UnitRole.MORPH) {
            managedUnit.setRole(UnitRole.IDLE);
        }
    }

    private void removeManagedUnit(Unit unit) {
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        if (managedUnit == null) {
            return;
        }
        this.buildingManager.remove(managedUnit);
        this.workerManager.removeManagedWorker(managedUnit);
        this.managedUnits.remove(managedUnit);
        this.squadManager.removeManagedUnit(managedUnit);
        this.scoutManager.removeScout(managedUnit);
        this.managedUnitLookup.remove(unit);
    }

    public void onUnitDestroy(Unit unit) {
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Resource_Mineral_Field) {
            this.workerManager.removeMineral(unit);
            return;
        }
        if (unitType == UnitType.Zerg_Extractor) {
            this.workerManager.removeGeyser(unit);
            return;
        }
        this.removeManagedUnit(unit);
    }

    public void onUnitMorph(Unit unit) {
        if (unit.getType() == UnitType.Zerg_Larva && !this.managedUnitLookup.containsKey(unit)) {
            this.workerManager.onUnitComplete(this.createManagedUnit(unit, UnitRole.LARVA));
            return;
        }
        if (!this.managedUnitLookup.containsKey(unit)) {
            return;
        }
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        if (unit.getType() != managedUnit.getUnitType()) {
            managedUnit.setUnitType(unit.getType());
        }
        if (unit.getType().isBuilding()) {
            this.removeManagedUnit(unit);
            this.createBuilding(unit, managedUnit);
            return;
        }
        if (unit.getType() == UnitType.Zerg_Overlord) {
            managedUnit.setCanFight(false);
        }
        this.workerManager.onUnitMorph(managedUnit);
    }

    private void checkBaseThreats() {
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : baseThreats.keySet()) {
            if (baseThreats.get(base).size() > 0) {
                this.assignGatherersToDefense(base);
                continue;
            }
            this.assignDefendersToGather(base);
        }
    }

    private void assignGatherersToDefense(Base base) {
        HashSet<ManagedUnit> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase().get(base);
        if (gatherersAssignedToBase.size() == 0) {
            return;
        }
        List<Unit> threateningUnits = this.gameState.getBaseToThreatLookup().get(base).stream().collect(Collectors.toList());
        List<ManagedUnit> gatherersToReassign = this.squadManager.assignGathererDefenders(base, gatherersAssignedToBase, threateningUnits);
        for (ManagedUnit managedUnit : gatherersToReassign) {
            this.workerManager.removeManagedWorker(managedUnit);
        }
    }

    private void assignDefendersToGather(Base base) {
        HashSet<ManagedUnit> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase().get(base);
        List<ManagedUnit> gatherersToReassign = this.squadManager.disbandDefendSquad(base);
        for (ManagedUnit managedUnit : gatherersToReassign) {
            this.workerManager.addManagedWorker(managedUnit);
        }
    }

    private void assignClosestEnemyToManagedUnit(ManagedUnit managedUnit) {
        ArrayList<Unit> enemyUnits = new ArrayList<Unit>();
        enemyUnits.addAll(this.informationManager.getVisibleEnemyUnits());
        enemyUnits.addAll(this.informationManager.getEnemyBuildings());
        if (enemyUnits.size() > 0) {
            managedUnit.assignClosestEnemyAsFightTarget(enemyUnits, this.informationManager.pollScoutTarget(true));
        }
    }

    private ManagedUnit createManagedUnit(Unit unit, UnitRole role) {
        ManagedUnit managedUnit = this.factory.create(unit, role);
        this.managedUnitLookup.put(unit, managedUnit);
        this.managedUnits.add(managedUnit);
        return managedUnit;
    }

    private void createScout(Unit unit, ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.SCOUT);
        this.scoutManager.addScout(managedUnit);
        if (unit.getType() == UnitType.Zerg_Overlord) {
            managedUnit.setCanFight(false);
        }
    }

    private void createDrone(Unit unit, ManagedUnit managedUnit) {
        this.managedUnits.add(managedUnit);
        this.workerManager.onUnitComplete(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }

    private void createLarva(Unit unit, ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.LARVA);
        this.managedUnits.add(managedUnit);
        this.workerManager.onUnitComplete(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }

    private void createBuilding(Unit unit, ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.BUILDING);
        managedUnit.setCanFight(false);
        this.managedUnits.add(managedUnit);
        this.buildingManager.add(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }
}

