/*
 * Decompiled with CFR 0.152.
 */
package strategy.strategies;

import bwapi.UnitType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class UnitWeights {
    private Map<UnitType, Double> weightMap = new HashMap<UnitType, Double>();
    private HashSet<UnitType> enabledUnitTypes = new HashSet();

    public Double getWeight(UnitType unitType) {
        return this.weightMap.get((Object)unitType);
    }

    public void setWeight(UnitType unitType, Double weight) {
        this.weightMap.put(unitType, weight);
    }

    public void removeUnit(UnitType unitType) {
        this.weightMap.remove((Object)unitType);
    }

    public boolean hasUnit(UnitType unitType) {
        return this.weightMap.containsKey((Object)unitType);
    }

    public void enableUnit(UnitType unitType) {
        this.enabledUnitTypes.add(unitType);
    }

    public void disableUnit(UnitType unitType) {
        this.enabledUnitTypes.remove((Object)unitType);
    }

    public UnitType getRandom() {
        UnitType unitType = UnitType.Unknown;
        double totalWeight = 0.0;
        for (Map.Entry<UnitType, Double> e : this.weightMap.entrySet()) {
            if (!this.enabledUnitTypes.contains((Object)e.getKey())) continue;
            totalWeight += e.getValue().doubleValue();
        }
        double randomNumber = Math.random() * totalWeight;
        for (Map.Entry<UnitType, Double> e : this.weightMap.entrySet()) {
            if (!this.enabledUnitTypes.contains((Object)e.getKey()) || !((randomNumber -= e.getValue().doubleValue()) <= 0.0)) continue;
            unitType = e.getKey();
            break;
        }
        return unitType;
    }
}

