/*
 * Decompiled with CFR 0.152.
 */
package strategy;

import bwapi.Race;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import strategy.openers.FivePool;
import strategy.openers.FourPool;
import strategy.openers.NineHatch;
import strategy.openers.NinePoolSpeed;
import strategy.openers.Opener;
import strategy.openers.OpenerName;
import strategy.openers.OverPool;
import strategy.openers.TwelveHatch;
import strategy.openers.TwelvePool;

public class OpenerFactory {
    private static int TWO = 2;
    private Race opponentRace;
    private List<Opener> allOpeners = new ArrayList<Opener>();
    private Map<String, Opener> playableOpeners = new HashMap<String, Opener>();

    public OpenerFactory(int numStartingLocations, Race opponentRace) {
        this.opponentRace = opponentRace;
        this.initOpeners(numStartingLocations);
    }

    public Opener getByName(String name) {
        return this.playableOpeners.get(name);
    }

    public List<String> listAllOpenerNames() {
        return this.allOpeners.stream().map(s -> s.getNameString()).collect(Collectors.toList());
    }

    public Set<String> getPlayableOpeners() {
        return this.playableOpeners.values().stream().map(s -> s.getNameString()).collect(Collectors.toSet());
    }

    private void initOpeners(int numStartingLocations) {
        this.allOpeners.add(new NinePoolSpeed());
        this.allOpeners.add(new TwelveHatch());
        this.allOpeners.add(new OverPool());
        this.allOpeners.add(new FivePool());
        this.allOpeners.add(new FourPool());
        this.allOpeners.add(new TwelvePool());
        this.allOpeners.add(new NineHatch());
        for (Opener opener : this.allOpeners) {
            if (numStartingLocations != TWO && opener.getName() == OpenerName.FOUR_POOL || !this.playsRace(opener)) continue;
            this.playableOpeners.put(opener.getNameString(), opener);
        }
    }

    private boolean playsRace(Opener opener) {
        switch (this.opponentRace) {
            case Zerg: {
                return this.playsZerg(opener);
            }
            case Terran: {
                return this.playsTerran(opener);
            }
            case Protoss: {
                return this.playsProtoss(opener);
            }
        }
        return this.playsRandom(opener);
    }

    private boolean playsZerg(Opener opener) {
        switch (opener.getName()) {
            case OVER_POOL: 
            case NINE_POOL_SPEED: 
            case NINE_HATCH: 
            case TWELVE_HATCH: 
            case TWELVE_POOL: {
                return true;
            }
        }
        return false;
    }

    private boolean playsTerran(Opener opener) {
        switch (opener.getName()) {
            case NINE_POOL_SPEED: 
            case TWELVE_HATCH: 
            case TWELVE_POOL: 
            case FOUR_POOL: {
                return true;
            }
        }
        return false;
    }

    private boolean playsProtoss(Opener opener) {
        switch (opener.getName()) {
            case OVER_POOL: 
            case NINE_POOL_SPEED: 
            case TWELVE_HATCH: 
            case FOUR_POOL: {
                return true;
            }
        }
        return false;
    }

    private boolean playsRandom(Opener opener) {
        switch (opener.getName()) {
            case OVER_POOL: 
            case NINE_POOL_SPEED: 
            case FOUR_POOL: 
            case FIVE_POOL: {
                return true;
            }
        }
        return false;
    }
}

