/*
 * Decompiled with CFR 0.152.
 */
package planner;

import bwapi.TilePosition;
import bwapi.UnitType;
import bwapi.UpgradeType;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import planner.PlanState;
import planner.PlanType;

public class Plan {
    private final String uuid = UUID.randomUUID().toString();
    private PlanType type;
    private PlanState state = PlanState.PLANNED;
    private int priority;
    private int frameStart;
    private int retries = 0;
    private int predictedReadyFrame = 0;
    private boolean blockOtherPlans;
    @Nullable
    private TilePosition buildPosition;
    @Nullable
    private UnitType plannedUnit;
    @Nullable
    private UpgradeType plannedUpgrade;

    public Plan(UnitType unitType, int priority, boolean isBuilding, boolean isBlocking) {
        this.priority = priority;
        this.plannedUnit = unitType;
        this.type = isBuilding ? PlanType.BUILDING : PlanType.UNIT;
        this.blockOtherPlans = isBlocking;
    }

    public Plan(UnitType unitType, int priority, boolean isBuilding, boolean isBlocking, TilePosition buildPosition) {
        this.priority = priority;
        this.plannedUnit = unitType;
        this.type = isBuilding ? PlanType.BUILDING : PlanType.UNIT;
        this.buildPosition = buildPosition;
        this.blockOtherPlans = isBlocking;
    }

    public Plan(UpgradeType upgrade, int priority, boolean isBlocking) {
        this.priority = priority;
        this.plannedUpgrade = upgrade;
        this.type = PlanType.UPGRADE;
        this.blockOtherPlans = isBlocking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan u = (Plan)o;
        return this.uuid.equals(u.getUuid());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String getName() {
        if (this.plannedUpgrade != null) {
            return this.plannedUpgrade.toString();
        }
        if (this.plannedUnit != null) {
            return this.plannedUnit.toString();
        }
        return "NULL";
    }

    public String getUuid() {
        return this.uuid;
    }

    public PlanType getType() {
        return this.type;
    }

    public PlanState getState() {
        return this.state;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getFrameStart() {
        return this.frameStart;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getPredictedReadyFrame() {
        return this.predictedReadyFrame;
    }

    public boolean isBlockOtherPlans() {
        return this.blockOtherPlans;
    }

    @Nullable
    public TilePosition getBuildPosition() {
        return this.buildPosition;
    }

    @Nullable
    public UnitType getPlannedUnit() {
        return this.plannedUnit;
    }

    @Nullable
    public UpgradeType getPlannedUpgrade() {
        return this.plannedUpgrade;
    }

    public void setType(PlanType type) {
        this.type = type;
    }

    public void setState(PlanState state) {
        this.state = state;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setFrameStart(int frameStart) {
        this.frameStart = frameStart;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setPredictedReadyFrame(int predictedReadyFrame) {
        this.predictedReadyFrame = predictedReadyFrame;
    }

    public void setBlockOtherPlans(boolean blockOtherPlans) {
        this.blockOtherPlans = blockOtherPlans;
    }

    public void setBuildPosition(@Nullable TilePosition buildPosition) {
        this.buildPosition = buildPosition;
    }

    public void setPlannedUnit(@Nullable UnitType plannedUnit) {
        this.plannedUnit = plannedUnit;
    }

    public void setPlannedUpgrade(@Nullable UpgradeType plannedUpgrade) {
        this.plannedUpgrade = plannedUpgrade;
    }

    public String toString() {
        return "Plan(uuid=" + this.getUuid() + ", type=" + (Object)((Object)this.getType()) + ", state=" + (Object)((Object)this.getState()) + ", priority=" + this.getPriority() + ", frameStart=" + this.getFrameStart() + ", retries=" + this.getRetries() + ", predictedReadyFrame=" + this.getPredictedReadyFrame() + ", blockOtherPlans=" + this.isBlockOtherPlans() + ", buildPosition=" + this.getBuildPosition() + ", plannedUnit=" + (Object)((Object)this.getPlannedUnit()) + ", plannedUpgrade=" + (Object)((Object)this.getPlannedUpgrade()) + ")";
    }
}

