/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import org.bk.ass.collection.UnorderedCollection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.AgentUtil;
import org.bk.ass.sim.Simulator;
import org.bk.ass.sim.Weapon;

public class SuiciderBehavior
implements Simulator.Behavior {
    @Override
    public boolean simUnit(int frameSkip, Agent agent, UnorderedCollection<Agent> allies, UnorderedCollection<Agent> enemies) {
        if (agent.isStasised) {
            return false;
        }
        Agent selectedEnemy = null;
        int selectedDistanceSquared = Integer.MAX_VALUE;
        for (int i = enemies.size() - 1; i >= 0; --i) {
            int distance;
            Agent enemy = enemies.get(i);
            Weapon wpn = agent.weaponVs(enemy);
            if (enemy.healthShifted < 1 || wpn.damageShifted == 0 || !enemy.detected || (distance = AgentUtil.distanceSquared(agent, enemy)) >= selectedDistanceSquared) continue;
            selectedDistanceSquared = distance;
            selectedEnemy = enemy;
            if (selectedDistanceSquared <= agent.speedSquared) break;
        }
        if (selectedEnemy == null) {
            return false;
        }
        AgentUtil.moveToward(frameSkip, agent, selectedEnemy, (float)Math.sqrt(selectedDistanceSquared));
        if (selectedDistanceSquared <= agent.speedSquared) {
            AgentUtil.dealDamage(agent, agent.weaponVs(selectedEnemy), selectedEnemy);
            agent.healthShifted = 0;
        }
        return true;
    }
}

