/*
 * Decompiled with CFR 0.152.
 */
package learning;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import learning.DefensiveSunkRecord;
import learning.OpenerRecord;
import learning.StrategyRecord;

@JsonDeserialize(builder=OpponentRecordBuilder.class)
public class OpponentRecord {
    private String name;
    private String race;
    private int wins;
    private int losses;
    @Deprecated
    private Map<String, OpenerRecord> opponentStrategies;
    private Map<String, OpenerRecord> openerRecord;
    private Map<String, StrategyRecord> strategyRecordMap;
    private DefensiveSunkRecord defensiveSunkRecord;

    public int totalGames() {
        return this.wins + this.losses;
    }

    OpponentRecord(String name, String race, int wins, int losses, Map<String, OpenerRecord> opponentStrategies, Map<String, OpenerRecord> openerRecord, Map<String, StrategyRecord> strategyRecordMap, DefensiveSunkRecord defensiveSunkRecord) {
        this.name = name;
        this.race = race;
        this.wins = wins;
        this.losses = losses;
        this.opponentStrategies = opponentStrategies;
        this.openerRecord = openerRecord;
        this.strategyRecordMap = strategyRecordMap;
        this.defensiveSunkRecord = defensiveSunkRecord;
    }

    public static OpponentRecordBuilder builder() {
        return new OpponentRecordBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getRace() {
        return this.race;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    @Deprecated
    public Map<String, OpenerRecord> getOpponentStrategies() {
        return this.opponentStrategies;
    }

    public Map<String, OpenerRecord> getOpenerRecord() {
        return this.openerRecord;
    }

    public Map<String, StrategyRecord> getStrategyRecordMap() {
        return this.strategyRecordMap;
    }

    public DefensiveSunkRecord getDefensiveSunkRecord() {
        return this.defensiveSunkRecord;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRace(String race) {
        this.race = race;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    @Deprecated
    public void setOpponentStrategies(Map<String, OpenerRecord> opponentStrategies) {
        this.opponentStrategies = opponentStrategies;
    }

    public void setOpenerRecord(Map<String, OpenerRecord> openerRecord) {
        this.openerRecord = openerRecord;
    }

    public void setStrategyRecordMap(Map<String, StrategyRecord> strategyRecordMap) {
        this.strategyRecordMap = strategyRecordMap;
    }

    public void setDefensiveSunkRecord(DefensiveSunkRecord defensiveSunkRecord) {
        this.defensiveSunkRecord = defensiveSunkRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpponentRecord)) {
            return false;
        }
        OpponentRecord other = (OpponentRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        if (this.getLosses() != other.getLosses()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$race = this.getRace();
        String other$race = other.getRace();
        if (this$race == null ? other$race != null : !this$race.equals(other$race)) {
            return false;
        }
        Map<String, OpenerRecord> this$opponentStrategies = this.getOpponentStrategies();
        Map<String, OpenerRecord> other$opponentStrategies = other.getOpponentStrategies();
        if (this$opponentStrategies == null ? other$opponentStrategies != null : !((Object)this$opponentStrategies).equals(other$opponentStrategies)) {
            return false;
        }
        Map<String, OpenerRecord> this$openerRecord = this.getOpenerRecord();
        Map<String, OpenerRecord> other$openerRecord = other.getOpenerRecord();
        if (this$openerRecord == null ? other$openerRecord != null : !((Object)this$openerRecord).equals(other$openerRecord)) {
            return false;
        }
        Map<String, StrategyRecord> this$strategyRecordMap = this.getStrategyRecordMap();
        Map<String, StrategyRecord> other$strategyRecordMap = other.getStrategyRecordMap();
        if (this$strategyRecordMap == null ? other$strategyRecordMap != null : !((Object)this$strategyRecordMap).equals(other$strategyRecordMap)) {
            return false;
        }
        DefensiveSunkRecord this$defensiveSunkRecord = this.getDefensiveSunkRecord();
        DefensiveSunkRecord other$defensiveSunkRecord = other.getDefensiveSunkRecord();
        return !(this$defensiveSunkRecord == null ? other$defensiveSunkRecord != null : !((Object)this$defensiveSunkRecord).equals(other$defensiveSunkRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpponentRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $race = this.getRace();
        result = result * 59 + ($race == null ? 43 : $race.hashCode());
        Map<String, OpenerRecord> $opponentStrategies = this.getOpponentStrategies();
        result = result * 59 + ($opponentStrategies == null ? 43 : ((Object)$opponentStrategies).hashCode());
        Map<String, OpenerRecord> $openerRecord = this.getOpenerRecord();
        result = result * 59 + ($openerRecord == null ? 43 : ((Object)$openerRecord).hashCode());
        Map<String, StrategyRecord> $strategyRecordMap = this.getStrategyRecordMap();
        result = result * 59 + ($strategyRecordMap == null ? 43 : ((Object)$strategyRecordMap).hashCode());
        DefensiveSunkRecord $defensiveSunkRecord = this.getDefensiveSunkRecord();
        result = result * 59 + ($defensiveSunkRecord == null ? 43 : ((Object)$defensiveSunkRecord).hashCode());
        return result;
    }

    public String toString() {
        return "OpponentRecord(name=" + this.getName() + ", race=" + this.getRace() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ", opponentStrategies=" + this.getOpponentStrategies() + ", openerRecord=" + this.getOpenerRecord() + ", strategyRecordMap=" + this.getStrategyRecordMap() + ", defensiveSunkRecord=" + this.getDefensiveSunkRecord() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class OpponentRecordBuilder {
        private String name;
        private String race;
        private int wins;
        private int losses;
        private Map<String, OpenerRecord> opponentStrategies;
        private Map<String, OpenerRecord> openerRecord;
        private Map<String, StrategyRecord> strategyRecordMap;
        private DefensiveSunkRecord defensiveSunkRecord;

        OpponentRecordBuilder() {
        }

        public OpponentRecordBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OpponentRecordBuilder race(String race) {
            this.race = race;
            return this;
        }

        public OpponentRecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        public OpponentRecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        @Deprecated
        public OpponentRecordBuilder opponentStrategies(Map<String, OpenerRecord> opponentStrategies) {
            this.opponentStrategies = opponentStrategies;
            return this;
        }

        public OpponentRecordBuilder openerRecord(Map<String, OpenerRecord> openerRecord) {
            this.openerRecord = openerRecord;
            return this;
        }

        public OpponentRecordBuilder strategyRecordMap(Map<String, StrategyRecord> strategyRecordMap) {
            this.strategyRecordMap = strategyRecordMap;
            return this;
        }

        public OpponentRecordBuilder defensiveSunkRecord(DefensiveSunkRecord defensiveSunkRecord) {
            this.defensiveSunkRecord = defensiveSunkRecord;
            return this;
        }

        public OpponentRecord build() {
            return new OpponentRecord(this.name, this.race, this.wins, this.losses, this.opponentStrategies, this.openerRecord, this.strategyRecordMap, this.defensiveSunkRecord);
        }

        public String toString() {
            return "OpponentRecord.OpponentRecordBuilder(name=" + this.name + ", race=" + this.race + ", wins=" + this.wins + ", losses=" + this.losses + ", opponentStrategies=" + this.opponentStrategies + ", openerRecord=" + this.openerRecord + ", strategyRecordMap=" + this.strategyRecordMap + ", defensiveSunkRecord=" + this.defensiveSunkRecord + ")";
        }
    }
}

