/*
 * Decompiled with CFR 0.152.
 */
package info.map;

import bwapi.TilePosition;
import info.map.MapTileType;
import lombok.NonNull;

public class MapTile {
    @NonNull
    private TilePosition tile;
    @NonNull
    private int scoutImportance;
    @NonNull
    private boolean isBuildable;
    @NonNull
    private MapTileType type;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTile tp = (MapTile)o;
        return this.tile == tp.getTile();
    }

    public int hashCode() {
        return this.tile.hashCode();
    }

    public int getX() {
        return this.tile.getX();
    }

    public int getY() {
        return this.tile.getY();
    }

    public MapTile(@NonNull TilePosition tile, @NonNull int scoutImportance, @NonNull boolean isBuildable, @NonNull MapTileType type) {
        if (tile == null) {
            throw new NullPointerException("tile is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.tile = tile;
        this.scoutImportance = scoutImportance;
        this.isBuildable = isBuildable;
        this.type = type;
    }

    @NonNull
    public TilePosition getTile() {
        return this.tile;
    }

    @NonNull
    public int getScoutImportance() {
        return this.scoutImportance;
    }

    @NonNull
    public boolean isBuildable() {
        return this.isBuildable;
    }

    @NonNull
    public MapTileType getType() {
        return this.type;
    }

    public void setTile(@NonNull TilePosition tile) {
        if (tile == null) {
            throw new NullPointerException("tile is marked non-null but is null");
        }
        this.tile = tile;
    }

    public void setScoutImportance(@NonNull int scoutImportance) {
        this.scoutImportance = scoutImportance;
    }

    public void setBuildable(@NonNull boolean isBuildable) {
        this.isBuildable = isBuildable;
    }

    public void setType(@NonNull MapTileType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public String toString() {
        return "MapTile(tile=" + this.getTile() + ", scoutImportance=" + this.getScoutImportance() + ", isBuildable=" + this.isBuildable() + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

