/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.UpgradeType;

public class TechProgression {
    private boolean spawningPool = false;
    private boolean hydraliskDen = false;
    private boolean lair = false;
    private boolean spire = false;
    private boolean queensNest = false;
    private boolean hive = false;
    private int evolutionChambers = 0;
    private boolean plannedSpawningPool = false;
    private boolean plannedDen = false;
    private boolean plannedLair = false;
    private boolean plannedSpire = false;
    private boolean plannedQueensNest = false;
    private boolean plannedHive = false;
    private int plannedEvolutionChambers = 0;
    private boolean metabolicBoost = false;
    private boolean muscularAugments = false;
    private boolean groovedSpines = false;
    private int carapaceUpgrades = 0;
    private int rangedUpgrades = 0;
    private int meleeUpgrades = 0;
    private int flyerAttack = 0;
    private int flyerDefense = 0;
    private boolean plannedMetabolicBoost = false;
    private boolean plannedMuscularAugments = false;
    private boolean plannedGroovedSpines = false;
    private boolean plannedCarapaceUpgrades = false;
    private boolean plannedRangedUpgrades = false;
    private boolean plannedMeleeUpgrades = false;
    private boolean plannedFlyerAttack = false;
    private boolean plannedFlyerDefense = false;

    public boolean canPlanSunkenColony() {
        return this.spawningPool;
    }

    public boolean canPlanExtractor() {
        return this.spawningPool || this.plannedSpawningPool;
    }

    public boolean canPlanPool() {
        return !this.plannedSpawningPool && !this.spawningPool;
    }

    public boolean canPlanHydraliskDen() {
        return this.spawningPool && !this.plannedDen && !this.hydraliskDen;
    }

    public boolean canPlanLair() {
        return this.spawningPool && !this.plannedLair && !this.lair;
    }

    public boolean canPlanHive() {
        return this.queensNest && this.lair && !this.plannedHive && !this.hive;
    }

    public boolean canPlanSpire() {
        return this.lair && !this.plannedSpire && !this.spire;
    }

    public boolean canPlanQueensNest() {
        return this.lair && !this.plannedQueensNest && !this.queensNest;
    }

    public boolean canPlanMetabolicBoost() {
        return this.spawningPool && !this.plannedMetabolicBoost && !this.metabolicBoost;
    }

    public boolean canPlanMuscularAugments() {
        return this.hydraliskDen && !this.plannedMuscularAugments && !this.muscularAugments;
    }

    public boolean canPlanGroovedSpines() {
        return this.hydraliskDen && !this.plannedGroovedSpines && !this.groovedSpines;
    }

    public boolean canPlanEvolutionChamber() {
        return this.spawningPool && this.plannedEvolutionChambers + this.evolutionChambers < 2;
    }

    public int evolutionChambers() {
        return this.plannedEvolutionChambers + this.evolutionChambers;
    }

    public boolean canPlanCarapaceUpgrades() {
        if (this.plannedCarapaceUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.carapaceUpgrades >= 3) {
            return false;
        }
        if (this.carapaceUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.carapaceUpgrades != 1 || this.lair;
    }

    public boolean canPlanRangedUpgrades() {
        if (this.plannedRangedUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.rangedUpgrades >= 3) {
            return false;
        }
        if (this.rangedUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.rangedUpgrades != 1 || this.lair;
    }

    public boolean canPlanMeleeUpgrades() {
        if (this.plannedMeleeUpgrades) {
            return false;
        }
        if (this.evolutionChambers == 0) {
            return false;
        }
        if (this.meleeUpgrades >= 3) {
            return false;
        }
        if (this.meleeUpgrades == 2 && !this.hive) {
            return false;
        }
        return this.meleeUpgrades != 1 || this.lair;
    }

    public boolean canPlanFlyerAttack() {
        if (this.plannedFlyerAttack) {
            return false;
        }
        if (!this.spire) {
            return false;
        }
        if (this.flyerAttack >= 3) {
            return false;
        }
        return this.flyerAttack != 2 || this.hive;
    }

    public boolean canPlanFlyerDefense() {
        if (this.plannedFlyerDefense) {
            return false;
        }
        if (!this.spire) {
            return false;
        }
        if (this.flyerDefense >= 3) {
            return false;
        }
        return this.flyerDefense != 2 || this.hive;
    }

    public void upgradeTech(UpgradeType u) {
        switch (u) {
            case Metabolic_Boost: {
                this.metabolicBoost = true;
                this.plannedMetabolicBoost = false;
                break;
            }
            case Muscular_Augments: {
                this.muscularAugments = true;
                this.plannedMuscularAugments = false;
                break;
            }
            case Grooved_Spines: {
                this.groovedSpines = true;
                this.plannedGroovedSpines = false;
                break;
            }
            case Zerg_Carapace: {
                ++this.carapaceUpgrades;
                this.plannedCarapaceUpgrades = false;
                break;
            }
            case Zerg_Melee_Attacks: {
                ++this.meleeUpgrades;
                this.plannedMeleeUpgrades = false;
                break;
            }
            case Zerg_Missile_Attacks: {
                ++this.rangedUpgrades;
                this.plannedRangedUpgrades = false;
                break;
            }
            case Zerg_Flyer_Attacks: {
                ++this.flyerAttack;
                this.plannedFlyerAttack = false;
                break;
            }
            case Zerg_Flyer_Carapace: {
                ++this.flyerDefense;
                this.plannedFlyerDefense = false;
            }
        }
    }

    public int evolutionChamberBuffer() {
        int buffer = 0;
        if (this.plannedCarapaceUpgrades) {
            buffer += UpgradeType.Zerg_Carapace.upgradeTime();
        }
        if (this.plannedRangedUpgrades) {
            buffer += UpgradeType.Zerg_Missile_Attacks.upgradeTime();
        }
        if (this.plannedMeleeUpgrades) {
            buffer += UpgradeType.Zerg_Melee_Attacks.upgradeTime();
        }
        return buffer;
    }

    public boolean needLairForNextEvolutionChamberUpgrades() {
        return this.meleeUpgrades + this.rangedUpgrades + this.carapaceUpgrades > 1;
    }

    public boolean needHiveForUpgrades() {
        return this.needHiveForNextEvolutionChamberUpgrades() || this.needHiveForSpireUpgrades();
    }

    private boolean needHiveForSpireUpgrades() {
        return this.flyerAttack + this.flyerDefense > 3;
    }

    private boolean needHiveForNextEvolutionChamberUpgrades() {
        return this.meleeUpgrades + this.rangedUpgrades + this.carapaceUpgrades > 3;
    }

    public boolean isSpawningPool() {
        return this.spawningPool;
    }

    public boolean isHydraliskDen() {
        return this.hydraliskDen;
    }

    public boolean isLair() {
        return this.lair;
    }

    public boolean isSpire() {
        return this.spire;
    }

    public boolean isQueensNest() {
        return this.queensNest;
    }

    public boolean isHive() {
        return this.hive;
    }

    public int getEvolutionChambers() {
        return this.evolutionChambers;
    }

    public boolean isPlannedSpawningPool() {
        return this.plannedSpawningPool;
    }

    public boolean isPlannedDen() {
        return this.plannedDen;
    }

    public boolean isPlannedLair() {
        return this.plannedLair;
    }

    public boolean isPlannedSpire() {
        return this.plannedSpire;
    }

    public boolean isPlannedQueensNest() {
        return this.plannedQueensNest;
    }

    public boolean isPlannedHive() {
        return this.plannedHive;
    }

    public int getPlannedEvolutionChambers() {
        return this.plannedEvolutionChambers;
    }

    public boolean isMetabolicBoost() {
        return this.metabolicBoost;
    }

    public boolean isMuscularAugments() {
        return this.muscularAugments;
    }

    public boolean isGroovedSpines() {
        return this.groovedSpines;
    }

    public int getCarapaceUpgrades() {
        return this.carapaceUpgrades;
    }

    public int getRangedUpgrades() {
        return this.rangedUpgrades;
    }

    public int getMeleeUpgrades() {
        return this.meleeUpgrades;
    }

    public int getFlyerAttack() {
        return this.flyerAttack;
    }

    public int getFlyerDefense() {
        return this.flyerDefense;
    }

    public boolean isPlannedMetabolicBoost() {
        return this.plannedMetabolicBoost;
    }

    public boolean isPlannedMuscularAugments() {
        return this.plannedMuscularAugments;
    }

    public boolean isPlannedGroovedSpines() {
        return this.plannedGroovedSpines;
    }

    public boolean isPlannedCarapaceUpgrades() {
        return this.plannedCarapaceUpgrades;
    }

    public boolean isPlannedRangedUpgrades() {
        return this.plannedRangedUpgrades;
    }

    public boolean isPlannedMeleeUpgrades() {
        return this.plannedMeleeUpgrades;
    }

    public boolean isPlannedFlyerAttack() {
        return this.plannedFlyerAttack;
    }

    public boolean isPlannedFlyerDefense() {
        return this.plannedFlyerDefense;
    }

    public void setSpawningPool(boolean spawningPool) {
        this.spawningPool = spawningPool;
    }

    public void setHydraliskDen(boolean hydraliskDen) {
        this.hydraliskDen = hydraliskDen;
    }

    public void setLair(boolean lair) {
        this.lair = lair;
    }

    public void setSpire(boolean spire) {
        this.spire = spire;
    }

    public void setQueensNest(boolean queensNest) {
        this.queensNest = queensNest;
    }

    public void setHive(boolean hive) {
        this.hive = hive;
    }

    public void setEvolutionChambers(int evolutionChambers) {
        this.evolutionChambers = evolutionChambers;
    }

    public void setPlannedSpawningPool(boolean plannedSpawningPool) {
        this.plannedSpawningPool = plannedSpawningPool;
    }

    public void setPlannedDen(boolean plannedDen) {
        this.plannedDen = plannedDen;
    }

    public void setPlannedLair(boolean plannedLair) {
        this.plannedLair = plannedLair;
    }

    public void setPlannedSpire(boolean plannedSpire) {
        this.plannedSpire = plannedSpire;
    }

    public void setPlannedQueensNest(boolean plannedQueensNest) {
        this.plannedQueensNest = plannedQueensNest;
    }

    public void setPlannedHive(boolean plannedHive) {
        this.plannedHive = plannedHive;
    }

    public void setPlannedEvolutionChambers(int plannedEvolutionChambers) {
        this.plannedEvolutionChambers = plannedEvolutionChambers;
    }

    public void setMetabolicBoost(boolean metabolicBoost) {
        this.metabolicBoost = metabolicBoost;
    }

    public void setMuscularAugments(boolean muscularAugments) {
        this.muscularAugments = muscularAugments;
    }

    public void setGroovedSpines(boolean groovedSpines) {
        this.groovedSpines = groovedSpines;
    }

    public void setCarapaceUpgrades(int carapaceUpgrades) {
        this.carapaceUpgrades = carapaceUpgrades;
    }

    public void setRangedUpgrades(int rangedUpgrades) {
        this.rangedUpgrades = rangedUpgrades;
    }

    public void setMeleeUpgrades(int meleeUpgrades) {
        this.meleeUpgrades = meleeUpgrades;
    }

    public void setFlyerAttack(int flyerAttack) {
        this.flyerAttack = flyerAttack;
    }

    public void setFlyerDefense(int flyerDefense) {
        this.flyerDefense = flyerDefense;
    }

    public void setPlannedMetabolicBoost(boolean plannedMetabolicBoost) {
        this.plannedMetabolicBoost = plannedMetabolicBoost;
    }

    public void setPlannedMuscularAugments(boolean plannedMuscularAugments) {
        this.plannedMuscularAugments = plannedMuscularAugments;
    }

    public void setPlannedGroovedSpines(boolean plannedGroovedSpines) {
        this.plannedGroovedSpines = plannedGroovedSpines;
    }

    public void setPlannedCarapaceUpgrades(boolean plannedCarapaceUpgrades) {
        this.plannedCarapaceUpgrades = plannedCarapaceUpgrades;
    }

    public void setPlannedRangedUpgrades(boolean plannedRangedUpgrades) {
        this.plannedRangedUpgrades = plannedRangedUpgrades;
    }

    public void setPlannedMeleeUpgrades(boolean plannedMeleeUpgrades) {
        this.plannedMeleeUpgrades = plannedMeleeUpgrades;
    }

    public void setPlannedFlyerAttack(boolean plannedFlyerAttack) {
        this.plannedFlyerAttack = plannedFlyerAttack;
    }

    public void setPlannedFlyerDefense(boolean plannedFlyerDefense) {
        this.plannedFlyerDefense = plannedFlyerDefense;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TechProgression)) {
            return false;
        }
        TechProgression other = (TechProgression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSpawningPool() != other.isSpawningPool()) {
            return false;
        }
        if (this.isHydraliskDen() != other.isHydraliskDen()) {
            return false;
        }
        if (this.isLair() != other.isLair()) {
            return false;
        }
        if (this.isSpire() != other.isSpire()) {
            return false;
        }
        if (this.isQueensNest() != other.isQueensNest()) {
            return false;
        }
        if (this.isHive() != other.isHive()) {
            return false;
        }
        if (this.getEvolutionChambers() != other.getEvolutionChambers()) {
            return false;
        }
        if (this.isPlannedSpawningPool() != other.isPlannedSpawningPool()) {
            return false;
        }
        if (this.isPlannedDen() != other.isPlannedDen()) {
            return false;
        }
        if (this.isPlannedLair() != other.isPlannedLair()) {
            return false;
        }
        if (this.isPlannedSpire() != other.isPlannedSpire()) {
            return false;
        }
        if (this.isPlannedQueensNest() != other.isPlannedQueensNest()) {
            return false;
        }
        if (this.isPlannedHive() != other.isPlannedHive()) {
            return false;
        }
        if (this.getPlannedEvolutionChambers() != other.getPlannedEvolutionChambers()) {
            return false;
        }
        if (this.isMetabolicBoost() != other.isMetabolicBoost()) {
            return false;
        }
        if (this.isMuscularAugments() != other.isMuscularAugments()) {
            return false;
        }
        if (this.isGroovedSpines() != other.isGroovedSpines()) {
            return false;
        }
        if (this.getCarapaceUpgrades() != other.getCarapaceUpgrades()) {
            return false;
        }
        if (this.getRangedUpgrades() != other.getRangedUpgrades()) {
            return false;
        }
        if (this.getMeleeUpgrades() != other.getMeleeUpgrades()) {
            return false;
        }
        if (this.getFlyerAttack() != other.getFlyerAttack()) {
            return false;
        }
        if (this.getFlyerDefense() != other.getFlyerDefense()) {
            return false;
        }
        if (this.isPlannedMetabolicBoost() != other.isPlannedMetabolicBoost()) {
            return false;
        }
        if (this.isPlannedMuscularAugments() != other.isPlannedMuscularAugments()) {
            return false;
        }
        if (this.isPlannedGroovedSpines() != other.isPlannedGroovedSpines()) {
            return false;
        }
        if (this.isPlannedCarapaceUpgrades() != other.isPlannedCarapaceUpgrades()) {
            return false;
        }
        if (this.isPlannedRangedUpgrades() != other.isPlannedRangedUpgrades()) {
            return false;
        }
        if (this.isPlannedMeleeUpgrades() != other.isPlannedMeleeUpgrades()) {
            return false;
        }
        if (this.isPlannedFlyerAttack() != other.isPlannedFlyerAttack()) {
            return false;
        }
        return this.isPlannedFlyerDefense() == other.isPlannedFlyerDefense();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TechProgression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSpawningPool() ? 79 : 97);
        result = result * 59 + (this.isHydraliskDen() ? 79 : 97);
        result = result * 59 + (this.isLair() ? 79 : 97);
        result = result * 59 + (this.isSpire() ? 79 : 97);
        result = result * 59 + (this.isQueensNest() ? 79 : 97);
        result = result * 59 + (this.isHive() ? 79 : 97);
        result = result * 59 + this.getEvolutionChambers();
        result = result * 59 + (this.isPlannedSpawningPool() ? 79 : 97);
        result = result * 59 + (this.isPlannedDen() ? 79 : 97);
        result = result * 59 + (this.isPlannedLair() ? 79 : 97);
        result = result * 59 + (this.isPlannedSpire() ? 79 : 97);
        result = result * 59 + (this.isPlannedQueensNest() ? 79 : 97);
        result = result * 59 + (this.isPlannedHive() ? 79 : 97);
        result = result * 59 + this.getPlannedEvolutionChambers();
        result = result * 59 + (this.isMetabolicBoost() ? 79 : 97);
        result = result * 59 + (this.isMuscularAugments() ? 79 : 97);
        result = result * 59 + (this.isGroovedSpines() ? 79 : 97);
        result = result * 59 + this.getCarapaceUpgrades();
        result = result * 59 + this.getRangedUpgrades();
        result = result * 59 + this.getMeleeUpgrades();
        result = result * 59 + this.getFlyerAttack();
        result = result * 59 + this.getFlyerDefense();
        result = result * 59 + (this.isPlannedMetabolicBoost() ? 79 : 97);
        result = result * 59 + (this.isPlannedMuscularAugments() ? 79 : 97);
        result = result * 59 + (this.isPlannedGroovedSpines() ? 79 : 97);
        result = result * 59 + (this.isPlannedCarapaceUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedRangedUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedMeleeUpgrades() ? 79 : 97);
        result = result * 59 + (this.isPlannedFlyerAttack() ? 79 : 97);
        result = result * 59 + (this.isPlannedFlyerDefense() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TechProgression(spawningPool=" + this.isSpawningPool() + ", hydraliskDen=" + this.isHydraliskDen() + ", lair=" + this.isLair() + ", spire=" + this.isSpire() + ", queensNest=" + this.isQueensNest() + ", hive=" + this.isHive() + ", evolutionChambers=" + this.getEvolutionChambers() + ", plannedSpawningPool=" + this.isPlannedSpawningPool() + ", plannedDen=" + this.isPlannedDen() + ", plannedLair=" + this.isPlannedLair() + ", plannedSpire=" + this.isPlannedSpire() + ", plannedQueensNest=" + this.isPlannedQueensNest() + ", plannedHive=" + this.isPlannedHive() + ", plannedEvolutionChambers=" + this.getPlannedEvolutionChambers() + ", metabolicBoost=" + this.isMetabolicBoost() + ", muscularAugments=" + this.isMuscularAugments() + ", groovedSpines=" + this.isGroovedSpines() + ", carapaceUpgrades=" + this.getCarapaceUpgrades() + ", rangedUpgrades=" + this.getRangedUpgrades() + ", meleeUpgrades=" + this.getMeleeUpgrades() + ", flyerAttack=" + this.getFlyerAttack() + ", flyerDefense=" + this.getFlyerDefense() + ", plannedMetabolicBoost=" + this.isPlannedMetabolicBoost() + ", plannedMuscularAugments=" + this.isPlannedMuscularAugments() + ", plannedGroovedSpines=" + this.isPlannedGroovedSpines() + ", plannedCarapaceUpgrades=" + this.isPlannedCarapaceUpgrades() + ", plannedRangedUpgrades=" + this.isPlannedRangedUpgrades() + ", plannedMeleeUpgrades=" + this.isPlannedMeleeUpgrades() + ", plannedFlyerAttack=" + this.isPlannedFlyerAttack() + ", plannedFlyerDefense=" + this.isPlannedFlyerDefense() + ")";
    }
}

